/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.provider.Telephony;
import android.telephony.ServiceState;
import android.telephony.SmsMessage;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.android.mms.data.Contact;
import com.android.mms.transaction.MessagingNotification;
import com.android.mms.transaction.SmsMessageSender;
import com.android.mms.transaction.SmsReceiver;
import com.android.mms.transaction.SmsSingleRecipientSender;
import com.android.mms.ui.ClassZeroActivity;
import com.android.mms.util.Recycler;
import com.google.android.mms.MmsException;

public class SmsReceiverService
extends Service {
    private static final String TAG = "SmsReceiverService";
    private ServiceHandler mServiceHandler;
    private Looper mServiceLooper;
    private boolean mSending;
    public static final String MESSAGE_SENT_ACTION = "com.android.mms.transaction.MESSAGE_SENT";
    public static final String EXTRA_MESSAGE_SENT_SEND_NEXT = "SendNextMsg";
    public static final String ACTION_SEND_MESSAGE = "com.android.mms.transaction.SEND_MESSAGE";
    private static final String[] SEND_PROJECTION = new String[]{"_id", "thread_id", "address", "body", "status"};
    public Handler mToastHandler = new Handler();
    private static final int SEND_COLUMN_ID = 0;
    private static final int SEND_COLUMN_THREAD_ID = 1;
    private static final int SEND_COLUMN_ADDRESS = 2;
    private static final int SEND_COLUMN_BODY = 3;
    private static final int SEND_COLUMN_STATUS = 4;
    private int mResultCode;
    public static final String CLASS_ZERO_BODY_KEY = "CLASS_ZERO_BODY";
    private static final String[] REPLACE_PROJECTION = new String[]{"_id", "address", "protocol"};
    private static final int REPLACE_COLUMN_ID = 0;

    public void onCreate() {
        HandlerThread thread = new HandlerThread(TAG, 10);
        thread.start();
        this.mServiceLooper = thread.getLooper();
        this.mServiceHandler = new ServiceHandler(this.mServiceLooper);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.mResultCode = intent != null ? intent.getIntExtra("result", 0) : 0;
        Message msg = this.mServiceHandler.obtainMessage();
        msg.arg1 = startId;
        msg.obj = intent;
        this.mServiceHandler.sendMessage(msg);
        return 2;
    }

    public void onDestroy() {
        this.mServiceLooper.quit();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    private void handleServiceStateChanged(Intent intent) {
        ServiceState serviceState = ServiceState.newFromBundle((Bundle)intent.getExtras());
        if (serviceState.getState() == 0) {
            this.sendFirstQueuedMessage();
        }
    }

    private void handleSendMessage() {
        if (!this.mSending) {
            this.sendFirstQueuedMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendFirstQueuedMessage() {
        boolean success = true;
        Uri uri = Uri.parse((String)"content://sms/queued");
        ContentResolver resolver = this.getContentResolver();
        Cursor c = SqliteWrapper.query((Context)this, (ContentResolver)resolver, (Uri)uri, (String[])SEND_PROJECTION, null, null, (String)"date ASC");
        if (c != null) {
            try {
                if (c.moveToFirst()) {
                    String msgText = c.getString(3);
                    String address = c.getString(2);
                    int threadId = c.getInt(1);
                    int status = c.getInt(4);
                    int msgId = c.getInt(0);
                    Uri msgUri = ContentUris.withAppendedId((Uri)Telephony.Sms.CONTENT_URI, (long)msgId);
                    SmsSingleRecipientSender sender = new SmsSingleRecipientSender((Context)this, address, msgText, threadId, status == 32, msgUri);
                    if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                        Log.v((String)TAG, (String)("sendFirstQueuedMessage " + msgUri + ", address: " + address + ", threadId: " + threadId));
                    }
                    try {
                        ((SmsMessageSender)sender).sendMessage(-1L);
                        this.mSending = true;
                    }
                    catch (MmsException e) {
                        Log.e((String)TAG, (String)("sendFirstQueuedMessage: failed to send message " + msgUri + ", caught "), (Throwable)e);
                        this.mSending = false;
                        this.messageFailedToSend(msgUri, 1);
                        success = false;
                    }
                }
            }
            finally {
                c.close();
            }
        }
        if (success) {
            this.unRegisterForServiceStateChanges();
        }
    }

    private void handleSmsSent(Intent intent, int error) {
        Uri uri = intent.getData();
        this.mSending = false;
        boolean sendNextMsg = intent.getBooleanExtra(EXTRA_MESSAGE_SENT_SEND_NEXT, false);
        if (this.mResultCode == -1) {
            if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                Log.v((String)TAG, (String)("handleSmsSent sending uri: " + uri));
            }
            if (!Telephony.Sms.moveMessageToFolder((Context)this, (Uri)uri, (int)2, (int)error)) {
                Log.e((String)TAG, (String)("handleSmsSent: failed to move message " + uri + " to sent folder"));
            }
            if (sendNextMsg) {
                this.sendFirstQueuedMessage();
            }
            MessagingNotification.updateSendFailedNotification((Context)this);
        } else if (this.mResultCode == 2 || this.mResultCode == 4) {
            if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                Log.v((String)TAG, (String)("handleSmsSent: no service, queuing message w/ uri: " + uri));
            }
            this.registerForServiceStateChanges();
            Telephony.Sms.moveMessageToFolder((Context)this, (Uri)uri, (int)6, (int)error);
            this.mToastHandler.post(new Runnable(){

                public void run() {
                    Toast.makeText((Context)SmsReceiverService.this, (CharSequence)SmsReceiverService.this.getString(2131165420), (int)0).show();
                }
            });
        } else if (this.mResultCode == 6) {
            this.mToastHandler.post(new Runnable(){

                public void run() {
                    Toast.makeText((Context)SmsReceiverService.this, (CharSequence)SmsReceiverService.this.getString(2131165421), (int)0).show();
                }
            });
        } else {
            this.messageFailedToSend(uri, error);
            if (sendNextMsg) {
                this.sendFirstQueuedMessage();
            }
        }
    }

    private void messageFailedToSend(Uri uri, int error) {
        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
            Log.v((String)TAG, (String)("messageFailedToSend msg failed uri: " + uri));
        }
        Telephony.Sms.moveMessageToFolder((Context)this, (Uri)uri, (int)5, (int)error);
        MessagingNotification.notifySendFailed(this.getApplicationContext(), true);
    }

    private void handleSmsReceived(Intent intent, int error) {
        SmsMessage[] msgs = Telephony.Sms.Intents.getMessagesFromIntent((Intent)intent);
        Uri messageUri = this.insertMessage((Context)this, msgs, error);
        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
            SmsMessage sms = msgs[0];
            Log.v((String)TAG, (String)("handleSmsReceived" + (sms.isReplace() ? "(replace)" : "") + " messageUri: " + messageUri + ", address: " + sms.getOriginatingAddress() + ", body: " + sms.getMessageBody()));
        }
        if (messageUri != null) {
            MessagingNotification.blockingUpdateNewMessageIndicator((Context)this, true, false);
        }
    }

    private void handleBootCompleted() {
        this.moveOutboxMessagesToQueuedBox();
        this.sendFirstQueuedMessage();
        MessagingNotification.blockingUpdateNewMessageIndicator((Context)this, true, false);
    }

    private void moveOutboxMessagesToQueuedBox() {
        ContentValues values = new ContentValues(1);
        values.put("type", Integer.valueOf(6));
        SqliteWrapper.update((Context)this.getApplicationContext(), (ContentResolver)this.getContentResolver(), (Uri)Telephony.Sms.Outbox.CONTENT_URI, (ContentValues)values, (String)"type = 4", null);
    }

    private Uri insertMessage(Context context, SmsMessage[] msgs, int error) {
        SmsMessage sms = msgs[0];
        if (sms.getMessageClass() == SmsMessage.MessageClass.CLASS_0) {
            this.displayClassZeroMessage(context, sms);
            return null;
        }
        if (sms.isReplace()) {
            return this.replaceMessage(context, msgs, error);
        }
        return this.storeMessage(context, msgs, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Uri replaceMessage(Context context, SmsMessage[] msgs, int error) {
        SmsMessage sms = msgs[0];
        ContentValues values = this.extractContentValues(sms);
        values.put("body", sms.getMessageBody());
        values.put("error_code", Integer.valueOf(error));
        ContentResolver resolver = context.getContentResolver();
        String originatingAddress = sms.getOriginatingAddress();
        int protocolIdentifier = sms.getProtocolIdentifier();
        String selection = "address = ? AND protocol = ?";
        String[] selectionArgs = new String[]{originatingAddress, Integer.toString(protocolIdentifier)};
        Cursor cursor = SqliteWrapper.query((Context)context, (ContentResolver)resolver, (Uri)Telephony.Sms.Inbox.CONTENT_URI, (String[])REPLACE_PROJECTION, (String)selection, (String[])selectionArgs, null);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    long messageId = cursor.getLong(0);
                    Uri messageUri = ContentUris.withAppendedId((Uri)Telephony.Sms.CONTENT_URI, (long)messageId);
                    SqliteWrapper.update((Context)context, (ContentResolver)resolver, (Uri)messageUri, (ContentValues)values, null, null);
                    Uri uri = messageUri;
                    return uri;
                }
            }
            finally {
                cursor.close();
            }
        }
        return this.storeMessage(context, msgs, error);
    }

    private Uri storeMessage(Context context, SmsMessage[] msgs, int error) {
        SmsMessage sms = msgs[0];
        ContentValues values = this.extractContentValues(sms);
        values.put("error_code", Integer.valueOf(error));
        int pduCount = msgs.length;
        if (pduCount == 1) {
            values.put("body", sms.getDisplayMessageBody());
        } else {
            StringBuilder body = new StringBuilder();
            for (int i = 0; i < pduCount; ++i) {
                sms = msgs[i];
                body.append(sms.getDisplayMessageBody());
            }
            values.put("body", body.toString());
        }
        Long threadId = values.getAsLong("thread_id");
        String address = values.getAsString("address");
        if (!TextUtils.isEmpty((CharSequence)address)) {
            Contact cacheContact = Contact.get(address, true);
            if (cacheContact != null) {
                address = cacheContact.getNumber();
            }
        } else {
            address = this.getString(2131165423);
            values.put("address", address);
        }
        if ((threadId == null || threadId == 0L) && address != null) {
            threadId = Telephony.Threads.getOrCreateThreadId((Context)context, (String)address);
            values.put("thread_id", threadId);
        }
        ContentResolver resolver = context.getContentResolver();
        Uri insertedUri = SqliteWrapper.insert((Context)context, (ContentResolver)resolver, (Uri)Telephony.Sms.Inbox.CONTENT_URI, (ContentValues)values);
        Recycler.getSmsRecycler().deleteOldMessagesByThreadId(this.getApplicationContext(), threadId);
        return insertedUri;
    }

    private ContentValues extractContentValues(SmsMessage sms) {
        ContentValues values = new ContentValues();
        values.put("address", sms.getDisplayOriginatingAddress());
        values.put("date", new Long(System.currentTimeMillis()));
        values.put("protocol", Integer.valueOf(sms.getProtocolIdentifier()));
        values.put("read", Integer.valueOf(0));
        values.put("seen", Integer.valueOf(0));
        if (sms.getPseudoSubject().length() > 0) {
            values.put("subject", sms.getPseudoSubject());
        }
        values.put("reply_path_present", Integer.valueOf(sms.isReplyPathPresent() ? 1 : 0));
        values.put("service_center", sms.getServiceCenterAddress());
        return values;
    }

    private void displayClassZeroMessage(Context context, SmsMessage sms) {
        Intent smsDialogIntent = new Intent(context, ClassZeroActivity.class).putExtra("pdu", sms.getPdu()).setFlags(0x18000000);
        context.startActivity(smsDialogIntent);
    }

    private void registerForServiceStateChanges() {
        Context context = this.getApplicationContext();
        this.unRegisterForServiceStateChanges();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SERVICE_STATE");
        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
            Log.v((String)TAG, (String)"registerForServiceStateChanges");
        }
        context.registerReceiver((BroadcastReceiver)SmsReceiver.getInstance(), intentFilter);
    }

    private void unRegisterForServiceStateChanges() {
        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
            Log.v((String)TAG, (String)"unRegisterForServiceStateChanges");
        }
        try {
            Context context = this.getApplicationContext();
            context.unregisterReceiver((BroadcastReceiver)SmsReceiver.getInstance());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private final class ServiceHandler
    extends Handler {
        public ServiceHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            int serviceId = msg.arg1;
            Intent intent = (Intent)msg.obj;
            if (intent != null) {
                String action = intent.getAction();
                int error = intent.getIntExtra("errorCode", 0);
                if (SmsReceiverService.MESSAGE_SENT_ACTION.equals(intent.getAction())) {
                    SmsReceiverService.this.handleSmsSent(intent, error);
                } else if ("android.provider.Telephony.SMS_RECEIVED".equals(action)) {
                    SmsReceiverService.this.handleSmsReceived(intent, error);
                } else if ("android.intent.action.BOOT_COMPLETED".equals(action)) {
                    SmsReceiverService.this.handleBootCompleted();
                } else if ("android.intent.action.SERVICE_STATE".equals(action)) {
                    SmsReceiverService.this.handleServiceStateChanged(intent);
                } else if (SmsReceiverService.ACTION_SEND_MESSAGE.endsWith(action)) {
                    SmsReceiverService.this.handleSendMessage();
                }
            }
            SmsReceiver.finishStartingService(SmsReceiverService.this, serviceId);
        }
    }
}

