/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import android.util.Log;
import com.android.mms.transaction.MessageSender;
import com.android.mms.transaction.SmsReceiver;
import com.google.android.mms.MmsException;

public class SmsMessageSender
implements MessageSender {
    protected final Context mContext;
    protected final int mNumberOfDests;
    private final String[] mDests;
    protected final String mMessageText;
    protected final String mServiceCenter;
    protected final long mThreadId;
    protected long mTimestamp;
    private static final boolean DEFAULT_DELIVERY_REPORT_MODE = false;
    private static final String[] SERVICE_CENTER_PROJECTION = new String[]{"reply_path_present", "service_center"};
    private static final int COLUMN_REPLY_PATH_PRESENT = 0;
    private static final int COLUMN_SERVICE_CENTER = 1;

    public SmsMessageSender(Context context, String[] dests, String msgText, long threadId) {
        this.mContext = context;
        this.mMessageText = msgText;
        if (dests != null) {
            this.mNumberOfDests = dests.length;
            this.mDests = new String[this.mNumberOfDests];
            System.arraycopy(dests, 0, this.mDests, 0, this.mNumberOfDests);
        } else {
            this.mNumberOfDests = 0;
            this.mDests = null;
        }
        this.mTimestamp = System.currentTimeMillis();
        this.mThreadId = threadId;
        this.mServiceCenter = this.getOutgoingServiceCenter(this.mThreadId);
    }

    public boolean sendMessage(long token) throws MmsException {
        return this.queueMessage(token);
    }

    private boolean queueMessage(long token) throws MmsException {
        if (this.mMessageText == null || this.mNumberOfDests == 0) {
            throw new MmsException("Null message body or dest.");
        }
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.mContext);
        boolean requestDeliveryReport = prefs.getBoolean("pref_key_sms_delivery_reports", false);
        for (int i = 0; i < this.mNumberOfDests; ++i) {
            try {
                Telephony.Sms.addMessageToUri((ContentResolver)this.mContext.getContentResolver(), (Uri)Uri.parse((String)"content://sms/queued"), (String)this.mDests[i], (String)this.mMessageText, null, (Long)this.mTimestamp, (boolean)true, (boolean)requestDeliveryReport, (long)this.mThreadId);
                continue;
            }
            catch (SQLiteException e) {
                SqliteWrapper.checkSQLiteException((Context)this.mContext, (SQLiteException)e);
            }
        }
        this.mContext.sendBroadcast(new Intent("com.android.mms.transaction.SEND_MESSAGE", null, this.mContext, SmsReceiver.class));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOutgoingServiceCenter(long threadId) {
        Cursor cursor = null;
        try {
            cursor = SqliteWrapper.query((Context)this.mContext, (ContentResolver)this.mContext.getContentResolver(), (Uri)Telephony.Sms.CONTENT_URI, (String[])SERVICE_CENTER_PROJECTION, (String)("thread_id = " + threadId), null, (String)"date DESC");
            if (cursor == null || !cursor.moveToFirst()) {
                String string2 = null;
                return string2;
            }
            boolean replyPathPresent = 1 == cursor.getInt(0);
            String string3 = replyPathPresent ? cursor.getString(1) : null;
            return string3;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    private void log(String msg) {
        Log.d((String)"Mms", (String)("[SmsMsgSender] " + msg));
    }
}

