/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.provider.Telephony;
import android.util.Log;
import com.android.mms.transaction.DefaultRetryScheme;
import com.android.mms.transaction.MessagingNotification;
import com.android.mms.transaction.NotificationTransaction;
import com.android.mms.transaction.Observable;
import com.android.mms.transaction.Observer;
import com.android.mms.transaction.ReadRecTransaction;
import com.android.mms.transaction.RetrieveTransaction;
import com.android.mms.transaction.SendTransaction;
import com.android.mms.transaction.Transaction;
import com.android.mms.transaction.TransactionService;
import com.android.mms.transaction.TransactionState;
import com.android.mms.util.DownloadManager;
import com.google.android.mms.pdu.PduPersister;

public class RetryScheduler
implements Observer {
    private static final String TAG = "RetryScheduler";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private static RetryScheduler sInstance;

    private RetryScheduler(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
    }

    public static RetryScheduler getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new RetryScheduler(context);
        }
        return sInstance;
    }

    private boolean isConnected() {
        ConnectivityManager mConnMgr = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        return mConnMgr.getNetworkInfo(2).isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable observable) {
        block9: {
            try {
                Transaction t = (Transaction)observable;
                if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                    Log.v((String)TAG, (String)("[RetryScheduler] update " + observable));
                }
                if (!(t instanceof NotificationTransaction) && !(t instanceof RetrieveTransaction) && !(t instanceof ReadRecTransaction) && !(t instanceof SendTransaction)) break block9;
                try {
                    Uri uri;
                    TransactionState state = t.getState();
                    if (state.getState() == 2 && (uri = state.getContentUri()) != null) {
                        this.scheduleRetry(uri);
                    }
                }
                finally {
                    t.detach(this);
                }
            }
            finally {
                if (this.isConnected()) {
                    RetryScheduler.setRetryAlarm(this.mContext);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRetry(Uri uri) {
        block17: {
            long msgId = ContentUris.parseId((Uri)uri);
            Uri.Builder uriBuilder = Telephony.MmsSms.PendingMessages.CONTENT_URI.buildUpon();
            uriBuilder.appendQueryParameter("protocol", "mms");
            uriBuilder.appendQueryParameter("message", String.valueOf(msgId));
            Cursor cursor = SqliteWrapper.query((Context)this.mContext, (ContentResolver)this.mContentResolver, (Uri)uriBuilder.build(), null, null, null, null);
            if (cursor != null) {
                try {
                    if (cursor.getCount() != 1 || !cursor.moveToFirst()) break block17;
                    int msgType = cursor.getInt(cursor.getColumnIndexOrThrow("msg_type"));
                    int retryIndex = cursor.getInt(cursor.getColumnIndexOrThrow("retry_index")) + 1;
                    int errorType = 1;
                    DefaultRetryScheme scheme = new DefaultRetryScheme(this.mContext, retryIndex);
                    ContentValues values = new ContentValues(4);
                    long current = System.currentTimeMillis();
                    boolean isRetryDownloading = msgType == 130;
                    boolean retry = true;
                    int respStatus = this.getResponseStatus(msgId);
                    if (respStatus == 132) {
                        DownloadManager.getInstance().showErrorCodeToast(2131165267);
                        retry = false;
                    }
                    if (retryIndex < scheme.getRetryLimit() && retry) {
                        long retryAt = current + scheme.getWaitingInterval();
                        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                            Log.v((String)TAG, (String)("scheduleRetry: retry for " + uri + " is scheduled at " + (retryAt - System.currentTimeMillis()) + "ms from now"));
                        }
                        values.put("due_time", Long.valueOf(retryAt));
                        if (isRetryDownloading) {
                            DownloadManager.getInstance().markState(uri, 130);
                        }
                    } else {
                        errorType = 10;
                        if (isRetryDownloading) {
                            Cursor c = SqliteWrapper.query((Context)this.mContext, (ContentResolver)this.mContext.getContentResolver(), (Uri)uri, (String[])new String[]{"thread_id"}, null, null, null);
                            long threadId = -1L;
                            if (c != null) {
                                try {
                                    if (c.moveToFirst()) {
                                        threadId = c.getLong(0);
                                    }
                                }
                                finally {
                                    c.close();
                                }
                            }
                            if (threadId != -1L) {
                                MessagingNotification.notifyDownloadFailed(this.mContext, threadId);
                            }
                            DownloadManager.getInstance().markState(uri, 135);
                        } else {
                            ContentValues readValues = new ContentValues(1);
                            readValues.put("read", Integer.valueOf(0));
                            SqliteWrapper.update((Context)this.mContext, (ContentResolver)this.mContext.getContentResolver(), (Uri)uri, (ContentValues)readValues, null, null);
                            MessagingNotification.notifySendFailed(this.mContext, true);
                        }
                    }
                    values.put("err_type", Integer.valueOf(errorType));
                    values.put("retry_index", Integer.valueOf(retryIndex));
                    values.put("last_try", Long.valueOf(current));
                    int columnIndex = cursor.getColumnIndexOrThrow("_id");
                    long id2 = cursor.getLong(columnIndex);
                    SqliteWrapper.update((Context)this.mContext, (ContentResolver)this.mContentResolver, (Uri)Telephony.MmsSms.PendingMessages.CONTENT_URI, (ContentValues)values, (String)("_id=" + id2), null);
                }
                finally {
                    cursor.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getResponseStatus(long msgID) {
        int respStatus = 0;
        Cursor cursor = SqliteWrapper.query((Context)this.mContext, (ContentResolver)this.mContentResolver, (Uri)Telephony.Mms.Outbox.CONTENT_URI, null, (String)("_id=" + msgID), null, null);
        try {
            if (cursor.moveToFirst()) {
                respStatus = cursor.getInt(cursor.getColumnIndexOrThrow("resp_st"));
            }
        }
        finally {
            cursor.close();
        }
        if (respStatus != 0) {
            Log.e((String)TAG, (String)("Response status is: " + respStatus));
        }
        return respStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRetryAlarm(Context context) {
        Cursor cursor = PduPersister.getPduPersister((Context)context).getPendingMessages(Long.MAX_VALUE);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    long retryAt = cursor.getLong(cursor.getColumnIndexOrThrow("due_time"));
                    Intent service = new Intent("android.intent.action.ACTION_ONALARM", null, context, TransactionService.class);
                    PendingIntent operation = PendingIntent.getService((Context)context, (int)0, (Intent)service, (int)0x40000000);
                    AlarmManager am = (AlarmManager)context.getSystemService("alarm");
                    am.set(1, retryAt, operation);
                    if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                        Log.v((String)TAG, (String)("Next retry is scheduled at" + (retryAt - System.currentTimeMillis()) + "ms from now"));
                    }
                }
            }
            finally {
                cursor.close();
            }
        }
    }
}

