/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.Context;
import android.net.Uri;
import android.provider.Telephony;
import com.android.mms.transaction.RetryScheduler;
import com.android.mms.transaction.Transaction;
import com.android.mms.transaction.TransactionSettings;
import com.android.mms.ui.MessageUtils;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.PduComposer;
import com.google.android.mms.pdu.PduPersister;
import com.google.android.mms.pdu.ReadRecInd;
import java.io.IOException;

public class ReadRecTransaction
extends Transaction {
    private static final String TAG = "ReadRecTransaction";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private final Uri mReadReportURI;

    public ReadRecTransaction(Context context, int transId, TransactionSettings connectionSettings, String uri) {
        super(context, transId, connectionSettings);
        this.mReadReportURI = Uri.parse((String)uri);
        this.mId = uri;
        this.attach(RetryScheduler.getInstance(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        PduPersister persister = PduPersister.getPduPersister((Context)this.mContext);
        try {
            ReadRecInd readRecInd = (ReadRecInd)persister.load(this.mReadReportURI);
            String lineNumber = MessageUtils.getLocalNumber();
            readRecInd.setFrom(new EncodedStringValue(lineNumber));
            byte[] postingData = new PduComposer(this.mContext, (GenericPdu)readRecInd).make();
            this.sendPdu(postingData);
            Uri uri = persister.move(this.mReadReportURI, Telephony.Mms.Sent.CONTENT_URI);
            this.mTransactionState.setState(1);
            this.mTransactionState.setContentUri(uri);
        }
        catch (IOException e) {
        }
        catch (MmsException e) {
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            if (this.mTransactionState.getState() != 1) {
                this.mTransactionState.setState(2);
                this.mTransactionState.setContentUri(this.mReadReportURI);
            }
            this.notifyObservers();
        }
    }

    public int getType() {
        return 3;
    }
}

