/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.PowerManager;
import android.provider.Telephony;
import android.util.Log;
import com.android.mms.MmsConfig;
import com.android.mms.transaction.TransactionService;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.DeliveryInd;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.NotificationInd;
import com.google.android.mms.pdu.PduParser;
import com.google.android.mms.pdu.PduPersister;
import com.google.android.mms.pdu.ReadOrigInd;

public class PushReceiver
extends BroadcastReceiver {
    private static final String TAG = "PushReceiver";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;

    public void onReceive(Context context, Intent intent) {
        if (intent.getAction().equals("android.provider.Telephony.WAP_PUSH_RECEIVED") && "application/vnd.wap.mms-message".equals(intent.getType())) {
            PowerManager pm = (PowerManager)context.getSystemService("power");
            PowerManager.WakeLock wl = pm.newWakeLock(1, "MMS PushReceiver");
            wl.acquire(5000L);
            new ReceivePushTask(context).execute(new Intent[]{intent});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long findThreadId(Context context, GenericPdu pdu, int type) {
        String messageId = type == 134 ? new String(((DeliveryInd)pdu).getMessageId()) : new String(((ReadOrigInd)pdu).getMessageId());
        StringBuilder sb = new StringBuilder(40);
        sb.append("m_id");
        sb.append('=');
        sb.append(DatabaseUtils.sqlEscapeString((String)messageId));
        sb.append(" AND ");
        sb.append("m_type");
        sb.append('=');
        sb.append(128);
        Cursor cursor = SqliteWrapper.query((Context)context, (ContentResolver)context.getContentResolver(), (Uri)Telephony.Mms.CONTENT_URI, (String[])new String[]{"thread_id"}, (String)sb.toString(), null, null);
        if (cursor != null) {
            try {
                if (cursor.getCount() == 1 && cursor.moveToFirst()) {
                    long l = cursor.getLong(0);
                    return l;
                }
            }
            finally {
                cursor.close();
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isDuplicateNotification(Context context, NotificationInd nInd) {
        byte[] rawLocation = nInd.getContentLocation();
        if (rawLocation != null) {
            String location = new String(rawLocation);
            String selection = "ct_l = ?";
            String[] selectionArgs = new String[]{location};
            Cursor cursor = SqliteWrapper.query((Context)context, (ContentResolver)context.getContentResolver(), (Uri)Telephony.Mms.CONTENT_URI, (String[])new String[]{"_id"}, (String)selection, (String[])selectionArgs, null);
            if (cursor != null) {
                try {
                    if (cursor.getCount() > 0) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    cursor.close();
                }
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReceivePushTask
    extends AsyncTask<Intent, Void, Void> {
        private Context mContext;

        public ReceivePushTask(Context context) {
            this.mContext = context;
        }

        protected Void doInBackground(Intent ... intents) {
            Intent intent = intents[0];
            byte[] pushData = intent.getByteArrayExtra("data");
            PduParser parser = new PduParser(pushData);
            GenericPdu pdu = parser.parse();
            if (null == pdu) {
                Log.e((String)PushReceiver.TAG, (String)"Invalid PUSH data");
                return null;
            }
            PduPersister p = PduPersister.getPduPersister((Context)this.mContext);
            ContentResolver cr = this.mContext.getContentResolver();
            int type = pdu.getMessageType();
            long threadId = -1L;
            try {
                switch (type) {
                    case 134: 
                    case 136: {
                        threadId = PushReceiver.findThreadId(this.mContext, pdu, type);
                        if (threadId == -1L) break;
                        Uri uri = p.persist(pdu, Telephony.Mms.Inbox.CONTENT_URI);
                        ContentValues values = new ContentValues(1);
                        values.put("thread_id", Long.valueOf(threadId));
                        SqliteWrapper.update((Context)this.mContext, (ContentResolver)cr, (Uri)uri, (ContentValues)values, null, null);
                        break;
                    }
                    case 130: {
                        byte[] contentLocation;
                        NotificationInd nInd = (NotificationInd)pdu;
                        if (MmsConfig.getTransIdEnabled() && 61 == (contentLocation = nInd.getContentLocation())[contentLocation.length - 1]) {
                            byte[] transactionId = nInd.getTransactionId();
                            byte[] contentLocationWithId = new byte[contentLocation.length + transactionId.length];
                            System.arraycopy(contentLocation, 0, contentLocationWithId, 0, contentLocation.length);
                            System.arraycopy(transactionId, 0, contentLocationWithId, contentLocation.length, transactionId.length);
                            nInd.setContentLocation(contentLocationWithId);
                        }
                        if (!PushReceiver.isDuplicateNotification(this.mContext, nInd)) {
                            Uri uri = p.persist(pdu, Telephony.Mms.Inbox.CONTENT_URI);
                            Intent svc = new Intent(this.mContext, TransactionService.class);
                            svc.putExtra("uri", uri.toString());
                            svc.putExtra("type", 0);
                            this.mContext.startService(svc);
                        }
                        break;
                    }
                    default: {
                        Log.e((String)PushReceiver.TAG, (String)"Received unrecognized PDU.");
                    }
                }
            }
            catch (MmsException e) {
                Log.e((String)PushReceiver.TAG, (String)("Failed to save the data from PUSH: type=" + type), (Throwable)e);
            }
            catch (RuntimeException e) {
                Log.e((String)PushReceiver.TAG, (String)"Unexpected RuntimeException.", (Throwable)e);
            }
            return null;
        }
    }
}

