/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import android.util.Log;
import android.widget.Toast;
import com.android.mms.data.Contact;
import com.android.mms.data.Conversation;
import com.android.mms.ui.ComposeMessageActivity;
import com.android.mms.ui.ConversationList;
import com.android.mms.util.AddressUtils;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.PduPersister;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagingNotification {
    private static final String TAG = "Mms:app";
    private static final int NOTIFICATION_ID = 123;
    public static final int MESSAGE_FAILED_NOTIFICATION_ID = 789;
    public static final int DOWNLOAD_FAILED_NOTIFICATION_ID = 531;
    private static final String[] MMS_STATUS_PROJECTION = new String[]{"thread_id", "date", "_id", "sub", "sub_cs"};
    private static final String[] SMS_STATUS_PROJECTION = new String[]{"thread_id", "date", "address", "subject", "body"};
    private static final int COLUMN_THREAD_ID = 0;
    private static final int COLUMN_DATE = 1;
    private static final int COLUMN_MMS_ID = 2;
    private static final int COLUMN_SMS_ADDRESS = 2;
    private static final int COLUMN_SUBJECT = 3;
    private static final int COLUMN_SUBJECT_CS = 4;
    private static final int COLUMN_SMS_BODY = 4;
    private static final String NEW_INCOMING_SM_CONSTRAINT = "(type = 1 AND seen = 0)";
    private static final String NEW_DELIVERY_SM_CONSTRAINT = "(type = 2 AND status = 0)";
    private static final String NEW_INCOMING_MM_CONSTRAINT = "(msg_box=1 AND seen=0 AND (m_type=130 OR m_type=132))";
    private static final MmsSmsNotificationInfoComparator INFO_COMPARATOR = new MmsSmsNotificationInfoComparator();
    private static final Uri UNDELIVERED_URI = Uri.parse((String)"content://mms-sms/undelivered");
    private static final String NOTIFICATION_DELETED_ACTION = "com.android.mms.NOTIFICATION_DELETED_ACTION";
    private static OnDeletedReceiver sNotificationDeletedReceiver = new OnDeletedReceiver();
    private static Intent sNotificationOnDeleteIntent;
    private static Handler mToastHandler;

    private MessagingNotification() {
    }

    public static void init(Context context) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(NOTIFICATION_DELETED_ACTION);
        context.registerReceiver((BroadcastReceiver)sNotificationDeletedReceiver, intentFilter);
        sNotificationOnDeleteIntent = new Intent(NOTIFICATION_DELETED_ACTION);
    }

    public static void nonBlockingUpdateNewMessageIndicator(final Context context, final boolean isNew, final boolean isStatusMessage) {
        new Thread(new Runnable(){

            public void run() {
                MessagingNotification.blockingUpdateNewMessageIndicator(context, isNew, isStatusMessage);
            }
        }).start();
    }

    public static void blockingUpdateNewMessageIndicator(Context context, boolean isNew, boolean isStatusMessage) {
        TreeSet<MmsSmsNotificationInfo> accumulator = new TreeSet<MmsSmsNotificationInfo>(INFO_COMPARATOR);
        MmsSmsDeliveryInfo delivery = null;
        HashSet<Long> threads = new HashSet<Long>(4);
        int count = 0;
        count += MessagingNotification.accumulateNotificationInfo(accumulator, MessagingNotification.getMmsNewMessageNotificationInfo(context, threads));
        count += MessagingNotification.accumulateNotificationInfo(accumulator, MessagingNotification.getSmsNewMessageNotificationInfo(context, threads));
        MessagingNotification.cancelNotification(context, 123);
        if (!accumulator.isEmpty()) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.d((String)TAG, (String)("blockingUpdateNewMessageIndicator: count=" + count + ", isNew=" + isNew));
            }
            ((MmsSmsNotificationInfo)accumulator.first()).deliver(context, isNew, count, threads.size());
        }
        if ((delivery = MessagingNotification.getSmsNewDeliveryInfo(context)) != null) {
            delivery.deliver(context, isStatusMessage);
        }
    }

    public static void blockingUpdateAllNotifications(Context context) {
        MessagingNotification.nonBlockingUpdateNewMessageIndicator(context, false, false);
        MessagingNotification.updateSendFailedNotification(context);
        MessagingNotification.updateDownloadFailedNotification(context);
    }

    private static final int accumulateNotificationInfo(SortedSet set, MmsSmsNotificationInfo info) {
        if (info != null) {
            set.add(info);
            return info.mCount;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final MmsSmsNotificationInfo getMmsNewMessageNotificationInfo(Context context, Set<Long> threads) {
        ContentResolver resolver = context.getContentResolver();
        Cursor cursor = SqliteWrapper.query((Context)context, (ContentResolver)resolver, (Uri)Telephony.Mms.CONTENT_URI, (String[])MMS_STATUS_PROJECTION, (String)NEW_INCOMING_MM_CONSTRAINT, null, (String)"date desc");
        if (cursor == null) {
            return null;
        }
        try {
            if (!cursor.moveToFirst()) {
                MmsSmsNotificationInfo mmsSmsNotificationInfo = null;
                return mmsSmsNotificationInfo;
            }
            long msgId = cursor.getLong(2);
            Uri msgUri = Telephony.Mms.CONTENT_URI.buildUpon().appendPath(Long.toString(msgId)).build();
            String address = AddressUtils.getFrom(context, msgUri);
            String subject = MessagingNotification.getMmsSubject(cursor.getString(3), cursor.getInt(4));
            long threadId = cursor.getLong(0);
            long timeMillis = cursor.getLong(1) * 1000L;
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.d((String)TAG, (String)("getMmsNewMessageNotificationInfo: count=" + cursor.getCount() + ", first addr = " + address + ", thread_id=" + threadId));
            }
            MmsSmsNotificationInfo info = MessagingNotification.getNewMessageNotificationInfo(address, subject, context, 2130837586, null, threadId, timeMillis, cursor.getCount());
            threads.add(threadId);
            while (cursor.moveToNext()) {
                threads.add(cursor.getLong(0));
            }
            MmsSmsNotificationInfo mmsSmsNotificationInfo = info;
            return mmsSmsNotificationInfo;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final MmsSmsDeliveryInfo getSmsNewDeliveryInfo(Context context) {
        ContentResolver resolver = context.getContentResolver();
        Cursor cursor = SqliteWrapper.query((Context)context, (ContentResolver)resolver, (Uri)Telephony.Sms.CONTENT_URI, (String[])SMS_STATUS_PROJECTION, (String)NEW_DELIVERY_SM_CONSTRAINT, null, (String)"date desc");
        if (cursor == null) {
            return null;
        }
        try {
            if (!cursor.moveToFirst()) {
                MmsSmsDeliveryInfo mmsSmsDeliveryInfo = null;
                return mmsSmsDeliveryInfo;
            }
            String address = cursor.getString(2);
            long timeMillis = 3000L;
            MmsSmsDeliveryInfo mmsSmsDeliveryInfo = new MmsSmsDeliveryInfo(String.format(context.getString(2131165404), address), timeMillis);
            return mmsSmsDeliveryInfo;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final MmsSmsNotificationInfo getSmsNewMessageNotificationInfo(Context context, Set<Long> threads) {
        ContentResolver resolver = context.getContentResolver();
        Cursor cursor = SqliteWrapper.query((Context)context, (ContentResolver)resolver, (Uri)Telephony.Sms.CONTENT_URI, (String[])SMS_STATUS_PROJECTION, (String)NEW_INCOMING_SM_CONSTRAINT, null, (String)"date desc");
        if (cursor == null) {
            return null;
        }
        try {
            if (!cursor.moveToFirst()) {
                MmsSmsNotificationInfo mmsSmsNotificationInfo = null;
                return mmsSmsNotificationInfo;
            }
            String address = cursor.getString(2);
            String body = cursor.getString(4);
            long threadId = cursor.getLong(0);
            long timeMillis = cursor.getLong(1);
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.d((String)TAG, (String)("getSmsNewMessageNotificationInfo: count=" + cursor.getCount() + ", first addr=" + address + ", thread_id=" + threadId));
            }
            MmsSmsNotificationInfo info = MessagingNotification.getNewMessageNotificationInfo(address, body, context, 2130837587, null, threadId, timeMillis, cursor.getCount());
            threads.add(threadId);
            while (cursor.moveToNext()) {
                threads.add(cursor.getLong(0));
            }
            MmsSmsNotificationInfo mmsSmsNotificationInfo = info;
            return mmsSmsNotificationInfo;
        }
        finally {
            cursor.close();
        }
    }

    private static final MmsSmsNotificationInfo getNewMessageNotificationInfo(String address, String body, Context context, int iconResourceId, String subject, long threadId, long timeMillis, int count) {
        Intent clickIntent = ComposeMessageActivity.createIntent(context, threadId);
        clickIntent.setFlags(0x34000000);
        String senderInfo = ((Object)MessagingNotification.buildTickerMessage(context, address, null, null)).toString();
        String senderInfoName = senderInfo.substring(0, senderInfo.length() - 2);
        CharSequence ticker = MessagingNotification.buildTickerMessage(context, address, subject, body);
        return new MmsSmsNotificationInfo(clickIntent, body, iconResourceId, ticker, timeMillis, senderInfoName, count);
    }

    public static void cancelNotification(Context context, int notificationId) {
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        nm.cancel(notificationId);
    }

    private static void updateDeliveryNotification(final Context context, boolean isStatusMessage, final CharSequence message, final long timeMillis) {
        if (!isStatusMessage) {
            return;
        }
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)context);
        if (!sp.getBoolean("pref_key_enable_notifications", true)) {
            return;
        }
        mToastHandler.post(new Runnable(){

            public void run() {
                Toast.makeText((Context)context, (CharSequence)message, (int)((int)timeMillis)).show();
            }
        });
    }

    private static void updateNotification(Context context, Intent clickIntent, String description, int iconRes, boolean isNew, CharSequence ticker, long timeMillis, String title, int messageCount, int uniqueThreadCount) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)context);
        if (!sp.getBoolean("pref_key_enable_notifications", true)) {
            return;
        }
        Notification notification = new Notification(iconRes, ticker, timeMillis);
        if (uniqueThreadCount > 1) {
            title = context.getString(2131165406);
            clickIntent = new Intent("android.intent.action.MAIN");
            clickIntent.setFlags(0x34000000);
            clickIntent.setType("vnd.android-dir/mms-sms");
        }
        if (messageCount > 1) {
            description = context.getString(2131165405, new Object[]{Integer.toString(messageCount)});
        }
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)clickIntent, (int)0x8000000);
        notification.setLatestEventInfo(context, (CharSequence)title, (CharSequence)description, pendingIntent);
        if (isNew) {
            String ringtoneStr;
            boolean nowSilent;
            String vibrateWhen = sp.contains("pref_key_vibrateWhen") ? sp.getString("pref_key_vibrateWhen", null) : (sp.contains("pref_key_vibrate") ? (sp.getBoolean("pref_key_vibrate", false) ? context.getString(2131165334) : context.getString(2131165335)) : context.getString(2131165333));
            boolean vibrateAlways = vibrateWhen.equals("always");
            boolean vibrateSilent = vibrateWhen.equals("silent");
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            boolean bl = nowSilent = audioManager.getRingerMode() == 1;
            if (vibrateAlways || vibrateSilent && nowSilent) {
                notification.defaults |= 2;
            }
            notification.sound = TextUtils.isEmpty((CharSequence)(ringtoneStr = sp.getString("pref_key_ringtone", null))) ? null : Uri.parse((String)ringtoneStr);
        }
        notification.flags |= 1;
        notification.defaults |= 4;
        notification.deleteIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)sNotificationOnDeleteIntent, (int)0);
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        nm.notify(123, notification);
    }

    protected static CharSequence buildTickerMessage(Context context, String address, String subject, String body) {
        String displayAddress = Contact.get(address, true).getName();
        StringBuilder buf = new StringBuilder(displayAddress == null ? "" : displayAddress.replace('\n', ' ').replace('\r', ' '));
        buf.append(':').append(' ');
        int offset = buf.length();
        if (!TextUtils.isEmpty((CharSequence)subject)) {
            subject = subject.replace('\n', ' ').replace('\r', ' ');
            buf.append(subject);
            buf.append(' ');
        }
        if (!TextUtils.isEmpty((CharSequence)body)) {
            body = body.replace('\n', ' ').replace('\r', ' ');
            buf.append(body);
        }
        SpannableString spanText = new SpannableString((CharSequence)buf.toString());
        spanText.setSpan((Object)new StyleSpan(1), 0, offset, 33);
        return spanText;
    }

    private static String getMmsSubject(String sub, int charset) {
        return TextUtils.isEmpty((CharSequence)sub) ? "" : new EncodedStringValue(charset, PduPersister.getBytes((String)sub)).getString();
    }

    public static void notifyDownloadFailed(Context context, long threadId) {
        MessagingNotification.notifyFailed(context, true, threadId, false);
    }

    public static void notifySendFailed(Context context) {
        MessagingNotification.notifyFailed(context, false, 0L, false);
    }

    public static void notifySendFailed(Context context, boolean noisy) {
        MessagingNotification.notifyFailed(context, false, 0L, noisy);
    }

    private static void notifyFailed(Context context, boolean isDownload, long threadId, boolean noisy) {
        Intent failedIntent;
        String title;
        String description;
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)context);
        boolean enabled = sp.getBoolean("pref_key_enable_notifications", true);
        if (!enabled) {
            return;
        }
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        long[] msgThreadId = new long[]{0L};
        int totalFailedCount = MessagingNotification.getUndeliveredMessageCount(context, msgThreadId);
        Notification notification = new Notification();
        if (totalFailedCount > 1) {
            description = context.getString(2131165407, new Object[]{Integer.toString(totalFailedCount)});
            title = context.getString(2131165408);
            failedIntent = new Intent(context, ConversationList.class);
        } else {
            title = isDownload ? context.getString(2131165428) : context.getString(2131165429);
            description = context.getString(2131165430);
            failedIntent = new Intent(context, ComposeMessageActivity.class);
            if (isDownload) {
                failedIntent.putExtra("failed_download_flag", true);
            } else {
                threadId = msgThreadId[0] != 0L ? msgThreadId[0] : 0L;
                failedIntent.putExtra("undelivered_flag", true);
            }
            failedIntent.putExtra("thread_id", threadId);
        }
        failedIntent.setFlags(0x14000000);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)failedIntent, (int)0x8000000);
        notification.icon = 2130837588;
        notification.tickerText = title;
        notification.setLatestEventInfo(context, (CharSequence)title, (CharSequence)description, pendingIntent);
        if (noisy) {
            String ringtoneStr;
            boolean vibrate = sp.getBoolean("pref_key_vibrate", false);
            if (vibrate) {
                notification.defaults |= 2;
            }
            Uri uri = notification.sound = TextUtils.isEmpty((CharSequence)(ringtoneStr = sp.getString("pref_key_ringtone", null))) ? null : Uri.parse((String)ringtoneStr);
        }
        if (isDownload) {
            nm.notify(531, notification);
        } else {
            nm.notify(789, notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getUndeliveredMessageCount(Context context, long[] threadIdResult) {
        Cursor undeliveredCursor = SqliteWrapper.query((Context)context, (ContentResolver)context.getContentResolver(), (Uri)UNDELIVERED_URI, (String[])new String[]{"thread_id"}, (String)"read=0", null, null);
        if (undeliveredCursor == null) {
            return 0;
        }
        int count = undeliveredCursor.getCount();
        try {
            if (threadIdResult != null && undeliveredCursor.moveToFirst()) {
                threadIdResult[0] = undeliveredCursor.getLong(0);
                if (threadIdResult.length >= 2) {
                    long firstId = threadIdResult[0];
                    while (undeliveredCursor.moveToNext()) {
                        if (undeliveredCursor.getLong(0) == firstId) continue;
                        firstId = 0L;
                        break;
                    }
                    threadIdResult[1] = firstId;
                }
            }
        }
        finally {
            undeliveredCursor.close();
        }
        return count;
    }

    public static void updateSendFailedNotification(Context context) {
        if (MessagingNotification.getUndeliveredMessageCount(context, null) < 1) {
            MessagingNotification.cancelNotification(context, 789);
        } else {
            MessagingNotification.notifySendFailed(context);
        }
    }

    public static void updateSendFailedNotificationForThread(Context context, long threadId) {
        long[] msgThreadId = new long[]{0L, 0L};
        if (MessagingNotification.getUndeliveredMessageCount(context, msgThreadId) > 0 && msgThreadId[0] == threadId && msgThreadId[1] != 0L) {
            MessagingNotification.cancelNotification(context, 789);
        }
    }

    private static int getDownloadFailedMessageCount(Context context) {
        Cursor c = SqliteWrapper.query((Context)context, (ContentResolver)context.getContentResolver(), (Uri)Telephony.Mms.Inbox.CONTENT_URI, null, (String)("m_type=" + String.valueOf(130) + " AND " + "st" + "=" + String.valueOf(135)), null, null);
        if (c == null) {
            return 0;
        }
        int count = c.getCount();
        c.close();
        return count;
    }

    public static void updateDownloadFailedNotification(Context context) {
        if (MessagingNotification.getDownloadFailedMessageCount(context) < 1) {
            MessagingNotification.cancelNotification(context, 531);
        }
    }

    public static boolean isFailedToDeliver(Intent intent) {
        return intent != null && intent.getBooleanExtra("undelivered_flag", false);
    }

    public static boolean isFailedToDownload(Intent intent) {
        return intent != null && intent.getBooleanExtra("failed_download_flag", false);
    }

    static {
        mToastHandler = new Handler();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MmsSmsNotificationInfoComparator
    implements Comparator<MmsSmsNotificationInfo> {
        private MmsSmsNotificationInfoComparator() {
        }

        @Override
        public int compare(MmsSmsNotificationInfo info1, MmsSmsNotificationInfo info2) {
            return Long.signum(info2.getTime() - info1.getTime());
        }
    }

    private static final class MmsSmsNotificationInfo {
        public Intent mClickIntent;
        public String mDescription;
        public int mIconResourceId;
        public CharSequence mTicker;
        public long mTimeMillis;
        public String mTitle;
        public int mCount;

        public MmsSmsNotificationInfo(Intent clickIntent, String description, int iconResourceId, CharSequence ticker, long timeMillis, String title, int count) {
            this.mClickIntent = clickIntent;
            this.mDescription = description;
            this.mIconResourceId = iconResourceId;
            this.mTicker = ticker;
            this.mTimeMillis = timeMillis;
            this.mTitle = title;
            this.mCount = count;
        }

        public void deliver(Context context, boolean isNew, int count, int uniqueThreads) {
            MessagingNotification.updateNotification(context, this.mClickIntent, this.mDescription, this.mIconResourceId, isNew, isNew ? this.mTicker : null, this.mTimeMillis, this.mTitle, count, uniqueThreads);
        }

        public long getTime() {
            return this.mTimeMillis;
        }
    }

    private static final class MmsSmsDeliveryInfo {
        public CharSequence mTicker;
        public long mTimeMillis;

        public MmsSmsDeliveryInfo(CharSequence ticker, long timeMillis) {
            this.mTicker = ticker;
            this.mTimeMillis = timeMillis;
        }

        public void deliver(Context context, boolean isStatusMessage) {
            MessagingNotification.updateDeliveryNotification(context, isStatusMessage, this.mTicker, this.mTimeMillis);
        }
    }

    public static class OnDeletedReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            if (Log.isLoggable((String)MessagingNotification.TAG, (int)2)) {
                Log.d((String)MessagingNotification.TAG, (String)"[MessagingNotification] clear notification: mark all msgs seen");
            }
            Conversation.markAllConversationsAsSeen(context);
        }
    }
}

