/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.model;

import android.content.Context;
import android.drm.mobile1.DrmException;
import android.util.Log;
import com.android.mms.drm.DrmWrapper;
import com.android.mms.model.RegionMediaModel;
import com.android.mms.model.RegionModel;
import com.google.android.mms.pdu.CharacterSets;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.w3c.dom.events.Event;

public class TextModel
extends RegionMediaModel {
    private static final String TAG = "Mms/text";
    private CharSequence mText;
    private final int mCharset;

    public TextModel(Context context, String contentType, String src, RegionModel region) {
        this(context, contentType, src, 106, new byte[0], region);
    }

    public TextModel(Context context, String contentType, String src, int charset, byte[] data, RegionModel region) {
        super(context, "text", contentType, src, data != null ? data : new byte[]{}, region);
        if (charset == 0) {
            charset = 4;
        }
        this.mCharset = charset;
        this.mText = this.extractTextFromData(data);
    }

    private CharSequence extractTextFromData(byte[] data) {
        if (data != null) {
            try {
                if (0 == this.mCharset) {
                    return new String(data);
                }
                String name = CharacterSets.getMimeName((int)this.mCharset);
                return new String(data, name);
            }
            catch (UnsupportedEncodingException e) {
                Log.e((String)TAG, (String)("Unsupported encoding: " + this.mCharset), (Throwable)e);
                return new String(data);
            }
        }
        return "";
    }

    public TextModel(Context context, String contentType, String src, int charset, DrmWrapper wrapper, RegionModel regionModel) throws IOException {
        super(context, "text", contentType, src, wrapper, regionModel);
        if (charset == 0) {
            charset = 4;
        }
        this.mCharset = charset;
    }

    public String getText() {
        if (this.mText == null) {
            try {
                this.mText = this.extractTextFromData(this.getData());
            }
            catch (DrmException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                this.mText = e.getMessage();
            }
        }
        if (!(this.mText instanceof String)) {
            this.mText = ((Object)this.mText).toString();
        }
        return ((Object)this.mText).toString();
    }

    public void setText(CharSequence text) {
        this.mText = text;
        this.notifyModelChanged(true);
    }

    public void cloneText() {
        this.mText = new String(((Object)this.mText).toString());
    }

    public int getCharset() {
        return this.mCharset;
    }

    public void handleEvent(Event evt) {
        if (evt.getType().equals("SmilMediaStart")) {
            this.mVisible = true;
        } else if (this.mFill != 1) {
            this.mVisible = false;
        }
        this.notifyModelChanged(false);
    }
}

