/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.model;

import android.text.TextUtils;
import android.util.Log;
import com.android.mms.model.AudioModel;
import com.android.mms.model.IModelChangedObserver;
import com.android.mms.model.ImageModel;
import com.android.mms.model.MediaModel;
import com.android.mms.model.Model;
import com.android.mms.model.SlideshowModel;
import com.android.mms.model.TextModel;
import com.android.mms.model.VideoModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlideModel
extends Model
implements List<MediaModel>,
EventListener {
    public static final String TAG = "Mms/slideshow";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final int DEFAULT_SLIDE_DURATION = 5000;
    private final ArrayList<MediaModel> mMedia = new ArrayList();
    private MediaModel mText;
    private MediaModel mImage;
    private MediaModel mAudio;
    private MediaModel mVideo;
    private boolean mCanAddImage = true;
    private boolean mCanAddAudio = true;
    private boolean mCanAddVideo = true;
    private int mDuration;
    private boolean mVisible = true;
    private short mFill;
    private int mSlideSize;
    private SlideshowModel mParent;

    public SlideModel(SlideshowModel slideshow) {
        this(5000, slideshow);
    }

    public SlideModel(int duration, SlideshowModel slideshow) {
        this.mDuration = duration;
        this.mParent = slideshow;
    }

    public SlideModel(int duration, ArrayList<MediaModel> mediaList) {
        this.mDuration = duration;
        int maxDur = 0;
        for (MediaModel media : mediaList) {
            this.internalAdd(media);
            int mediaDur = media.getDuration();
            if (mediaDur <= maxDur) continue;
            maxDur = mediaDur;
        }
        this.updateDuration(maxDur);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void internalAdd(MediaModel media) throws IllegalStateException {
        if (media == null) {
            return;
        }
        if (media.isText()) {
            String contentType = media.getContentType();
            if (TextUtils.isEmpty((CharSequence)contentType) || "text/plain".equals(contentType) || "text/html".equals(contentType)) {
                this.internalAddOrReplace(this.mText, media);
                this.mText = media;
                return;
            } else {
                Log.w((String)TAG, (String)("[SlideModel] content type " + media.getContentType() + " isn't supported (as text)"));
            }
            return;
        } else if (media.isImage()) {
            if (!this.mCanAddImage) throw new IllegalStateException();
            this.internalAddOrReplace(this.mImage, media);
            this.mImage = media;
            this.mCanAddVideo = false;
            return;
        } else if (media.isAudio()) {
            if (!this.mCanAddAudio) throw new IllegalStateException();
            this.internalAddOrReplace(this.mAudio, media);
            this.mAudio = media;
            this.mCanAddVideo = false;
            return;
        } else {
            if (!media.isVideo()) return;
            if (!this.mCanAddVideo) throw new IllegalStateException();
            this.internalAddOrReplace(this.mVideo, media);
            this.mVideo = media;
            this.mCanAddImage = false;
            this.mCanAddAudio = false;
        }
    }

    private void internalAddOrReplace(MediaModel old, MediaModel media) {
        int addSize;
        int n = addSize = media.getMediaResizable() ? 0 : media.getMediaSize();
        if (old == null) {
            if (null != this.mParent) {
                this.mParent.checkMessageSize(addSize);
            }
            this.mMedia.add(media);
            this.increaseSlideSize(addSize);
            this.increaseMessageSize(addSize);
        } else {
            int removeSize = old.getMediaSize();
            if (addSize > removeSize) {
                if (null != this.mParent) {
                    this.mParent.checkMessageSize(addSize - removeSize);
                }
                this.increaseSlideSize(addSize - removeSize);
                this.increaseMessageSize(addSize - removeSize);
            } else {
                this.decreaseSlideSize(removeSize - addSize);
                this.decreaseMessageSize(removeSize - addSize);
            }
            this.mMedia.set(this.mMedia.indexOf(old), media);
            old.unregisterAllModelChangedObservers();
        }
        for (IModelChangedObserver observer : this.mModelChangedObservers) {
            media.registerModelChangedObserver(observer);
        }
    }

    private boolean internalRemove(Object object) {
        if (this.mMedia.remove(object)) {
            if (object instanceof TextModel) {
                this.mText = null;
            } else if (object instanceof ImageModel) {
                this.mImage = null;
                this.mCanAddVideo = true;
            } else if (object instanceof AudioModel) {
                this.mAudio = null;
                this.mCanAddVideo = true;
            } else if (object instanceof VideoModel) {
                this.mVideo = null;
                this.mCanAddImage = true;
                this.mCanAddAudio = true;
            }
            int decreaseSize = ((MediaModel)object).getMediaResizable() ? 0 : ((MediaModel)object).getMediaSize();
            this.decreaseSlideSize(decreaseSize);
            this.decreaseMessageSize(decreaseSize);
            ((Model)object).unregisterAllModelChangedObservers();
            return true;
        }
        return false;
    }

    public int getDuration() {
        return this.mDuration;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
        this.notifyModelChanged(true);
    }

    public int getSlideSize() {
        return this.mSlideSize;
    }

    public void increaseSlideSize(int increaseSize) {
        if (increaseSize > 0) {
            this.mSlideSize += increaseSize;
        }
    }

    public void decreaseSlideSize(int decreaseSize) {
        if (decreaseSize > 0) {
            this.mSlideSize -= decreaseSize;
        }
    }

    public void setParent(SlideshowModel parent) {
        this.mParent = parent;
    }

    public void increaseMessageSize(int increaseSize) {
        if (increaseSize > 0 && null != this.mParent) {
            int size = this.mParent.getCurrentMessageSize();
            this.mParent.setCurrentMessageSize(size += increaseSize);
        }
    }

    public void decreaseMessageSize(int decreaseSize) {
        if (decreaseSize > 0 && null != this.mParent) {
            int size = this.mParent.getCurrentMessageSize();
            this.mParent.setCurrentMessageSize(size -= decreaseSize);
        }
    }

    @Override
    public boolean add(MediaModel object) {
        this.internalAdd(object);
        this.notifyModelChanged(true);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends MediaModel> collection) {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public void clear() {
        if (this.mMedia.size() > 0) {
            for (MediaModel media : this.mMedia) {
                media.unregisterAllModelChangedObservers();
                int decreaseSize = media.getMediaSize();
                this.decreaseSlideSize(decreaseSize);
                this.decreaseMessageSize(decreaseSize);
            }
            this.mMedia.clear();
            this.mText = null;
            this.mImage = null;
            this.mAudio = null;
            this.mVideo = null;
            this.mCanAddImage = true;
            this.mCanAddAudio = true;
            this.mCanAddVideo = true;
            this.notifyModelChanged(true);
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.mMedia.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.mMedia.containsAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.mMedia.isEmpty();
    }

    @Override
    public Iterator<MediaModel> iterator() {
        return this.mMedia.iterator();
    }

    @Override
    public boolean remove(Object object) {
        if (object != null && object instanceof MediaModel && this.internalRemove(object)) {
            this.notifyModelChanged(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public int size() {
        return this.mMedia.size();
    }

    @Override
    public Object[] toArray() {
        return this.mMedia.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array2) {
        return this.mMedia.toArray(array2);
    }

    @Override
    public void add(int location, MediaModel object) {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public boolean addAll(int location, Collection<? extends MediaModel> collection) {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public MediaModel get(int location) {
        if (this.mMedia.size() == 0) {
            return null;
        }
        return this.mMedia.get(location);
    }

    @Override
    public int indexOf(Object object) {
        return this.mMedia.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.mMedia.lastIndexOf(object);
    }

    @Override
    public ListIterator<MediaModel> listIterator() {
        return this.mMedia.listIterator();
    }

    @Override
    public ListIterator<MediaModel> listIterator(int location) {
        return this.mMedia.listIterator(location);
    }

    @Override
    public MediaModel remove(int location) {
        MediaModel media = this.mMedia.get(location);
        if (media != null && this.internalRemove(media)) {
            this.notifyModelChanged(true);
        }
        return media;
    }

    @Override
    public MediaModel set(int location, MediaModel object) {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public List<MediaModel> subList(int start, int end) {
        return this.mMedia.subList(start, end);
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public void setVisible(boolean visible) {
        this.mVisible = visible;
        this.notifyModelChanged(true);
    }

    public short getFill() {
        return this.mFill;
    }

    public void setFill(short fill) {
        this.mFill = fill;
        this.notifyModelChanged(true);
    }

    @Override
    protected void registerModelChangedObserverInDescendants(IModelChangedObserver observer) {
        for (MediaModel media : this.mMedia) {
            media.registerModelChangedObserver(observer);
        }
    }

    @Override
    protected void unregisterModelChangedObserverInDescendants(IModelChangedObserver observer) {
        for (MediaModel media : this.mMedia) {
            media.unregisterModelChangedObserver(observer);
        }
    }

    @Override
    protected void unregisterAllModelChangedObserversInDescendants() {
        for (MediaModel media : this.mMedia) {
            media.unregisterAllModelChangedObservers();
        }
    }

    @Override
    public void handleEvent(Event evt) {
        if (evt.getType().equals("SmilSlideStart")) {
            this.mVisible = true;
        } else if (this.mFill != 1) {
            this.mVisible = false;
        }
        this.notifyModelChanged(false);
    }

    public boolean hasText() {
        return this.mText != null;
    }

    public boolean hasImage() {
        return this.mImage != null;
    }

    public boolean hasAudio() {
        return this.mAudio != null;
    }

    public boolean hasVideo() {
        return this.mVideo != null;
    }

    public boolean removeText() {
        return this.remove(this.mText);
    }

    public boolean removeImage() {
        return this.remove(this.mImage);
    }

    public boolean removeAudio() {
        return this.remove(this.mAudio);
    }

    public boolean removeVideo() {
        return this.remove(this.mVideo);
    }

    public TextModel getText() {
        return (TextModel)this.mText;
    }

    public ImageModel getImage() {
        return (ImageModel)this.mImage;
    }

    public AudioModel getAudio() {
        return (AudioModel)this.mAudio;
    }

    public VideoModel getVideo() {
        return (VideoModel)this.mVideo;
    }

    public void updateDuration(int duration) {
        if (duration <= 0) {
            return;
        }
        if (duration > this.mDuration || this.mDuration == 5000) {
            this.mDuration = duration;
        }
    }
}

