/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.model;

import android.content.Context;
import android.drm.mobile1.DrmException;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.android.mms.ContentRestrictionException;
import com.android.mms.ExceedMessageSizeException;
import com.android.mms.MmsConfig;
import com.android.mms.drm.DrmWrapper;
import com.android.mms.model.ContentRestriction;
import com.android.mms.model.ContentRestrictionFactory;
import com.android.mms.model.RegionMediaModel;
import com.android.mms.model.RegionModel;
import com.android.mms.ui.MessageUtils;
import com.android.mms.ui.UriImage;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.PduPart;
import com.google.android.mms.pdu.PduPersister;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import org.w3c.dom.events.Event;

public class ImageModel
extends RegionMediaModel {
    private static final String TAG = "Mms/image";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final int THUMBNAIL_BOUNDS_LIMIT = 480;
    private int mWidth;
    private int mHeight;
    private SoftReference<Bitmap> mBitmapCache = new SoftReference<Object>(null);

    public ImageModel(Context context, Uri uri, RegionModel region) throws MmsException {
        super(context, "img", uri, region);
        this.initModelFromUri(uri);
        this.checkContentRestriction();
    }

    public ImageModel(Context context, String contentType, String src, Uri uri, RegionModel region) throws DrmException, MmsException {
        super(context, "img", contentType, src, uri, region);
        this.decodeImageBounds();
    }

    public ImageModel(Context context, String contentType, String src, DrmWrapper wrapper, RegionModel regionModel) throws IOException {
        super(context, "img", contentType, src, wrapper, regionModel);
    }

    private void initModelFromUri(Uri uri) throws MmsException {
        UriImage uriImage = new UriImage(this.mContext, uri);
        this.mContentType = uriImage.getContentType();
        if (TextUtils.isEmpty((CharSequence)this.mContentType)) {
            throw new MmsException("Type of media is unknown.");
        }
        this.mSrc = uriImage.getSrc();
        this.mWidth = uriImage.getWidth();
        this.mHeight = uriImage.getHeight();
    }

    private void decodeImageBounds() throws DrmException {
        UriImage uriImage = new UriImage(this.mContext, this.getUriWithDrmCheck());
        this.mWidth = uriImage.getWidth();
        this.mHeight = uriImage.getHeight();
    }

    public void handleEvent(Event evt) {
        if (evt.getType().equals("SmilMediaStart")) {
            this.mVisible = true;
        } else if (this.mFill != 1) {
            this.mVisible = false;
        }
        this.notifyModelChanged(false);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    protected void checkContentRestriction() throws ContentRestrictionException {
        ContentRestriction cr = ContentRestrictionFactory.getContentRestriction();
        cr.checkImageContentType(this.mContentType);
    }

    public Bitmap getBitmap() {
        return this.internalGetBitmap(this.getUri());
    }

    public Bitmap getBitmapWithDrmCheck() throws DrmException {
        return this.internalGetBitmap(this.getUriWithDrmCheck());
    }

    private Bitmap internalGetBitmap(Uri uri) {
        Bitmap bm = this.mBitmapCache.get();
        if (bm == null) {
            try {
                bm = this.createThumbnailBitmap(480, uri);
                if (bm != null) {
                    this.mBitmapCache = new SoftReference<Bitmap>(bm);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
        return bm;
    }

    private Bitmap createThumbnailBitmap(int thumbnailBoundsLimit, Uri uri) {
        int outWidth = this.mWidth;
        int outHeight = this.mHeight;
        int s = 1;
        while (outWidth / s > thumbnailBoundsLimit || outHeight / s > thumbnailBoundsLimit) {
            s *= 2;
        }
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            Log.v((String)TAG, (String)("createThumbnailBitmap: scale=" + s + ", w=" + outWidth / s + ", h=" + outHeight / s));
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = s;
        InputStream input = null;
        try {
            input = this.mContext.getContentResolver().openInputStream(uri);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            Bitmap bitmap = null;
            return bitmap;
        }
        catch (OutOfMemoryError ex) {
            MessageUtils.writeHprofDataToFile();
            throw ex;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public boolean getMediaResizable() {
        return true;
    }

    protected void resizeMedia(int byteLimit, long messageId) throws MmsException {
        UriImage image = new UriImage(this.mContext, this.getUri());
        if (image == null) {
            throw new ExceedMessageSizeException("No room to resize picture: " + this.getUri());
        }
        PduPart part = image.getResizedImageAsPart(MmsConfig.getMaxImageWidth(), MmsConfig.getMaxImageHeight(), byteLimit);
        if (part == null) {
            throw new ExceedMessageSizeException("Not enough memory to turn image into part: " + this.getUri());
        }
        String src = this.getSrc();
        byte[] srcBytes = src.getBytes();
        part.setContentLocation(srcBytes);
        int period = src.lastIndexOf(".");
        byte[] contentId = period != -1 ? src.substring(0, period).getBytes() : srcBytes;
        part.setContentId(contentId);
        PduPersister persister = PduPersister.getPduPersister((Context)this.mContext);
        this.mSize = part.getData().length;
        Uri newUri = persister.persistPart(part, messageId);
        this.setUri(newUri);
    }
}

