/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.model;

import android.content.ContentResolver;
import com.android.mms.ContentRestrictionException;
import com.android.mms.ExceedMessageSizeException;
import com.android.mms.MmsConfig;
import com.android.mms.ResolutionException;
import com.android.mms.UnsupportContentTypeException;
import com.android.mms.model.ContentRestriction;
import com.google.android.mms.ContentType;
import java.util.ArrayList;

public class CarrierContentRestriction
implements ContentRestriction {
    private static final ArrayList<String> sSupportedImageTypes = ContentType.getImageTypes();
    private static final ArrayList<String> sSupportedAudioTypes = ContentType.getAudioTypes();
    private static final ArrayList<String> sSupportedVideoTypes = ContentType.getVideoTypes();

    public void checkMessageSize(int messageSize, int increaseSize, ContentResolver resolver) throws ContentRestrictionException {
        if (messageSize < 0 || increaseSize < 0) {
            throw new ContentRestrictionException("Negative message size or increase size");
        }
        int newSize = messageSize + increaseSize;
        if (newSize < 0 || newSize > MmsConfig.getMaxMessageSize()) {
            throw new ExceedMessageSizeException("Exceed message size limitation");
        }
    }

    public void checkResolution(int width, int height) throws ContentRestrictionException {
        if (width > MmsConfig.getMaxImageWidth() || height > MmsConfig.getMaxImageHeight()) {
            throw new ResolutionException("content resolution exceeds restriction.");
        }
    }

    public void checkImageContentType(String contentType) throws ContentRestrictionException {
        if (null == contentType) {
            throw new ContentRestrictionException("Null content type to be check");
        }
        if (!sSupportedImageTypes.contains(contentType)) {
            throw new UnsupportContentTypeException("Unsupported image content type : " + contentType);
        }
    }

    public void checkAudioContentType(String contentType) throws ContentRestrictionException {
        if (null == contentType) {
            throw new ContentRestrictionException("Null content type to be check");
        }
        if (!sSupportedAudioTypes.contains(contentType)) {
            throw new UnsupportContentTypeException("Unsupported audio content type : " + contentType);
        }
    }

    public void checkVideoContentType(String contentType) throws ContentRestrictionException {
        if (null == contentType) {
            throw new ContentRestrictionException("Null content type to be check");
        }
        if (!sSupportedVideoTypes.contains(contentType)) {
            throw new UnsupportContentTypeException("Unsupported video content type : " + contentType);
        }
    }
}

