/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.drm;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.util.Log;
import com.android.mms.drm.DrmWrapper;
import java.io.IOException;
import java.io.OutputStream;

public class DrmUtils {
    private static final String TAG = "DrmUtils";
    private static final Uri DRM_TEMP_URI = Uri.parse((String)"content://mms/drm");

    private DrmUtils() {
    }

    public static void cleanupStorage(Context context) {
        SqliteWrapper.delete((Context)context, (ContentResolver)context.getContentResolver(), (Uri)DRM_TEMP_URI, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Uri insert(Context context, DrmWrapper drmObj) throws IOException {
        ContentResolver cr = context.getContentResolver();
        Uri uri = SqliteWrapper.insert((Context)context, (ContentResolver)cr, (Uri)DRM_TEMP_URI, (ContentValues)new ContentValues(0));
        OutputStream os = null;
        try {
            os = cr.openOutputStream(uri);
            byte[] data = drmObj.getDecryptedData();
            if (data != null) {
                os.write(data);
            }
            Uri uri2 = uri;
            return uri2;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

