/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.dom.smil.parser;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.smil.SMILDocument;
import org.w3c.dom.smil.SMILElement;

public class SmilXmlSerializer {
    public static void serialize(SMILDocument smilDoc, OutputStream out) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"), 2048);
            SmilXmlSerializer.writeElement(writer, smilDoc.getDocumentElement());
            ((Writer)writer).flush();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeElement(Writer writer, Element element) throws IOException {
        SMILElement childElement;
        writer.write(60);
        writer.write(element.getTagName());
        if (element.hasAttributes()) {
            NamedNodeMap attributes = element.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attribute = (Attr)attributes.item(i);
                writer.write(" " + attribute.getName());
                writer.write("=\"" + attribute.getValue() + "\"");
            }
        }
        if ((childElement = (SMILElement)element.getFirstChild()) != null) {
            writer.write(62);
            do {
                SmilXmlSerializer.writeElement(writer, childElement);
            } while ((childElement = (SMILElement)childElement.getNextSibling()) != null);
            writer.write("</");
            writer.write(element.getTagName());
            writer.write(62);
        } else {
            writer.write("/>");
        }
    }
}

