/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.dom.smil;

import android.util.Log;
import com.android.mms.dom.events.EventImpl;
import com.android.mms.dom.smil.ElementTimeImpl;
import com.android.mms.dom.smil.SmilDocumentImpl;
import com.android.mms.dom.smil.SmilElementImpl;
import com.android.mms.dom.smil.SmilParElementImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.smil.ElementTime;
import org.w3c.dom.smil.SMILMediaElement;
import org.w3c.dom.smil.TimeList;

public class SmilMediaElementImpl
extends SmilElementImpl
implements SMILMediaElement {
    public static final String SMIL_MEDIA_START_EVENT = "SmilMediaStart";
    public static final String SMIL_MEDIA_END_EVENT = "SmilMediaEnd";
    public static final String SMIL_MEDIA_PAUSE_EVENT = "SmilMediaPause";
    public static final String SMIL_MEDIA_SEEK_EVENT = "SmilMediaSeek";
    private static final String TAG = "Mms:smil";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    ElementTime mElementTime = new ElementTimeImpl(this){

        private Event createEvent(String eventType) {
            DocumentEvent doc = (DocumentEvent)((Object)SmilMediaElementImpl.this.getOwnerDocument());
            Event event = doc.createEvent("Event");
            event.initEvent(eventType, false, false);
            return event;
        }

        private Event createEvent(String eventType, int seekTo) {
            DocumentEvent doc = (DocumentEvent)((Object)SmilMediaElementImpl.this.getOwnerDocument());
            EventImpl event = (EventImpl)doc.createEvent("Event");
            event.initEvent(eventType, false, false, seekTo);
            return event;
        }

        public boolean beginElement() {
            Event startEvent = this.createEvent(SmilMediaElementImpl.SMIL_MEDIA_START_EVENT);
            SmilMediaElementImpl.this.dispatchEvent(startEvent);
            return true;
        }

        public boolean endElement() {
            Event endEvent = this.createEvent(SmilMediaElementImpl.SMIL_MEDIA_END_EVENT);
            SmilMediaElementImpl.this.dispatchEvent(endEvent);
            return true;
        }

        public void resumeElement() {
            Event resumeEvent = this.createEvent(SmilMediaElementImpl.SMIL_MEDIA_START_EVENT);
            SmilMediaElementImpl.this.dispatchEvent(resumeEvent);
        }

        public void pauseElement() {
            Event pauseEvent = this.createEvent(SmilMediaElementImpl.SMIL_MEDIA_PAUSE_EVENT);
            SmilMediaElementImpl.this.dispatchEvent(pauseEvent);
        }

        public void seekElement(float seekTo) {
            Event seekEvent = this.createEvent(SmilMediaElementImpl.SMIL_MEDIA_SEEK_EVENT, (int)seekTo);
            SmilMediaElementImpl.this.dispatchEvent(seekEvent);
        }

        public float getDur() {
            float dur = super.getDur();
            if (dur == 0.0f) {
                String tag = SmilMediaElementImpl.this.getTagName();
                if (tag.equals("video") || tag.equals("audio")) {
                    dur = -1.0f;
                } else if (tag.equals("text") || tag.equals("img")) {
                    dur = 0.0f;
                } else {
                    Log.w((String)SmilMediaElementImpl.TAG, (String)"Unknown media type");
                }
            }
            return dur;
        }

        ElementTime getParentElementTime() {
            return ((SmilParElementImpl)this.mSmilElement.getParentNode()).mParTimeContainer;
        }
    };

    SmilMediaElementImpl(SmilDocumentImpl owner, String tagName) {
        super(owner, tagName);
    }

    public String getAbstractAttr() {
        return this.getAttribute("abstract");
    }

    public String getAlt() {
        return this.getAttribute("alt");
    }

    public String getAuthor() {
        return this.getAttribute("author");
    }

    public String getClipBegin() {
        return this.getAttribute("clipBegin");
    }

    public String getClipEnd() {
        return this.getAttribute("clipEnd");
    }

    public String getCopyright() {
        return this.getAttribute("copyright");
    }

    public String getLongdesc() {
        return this.getAttribute("longdesc");
    }

    public String getPort() {
        return this.getAttribute("port");
    }

    public String getReadIndex() {
        return this.getAttribute("readIndex");
    }

    public String getRtpformat() {
        return this.getAttribute("rtpformat");
    }

    public String getSrc() {
        return this.getAttribute("src");
    }

    public String getStripRepeat() {
        return this.getAttribute("stripRepeat");
    }

    public String getTitle() {
        return this.getAttribute("title");
    }

    public String getTransport() {
        return this.getAttribute("transport");
    }

    public String getType() {
        return this.getAttribute("type");
    }

    public void setAbstractAttr(String abstractAttr) throws DOMException {
        this.setAttribute("abstract", abstractAttr);
    }

    public void setAlt(String alt) throws DOMException {
        this.setAttribute("alt", alt);
    }

    public void setAuthor(String author) throws DOMException {
        this.setAttribute("author", author);
    }

    public void setClipBegin(String clipBegin) throws DOMException {
        this.setAttribute("clipBegin", clipBegin);
    }

    public void setClipEnd(String clipEnd) throws DOMException {
        this.setAttribute("clipEnd", clipEnd);
    }

    public void setCopyright(String copyright) throws DOMException {
        this.setAttribute("copyright", copyright);
    }

    public void setLongdesc(String longdesc) throws DOMException {
        this.setAttribute("longdesc", longdesc);
    }

    public void setPort(String port) throws DOMException {
        this.setAttribute("port", port);
    }

    public void setReadIndex(String readIndex) throws DOMException {
        this.setAttribute("readIndex", readIndex);
    }

    public void setRtpformat(String rtpformat) throws DOMException {
        this.setAttribute("rtpformat", rtpformat);
    }

    public void setSrc(String src) throws DOMException {
        this.setAttribute("src", src);
    }

    public void setStripRepeat(String stripRepeat) throws DOMException {
        this.setAttribute("stripRepeat", stripRepeat);
    }

    public void setTitle(String title) throws DOMException {
        this.setAttribute("title", title);
    }

    public void setTransport(String transport) throws DOMException {
        this.setAttribute("transport", transport);
    }

    public void setType(String type) throws DOMException {
        this.setAttribute("type", type);
    }

    public boolean beginElement() {
        return this.mElementTime.beginElement();
    }

    public boolean endElement() {
        return this.mElementTime.endElement();
    }

    public TimeList getBegin() {
        return this.mElementTime.getBegin();
    }

    public float getDur() {
        return this.mElementTime.getDur();
    }

    public TimeList getEnd() {
        return this.mElementTime.getEnd();
    }

    public short getFill() {
        return this.mElementTime.getFill();
    }

    public short getFillDefault() {
        return this.mElementTime.getFillDefault();
    }

    public float getRepeatCount() {
        return this.mElementTime.getRepeatCount();
    }

    public float getRepeatDur() {
        return this.mElementTime.getRepeatDur();
    }

    public short getRestart() {
        return this.mElementTime.getRestart();
    }

    public void pauseElement() {
        this.mElementTime.pauseElement();
    }

    public void resumeElement() {
        this.mElementTime.resumeElement();
    }

    public void seekElement(float seekTo) {
        this.mElementTime.seekElement(seekTo);
    }

    public void setBegin(TimeList begin) throws DOMException {
        this.mElementTime.setBegin(begin);
    }

    public void setDur(float dur) throws DOMException {
        this.mElementTime.setDur(dur);
    }

    public void setEnd(TimeList end) throws DOMException {
        this.mElementTime.setEnd(end);
    }

    public void setFill(short fill) throws DOMException {
        this.mElementTime.setFill(fill);
    }

    public void setFillDefault(short fillDefault) throws DOMException {
        this.mElementTime.setFillDefault(fillDefault);
    }

    public void setRepeatCount(float repeatCount) throws DOMException {
        this.mElementTime.setRepeatCount(repeatCount);
    }

    public void setRepeatDur(float repeatDur) throws DOMException {
        this.mElementTime.setRepeatDur(repeatDur);
    }

    public void setRestart(short restart) throws DOMException {
        this.mElementTime.setRestart(restart);
    }
}

