/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.dom.smil;

import com.android.mms.dom.DocumentImpl;
import com.android.mms.dom.events.EventImpl;
import com.android.mms.dom.smil.ElementSequentialTimeContainerImpl;
import com.android.mms.dom.smil.SmilElementImpl;
import com.android.mms.dom.smil.SmilLayoutElementImpl;
import com.android.mms.dom.smil.SmilMediaElementImpl;
import com.android.mms.dom.smil.SmilParElementImpl;
import com.android.mms.dom.smil.SmilRefElementImpl;
import com.android.mms.dom.smil.SmilRegionElementImpl;
import com.android.mms.dom.smil.SmilRegionMediaElementImpl;
import com.android.mms.dom.smil.SmilRootLayoutElementImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.smil.ElementSequentialTimeContainer;
import org.w3c.dom.smil.ElementTime;
import org.w3c.dom.smil.SMILDocument;
import org.w3c.dom.smil.SMILElement;
import org.w3c.dom.smil.SMILLayoutElement;
import org.w3c.dom.smil.TimeList;

public class SmilDocumentImpl
extends DocumentImpl
implements SMILDocument,
DocumentEvent {
    ElementSequentialTimeContainer mSeqTimeContainer;
    public static final String SMIL_DOCUMENT_START_EVENT = "SmilDocumentStart";
    public static final String SMIL_DOCUMENT_END_EVENT = "SimlDocumentEnd";

    public NodeList getActiveChildrenAt(float instant) {
        return this.mSeqTimeContainer.getActiveChildrenAt(instant);
    }

    public NodeList getTimeChildren() {
        return this.mSeqTimeContainer.getTimeChildren();
    }

    public boolean beginElement() {
        return this.mSeqTimeContainer.beginElement();
    }

    public boolean endElement() {
        return this.mSeqTimeContainer.endElement();
    }

    public TimeList getBegin() {
        return this.mSeqTimeContainer.getBegin();
    }

    public float getDur() {
        return this.mSeqTimeContainer.getDur();
    }

    public TimeList getEnd() {
        return this.mSeqTimeContainer.getEnd();
    }

    public short getFill() {
        return this.mSeqTimeContainer.getFill();
    }

    public short getFillDefault() {
        return this.mSeqTimeContainer.getFillDefault();
    }

    public float getRepeatCount() {
        return this.mSeqTimeContainer.getRepeatCount();
    }

    public float getRepeatDur() {
        return this.mSeqTimeContainer.getRepeatDur();
    }

    public short getRestart() {
        return this.mSeqTimeContainer.getRestart();
    }

    public void pauseElement() {
        this.mSeqTimeContainer.pauseElement();
    }

    public void resumeElement() {
        this.mSeqTimeContainer.resumeElement();
    }

    public void seekElement(float seekTo) {
        this.mSeqTimeContainer.seekElement(seekTo);
    }

    public void setBegin(TimeList begin) throws DOMException {
        this.mSeqTimeContainer.setBegin(begin);
    }

    public void setDur(float dur) throws DOMException {
        this.mSeqTimeContainer.setDur(dur);
    }

    public void setEnd(TimeList end) throws DOMException {
        this.mSeqTimeContainer.setEnd(end);
    }

    public void setFill(short fill) throws DOMException {
        this.mSeqTimeContainer.setFill(fill);
    }

    public void setFillDefault(short fillDefault) throws DOMException {
        this.mSeqTimeContainer.setFillDefault(fillDefault);
    }

    public void setRepeatCount(float repeatCount) throws DOMException {
        this.mSeqTimeContainer.setRepeatCount(repeatCount);
    }

    public void setRepeatDur(float repeatDur) throws DOMException {
        this.mSeqTimeContainer.setRepeatDur(repeatDur);
    }

    public void setRestart(short restart) throws DOMException {
        this.mSeqTimeContainer.setRestart(restart);
    }

    public Element createElement(String tagName) throws DOMException {
        if ((tagName = tagName.toLowerCase()).equals("text") || tagName.equals("img") || tagName.equals("video")) {
            return new SmilRegionMediaElementImpl(this, tagName);
        }
        if (tagName.equals("audio")) {
            return new SmilMediaElementImpl(this, tagName);
        }
        if (tagName.equals("layout")) {
            return new SmilLayoutElementImpl(this, tagName);
        }
        if (tagName.equals("root-layout")) {
            return new SmilRootLayoutElementImpl(this, tagName);
        }
        if (tagName.equals("region")) {
            return new SmilRegionElementImpl(this, tagName);
        }
        if (tagName.equals("ref")) {
            return new SmilRefElementImpl(this, tagName);
        }
        if (tagName.equals("par")) {
            return new SmilParElementImpl(this, tagName);
        }
        return new SmilElementImpl(this, tagName);
    }

    public SMILElement getDocumentElement() {
        Node rootElement = this.getFirstChild();
        if (rootElement == null || !(rootElement instanceof SMILElement)) {
            rootElement = this.createElement("smil");
            this.appendChild(rootElement);
        }
        return (SMILElement)rootElement;
    }

    public SMILElement getHead() {
        SMILElement rootElement = this.getDocumentElement();
        Node headElement = rootElement.getFirstChild();
        if (headElement == null || !(headElement instanceof SMILElement)) {
            headElement = this.createElement("head");
            rootElement.appendChild(headElement);
        }
        return (SMILElement)headElement;
    }

    public SMILElement getBody() {
        SMILElement rootElement = this.getDocumentElement();
        SMILElement headElement = this.getHead();
        Node bodyElement = headElement.getNextSibling();
        if (bodyElement == null || !(bodyElement instanceof SMILElement)) {
            bodyElement = this.createElement("body");
            rootElement.appendChild(bodyElement);
        }
        this.mSeqTimeContainer = new ElementSequentialTimeContainerImpl((SMILElement)bodyElement){

            public NodeList getTimeChildren() {
                return SmilDocumentImpl.this.getBody().getElementsByTagName("par");
            }

            public boolean beginElement() {
                Event startEvent = SmilDocumentImpl.this.createEvent("Event");
                startEvent.initEvent(SmilDocumentImpl.SMIL_DOCUMENT_START_EVENT, false, false);
                SmilDocumentImpl.this.dispatchEvent(startEvent);
                return true;
            }

            public boolean endElement() {
                Event endEvent = SmilDocumentImpl.this.createEvent("Event");
                endEvent.initEvent(SmilDocumentImpl.SMIL_DOCUMENT_END_EVENT, false, false);
                SmilDocumentImpl.this.dispatchEvent(endEvent);
                return true;
            }

            public void pauseElement() {
            }

            public void resumeElement() {
            }

            public void seekElement(float seekTo) {
            }

            ElementTime getParentElementTime() {
                return null;
            }
        };
        return (SMILElement)bodyElement;
    }

    public SMILLayoutElement getLayout() {
        SMILElement headElement = this.getHead();
        Node layoutElement = null;
        for (layoutElement = headElement.getFirstChild(); layoutElement != null && !(layoutElement instanceof SMILLayoutElement); layoutElement = layoutElement.getNextSibling()) {
        }
        if (layoutElement == null) {
            layoutElement = new SmilLayoutElementImpl(this, "layout");
            headElement.appendChild(layoutElement);
        }
        return (SMILLayoutElement)layoutElement;
    }

    public Event createEvent(String eventType) throws DOMException {
        if ("Event".equals(eventType)) {
            return new EventImpl();
        }
        throw new DOMException(9, "Not supported interface");
    }
}

