/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.dom.smil;

import com.android.mms.dom.NodeListImpl;
import com.android.mms.dom.smil.ElementTimeContainerImpl;
import java.util.ArrayList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.smil.ElementParallelTimeContainer;
import org.w3c.dom.smil.ElementTime;
import org.w3c.dom.smil.SMILElement;
import org.w3c.dom.smil.Time;
import org.w3c.dom.smil.TimeList;

public abstract class ElementParallelTimeContainerImpl
extends ElementTimeContainerImpl
implements ElementParallelTimeContainer {
    private static final String ENDSYNC_ATTRIBUTE_NAME = "endsync";
    private static final String ENDSYNC_FIRST = "first";
    private static final String ENDSYNC_LAST = "last";
    private static final String ENDSYNC_ALL = "all";
    private static final String ENDSYNC_MEDIA = "media";

    ElementParallelTimeContainerImpl(SMILElement element) {
        super(element);
    }

    public String getEndSync() {
        String endsync = this.mSmilElement.getAttribute(ENDSYNC_ATTRIBUTE_NAME);
        if (endsync == null || endsync.length() == 0) {
            this.setEndSync(ENDSYNC_LAST);
            return ENDSYNC_LAST;
        }
        if (ENDSYNC_FIRST.equals(endsync) || ENDSYNC_LAST.equals(endsync) || ENDSYNC_ALL.equals(endsync) || ENDSYNC_MEDIA.equals(endsync)) {
            return endsync;
        }
        this.setEndSync(ENDSYNC_LAST);
        return ENDSYNC_LAST;
    }

    public void setEndSync(String endSync) throws DOMException {
        if (!(ENDSYNC_FIRST.equals(endSync) || ENDSYNC_LAST.equals(endSync) || ENDSYNC_ALL.equals(endSync) || ENDSYNC_MEDIA.equals(endSync))) {
            throw new DOMException(9, "Unsupported endsync value" + endSync);
        }
        this.mSmilElement.setAttribute(ENDSYNC_ATTRIBUTE_NAME, endSync);
    }

    public float getDur() {
        float dur = super.getDur();
        if (dur == 0.0f) {
            dur = this.getImplicitDuration();
        }
        return dur;
    }

    public float getImplicitDuration() {
        float dur = -1.0f;
        if (ENDSYNC_LAST.equals(this.getEndSync())) {
            NodeList children = this.getTimeChildren();
            for (int i = 0; i < children.getLength(); ++i) {
                ElementTime child = (ElementTime)((Object)children.item(i));
                TimeList endTimeList = child.getEnd();
                for (int j = 0; j < endTimeList.getLength(); ++j) {
                    Time endTime = endTimeList.item(j);
                    if (endTime.getTimeType() == 0) {
                        return -1.0f;
                    }
                    if (!endTime.getResolved()) continue;
                    float end = (float)endTime.getResolvedOffset();
                    dur = end > dur ? end : dur;
                }
            }
        }
        return dur;
    }

    public NodeList getActiveChildrenAt(float instant) {
        ArrayList<Node> activeChildren = new ArrayList<Node>();
        NodeList children = this.getTimeChildren();
        int childrenLen = children.getLength();
        for (int i = 0; i < childrenLen; ++i) {
            double maxOffset = 0.0;
            boolean active = false;
            ElementTime child = (ElementTime)((Object)children.item(i));
            TimeList beginList = child.getBegin();
            int len = beginList.getLength();
            for (int j = 0; j < len; ++j) {
                double resolvedOffset;
                Time begin = beginList.item(j);
                if (!begin.getResolved() || !((resolvedOffset = begin.getResolvedOffset() * 1000.0) <= (double)instant) || !(resolvedOffset >= maxOffset)) continue;
                maxOffset = resolvedOffset;
                active = true;
            }
            TimeList endList = child.getEnd();
            len = endList.getLength();
            for (int j = 0; j < len; ++j) {
                double resolvedOffset;
                Time end = endList.item(j);
                if (!end.getResolved() || !((resolvedOffset = end.getResolvedOffset() * 1000.0) <= (double)instant) || !(resolvedOffset >= maxOffset)) continue;
                maxOffset = resolvedOffset;
                active = false;
            }
            if (!active) continue;
            activeChildren.add((Node)((Object)child));
        }
        return new NodeListImpl(activeChildren);
    }
}

