/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.data;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.Telephony;
import android.telephony.SmsMessage;
import android.text.TextUtils;
import android.util.Log;
import com.android.common.userhappiness.UserHappinessSignals;
import com.android.mms.ExceedMessageSizeException;
import com.android.mms.LogTag;
import com.android.mms.MmsConfig;
import com.android.mms.ResolutionException;
import com.android.mms.UnsupportContentTypeException;
import com.android.mms.data.ContactList;
import com.android.mms.data.Conversation;
import com.android.mms.data.RecipientIdCache;
import com.android.mms.model.AudioModel;
import com.android.mms.model.ImageModel;
import com.android.mms.model.MediaModel;
import com.android.mms.model.SlideModel;
import com.android.mms.model.SlideshowModel;
import com.android.mms.model.TextModel;
import com.android.mms.model.VideoModel;
import com.android.mms.transaction.MmsMessageSender;
import com.android.mms.transaction.SmsMessageSender;
import com.android.mms.ui.ComposeMessageActivity;
import com.android.mms.ui.MessageUtils;
import com.android.mms.ui.SlideshowEditor;
import com.android.mms.util.Recycler;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.PduBody;
import com.google.android.mms.pdu.PduPersister;
import com.google.android.mms.pdu.SendReq;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingMessage {
    private static final String TAG = "WorkingMessage";
    private static final boolean DEBUG = false;
    public static final String ACTION_SENDING_SMS = "android.intent.action.SENDING_SMS";
    public static final String EXTRA_SMS_MESSAGE = "android.mms.extra.MESSAGE";
    public static final String EXTRA_SMS_RECIPIENTS = "android.mms.extra.RECIPIENTS";
    public static final String EXTRA_SMS_THREAD_ID = "android.mms.extra.THREAD_ID";
    private final Activity mActivity;
    private final ContentResolver mContentResolver;
    private static final int RECIPIENTS_REQUIRE_MMS = 1;
    private static final int HAS_SUBJECT = 2;
    private static final int HAS_ATTACHMENT = 4;
    private static final int LENGTH_REQUIRES_MMS = 8;
    private static final int FORCE_MMS = 16;
    private int mMmsState;
    public static final int OK = 0;
    public static final int UNKNOWN_ERROR = -1;
    public static final int MESSAGE_SIZE_EXCEEDED = -2;
    public static final int UNSUPPORTED_TYPE = -3;
    public static final int IMAGE_TOO_LARGE = -4;
    public static final int TEXT = 0;
    public static final int IMAGE = 1;
    public static final int VIDEO = 2;
    public static final int AUDIO = 3;
    public static final int SLIDESHOW = 4;
    private int mAttachmentType;
    private Conversation mConversation;
    private CharSequence mText;
    private SlideshowModel mSlideshow;
    private Uri mMessageUri;
    private CharSequence mSubject;
    private boolean mDiscarded = false;
    private static boolean sMmsEnabled = MmsConfig.getMmsEnabled();
    private final MessageStatusListener mStatusListener;
    private List<String> mWorkingRecipients;
    private static final String[] MMS_OUTBOX_PROJECTION = new String[]{"_id", "m_size"};
    private static final int MMS_MESSAGE_SIZE_INDEX = 1;
    private static final String[] MMS_DRAFT_PROJECTION = new String[]{"_id", "sub", "sub_cs"};
    private static final int MMS_ID_INDEX = 0;
    private static final int MMS_SUBJECT_INDEX = 1;
    private static final int MMS_SUBJECT_CS_INDEX = 2;
    private static final String SMS_DRAFT_WHERE = "type=3";
    private static final String[] SMS_BODY_PROJECTION = new String[]{"body"};
    private static final int SMS_BODY_INDEX = 0;

    private WorkingMessage(ComposeMessageActivity activity) {
        this.mActivity = activity;
        this.mContentResolver = this.mActivity.getContentResolver();
        this.mStatusListener = activity;
        this.mAttachmentType = 0;
        this.mText = "";
    }

    public static WorkingMessage createEmpty(ComposeMessageActivity activity) {
        WorkingMessage msg = new WorkingMessage(activity);
        return msg;
    }

    public static WorkingMessage load(ComposeMessageActivity activity, Uri uri) {
        WorkingMessage msg;
        if (!uri.toString().startsWith(Telephony.Mms.Draft.CONTENT_URI.toString())) {
            PduPersister persister = PduPersister.getPduPersister((Context)activity);
            if (Log.isLoggable((String)"Mms:app", (int)2)) {
                LogTag.debug("load: moving %s to drafts", uri);
            }
            try {
                uri = persister.move(uri, Telephony.Mms.Draft.CONTENT_URI);
            }
            catch (MmsException e) {
                LogTag.error("Can't move %s to drafts", uri);
                return null;
            }
        }
        if ((msg = new WorkingMessage(activity)).loadFromUri(uri)) {
            return msg;
        }
        return null;
    }

    private void correctAttachmentState() {
        int slideCount = this.mSlideshow.size();
        if (slideCount == 0) {
            this.mAttachmentType = 0;
            this.mSlideshow = null;
            if (this.mMessageUri != null) {
                this.asyncDelete(this.mMessageUri, null, null);
                this.mMessageUri = null;
            }
        } else if (slideCount > 1) {
            this.mAttachmentType = 4;
        } else {
            SlideModel slide = this.mSlideshow.get(0);
            if (slide.hasImage()) {
                this.mAttachmentType = 1;
            } else if (slide.hasVideo()) {
                this.mAttachmentType = 2;
            } else if (slide.hasAudio()) {
                this.mAttachmentType = 3;
            }
        }
        this.updateState(4, this.hasAttachment(), false);
    }

    private boolean loadFromUri(Uri uri) {
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            LogTag.debug("loadFromUri %s", uri);
        }
        try {
            this.mSlideshow = SlideshowModel.createFromMessageUri((Context)this.mActivity, uri);
        }
        catch (MmsException e) {
            LogTag.error("Couldn't load URI %s", uri);
            return false;
        }
        this.mMessageUri = uri;
        this.syncTextFromSlideshow();
        this.correctAttachmentState();
        return true;
    }

    public static WorkingMessage loadDraft(ComposeMessageActivity activity, Conversation conv) {
        WorkingMessage msg = new WorkingMessage(activity);
        if (msg.loadFromConversation(conv)) {
            return msg;
        }
        return WorkingMessage.createEmpty(activity);
    }

    private boolean loadFromConversation(Conversation conv) {
        long threadId;
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            LogTag.debug("loadFromConversation %s", conv);
        }
        if ((threadId = conv.getThreadId()) <= 0L) {
            return false;
        }
        this.mText = this.readDraftSmsMessage(conv);
        if (!TextUtils.isEmpty((CharSequence)this.mText)) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        Uri uri = WorkingMessage.readDraftMmsMessage((Context)this.mActivity, threadId, sb);
        if (uri != null && this.loadFromUri(uri)) {
            if (sb.length() > 0) {
                this.setSubject(sb.toString(), false);
            }
            return true;
        }
        return false;
    }

    public void setText(CharSequence s) {
        this.mText = s;
    }

    public CharSequence getText() {
        return this.mText;
    }

    public boolean hasText() {
        return this.mText != null && TextUtils.getTrimmedLength((CharSequence)this.mText) > 0;
    }

    public int setAttachment(int type, Uri dataUri, boolean append) {
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            LogTag.debug("setAttachment type=%d uri %s", type, dataUri);
        }
        int result = 0;
        this.ensureSlideshow();
        try {
            if (append) {
                this.appendMedia(type, dataUri);
            } else {
                this.changeMedia(type, dataUri);
            }
        }
        catch (MmsException e) {
            result = -1;
        }
        catch (UnsupportContentTypeException e) {
            result = -3;
        }
        catch (ExceedMessageSizeException e) {
            result = -2;
        }
        catch (ResolutionException e) {
            result = -4;
        }
        if (result == 0) {
            this.mAttachmentType = type;
            this.mStatusListener.onAttachmentChanged();
        } else if (append) {
            SlideshowEditor slideShowEditor = new SlideshowEditor((Context)this.mActivity, this.mSlideshow);
            slideShowEditor.removeSlide(this.mSlideshow.size() - 1);
        }
        if (!MmsConfig.getMultipartSmsEnabled()) {
            if (!append && this.mAttachmentType == 0 && type == 0) {
                int[] params = SmsMessage.calculateLength((CharSequence)this.getText(), (boolean)false);
                int msgCount = params[0];
                if (msgCount >= MmsConfig.getSmsToMmsTextThreshold()) {
                    this.setLengthRequiresMms(true, false);
                } else {
                    this.updateState(4, this.hasAttachment(), true);
                }
            } else {
                this.updateState(4, this.hasAttachment(), true);
            }
        } else {
            this.updateState(4, this.hasAttachment(), true);
        }
        this.correctAttachmentState();
        return result;
    }

    public boolean isWorthSaving() {
        if (this.hasText() || this.hasSubject() || this.hasAttachment() || this.hasSlideshow()) {
            return true;
        }
        return this.isFakeMmsForDraft();
    }

    public boolean isFakeMmsForDraft() {
        return (this.mMmsState & 0x10) > 0;
    }

    private void ensureSlideshow() {
        if (this.mSlideshow != null) {
            return;
        }
        SlideshowModel slideshow = SlideshowModel.createNew((Context)this.mActivity);
        SlideModel slide = new SlideModel(slideshow);
        slideshow.add(slide);
        this.mSlideshow = slideshow;
    }

    private void changeMedia(int type, Uri uri) throws MmsException {
        MediaModel media;
        SlideModel slide = this.mSlideshow.get(0);
        if (slide == null) {
            Log.w((String)"Mms", (String)"[WorkingMessage] changeMedia: no slides!");
            return;
        }
        slide.removeImage();
        slide.removeVideo();
        slide.removeAudio();
        if (type == 0) {
            return;
        }
        if (type == 1) {
            media = new ImageModel((Context)this.mActivity, uri, this.mSlideshow.getLayout().getImageRegion());
        } else if (type == 2) {
            media = new VideoModel((Context)this.mActivity, uri, this.mSlideshow.getLayout().getImageRegion());
        } else if (type == 3) {
            media = new AudioModel((Context)this.mActivity, uri);
        } else {
            throw new IllegalArgumentException("changeMedia type=" + type + ", uri=" + uri);
        }
        slide.add(media);
        if (type == 2 || type == 3) {
            slide.updateDuration(media.getDuration());
        }
    }

    private void appendMedia(int type, Uri uri) throws MmsException {
        MediaModel media;
        SlideshowEditor slideShowEditor;
        if (type == 0) {
            return;
        }
        boolean addNewSlide = true;
        if (this.mSlideshow.size() == 1 && !this.mSlideshow.isSimple()) {
            addNewSlide = false;
        }
        if (addNewSlide && !(slideShowEditor = new SlideshowEditor((Context)this.mActivity, this.mSlideshow)).addNewSlide()) {
            return;
        }
        SlideModel slide = this.mSlideshow.get(this.mSlideshow.size() - 1);
        if (type == 1) {
            media = new ImageModel((Context)this.mActivity, uri, this.mSlideshow.getLayout().getImageRegion());
        } else if (type == 2) {
            media = new VideoModel((Context)this.mActivity, uri, this.mSlideshow.getLayout().getImageRegion());
        } else if (type == 3) {
            media = new AudioModel((Context)this.mActivity, uri);
        } else {
            throw new IllegalArgumentException("changeMedia type=" + type + ", uri=" + uri);
        }
        slide.add(media);
        if (type == 2 || type == 3) {
            slide.updateDuration(media.getDuration());
        }
    }

    public boolean hasAttachment() {
        return this.mAttachmentType > 0;
    }

    public SlideshowModel getSlideshow() {
        return this.mSlideshow;
    }

    public boolean hasSlideshow() {
        return this.mAttachmentType == 4;
    }

    public void setSubject(CharSequence s, boolean notify) {
        this.mSubject = s;
        this.updateState(2, s != null, notify);
    }

    public CharSequence getSubject() {
        return this.mSubject;
    }

    public boolean hasSubject() {
        return this.mSubject != null && TextUtils.getTrimmedLength((CharSequence)this.mSubject) > 0;
    }

    private void syncTextToSlideshow() {
        TextModel text;
        if (this.mSlideshow == null || this.mSlideshow.size() != 1) {
            return;
        }
        SlideModel slide = this.mSlideshow.get(0);
        if (!slide.hasText()) {
            text = new TextModel((Context)this.mActivity, "text/plain", "text_0.txt", this.mSlideshow.getLayout().getTextRegion());
            slide.add(text);
        } else {
            text = slide.getText();
        }
        text.setText(this.mText);
    }

    private void syncTextFromSlideshow() {
        if (this.mSlideshow.size() != 1) {
            return;
        }
        SlideModel slide = this.mSlideshow.get(0);
        if (slide == null || !slide.hasText()) {
            return;
        }
        this.mText = slide.getText().getText();
    }

    private void removeSubjectIfEmpty(boolean notify) {
        if (!this.hasSubject()) {
            this.setSubject(null, notify);
        }
    }

    private void prepareForSave(boolean notify) {
        this.syncWorkingRecipients();
        if (this.requiresMms()) {
            this.ensureSlideshow();
            this.syncTextToSlideshow();
            this.removeSubjectIfEmpty(notify);
        }
    }

    public void syncWorkingRecipients() {
        if (this.mWorkingRecipients != null) {
            ContactList recipients = ContactList.getByNumbers(this.mWorkingRecipients, false);
            this.mConversation.setRecipients(recipients);
            this.mWorkingRecipients = null;
        }
    }

    public String getWorkingRecipients() {
        if (this.mWorkingRecipients == null) {
            return null;
        }
        ContactList recipients = ContactList.getByNumbers(this.mWorkingRecipients, false);
        return recipients.serialize();
    }

    public void removeFakeMmsForDraft() {
        this.updateState(16, false, false);
    }

    public Uri saveAsMms(boolean notify) {
        if (this.mDiscarded) {
            throw new IllegalStateException("save() called after discard()");
        }
        this.updateState(16, true, notify);
        this.prepareForSave(true);
        this.mConversation.ensureThreadId();
        this.mConversation.setDraftState(true);
        PduPersister persister = PduPersister.getPduPersister((Context)this.mActivity);
        SendReq sendReq = WorkingMessage.makeSendReq(this.mConversation, this.mSubject);
        if (this.mMessageUri == null) {
            this.mMessageUri = WorkingMessage.createDraftMmsMessage(persister, sendReq, this.mSlideshow);
        } else {
            WorkingMessage.updateDraftMmsMessage(this.mMessageUri, persister, this.mSlideshow, sendReq);
        }
        return this.mMessageUri;
    }

    public void saveDraft() {
        if (this.mDiscarded) {
            return;
        }
        if (this.mConversation == null) {
            throw new IllegalStateException("saveDraft() called with no conversation");
        }
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            LogTag.debug("saveDraft for mConversation " + this.mConversation, new Object[0]);
        }
        this.prepareForSave(false);
        if (this.requiresMms()) {
            this.asyncUpdateDraftMmsMessage(this.mConversation);
        } else {
            String content = ((Object)this.mText).toString();
            if (!TextUtils.isEmpty((CharSequence)content)) {
                this.asyncUpdateDraftSmsMessage(this.mConversation, content);
            }
        }
        this.mConversation.setDraftState(true);
    }

    public synchronized void discard() {
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            LogTag.debug("[WorkingMessage] discard", new Object[0]);
        }
        if (this.mDiscarded) {
            return;
        }
        this.mDiscarded = true;
        if (this.mMessageUri != null) {
            this.asyncDelete(this.mMessageUri, null, null);
        }
        this.clearConversation(this.mConversation);
    }

    public void unDiscard() {
        this.mDiscarded = false;
    }

    public boolean isDiscarded() {
        return this.mDiscarded;
    }

    public void writeStateToBundle(Bundle bundle) {
        if (this.hasSubject()) {
            bundle.putString("subject", ((Object)this.mSubject).toString());
        }
        if (this.mMessageUri != null) {
            bundle.putParcelable("msg_uri", (Parcelable)this.mMessageUri);
        } else if (this.hasText()) {
            bundle.putString("sms_body", ((Object)this.mText).toString());
        }
    }

    public void readStateFromBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        String subject = bundle.getString("subject");
        this.setSubject(subject, false);
        Uri uri = (Uri)bundle.getParcelable("msg_uri");
        if (uri != null) {
            this.loadFromUri(uri);
            return;
        }
        String body = bundle.getString("sms_body");
        this.mText = body;
    }

    public void setWorkingRecipients(List<String> numbers) {
        this.mWorkingRecipients = numbers;
        Log.i((String)TAG, (String)"setWorkingRecipients");
    }

    private void dumpWorkingRecipients() {
        Log.i((String)TAG, (String)"-- mWorkingRecipients:");
        if (this.mWorkingRecipients != null) {
            int count = this.mWorkingRecipients.size();
            for (int i = 0; i < count; ++i) {
                Log.i((String)TAG, (String)("   [" + i + "] " + this.mWorkingRecipients.get(i)));
            }
            Log.i((String)TAG, (String)"");
        }
    }

    public void dump() {
        Log.i((String)TAG, (String)"WorkingMessage:");
        this.dumpWorkingRecipients();
        if (this.mConversation != null) {
            Log.i((String)TAG, (String)("mConversation: " + this.mConversation.toString()));
        }
    }

    public void setConversation(Conversation conv) {
        this.mConversation = conv;
        this.setHasEmail(conv.getRecipients().containsEmail(), false);
    }

    public void setHasEmail(boolean hasEmail, boolean notify) {
        if (MmsConfig.getEmailGateway() != null) {
            this.updateState(1, false, notify);
        } else {
            this.updateState(1, hasEmail, notify);
        }
    }

    public boolean requiresMms() {
        return this.mMmsState > 0;
    }

    public void setLengthRequiresMms(boolean mmsRequired, boolean notify) {
        this.updateState(8, mmsRequired, notify);
    }

    private static String stateString(int state) {
        if (state == 0) {
            return "<none>";
        }
        StringBuilder sb = new StringBuilder();
        if ((state & 1) > 0) {
            sb.append("RECIPIENTS_REQUIRE_MMS | ");
        }
        if ((state & 2) > 0) {
            sb.append("HAS_SUBJECT | ");
        }
        if ((state & 4) > 0) {
            sb.append("HAS_ATTACHMENT | ");
        }
        if ((state & 8) > 0) {
            sb.append("LENGTH_REQUIRES_MMS | ");
        }
        if ((state & 0x10) > 0) {
            sb.append("FORCE_MMS | ");
        }
        sb.delete(sb.length() - 3, sb.length());
        return sb.toString();
    }

    private void updateState(int state, boolean on, boolean notify) {
        if (!sMmsEnabled) {
            return;
        }
        int oldState = this.mMmsState;
        this.mMmsState = on ? (this.mMmsState |= state) : (this.mMmsState &= ~state);
        if (this.mMmsState == 16 && (oldState & 0xFFFFFFEF) > 0) {
            this.mMmsState = 0;
        }
        if (notify) {
            if (oldState == 0 && this.mMmsState != 0) {
                this.mStatusListener.onProtocolChanged(true);
            } else if (oldState != 0 && this.mMmsState == 0) {
                this.mStatusListener.onProtocolChanged(false);
            }
        }
        if (oldState != this.mMmsState && Log.isLoggable((String)"Mms:app", (int)2)) {
            LogTag.debug("updateState: %s%s = %s", on ? "+" : "-", WorkingMessage.stateString(state), WorkingMessage.stateString(this.mMmsState));
        }
    }

    public void send(final String recipientsInUI) {
        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
            LogTag.debug("send", new Object[0]);
        }
        this.prepareForSave(true);
        String newRecipients = this.mConversation.getRecipients().serialize();
        if (!TextUtils.isEmpty((CharSequence)recipientsInUI) && !newRecipients.equals(recipientsInUI)) {
            LogTag.warnPossibleRecipientMismatch("send() after newRecipients changed from " + recipientsInUI + " to " + newRecipients, this.mActivity);
            this.dumpWorkingRecipients();
        }
        final Conversation conv = this.mConversation;
        String msgTxt = ((Object)this.mText).toString();
        if (this.requiresMms() || this.addressContainsEmailToMms(conv, msgTxt)) {
            final Uri mmsUri = this.mMessageUri;
            final PduPersister persister = PduPersister.getPduPersister((Context)this.mActivity);
            final SlideshowModel slideshow = this.mSlideshow;
            final SendReq sendReq = WorkingMessage.makeSendReq(conv, this.mSubject);
            new Thread(new Runnable(){

                public void run() {
                    slideshow.prepareForSend();
                    WorkingMessage.this.sendMmsWorker(conv, mmsUri, persister, slideshow, sendReq);
                }
            }).start();
        } else {
            final String msgText = ((Object)this.mText).toString();
            new Thread(new Runnable(){

                public void run() {
                    WorkingMessage.this.preSendSmsWorker(conv, msgText, recipientsInUI);
                }
            }).start();
        }
        RecipientIdCache.updateNumbers(conv.getThreadId(), conv.getRecipients());
        this.mDiscarded = true;
    }

    private boolean addressContainsEmailToMms(Conversation conv, String text) {
        if (MmsConfig.getEmailGateway() != null) {
            String[] dests = conv.getRecipients().getNumbers();
            int length = dests.length;
            for (int i = 0; i < length; ++i) {
                String mtext;
                int[] params;
                if (!Telephony.Mms.isEmailAddress((String)dests[i]) && !MessageUtils.isAlias(dests[i]) || (params = SmsMessage.calculateLength((String)(mtext = dests[i] + " " + text), (boolean)false))[0] <= 1) continue;
                this.updateState(1, true, true);
                this.ensureSlideshow();
                this.syncTextToSlideshow();
                return true;
            }
        }
        return false;
    }

    private void preSendSmsWorker(Conversation conv, String msgText, String recipientsInUI) {
        UserHappinessSignals.userAcceptedImeText((Context)this.mActivity);
        this.mStatusListener.onPreMessageSent();
        long origThreadId = conv.getThreadId();
        long threadId = conv.ensureThreadId();
        String semiSepRecipients = conv.getRecipients().serialize();
        if (origThreadId != 0L && origThreadId != threadId || !semiSepRecipients.equals(recipientsInUI) && !TextUtils.isEmpty((CharSequence)recipientsInUI)) {
            String msg = origThreadId != 0L && origThreadId != threadId ? "WorkingMessage.preSendSmsWorker threadId changed or recipients changed. origThreadId: " + origThreadId + " new threadId: " + threadId + " also mConversation.getThreadId(): " + this.mConversation.getThreadId() : "Recipients in window: \"" + recipientsInUI + "\" differ from recipients from conv: \"" + semiSepRecipients + "\"";
            LogTag.warnPossibleRecipientMismatch(msg, this.mActivity);
        }
        this.sendSmsWorker(msgText, semiSepRecipients, threadId);
        this.deleteDraftSmsMessage(threadId);
    }

    private void sendSmsWorker(String msgText, String semiSepRecipients, long threadId) {
        String[] dests = TextUtils.split((String)semiSepRecipients, (String)";");
        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
            LogTag.debug("sendSmsWorker sending message: recipients=" + semiSepRecipients + ", threadId=" + threadId, new Object[0]);
        }
        SmsMessageSender sender = new SmsMessageSender((Context)this.mActivity, dests, msgText, threadId);
        try {
            sender.sendMessage(threadId);
            Recycler.getSmsRecycler().deleteOldMessagesByThreadId((Context)this.mActivity, threadId);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Failed to send SMS message, threadId=" + threadId), (Throwable)e);
        }
        this.mStatusListener.onMessageSent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMmsWorker(Conversation conv, Uri mmsUri, PduPersister persister, SlideshowModel slideshow, SendReq sendReq) {
        UserHappinessSignals.userAcceptedImeText((Context)this.mActivity);
        Cursor cursor = null;
        try {
            cursor = SqliteWrapper.query((Context)this.mActivity, (ContentResolver)this.mContentResolver, (Uri)Telephony.Mms.Outbox.CONTENT_URI, (String[])MMS_OUTBOX_PROJECTION, null, null, null);
            if (cursor != null) {
                long maxMessageSize = MmsConfig.getMaxSizeScaleForPendingMmsAllowed() * MmsConfig.getMaxMessageSize();
                long totalPendingSize = 0L;
                while (cursor.moveToNext()) {
                    totalPendingSize += cursor.getLong(1);
                }
                if (totalPendingSize >= maxMessageSize) {
                    this.unDiscard();
                    this.mStatusListener.onMaxPendingMessagesReached();
                    return;
                }
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        this.mStatusListener.onPreMessageSent();
        long threadId = conv.ensureThreadId();
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            LogTag.debug("sendMmsWorker: update draft MMS message " + mmsUri, new Object[0]);
        }
        if (mmsUri == null) {
            mmsUri = WorkingMessage.createDraftMmsMessage(persister, sendReq, slideshow);
        } else {
            WorkingMessage.updateDraftMmsMessage(mmsUri, persister, slideshow, sendReq);
        }
        this.deleteDraftSmsMessage(threadId);
        int error = 0;
        try {
            slideshow.finalResize(mmsUri);
        }
        catch (ExceedMessageSizeException e1) {
            error = -2;
        }
        catch (MmsException e1) {
            error = -1;
        }
        if (error != 0) {
            this.markMmsMessageWithError(mmsUri);
            this.mStatusListener.onAttachmentError(error);
            return;
        }
        MmsMessageSender sender = new MmsMessageSender((Context)this.mActivity, mmsUri, slideshow.getCurrentMessageSize());
        try {
            if (!sender.sendMessage(threadId)) {
                SqliteWrapper.delete((Context)this.mActivity, (ContentResolver)this.mContentResolver, (Uri)mmsUri, null, null);
            }
            Recycler.getMmsRecycler().deleteOldMessagesByThreadId((Context)this.mActivity, threadId);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Failed to send message: " + mmsUri + ", threadId=" + threadId), (Throwable)e);
        }
        this.mStatusListener.onMessageSent();
    }

    private void markMmsMessageWithError(Uri mmsUri) {
        try {
            PduPersister p = PduPersister.getPduPersister((Context)this.mActivity);
            p.move(mmsUri, Telephony.Mms.Outbox.CONTENT_URI);
            ContentValues values = new ContentValues(1);
            values.put("err_type", Integer.valueOf(10));
            long msgId = ContentUris.parseId((Uri)mmsUri);
            SqliteWrapper.update((Context)this.mActivity, (ContentResolver)this.mContentResolver, (Uri)Telephony.MmsSms.PendingMessages.CONTENT_URI, (ContentValues)values, (String)("_id=" + msgId), null);
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)("Failed to move message to outbox and mark as error: " + mmsUri), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Uri readDraftMmsMessage(Context context, long threadId, StringBuilder sb) {
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            LogTag.debug("readDraftMmsMessage tid=%d", threadId);
        }
        ContentResolver cr = context.getContentResolver();
        String selection = "thread_id = " + threadId;
        Cursor cursor = SqliteWrapper.query((Context)context, (ContentResolver)cr, (Uri)Telephony.Mms.Draft.CONTENT_URI, (String[])MMS_DRAFT_PROJECTION, (String)selection, null, null);
        try {
            if (cursor.moveToFirst()) {
                Uri uri = ContentUris.withAppendedId((Uri)Telephony.Mms.Draft.CONTENT_URI, (long)cursor.getLong(0));
                String subject = MessageUtils.extractEncStrFromCursor(cursor, 1, 2);
                if (subject != null) {
                    sb.append(subject);
                }
                Uri uri2 = uri;
                return uri2;
            }
        }
        finally {
            cursor.close();
        }
        return null;
    }

    private static SendReq makeSendReq(Conversation conv, CharSequence subject) {
        String[] dests = conv.getRecipients().getNumbers(true);
        SendReq req = new SendReq();
        EncodedStringValue[] encodedNumbers = EncodedStringValue.encodeStrings((String[])dests);
        if (encodedNumbers != null) {
            req.setTo(encodedNumbers);
        }
        if (!TextUtils.isEmpty((CharSequence)subject)) {
            req.setSubject(new EncodedStringValue(((Object)subject).toString()));
        }
        req.setDate(System.currentTimeMillis() / 1000L);
        return req;
    }

    private static Uri createDraftMmsMessage(PduPersister persister, SendReq sendReq, SlideshowModel slideshow) {
        try {
            PduBody pb = slideshow.toPduBody();
            sendReq.setBody(pb);
            Uri res = persister.persist((GenericPdu)sendReq, Telephony.Mms.Draft.CONTENT_URI);
            slideshow.sync(pb);
            return res;
        }
        catch (MmsException e) {
            return null;
        }
    }

    private void asyncUpdateDraftMmsMessage(final Conversation conv) {
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            LogTag.debug("asyncUpdateDraftMmsMessage conv=%s mMessageUri=%s", conv, this.mMessageUri);
        }
        final PduPersister persister = PduPersister.getPduPersister((Context)this.mActivity);
        final SendReq sendReq = WorkingMessage.makeSendReq(conv, this.mSubject);
        new Thread(new Runnable(){

            public void run() {
                conv.ensureThreadId();
                conv.setDraftState(true);
                if (WorkingMessage.this.mMessageUri == null) {
                    WorkingMessage.this.mMessageUri = WorkingMessage.createDraftMmsMessage(persister, sendReq, WorkingMessage.this.mSlideshow);
                } else {
                    WorkingMessage.updateDraftMmsMessage(WorkingMessage.this.mMessageUri, persister, WorkingMessage.this.mSlideshow, sendReq);
                }
                WorkingMessage.this.asyncDeleteDraftSmsMessage(conv);
            }
        }).start();
    }

    private static void updateDraftMmsMessage(Uri uri, PduPersister persister, SlideshowModel slideshow, SendReq sendReq) {
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            LogTag.debug("updateDraftMmsMessage uri=%s", uri);
        }
        if (uri == null) {
            Log.e((String)TAG, (String)"updateDraftMmsMessage null uri");
            return;
        }
        persister.updateHeaders(uri, sendReq);
        PduBody pb = slideshow.toPduBody();
        try {
            persister.updateParts(uri, pb);
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)("updateDraftMmsMessage: cannot update message " + uri));
        }
        slideshow.sync(pb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readDraftSmsMessage(Conversation conv) {
        long thread_id = conv.getThreadId();
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            LogTag.debug("readDraftSmsMessage tid=%d", thread_id);
        }
        if (thread_id <= 0L || !conv.hasDraft()) {
            return "";
        }
        Uri thread_uri = ContentUris.withAppendedId((Uri)Telephony.Sms.Conversations.CONTENT_URI, (long)thread_id);
        String body = "";
        Cursor c = SqliteWrapper.query((Context)this.mActivity, (ContentResolver)this.mContentResolver, (Uri)thread_uri, (String[])SMS_BODY_PROJECTION, (String)SMS_DRAFT_WHERE, null, null);
        boolean haveDraft = false;
        if (c != null) {
            try {
                if (c.moveToFirst()) {
                    body = c.getString(0);
                    haveDraft = true;
                }
            }
            finally {
                c.close();
            }
        }
        if (haveDraft && conv.getMessageCount() == 0) {
            this.clearConversation(conv);
        }
        return body;
    }

    private void clearConversation(Conversation conv) {
        this.asyncDeleteDraftSmsMessage(conv);
        if (conv.getMessageCount() == 0) {
            conv.clearThreadId();
        }
        conv.setDraftState(false);
    }

    private void asyncUpdateDraftSmsMessage(final Conversation conv, final String contents) {
        new Thread(new Runnable(){

            public void run() {
                long threadId = conv.ensureThreadId();
                conv.setDraftState(true);
                WorkingMessage.this.updateDraftSmsMessage(threadId, contents);
            }
        }).start();
    }

    private void updateDraftSmsMessage(long thread_id, String contents) {
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            LogTag.debug("updateDraftSmsMessage tid=%d, contents=\"%s\"", thread_id, contents);
        }
        if (thread_id <= 0L) {
            return;
        }
        ContentValues values = new ContentValues(3);
        values.put("thread_id", Long.valueOf(thread_id));
        values.put("body", contents);
        values.put("type", Integer.valueOf(3));
        SqliteWrapper.insert((Context)this.mActivity, (ContentResolver)this.mContentResolver, (Uri)Telephony.Sms.CONTENT_URI, (ContentValues)values);
        this.asyncDeleteDraftMmsMessage(thread_id);
    }

    private void asyncDelete(final Uri uri, final String selection, final String[] selectionArgs) {
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            LogTag.debug("asyncDelete %s where %s", uri, selection);
        }
        new Thread(new Runnable(){

            public void run() {
                SqliteWrapper.delete((Context)WorkingMessage.this.mActivity, (ContentResolver)WorkingMessage.this.mContentResolver, (Uri)uri, (String)selection, (String[])selectionArgs);
            }
        }).start();
    }

    private void asyncDeleteDraftSmsMessage(Conversation conv) {
        long threadId = conv.getThreadId();
        if (threadId > 0L) {
            this.asyncDelete(ContentUris.withAppendedId((Uri)Telephony.Sms.Conversations.CONTENT_URI, (long)threadId), SMS_DRAFT_WHERE, null);
        }
    }

    private void deleteDraftSmsMessage(long threadId) {
        SqliteWrapper.delete((Context)this.mActivity, (ContentResolver)this.mContentResolver, (Uri)ContentUris.withAppendedId((Uri)Telephony.Sms.Conversations.CONTENT_URI, (long)threadId), (String)SMS_DRAFT_WHERE, null);
    }

    private void asyncDeleteDraftMmsMessage(long threadId) {
        String where = "thread_id = " + threadId;
        this.asyncDelete(Telephony.Mms.Draft.CONTENT_URI, where, null);
    }

    public static interface MessageStatusListener {
        public void onProtocolChanged(boolean var1);

        public void onAttachmentChanged();

        public void onPreMessageSent();

        public void onMessageSent();

        public void onMaxPendingMessagesReached();

        public void onAttachmentError(int var1);
    }
}

