/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.data;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.android.mms.LogTag;
import com.android.mms.data.Contact;
import com.android.mms.data.ContactList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipientIdCache {
    private static final boolean LOCAL_DEBUG = false;
    private static final String TAG = "Mms/cache";
    private static Uri sAllCanonical = Uri.parse((String)"content://mms-sms/canonical-addresses");
    private static Uri sSingleCanonicalAddressUri = Uri.parse((String)"content://mms-sms/canonical-address");
    private static RecipientIdCache sInstance;
    private final Map<Long, String> mCache = new HashMap<Long, String>();
    private final Context mContext;

    static RecipientIdCache getInstance() {
        return sInstance;
    }

    static void init(Context context) {
        sInstance = new RecipientIdCache(context);
        new Thread(new Runnable(){

            public void run() {
                RecipientIdCache.fill();
            }
        }).start();
    }

    RecipientIdCache(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fill() {
        Context context;
        Cursor c;
        if (Log.isLoggable((String)"Mms:threadcache", (int)2)) {
            LogTag.debug("[RecipientIdCache] fill: begin", new Object[0]);
        }
        if ((c = SqliteWrapper.query((Context)(context = RecipientIdCache.sInstance.mContext), (ContentResolver)context.getContentResolver(), (Uri)sAllCanonical, null, null, null, null)) == null) {
            Log.w((String)TAG, (String)"null Cursor in fill()");
            return;
        }
        try {
            RecipientIdCache recipientIdCache = sInstance;
            synchronized (recipientIdCache) {
                RecipientIdCache.sInstance.mCache.clear();
                while (c.moveToNext()) {
                    long id2 = c.getLong(0);
                    String number = c.getString(1);
                    RecipientIdCache.sInstance.mCache.put(id2, number);
                }
            }
        }
        finally {
            c.close();
        }
        if (Log.isLoggable((String)"Mms:threadcache", (int)2)) {
            LogTag.debug("[RecipientIdCache] fill: finished", new Object[0]);
            RecipientIdCache.dump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Entry> getAddresses(String spaceSepIds) {
        RecipientIdCache recipientIdCache = sInstance;
        synchronized (recipientIdCache) {
            String[] ids;
            ArrayList<Entry> numbers = new ArrayList<Entry>();
            for (String id2 : ids = spaceSepIds.split(" ")) {
                long longId;
                try {
                    longId = Long.parseLong(id2);
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                String number = RecipientIdCache.sInstance.mCache.get(longId);
                if (number == null) {
                    Log.w((String)TAG, (String)("RecipientId " + longId + " not in cache!"));
                    if (Log.isLoggable((String)"Mms:threadcache", (int)2)) {
                        RecipientIdCache.dump();
                    }
                    RecipientIdCache.fill();
                    number = RecipientIdCache.sInstance.mCache.get(longId);
                }
                if (TextUtils.isEmpty((CharSequence)number)) {
                    Log.w((String)TAG, (String)("RecipientId " + longId + " has empty number!"));
                    continue;
                }
                numbers.add(new Entry(longId, number));
            }
            return numbers;
        }
    }

    public static void updateNumbers(long threadId, ContactList contacts) {
        long recipientId = 0L;
        for (Contact contact : contacts) {
            if (!contact.isNumberModified()) continue;
            contact.setIsNumberModified(false);
            recipientId = contact.getRecipientId();
            if (recipientId == 0L) continue;
            String number1 = contact.getNumber();
            String number2 = RecipientIdCache.sInstance.mCache.get(recipientId);
            if (Log.isLoggable((String)"Mms:app", (int)2)) {
                Log.d((String)TAG, (String)("[RecipientIdCache] updateNumbers: comparing " + number1 + " with " + number2));
            }
            if (number1.equalsIgnoreCase(number2)) continue;
            RecipientIdCache.sInstance.mCache.put(recipientId, number1);
            sInstance.updateCanonicalAddressInDb(recipientId, number1);
        }
    }

    private void updateCanonicalAddressInDb(long id2, String number) {
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            Log.d((String)TAG, (String)("[RecipientIdCache] updateCanonicalAddressInDb: id=" + id2 + ", number=" + number));
        }
        final ContentValues values = new ContentValues();
        values.put("address", number);
        final StringBuilder buf = new StringBuilder("_id");
        buf.append('=').append(id2);
        final Uri uri = ContentUris.withAppendedId((Uri)sSingleCanonicalAddressUri, (long)id2);
        final ContentResolver cr = this.mContext.getContentResolver();
        new Thread("updateCanonicalAddressInDb"){

            public void run() {
                cr.update(uri, values, buf.toString(), null);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump() {
        RecipientIdCache recipientIdCache = sInstance;
        synchronized (recipientIdCache) {
            Log.d((String)TAG, (String)"*** Recipient ID cache dump ***");
            for (Long id2 : RecipientIdCache.sInstance.mCache.keySet()) {
                Log.d((String)TAG, (String)(id2 + ": " + RecipientIdCache.sInstance.mCache.get(id2)));
            }
        }
    }

    public static class Entry {
        public long id;
        public String number;

        public Entry(long id2, String number) {
            this.id = id2;
            this.number = number;
        }
    }
}

