/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.data;

import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.Telephony;
import android.text.TextUtils;
import android.util.Log;
import com.android.mms.LogTag;
import com.android.mms.data.Contact;
import com.android.mms.data.ContactList;
import com.android.mms.transaction.MessagingNotification;
import com.android.mms.ui.MessageUtils;
import com.android.mms.util.DraftCache;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Conversation {
    private static final String TAG = "Mms/conv";
    private static final boolean DEBUG = false;
    private static final Uri sAllThreadsUri = Telephony.Threads.CONTENT_URI.buildUpon().appendQueryParameter("simple", "true").build();
    private static final String[] ALL_THREADS_PROJECTION = new String[]{"_id", "date", "message_count", "recipient_ids", "snippet", "snippet_cs", "read", "error", "has_attachment"};
    private static final String[] UNREAD_PROJECTION = new String[]{"_id", "read"};
    private static final String UNREAD_SELECTION = "(read=0 OR seen=0)";
    private static final String[] SEEN_PROJECTION = new String[]{"seen"};
    private static final int ID = 0;
    private static final int DATE = 1;
    private static final int MESSAGE_COUNT = 2;
    private static final int RECIPIENT_IDS = 3;
    private static final int SNIPPET = 4;
    private static final int SNIPPET_CS = 5;
    private static final int READ = 6;
    private static final int ERROR = 7;
    private static final int HAS_ATTACHMENT = 8;
    private final Context mContext;
    private long mThreadId;
    private ContactList mRecipients;
    private long mDate;
    private int mMessageCount;
    private String mSnippet;
    private boolean mHasUnreadMessages;
    private boolean mHasAttachment;
    private boolean mHasError;
    private static ContentValues mReadContentValues;
    private static boolean mLoadingThreads;
    private boolean mMarkAsReadBlocked;
    private Object mMarkAsBlockedSyncer = new Object();

    private Conversation(Context context) {
        this.mContext = context;
        this.mRecipients = new ContactList();
        this.mThreadId = 0L;
    }

    private Conversation(Context context, long threadId, boolean allowQuery) {
        this.mContext = context;
        if (!this.loadFromThreadId(threadId, allowQuery)) {
            this.mRecipients = new ContactList();
            this.mThreadId = 0L;
        }
    }

    private Conversation(Context context, Cursor cursor, boolean allowQuery) {
        this.mContext = context;
        Conversation.fillFromCursor(context, this, cursor, allowQuery);
    }

    public static Conversation createNew(Context context) {
        return new Conversation(context);
    }

    public static Conversation get(Context context, long threadId, boolean allowQuery) {
        Conversation conv = Cache.get(threadId);
        if (conv != null) {
            return conv;
        }
        conv = new Conversation(context, threadId, allowQuery);
        try {
            Cache.put(conv);
        }
        catch (IllegalStateException e) {
            LogTag.error("Tried to add duplicate Conversation to Cache", new Object[0]);
        }
        return conv;
    }

    public static Conversation get(Context context, ContactList recipients, boolean allowQuery) {
        if (recipients.size() < 1) {
            return Conversation.createNew(context);
        }
        Conversation conv = Cache.get(recipients);
        if (conv != null) {
            return conv;
        }
        long threadId = Conversation.getOrCreateThreadId(context, recipients);
        conv = new Conversation(context, threadId, allowQuery);
        Log.d((String)TAG, (String)"Conversation.get: created new conversation xxxxxxx");
        if (!conv.getRecipients().equals(recipients)) {
            Log.e((String)TAG, (String)"Conversation.get: new conv's recipients don't match input recpients xxxxxxx");
        }
        try {
            Cache.put(conv);
        }
        catch (IllegalStateException e) {
            LogTag.error("Tried to add duplicate Conversation to Cache", new Object[0]);
        }
        return conv;
    }

    public static Conversation get(Context context, Uri uri, boolean allowQuery) {
        if (uri == null) {
            return Conversation.createNew(context);
        }
        if (uri.getPathSegments().size() >= 2) {
            try {
                long threadId = Long.parseLong((String)uri.getPathSegments().get(1));
                return Conversation.get(context, threadId, allowQuery);
            }
            catch (NumberFormatException exception) {
                LogTag.error("Invalid URI: " + uri, new Object[0]);
            }
        }
        String recipient = Conversation.getRecipients(uri);
        return Conversation.get(context, ContactList.getByNumbers(recipient, allowQuery, true), allowQuery);
    }

    public boolean sameRecipient(Uri uri) {
        int size = this.mRecipients.size();
        if (size > 1) {
            return false;
        }
        if (uri == null) {
            return size == 0;
        }
        if (uri.getPathSegments().size() >= 2) {
            return false;
        }
        String recipient = Conversation.getRecipients(uri);
        ContactList incomingRecipient = ContactList.getByNumbers(recipient, false, false);
        return this.mRecipients.equals(incomingRecipient);
    }

    public static Conversation from(Context context, Cursor cursor) {
        Conversation conv;
        long threadId = cursor.getLong(0);
        if (threadId > 0L && (conv = Cache.get(threadId)) != null) {
            Conversation.fillFromCursor(context, conv, cursor, false);
            return conv;
        }
        conv = new Conversation(context, cursor, false);
        try {
            Cache.put(conv);
        }
        catch (IllegalStateException e) {
            LogTag.error("Tried to add duplicate Conversation to Cache", new Object[0]);
        }
        return conv;
    }

    private void buildReadContentValues() {
        if (mReadContentValues == null) {
            mReadContentValues = new ContentValues(2);
            mReadContentValues.put("read", Integer.valueOf(1));
            mReadContentValues.put("seen", Integer.valueOf(1));
        }
    }

    public void markAsRead() {
        final Uri threadUri = this.getUri();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = Conversation.this.mMarkAsBlockedSyncer;
                synchronized (object) {
                    if (Conversation.this.mMarkAsReadBlocked) {
                        try {
                            Conversation.this.mMarkAsBlockedSyncer.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    if (threadUri != null) {
                        Conversation.this.buildReadContentValues();
                        boolean needUpdate = true;
                        Cursor c = Conversation.this.mContext.getContentResolver().query(threadUri, UNREAD_PROJECTION, Conversation.UNREAD_SELECTION, null, null);
                        if (c != null) {
                            try {
                                needUpdate = c.getCount() > 0;
                            }
                            finally {
                                c.close();
                            }
                        }
                        if (needUpdate) {
                            LogTag.debug("markAsRead: update read/seen for thread uri: " + threadUri, new Object[0]);
                            Conversation.this.mContext.getContentResolver().update(threadUri, mReadContentValues, Conversation.UNREAD_SELECTION, null);
                        }
                        Conversation.this.setHasUnreadMessages(false);
                    }
                }
                MessagingNotification.blockingUpdateAllNotifications(Conversation.this.mContext);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockMarkAsRead(boolean block) {
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            LogTag.debug("blockMarkAsRead: " + block, new Object[0]);
        }
        Object object = this.mMarkAsBlockedSyncer;
        synchronized (object) {
            if (block != this.mMarkAsReadBlocked) {
                this.mMarkAsReadBlocked = block;
                if (!this.mMarkAsReadBlocked) {
                    this.mMarkAsBlockedSyncer.notifyAll();
                }
            }
        }
    }

    public synchronized Uri getUri() {
        if (this.mThreadId <= 0L) {
            return null;
        }
        return ContentUris.withAppendedId((Uri)Telephony.Threads.CONTENT_URI, (long)this.mThreadId);
    }

    public static Uri getUri(long threadId) {
        return ContentUris.withAppendedId((Uri)Telephony.Threads.CONTENT_URI, (long)threadId);
    }

    public synchronized long getThreadId() {
        return this.mThreadId;
    }

    public synchronized long ensureThreadId() {
        if (this.mThreadId <= 0L) {
            this.mThreadId = Conversation.getOrCreateThreadId(this.mContext, this.mRecipients);
        }
        return this.mThreadId;
    }

    public synchronized void clearThreadId() {
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            LogTag.debug("clearThreadId old threadId was: " + this.mThreadId + " now zero", new Object[0]);
        }
        Cache.remove(this.mThreadId);
        this.mThreadId = 0L;
    }

    public synchronized void setRecipients(ContactList list) {
        this.mRecipients = list;
        this.mThreadId = 0L;
    }

    public synchronized ContactList getRecipients() {
        return this.mRecipients;
    }

    public synchronized boolean hasDraft() {
        if (this.mThreadId <= 0L) {
            return false;
        }
        return DraftCache.getInstance().hasDraft(this.mThreadId);
    }

    public synchronized void setDraftState(boolean hasDraft) {
        if (this.mThreadId <= 0L) {
            return;
        }
        DraftCache.getInstance().setDraftState(this.mThreadId, hasDraft);
    }

    public synchronized long getDate() {
        return this.mDate;
    }

    public synchronized int getMessageCount() {
        return this.mMessageCount;
    }

    public synchronized String getSnippet() {
        return this.mSnippet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUnreadMessages() {
        Conversation conversation = this;
        synchronized (conversation) {
            return this.mHasUnreadMessages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHasUnreadMessages(boolean flag) {
        Conversation conversation = this;
        synchronized (conversation) {
            this.mHasUnreadMessages = flag;
        }
    }

    public synchronized boolean hasAttachment() {
        return this.mHasAttachment;
    }

    public synchronized boolean hasError() {
        return this.mHasError;
    }

    private static long getOrCreateThreadId(Context context, ContactList list) {
        HashSet<String> recipients = new HashSet<String>();
        Contact cacheContact = null;
        for (Contact c : list) {
            cacheContact = Contact.get(c.getNumber(), false);
            if (cacheContact != null) {
                recipients.add(cacheContact.getNumber());
                continue;
            }
            recipients.add(c.getNumber());
        }
        long retVal = Telephony.Threads.getOrCreateThreadId((Context)context, recipients);
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            LogTag.debug("[Conversation] getOrCreateThreadId for (%s) returned %d", recipients, retVal);
        }
        return retVal;
    }

    public synchronized boolean equals(Object obj) {
        try {
            Conversation other = (Conversation)obj;
            return this.mRecipients.equals(other.mRecipients);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public synchronized int hashCode() {
        return this.mRecipients.hashCode();
    }

    public synchronized String toString() {
        return String.format("[%s] (tid %d)", this.mRecipients.serialize(), this.mThreadId);
    }

    public static void asyncDeleteObsoleteThreads(AsyncQueryHandler handler, int token) {
        handler.startDelete(token, null, Telephony.Threads.OBSOLETE_THREADS_URI, null, null);
    }

    public static void startQueryForAll(AsyncQueryHandler handler, int token) {
        handler.cancelOperation(token);
        handler.startQuery(token, null, sAllThreadsUri, ALL_THREADS_PROJECTION, null, null, "date DESC");
    }

    public static void startDelete(AsyncQueryHandler handler, int token, boolean deleteAll, long threadId) {
        Uri uri = ContentUris.withAppendedId((Uri)Telephony.Threads.CONTENT_URI, (long)threadId);
        String selection = deleteAll ? null : "locked=0";
        handler.startDelete(token, null, uri, selection, null);
    }

    public static void startDeleteAll(AsyncQueryHandler handler, int token, boolean deleteAll) {
        String selection = deleteAll ? null : "locked=0";
        handler.startDelete(token, null, Telephony.Threads.CONTENT_URI, selection, null);
    }

    public static void startQueryHaveLockedMessages(AsyncQueryHandler handler, long threadId, int token) {
        handler.cancelOperation(token);
        Uri uri = Telephony.MmsSms.CONTENT_LOCKED_URI;
        if (threadId != -1L) {
            uri = ContentUris.withAppendedId((Uri)uri, (long)threadId);
        }
        handler.startQuery(token, (Object)new Long(threadId), uri, ALL_THREADS_PROJECTION, null, null, "date DESC");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillFromCursor(Context context, Conversation conv, Cursor c, boolean allowQuery) {
        Conversation conversation = conv;
        synchronized (conversation) {
            conv.mThreadId = c.getLong(0);
            conv.mDate = c.getLong(1);
            conv.mMessageCount = c.getInt(2);
            String snippet = MessageUtils.extractEncStrFromCursor(c, 4, 5);
            if (TextUtils.isEmpty((CharSequence)snippet)) {
                snippet = context.getString(2131165201);
            }
            conv.mSnippet = snippet;
            conv.setHasUnreadMessages(c.getInt(6) == 0);
            conv.mHasError = c.getInt(7) != 0;
            conv.mHasAttachment = c.getInt(8) != 0;
        }
        String recipientIds = c.getString(3);
        ContactList recipients = ContactList.getByIds(recipientIds, allowQuery);
        Conversation conversation2 = conv;
        synchronized (conversation2) {
            conv.mRecipients = recipients;
        }
        if (Log.isLoggable((String)"Mms:threadcache", (int)2)) {
            LogTag.debug("fillFromCursor: conv=" + conv + ", recipientIds=" + recipientIds, new Object[0]);
        }
    }

    public static void init(final Context context) {
        new Thread(new Runnable(){

            public void run() {
                Conversation.cacheAllThreads(context);
            }
        }).start();
    }

    public static void markAllConversationsAsSeen(final Context context) {
        new Thread(new Runnable(){

            public void run() {
                Conversation.blockingMarkAllSmsMessagesAsSeen(context);
                Conversation.blockingMarkAllMmsMessagesAsSeen(context);
                MessagingNotification.blockingUpdateAllNotifications(context);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void blockingMarkAllSmsMessagesAsSeen(Context context) {
        ContentResolver resolver = context.getContentResolver();
        Cursor cursor = resolver.query(Telephony.Sms.Inbox.CONTENT_URI, SEEN_PROJECTION, "seen=0", null, null);
        int count = 0;
        if (cursor != null) {
            try {
                count = cursor.getCount();
            }
            finally {
                cursor.close();
            }
        }
        if (count == 0) {
            return;
        }
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            Log.d((String)TAG, (String)("mark " + count + " SMS msgs as seen"));
        }
        ContentValues values = new ContentValues(1);
        values.put("seen", Integer.valueOf(1));
        resolver.update(Telephony.Sms.Inbox.CONTENT_URI, values, "seen=0", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void blockingMarkAllMmsMessagesAsSeen(Context context) {
        ContentResolver resolver = context.getContentResolver();
        Cursor cursor = resolver.query(Telephony.Mms.Inbox.CONTENT_URI, SEEN_PROJECTION, "seen=0", null, null);
        int count = 0;
        if (cursor != null) {
            try {
                count = cursor.getCount();
            }
            finally {
                cursor.close();
            }
        }
        if (count == 0) {
            return;
        }
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            Log.d((String)TAG, (String)("mark " + count + " MMS msgs as seen"));
        }
        ContentValues values = new ContentValues(1);
        values.put("seen", Integer.valueOf(1));
        resolver.update(Telephony.Mms.Inbox.CONTENT_URI, values, "seen=0", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadingThreads() {
        Cache cache = Cache.getInstance();
        synchronized (cache) {
            return mLoadingThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheAllThreads(Context context) {
        HashSet<Long> threadsOnDisk;
        block26: {
            if (Log.isLoggable((String)"Mms:threadcache", (int)2)) {
                LogTag.debug("[Conversation] cacheAllThreads: begin", new Object[0]);
            }
            Cache cache = Cache.getInstance();
            synchronized (cache) {
                if (mLoadingThreads) {
                    return;
                }
                mLoadingThreads = true;
            }
            threadsOnDisk = new HashSet<Long>();
            Cursor c = context.getContentResolver().query(sAllThreadsUri, ALL_THREADS_PROJECTION, null, null, null);
            try {
                if (c == null) break block26;
                while (c.moveToNext()) {
                    Conversation conv;
                    long threadId = c.getLong(0);
                    threadsOnDisk.add(threadId);
                    Cache cache2 = Cache.getInstance();
                    synchronized (cache2) {
                        conv = Cache.get(threadId);
                    }
                    if (conv == null) {
                        conv = new Conversation(context, c, true);
                        try {
                            cache2 = Cache.getInstance();
                            synchronized (cache2) {
                                Cache.put(conv);
                                continue;
                            }
                        }
                        catch (IllegalStateException e) {
                            LogTag.error("Tried to add duplicate Conversation to Cache", new Object[0]);
                            continue;
                        }
                    }
                    Conversation.fillFromCursor(context, conv, c, true);
                }
            }
            finally {
                if (c != null) {
                    c.close();
                }
                Cache cache3 = Cache.getInstance();
                synchronized (cache3) {
                    mLoadingThreads = false;
                }
            }
        }
        Cache.keepOnly(threadsOnDisk);
        if (Log.isLoggable((String)"Mms:threadcache", (int)2)) {
            LogTag.debug("[Conversation] cacheAllThreads: finished", new Object[0]);
            Cache.dumpCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadFromThreadId(long threadId, boolean allowQuery) {
        block5: {
            Cursor c = this.mContext.getContentResolver().query(sAllThreadsUri, ALL_THREADS_PROJECTION, "_id=" + Long.toString(threadId), null, null);
            try {
                if (c.moveToFirst()) {
                    Conversation.fillFromCursor(this.mContext, this, c, allowQuery);
                    if (threadId != this.mThreadId) {
                        LogTag.error("loadFromThreadId: fillFromCursor returned differnt thread_id! threadId=" + threadId + ", mThreadId=" + this.mThreadId, new Object[0]);
                    }
                    break block5;
                }
                LogTag.error("loadFromThreadId: Can't find thread ID " + threadId, new Object[0]);
                boolean bl = false;
                return bl;
            }
            finally {
                c.close();
            }
        }
        return true;
    }

    private static String getRecipients(Uri uri) {
        String base = uri.getSchemeSpecificPart();
        int pos = base.indexOf(63);
        return pos == -1 ? base : base.substring(0, pos);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Cache {
        private static Cache sInstance = new Cache();
        private final HashSet<Conversation> mCache = new HashSet(10);

        static Cache getInstance() {
            return sInstance;
        }

        private Cache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Conversation get(long threadId) {
            Cache cache = sInstance;
            synchronized (cache) {
                if (Log.isLoggable((String)"Mms:threadcache", (int)2)) {
                    LogTag.debug("Conversation get with threadId: " + threadId, new Object[0]);
                }
                for (Conversation c : Cache.sInstance.mCache) {
                    if (c.getThreadId() != threadId) continue;
                    return c;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Conversation get(ContactList list) {
            Cache cache = sInstance;
            synchronized (cache) {
                if (Log.isLoggable((String)"Mms:threadcache", (int)2)) {
                    LogTag.debug("Conversation get with ContactList: " + list, new Object[0]);
                }
                for (Conversation c : Cache.sInstance.mCache) {
                    if (!c.getRecipients().equals(list)) continue;
                    return c;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void put(Conversation c) {
            Cache cache = sInstance;
            synchronized (cache) {
                if (Log.isLoggable((String)"Mms:threadcache", (int)2)) {
                    LogTag.debug("Conversation.Cache.put: conv= " + c + ", hash: " + c.hashCode(), new Object[0]);
                }
                if (Cache.sInstance.mCache.contains(c)) {
                    throw new IllegalStateException("cache already contains " + c + " threadId: " + c.mThreadId);
                }
                Cache.sInstance.mCache.add(c);
            }
        }

        static void remove(long threadId) {
            for (Conversation c : Cache.sInstance.mCache) {
                if (c.getThreadId() != threadId) continue;
                Cache.sInstance.mCache.remove(c);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void dumpCache() {
            Cache cache = sInstance;
            synchronized (cache) {
                LogTag.debug("Conversation dumpCache: ", new Object[0]);
                for (Conversation c : Cache.sInstance.mCache) {
                    LogTag.debug("   conv: " + c.toString() + " hash: " + c.hashCode(), new Object[0]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void keepOnly(Set<Long> threads) {
            Cache cache = sInstance;
            synchronized (cache) {
                Iterator<Conversation> iter = Cache.sInstance.mCache.iterator();
                while (iter.hasNext()) {
                    Conversation c = iter.next();
                    if (threads.contains(c.getThreadId())) continue;
                    iter.remove();
                }
            }
        }
    }
}

