/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.data;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.provider.ContactsContract;
import android.provider.Telephony;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.util.Log;
import com.android.mms.data.RecipientIdCache;
import com.android.mms.ui.MessageUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Contact {
    private static final String TAG = "Contact";
    private static final boolean V = false;
    private static ContactsCache sContactCache;
    private static final ContentObserver sPresenceObserver;
    private static final HashSet<UpdateListener> mListeners;
    private String mNumber;
    private String mName = "";
    private String mNameAndNumber;
    private boolean mNumberIsModified;
    private long mRecipientId;
    private String mLabel;
    private long mPersonId;
    private int mPresenceResId;
    private String mPresenceText;
    private BitmapDrawable mAvatar;
    private byte[] mAvatarData;
    private boolean mIsStale;
    private boolean mQueryPending;

    private Contact(String number) {
        this.setNumber(number);
        this.mNumberIsModified = false;
        this.mLabel = "";
        this.mPersonId = 0L;
        this.mPresenceResId = 0;
        this.mIsStale = true;
    }

    public String toString() {
        return String.format("{ number=%s, name=%s, nameAndNumber=%s, label=%s, person_id=%d, hash=%d }", this.mNumber != null ? this.mNumber : "null", this.mName != null ? this.mName : "null", this.mNameAndNumber != null ? this.mNameAndNumber : "null", this.mLabel != null ? this.mLabel : "null", this.mPersonId, this.hashCode());
    }

    private static void logWithTrace(String msg, Object ... format) {
        Thread current = Thread.currentThread();
        StackTraceElement[] stack = current.getStackTrace();
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(current.getId());
        sb.append("] ");
        sb.append(String.format(msg, format));
        sb.append(" <- ");
        int stop = stack.length > 7 ? 7 : stack.length;
        for (int i = 3; i < stop; ++i) {
            String methodName = stack[i].getMethodName();
            sb.append(methodName);
            if (i + 1 == stop) continue;
            sb.append(" <- ");
        }
        Log.d((String)TAG, (String)sb.toString());
    }

    public static Contact get(String number, boolean canBlock) {
        return sContactCache.get(number, canBlock);
    }

    public static void invalidateCache() {
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            Contact.log("invalidateCache");
        }
        sContactCache.invalidate();
    }

    private static String emptyIfNull(String s) {
        return s != null ? s : "";
    }

    public static String formatNameAndNumber(String name, String number) {
        String formattedNumber = number;
        if (!Telephony.Mms.isEmailAddress((String)number)) {
            formattedNumber = PhoneNumberUtils.formatNumber((String)number);
        }
        if (!TextUtils.isEmpty((CharSequence)name) && !name.equals(number)) {
            return name + " <" + formattedNumber + ">";
        }
        return formattedNumber;
    }

    public synchronized void reload() {
        this.mIsStale = true;
        sContactCache.get(this.mNumber, false);
    }

    public synchronized String getNumber() {
        return this.mNumber;
    }

    public synchronized void setNumber(String number) {
        this.mNumber = number;
        this.notSynchronizedUpdateNameAndNumber();
        this.mNumberIsModified = true;
    }

    public boolean isNumberModified() {
        return this.mNumberIsModified;
    }

    public void setIsNumberModified(boolean flag) {
        this.mNumberIsModified = flag;
    }

    public synchronized String getName() {
        if (TextUtils.isEmpty((CharSequence)this.mName)) {
            return this.mNumber;
        }
        return this.mName;
    }

    public synchronized String getNameAndNumber() {
        return this.mNameAndNumber;
    }

    private synchronized void updateNameAndNumber() {
        this.notSynchronizedUpdateNameAndNumber();
    }

    private void notSynchronizedUpdateNameAndNumber() {
        this.mNameAndNumber = Contact.formatNameAndNumber(this.mName, this.mNumber);
    }

    public synchronized long getRecipientId() {
        return this.mRecipientId;
    }

    public synchronized void setRecipientId(long id2) {
        this.mRecipientId = id2;
    }

    public synchronized String getLabel() {
        return this.mLabel;
    }

    public synchronized Uri getUri() {
        return ContentUris.withAppendedId((Uri)ContactsContract.Contacts.CONTENT_URI, (long)this.mPersonId);
    }

    public synchronized int getPresenceResId() {
        return this.mPresenceResId;
    }

    public synchronized boolean existsInDatabase() {
        return this.mPersonId > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(UpdateListener l) {
        HashSet<UpdateListener> hashSet = mListeners;
        synchronized (hashSet) {
            mListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(UpdateListener l) {
        HashSet<UpdateListener> hashSet = mListeners;
        synchronized (hashSet) {
            mListeners.remove(l);
        }
    }

    public static synchronized void dumpListeners() {
        int i = 0;
        Log.i((String)TAG, (String)("[Contact] dumpListeners; size=" + mListeners.size()));
        for (UpdateListener listener : mListeners) {
            Log.i((String)TAG, (String)("[" + i++ + "]" + listener));
        }
    }

    public synchronized boolean isEmail() {
        return Telephony.Mms.isEmailAddress((String)this.mNumber);
    }

    public String getPresenceText() {
        return this.mPresenceText;
    }

    public synchronized Drawable getAvatar(Context context, Drawable defaultValue) {
        if (this.mAvatar == null && this.mAvatarData != null) {
            Bitmap b = BitmapFactory.decodeByteArray((byte[])this.mAvatarData, (int)0, (int)this.mAvatarData.length);
            this.mAvatar = new BitmapDrawable(context.getResources(), b);
        }
        return this.mAvatar != null ? this.mAvatar : defaultValue;
    }

    public static void init(Context context) {
        sContactCache = new ContactsCache(context);
        RecipientIdCache.init(context);
    }

    public static void dump() {
        sContactCache.dump();
    }

    private static void log(String msg) {
        Log.d((String)TAG, (String)msg);
    }

    static /* synthetic */ byte[] access$1102(Contact x0, byte[] x1) {
        x0.mAvatarData = x1;
        return x1;
    }

    static {
        sPresenceObserver = new ContentObserver(new Handler()){

            public void onChange(boolean selfUpdate) {
                if (Log.isLoggable((String)"Mms:app", (int)2)) {
                    Contact.log("presence changed, invalidate cache");
                }
                Contact.invalidateCache();
            }
        };
        mListeners = new HashSet();
    }

    private static class ContactsCache {
        private final TaskStack mTaskQueue = new TaskStack();
        private static final String SEPARATOR = ";";
        private static final String CALLER_ID_SELECTION = "PHONE_NUMBERS_EQUAL(data1,?) AND mimetype='vnd.android.cursor.item/phone_v2' AND raw_contact_id IN (SELECT raw_contact_id  FROM phone_lookup WHERE normalized_number GLOB('+*'))";
        private static final Uri PHONES_WITH_PRESENCE_URI = ContactsContract.Data.CONTENT_URI;
        private static final String[] CALLER_ID_PROJECTION = new String[]{"data1", "data3", "display_name", "contact_id", "contact_presence", "contact_status"};
        private static final int PHONE_NUMBER_COLUMN = 0;
        private static final int PHONE_LABEL_COLUMN = 1;
        private static final int CONTACT_NAME_COLUMN = 2;
        private static final int CONTACT_ID_COLUMN = 3;
        private static final int CONTACT_PRESENCE_COLUMN = 4;
        private static final int CONTACT_STATUS_COLUMN = 5;
        private static final Uri EMAIL_WITH_PRESENCE_URI = ContactsContract.Data.CONTENT_URI;
        private static final String EMAIL_SELECTION = "UPPER(data1)=UPPER(?) AND mimetype='vnd.android.cursor.item/email_v2'";
        private static final String[] EMAIL_PROJECTION = new String[]{"data4", "contact_presence", "contact_id", "display_name"};
        private static final int EMAIL_NAME_COLUMN = 0;
        private static final int EMAIL_STATUS_COLUMN = 1;
        private static final int EMAIL_ID_COLUMN = 2;
        private static final int EMAIL_CONTACT_NAME_COLUMN = 3;
        private final Context mContext;
        private final HashMap<String, ArrayList<Contact>> mContactsHash = new HashMap();
        static final int STATIC_KEY_BUFFER_MAXIMUM_LENGTH = 5;
        static CharBuffer sStaticKeyBuffer = CharBuffer.allocate(5);

        private ContactsCache(Context context) {
            this.mContext = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dump() {
            ContactsCache contactsCache = this;
            synchronized (contactsCache) {
                Log.d((String)Contact.TAG, (String)"**** Contact cache dump ****");
                for (String key : this.mContactsHash.keySet()) {
                    ArrayList<Contact> alc = this.mContactsHash.get(key);
                    for (Contact c : alc) {
                        Log.d((String)Contact.TAG, (String)(key + " ==> " + c.toString()));
                    }
                }
            }
        }

        public void pushTask(Runnable r) {
            this.mTaskQueue.push(r);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Contact get(String number, boolean canBlock) {
            if (TextUtils.isEmpty((CharSequence)number)) {
                number = "";
            }
            Contact contact = this.get(number);
            Runnable r = null;
            Contact contact2 = contact;
            synchronized (contact2) {
                while (canBlock && contact.mQueryPending) {
                    try {
                        contact.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                if (contact.mIsStale && !contact.mQueryPending) {
                    contact.mIsStale = false;
                    if (Log.isLoggable((String)"Mms:app", (int)2)) {
                        Contact.log("async update for " + contact.toString() + " canBlock: " + canBlock + " isStale: " + contact.mIsStale);
                    }
                    final Contact c = contact;
                    r = new Runnable(){

                        public void run() {
                            ContactsCache.this.updateContact(c);
                        }
                    };
                    contact.mQueryPending = true;
                }
            }
            if (r != null) {
                if (canBlock) {
                    r.run();
                } else {
                    this.pushTask(r);
                }
            }
            return contact;
        }

        private boolean contactChanged(Contact orig, Contact newContactData) {
            String newLabel;
            String newName;
            String oldName = Contact.emptyIfNull(orig.mName);
            if (!oldName.equals(newName = Contact.emptyIfNull(newContactData.mName))) {
                return true;
            }
            String oldLabel = Contact.emptyIfNull(orig.mLabel);
            if (!oldLabel.equals(newLabel = Contact.emptyIfNull(newContactData.mLabel))) {
                return true;
            }
            if (orig.mPersonId != newContactData.mPersonId) {
                return true;
            }
            if (orig.mPresenceResId != newContactData.mPresenceResId) {
                return true;
            }
            return !Arrays.equals(orig.mAvatarData, newContactData.mAvatarData);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateContact(Contact c) {
            if (c == null) {
                return;
            }
            Contact entry = this.getContactInfo(c.mNumber);
            Contact contact = c;
            synchronized (contact) {
                if (this.contactChanged(c, entry)) {
                    HashSet iterator;
                    if (Log.isLoggable((String)"Mms:app", (int)2)) {
                        Contact.log("updateContact: contact changed for " + entry.mName);
                    }
                    c.mNumber = entry.mNumber;
                    c.mLabel = entry.mLabel;
                    c.mPersonId = entry.mPersonId;
                    c.mPresenceResId = entry.mPresenceResId;
                    c.mPresenceText = entry.mPresenceText;
                    Contact.access$1102(c, entry.mAvatarData);
                    c.mAvatar = entry.mAvatar;
                    if (MessageUtils.isLocalNumber(c.mNumber)) {
                        c.mName = this.mContext.getString(2131165471);
                    } else {
                        c.mName = entry.mName;
                    }
                    c.notSynchronizedUpdateNameAndNumber();
                    HashSet hashSet = mListeners;
                    synchronized (hashSet) {
                        iterator = (HashSet)mListeners.clone();
                    }
                    for (UpdateListener l : iterator) {
                        l.onUpdate(c);
                    }
                }
                Contact contact2 = c;
                synchronized (contact2) {
                    c.mQueryPending = false;
                    c.notifyAll();
                }
            }
        }

        public Contact getContactInfo(String numberOrEmail) {
            if (Telephony.Mms.isEmailAddress((String)numberOrEmail)) {
                return this.getContactInfoForEmailAddress(numberOrEmail);
            }
            return this.getContactInfoForPhoneNumber(numberOrEmail);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Contact getContactInfoForPhoneNumber(String number) {
            Contact entry;
            block10: {
                number = PhoneNumberUtils.stripSeparators((String)number);
                entry = new Contact(number);
                String selection = CALLER_ID_SELECTION.replace("+", PhoneNumberUtils.toCallerIDMinMatch((String)number));
                Cursor cursor = this.mContext.getContentResolver().query(PHONES_WITH_PRESENCE_URI, CALLER_ID_PROJECTION, selection, new String[]{number}, null);
                if (cursor == null) {
                    Log.w((String)Contact.TAG, (String)("queryContactInfoByNumber(" + number + ") returned NULL cursor!" + " contact uri used " + PHONES_WITH_PRESENCE_URI));
                    return entry;
                }
                try {
                    if (!cursor.moveToFirst()) break block10;
                    Contact contact = entry;
                    synchronized (contact) {
                        entry.mLabel = cursor.getString(1);
                        entry.mName = cursor.getString(2);
                        entry.mPersonId = cursor.getLong(3);
                        entry.mPresenceResId = this.getPresenceIconResourceId(cursor.getInt(4));
                        entry.mPresenceText = cursor.getString(5);
                    }
                    byte[] data = this.loadAvatarData(entry);
                    Contact contact2 = entry;
                    synchronized (contact2) {
                        Contact.access$1102(entry, data);
                    }
                }
                finally {
                    cursor.close();
                }
            }
            return entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] loadAvatarData(Contact entry) {
            byte[] data = null;
            if (entry.mPersonId == 0L || entry.mAvatar != null) {
                return null;
            }
            Uri contactUri = ContentUris.withAppendedId((Uri)ContactsContract.Contacts.CONTENT_URI, (long)entry.mPersonId);
            InputStream avatarDataStream = ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)this.mContext.getContentResolver(), (Uri)contactUri);
            try {
                if (avatarDataStream != null) {
                    data = new byte[avatarDataStream.available()];
                    avatarDataStream.read(data, 0, data.length);
                }
            }
            catch (IOException ex) {
            }
            finally {
                try {
                    if (avatarDataStream != null) {
                        avatarDataStream.close();
                    }
                }
                catch (IOException e) {}
            }
            return data;
        }

        private int getPresenceIconResourceId(int presence) {
            if (presence != 0) {
                return ContactsContract.Presence.getPresenceIconResourceId((int)presence);
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Contact getContactInfoForEmailAddress(String email) {
            Contact entry = new Contact(email);
            Cursor cursor = SqliteWrapper.query((Context)this.mContext, (ContentResolver)this.mContext.getContentResolver(), (Uri)EMAIL_WITH_PRESENCE_URI, (String[])EMAIL_PROJECTION, (String)EMAIL_SELECTION, (String[])new String[]{email}, null);
            if (cursor == null) return entry;
            try {
                boolean found;
                do {
                    if (!cursor.moveToNext()) return entry;
                    found = false;
                    Contact contact = entry;
                    synchronized (contact) {
                        entry.mPresenceResId = this.getPresenceIconResourceId(cursor.getInt(1));
                        entry.mPersonId = cursor.getLong(2);
                        String name = cursor.getString(0);
                        if (TextUtils.isEmpty((CharSequence)name)) {
                            name = cursor.getString(3);
                        }
                        if (!TextUtils.isEmpty((CharSequence)name)) {
                            entry.mName = name;
                            found = true;
                        }
                    }
                } while (!found);
                byte[] data = this.loadAvatarData(entry);
                Contact contact = entry;
                synchronized (contact) {
                    Contact.access$1102(entry, data);
                    return entry;
                }
            }
            finally {
                cursor.close();
            }
        }

        private String key(String phoneNumber, CharBuffer keyBuffer) {
            keyBuffer.clear();
            keyBuffer.mark();
            int position = phoneNumber.length();
            int resultCount = 0;
            while (--position >= 0) {
                char c = phoneNumber.charAt(position);
                if (!Character.isDigit(c)) continue;
                keyBuffer.put(c);
                if (++resultCount != 5) continue;
                break;
            }
            keyBuffer.reset();
            if (resultCount > 0) {
                return keyBuffer.toString();
            }
            return phoneNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Contact get(String numberOrEmail) {
            ContactsCache contactsCache = this;
            synchronized (contactsCache) {
                boolean isNotRegularPhoneNumber = Telephony.Mms.isEmailAddress((String)numberOrEmail) || MessageUtils.isAlias(numberOrEmail);
                String key = isNotRegularPhoneNumber ? numberOrEmail : this.key(numberOrEmail, sStaticKeyBuffer);
                ArrayList<Contact> candidates = this.mContactsHash.get(key);
                if (candidates != null) {
                    int length = candidates.size();
                    for (int i = 0; i < length; ++i) {
                        Contact c = candidates.get(i);
                        if (isNotRegularPhoneNumber) {
                            if (!numberOrEmail.equals(c.mNumber)) continue;
                            return c;
                        }
                        if (!PhoneNumberUtils.compare((String)numberOrEmail, (String)c.mNumber)) continue;
                        return c;
                    }
                } else {
                    candidates = new ArrayList();
                    this.mContactsHash.put(key, candidates);
                }
                Contact c = new Contact(numberOrEmail);
                candidates.add(c);
                return c;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void invalidate() {
            ContactsCache contactsCache = this;
            synchronized (contactsCache) {
                for (ArrayList<Contact> alc : this.mContactsHash.values()) {
                    Iterator<Contact> i$ = alc.iterator();
                    while (i$.hasNext()) {
                        Contact c;
                        Contact contact = c = i$.next();
                        synchronized (contact) {
                            c.mIsStale = true;
                        }
                    }
                }
            }
        }

        private static class TaskStack {
            Thread mWorkerThread;
            private final ArrayList<Runnable> mThingsToLoad = new ArrayList();

            public TaskStack() {
                this.mWorkerThread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        while (true) {
                            Runnable r = null;
                            ArrayList arrayList = TaskStack.this.mThingsToLoad;
                            synchronized (arrayList) {
                                if (TaskStack.this.mThingsToLoad.size() == 0) {
                                    try {
                                        TaskStack.this.mThingsToLoad.wait();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                                if (TaskStack.this.mThingsToLoad.size() > 0) {
                                    r = (Runnable)TaskStack.this.mThingsToLoad.remove(0);
                                }
                            }
                            if (r == null) continue;
                            r.run();
                        }
                    }
                });
                this.mWorkerThread.start();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void push(Runnable r) {
                ArrayList<Runnable> arrayList = this.mThingsToLoad;
                synchronized (arrayList) {
                    this.mThingsToLoad.add(r);
                    this.mThingsToLoad.notify();
                }
            }
        }
    }

    public static interface UpdateListener {
        public void onUpdate(Contact var1);
    }
}

