/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms;

import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.ContentObserver;
import android.database.CrossProcessCursor;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.DataSetObserver;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Bundle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class SuggestionsProvider
extends ContentProvider {
    static final String AUTHORITY = "com.android.mms.SuggestionsProvider";

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    public boolean onCreate() {
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Uri u = Uri.parse((String)String.format("content://mms-sms/searchSuggest?pattern=%s", selectionArgs[0]));
        Cursor c = this.getContext().getContentResolver().query(u, null, null, null, null);
        return new SuggestionsCursor(c, selectionArgs[0]);
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SuggestionsCursor
    implements CrossProcessCursor {
        Cursor mDatabaseCursor;
        int mColumnCount;
        int mCurrentRow;
        ArrayList<Row> mRows = new ArrayList();
        private String[] mVirtualColumns = new String[]{"suggest_intent_data", "suggest_intent_action", "suggest_intent_extra_data", "suggest_text_1"};
        private final int INTENT_DATA_COLUMN = 0;
        private final int INTENT_ACTION_COLUMN = 1;
        private final int INTENT_EXTRA_DATA_COLUMN = 2;
        private final int INTENT_TEXT_COLUMN = 3;

        public SuggestionsCursor(Cursor cursor, String query) {
            this.mDatabaseCursor = cursor;
            this.mColumnCount = cursor.getColumnCount();
            try {
                this.computeRows();
            }
            catch (SQLiteException ex) {
                this.mRows.clear();
            }
        }

        public int getCount() {
            return this.mRows.size();
        }

        private void computeRows() {
            HashSet<String> got = new HashSet<String>();
            int textColumn = this.mDatabaseCursor.getColumnIndex("index_text");
            int offsetsColumn = this.mDatabaseCursor.getColumnIndex("offsets(words)");
            int count = this.mDatabaseCursor.getCount();
            for (int i = 0; i < count; ++i) {
                this.mDatabaseCursor.moveToPosition(i);
                String message = this.mDatabaseCursor.getString(textColumn);
                int[] offsets = this.computeOffsets(this.mDatabaseCursor.getString(offsetsColumn));
                for (int j = 0; j < offsets.length; j += 4) {
                    int startOffset = offsets[j + 2];
                    int length = offsets[j + 3];
                    int endOffset = startOffset + length;
                    String candidate = message.substring(startOffset, endOffset);
                    String key = candidate.toLowerCase();
                    if (got.contains(key)) continue;
                    got.add(key);
                    this.mRows.add(new Row(i, message, startOffset, endOffset));
                }
            }
        }

        private int[] computeOffsets(String offsetsString) {
            String[] vals = offsetsString.split(" ");
            int[] retvals = new int[vals.length];
            for (int i = retvals.length - 1; i >= 0; --i) {
                retvals[i] = Integer.parseInt(vals[i]);
            }
            return retvals;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fillWindow(int position, CursorWindow window) {
            int count = this.getCount();
            if (position < 0 || position > count + 1) {
                return;
            }
            window.acquireReference();
            try {
                int oldpos = this.getPosition();
                int pos = position;
                window.clear();
                window.setStartPosition(position);
                int columnNum = this.getColumnCount();
                window.setNumColumns(columnNum);
                while (this.moveToPosition(pos) && window.allocRow()) {
                    for (int i = 0; i < columnNum; ++i) {
                        String field = this.getString(i);
                        if (field != null) {
                            if (window.putString(field, pos, i)) continue;
                            window.freeLastRow();
                            break;
                        }
                        if (window.putNull(pos, i)) continue;
                        window.freeLastRow();
                        break;
                    }
                    ++pos;
                }
                this.moveToPosition(oldpos);
            }
            catch (IllegalStateException e) {
            }
            finally {
                window.releaseReference();
            }
        }

        public CursorWindow getWindow() {
            CursorWindow window = new CursorWindow(false);
            return window;
        }

        public boolean onMove(int oldPosition, int newPosition) {
            return ((CrossProcessCursor)this.mDatabaseCursor).onMove(oldPosition, newPosition);
        }

        public int getColumnCount() {
            return this.mColumnCount + this.mVirtualColumns.length;
        }

        public int getColumnIndex(String columnName) {
            for (int i = 0; i < this.mVirtualColumns.length; ++i) {
                if (!this.mVirtualColumns[i].equals(columnName)) continue;
                return this.mColumnCount + i;
            }
            return this.mDatabaseCursor.getColumnIndex(columnName);
        }

        public String[] getColumnNames() {
            int i;
            String[] x = this.mDatabaseCursor.getColumnNames();
            String[] y = new String[x.length + this.mVirtualColumns.length];
            for (i = 0; i < x.length; ++i) {
                y[i] = x[i];
            }
            for (i = 0; i < this.mVirtualColumns.length; ++i) {
                y[x.length + i] = this.mVirtualColumns[i];
            }
            return y;
        }

        public boolean moveToPosition(int position) {
            if (position >= 0 && position < this.mRows.size()) {
                this.mCurrentRow = position;
                this.mDatabaseCursor.moveToPosition(this.mRows.get((int)position).mRowNumber);
                return true;
            }
            return false;
        }

        public boolean move(int offset) {
            return this.moveToPosition(this.mCurrentRow + offset);
        }

        public boolean moveToFirst() {
            return this.moveToPosition(0);
        }

        public boolean moveToLast() {
            return this.moveToPosition(this.mRows.size() - 1);
        }

        public boolean moveToNext() {
            return this.moveToPosition(this.mCurrentRow + 1);
        }

        public boolean moveToPrevious() {
            return this.moveToPosition(this.mCurrentRow - 1);
        }

        public String getString(int column) {
            if (column < this.mColumnCount) {
                return this.mDatabaseCursor.getString(column);
            }
            Row row = this.mRows.get(this.mCurrentRow);
            switch (column - this.mColumnCount) {
                case 0: {
                    Uri u = Uri.parse((String)"content://mms-sms/search").buildUpon().appendQueryParameter("pattern", row.getWord()).build();
                    return u.toString();
                }
                case 1: {
                    return "android.intent.action.SEARCH";
                }
                case 2: {
                    return this.getString(this.getColumnIndex("suggest_text_1"));
                }
                case 3: {
                    return row.getWord();
                }
            }
            return null;
        }

        public void abortUpdates() {
        }

        public void close() {
            this.mDatabaseCursor.close();
        }

        public boolean commitUpdates() {
            return false;
        }

        public boolean commitUpdates(Map<? extends Long, ? extends Map<String, Object>> values) {
            return false;
        }

        public void copyStringToBuffer(int columnIndex, CharArrayBuffer buffer) {
            this.mDatabaseCursor.copyStringToBuffer(columnIndex, buffer);
        }

        public void deactivate() {
            this.mDatabaseCursor.deactivate();
        }

        public boolean deleteRow() {
            return false;
        }

        public byte[] getBlob(int columnIndex) {
            return null;
        }

        public int getColumnIndexOrThrow(String columnName) throws IllegalArgumentException {
            return 0;
        }

        public String getColumnName(int columnIndex) {
            return null;
        }

        public double getDouble(int columnIndex) {
            return 0.0;
        }

        public Bundle getExtras() {
            return Bundle.EMPTY;
        }

        public float getFloat(int columnIndex) {
            return 0.0f;
        }

        public int getInt(int columnIndex) {
            return 0;
        }

        public long getLong(int columnIndex) {
            return 0L;
        }

        public int getPosition() {
            return this.mCurrentRow;
        }

        public short getShort(int columnIndex) {
            return 0;
        }

        public boolean getWantsAllOnMoveCalls() {
            return false;
        }

        public boolean hasUpdates() {
            return false;
        }

        public boolean isAfterLast() {
            return this.mCurrentRow >= this.mRows.size();
        }

        public boolean isBeforeFirst() {
            return this.mCurrentRow < 0;
        }

        public boolean isClosed() {
            return this.mDatabaseCursor.isClosed();
        }

        public boolean isFirst() {
            return this.mCurrentRow == 0;
        }

        public boolean isLast() {
            return this.mCurrentRow == this.mRows.size() - 1;
        }

        public boolean isNull(int columnIndex) {
            return false;
        }

        public void registerContentObserver(ContentObserver observer) {
            this.mDatabaseCursor.registerContentObserver(observer);
        }

        public void registerDataSetObserver(DataSetObserver observer) {
            this.mDatabaseCursor.registerDataSetObserver(observer);
        }

        public boolean requery() {
            return false;
        }

        public Bundle respond(Bundle extras) {
            return this.mDatabaseCursor.respond(extras);
        }

        public void setNotificationUri(ContentResolver cr, Uri uri) {
            this.mDatabaseCursor.setNotificationUri(cr, uri);
        }

        public boolean supportsUpdates() {
            return false;
        }

        public void unregisterContentObserver(ContentObserver observer) {
            this.mDatabaseCursor.unregisterContentObserver(observer);
        }

        public void unregisterDataSetObserver(DataSetObserver observer) {
            this.mDatabaseCursor.unregisterDataSetObserver(observer);
        }

        public boolean updateBlob(int columnIndex, byte[] value) {
            return false;
        }

        public boolean updateDouble(int columnIndex, double value) {
            return false;
        }

        public boolean updateFloat(int columnIndex, float value) {
            return false;
        }

        public boolean updateInt(int columnIndex, int value) {
            return false;
        }

        public boolean updateLong(int columnIndex, long value) {
            return false;
        }

        public boolean updateShort(int columnIndex, short value) {
            return false;
        }

        public boolean updateString(int columnIndex, String value) {
            return false;
        }

        public boolean updateToNull(int columnIndex) {
            return false;
        }

        private class Row {
            String mText;
            int mRowNumber;
            int mStartOffset;
            int mEndOffset;

            public Row(int row, String text, int startOffset, int endOffset) {
                this.mText = text;
                this.mRowNumber = row;
                this.mStartOffset = startOffset;
                this.mEndOffset = endOffset;
            }

            public String getWord() {
                return this.mText.substring(this.mStartOffset, this.mEndOffset);
            }
        }
    }
}

