/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms;

import android.app.Application;
import android.content.Context;
import android.content.res.Configuration;
import android.preference.PreferenceManager;
import android.provider.SearchRecentSuggestions;
import android.telephony.TelephonyManager;
import com.android.mms.MmsConfig;
import com.android.mms.data.Contact;
import com.android.mms.data.Conversation;
import com.android.mms.drm.DrmUtils;
import com.android.mms.layout.LayoutManager;
import com.android.mms.transaction.MessagingNotification;
import com.android.mms.util.DownloadManager;
import com.android.mms.util.DraftCache;
import com.android.mms.util.RateController;
import com.android.mms.util.SmileyParser;

public class MmsApp
extends Application {
    public static final String LOG_TAG = "Mms";
    private SearchRecentSuggestions mRecentSuggestions;
    private TelephonyManager mTelephonyManager;
    private static MmsApp sMmsApp = null;

    public void onCreate() {
        super.onCreate();
        sMmsApp = this;
        PreferenceManager.setDefaultValues((Context)this, (int)2130968577, (boolean)false);
        MmsConfig.init((Context)this);
        Contact.init((Context)this);
        DraftCache.init((Context)this);
        Conversation.init((Context)this);
        DownloadManager.init((Context)this);
        RateController.init((Context)this);
        DrmUtils.cleanupStorage((Context)this);
        LayoutManager.init((Context)this);
        SmileyParser.init((Context)this);
        MessagingNotification.init((Context)this);
    }

    public static synchronized MmsApp getApplication() {
        return sMmsApp;
    }

    public void onTerminate() {
        DrmUtils.cleanupStorage((Context)this);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        LayoutManager.getInstance().onConfigurationChanged(newConfig);
    }

    public TelephonyManager getTelephonyManager() {
        if (this.mTelephonyManager == null) {
            this.mTelephonyManager = (TelephonyManager)this.getApplicationContext().getSystemService("phone");
        }
        return this.mTelephonyManager;
    }

    public SearchRecentSuggestions getRecentSuggestions() {
        return this.mRecentSuggestions;
    }
}

