/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.util;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.style.ImageSpan;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmileyParser {
    private static SmileyParser sInstance;
    private final Context mContext;
    private final String[] mSmileyTexts;
    private final Pattern mPattern;
    private final HashMap<String, Integer> mSmileyToRes;
    public static final int[] DEFAULT_SMILEY_RES_IDS;
    public static final int DEFAULT_SMILEY_TEXTS = 2131034112;
    public static final int DEFAULT_SMILEY_NAMES = 2131034113;

    public static SmileyParser getInstance() {
        return sInstance;
    }

    public static void init(Context context) {
        sInstance = new SmileyParser(context);
    }

    private SmileyParser(Context context) {
        this.mContext = context;
        this.mSmileyTexts = this.mContext.getResources().getStringArray(2131034112);
        this.mSmileyToRes = this.buildSmileyToRes();
        this.mPattern = this.buildPattern();
    }

    private HashMap<String, Integer> buildSmileyToRes() {
        if (DEFAULT_SMILEY_RES_IDS.length != this.mSmileyTexts.length) {
            throw new IllegalStateException("Smiley resource ID/text mismatch");
        }
        HashMap<String, Integer> smileyToRes = new HashMap<String, Integer>(this.mSmileyTexts.length);
        for (int i = 0; i < this.mSmileyTexts.length; ++i) {
            smileyToRes.put(this.mSmileyTexts[i], DEFAULT_SMILEY_RES_IDS[i]);
        }
        return smileyToRes;
    }

    private Pattern buildPattern() {
        StringBuilder patternString = new StringBuilder(this.mSmileyTexts.length * 3);
        patternString.append('(');
        for (String s : this.mSmileyTexts) {
            patternString.append(Pattern.quote(s));
            patternString.append('|');
        }
        patternString.replace(patternString.length() - 1, patternString.length(), ")");
        return Pattern.compile(patternString.toString());
    }

    public CharSequence addSmileySpans(CharSequence text) {
        SpannableStringBuilder builder = new SpannableStringBuilder(text);
        Matcher matcher = this.mPattern.matcher(text);
        while (matcher.find()) {
            int resId = this.mSmileyToRes.get(matcher.group());
            builder.setSpan((Object)new ImageSpan(this.mContext, resId), matcher.start(), matcher.end(), 33);
        }
        return builder;
    }

    static {
        DEFAULT_SMILEY_RES_IDS = new int[]{Smileys.getSmileyResource(Smileys.HAPPY), Smileys.getSmileyResource(Smileys.SAD), Smileys.getSmileyResource(Smileys.WINKING), Smileys.getSmileyResource(Smileys.TONGUE_STICKING_OUT), Smileys.getSmileyResource(Smileys.SURPRISED), Smileys.getSmileyResource(Smileys.KISSING), Smileys.getSmileyResource(Smileys.YELLING), Smileys.getSmileyResource(Smileys.COOL), Smileys.getSmileyResource(Smileys.MONEY_MOUTH), Smileys.getSmileyResource(Smileys.FOOT_IN_MOUTH), Smileys.getSmileyResource(Smileys.EMBARRASSED), Smileys.getSmileyResource(Smileys.ANGEL), Smileys.getSmileyResource(Smileys.UNDECIDED), Smileys.getSmileyResource(Smileys.CRYING), Smileys.getSmileyResource(Smileys.LIPS_ARE_SEALED), Smileys.getSmileyResource(Smileys.LAUGHING), Smileys.getSmileyResource(Smileys.WTF)};
    }

    static class Smileys {
        private static final int[] sIconIds = new int[]{2130837516, 2130837521, 2130837525, 2130837523, 2130837522, 2130837517, 2130837527, 2130837512, 2130837520, 2130837515, 2130837514, 2130837511, 2130837524, 2130837513, 2130837519, 2130837518, 2130837526};
        public static int HAPPY = 0;
        public static int SAD = 1;
        public static int WINKING = 2;
        public static int TONGUE_STICKING_OUT = 3;
        public static int SURPRISED = 4;
        public static int KISSING = 5;
        public static int YELLING = 6;
        public static int COOL = 7;
        public static int MONEY_MOUTH = 8;
        public static int FOOT_IN_MOUTH = 9;
        public static int EMBARRASSED = 10;
        public static int ANGEL = 11;
        public static int UNDECIDED = 12;
        public static int CRYING = 13;
        public static int LIPS_ARE_SEALED = 14;
        public static int LAUGHING = 15;
        public static int WTF = 16;

        Smileys() {
        }

        public static int getSmileyResource(int which) {
            return sIconIds[which];
        }
    }
}

