/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.util;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import android.util.Log;
import com.android.mms.MmsConfig;
import com.android.mms.ui.MessageUtils;

public abstract class Recycler {
    private static final boolean LOCAL_DEBUG = false;
    private static final String TAG = "Recycler";
    private static final boolean DEFAULT_AUTO_DELETE = false;
    private static SmsRecycler sSmsRecycler;
    private static MmsRecycler sMmsRecycler;

    public static SmsRecycler getSmsRecycler() {
        if (sSmsRecycler == null) {
            sSmsRecycler = new SmsRecycler();
        }
        return sSmsRecycler;
    }

    public static MmsRecycler getMmsRecycler() {
        if (sMmsRecycler == null) {
            sMmsRecycler = new MmsRecycler();
        }
        return sMmsRecycler;
    }

    public static boolean checkForThreadsOverLimit(Context context) {
        SmsRecycler smsRecycler = Recycler.getSmsRecycler();
        MmsRecycler mmsRecycler = Recycler.getMmsRecycler();
        return ((Recycler)smsRecycler).anyThreadOverLimit(context) || ((Recycler)mmsRecycler).anyThreadOverLimit(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOldMessages(Context context) {
        if (!Recycler.isAutoDeleteEnabled(context)) {
            return;
        }
        Cursor cursor = this.getAllThreads(context);
        try {
            int limit = this.getMessageLimit(context);
            while (cursor.moveToNext()) {
                long threadId = this.getThreadId(cursor);
                this.deleteMessagesForThread(context, threadId, limit);
            }
        }
        finally {
            cursor.close();
        }
    }

    public void deleteOldMessagesByThreadId(Context context, long threadId) {
        if (!Recycler.isAutoDeleteEnabled(context)) {
            return;
        }
        this.deleteMessagesForThread(context, threadId, this.getMessageLimit(context));
    }

    public static boolean isAutoDeleteEnabled(Context context) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
        return prefs.getBoolean("pref_key_auto_delete", false);
    }

    public abstract int getMessageLimit(Context var1);

    public abstract void setMessageLimit(Context var1, int var2);

    public int getMessageMinLimit() {
        return MmsConfig.getMinMessageCountPerThread();
    }

    public int getMessageMaxLimit() {
        return MmsConfig.getMaxMessageCountPerThread();
    }

    protected abstract long getThreadId(Cursor var1);

    protected abstract Cursor getAllThreads(Context var1);

    protected abstract void deleteMessagesForThread(Context var1, long var2, int var4);

    protected abstract void dumpMessage(Cursor var1, Context var2);

    protected abstract boolean anyThreadOverLimit(Context var1);

    public static class MmsRecycler
    extends Recycler {
        private static final String[] ALL_MMS_THREADS_PROJECTION = new String[]{"thread_id", "count(*) as msg_count"};
        private static final int ID = 0;
        private static final int MESSAGE_COUNT = 1;
        private static final String[] MMS_MESSAGE_PROJECTION = new String[]{"_id", "thread_id", "date"};
        private static final int COLUMN_ID = 0;
        private static final int COLUMN_THREAD_ID = 1;
        private static final int COLUMN_MMS_DATE = 2;
        private static final int COLUMN_MMS_READ = 3;
        private final String MAX_MMS_MESSAGES_PER_THREAD = "MaxMmsMessagesPerThread";

        public int getMessageLimit(Context context) {
            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
            return prefs.getInt("MaxMmsMessagesPerThread", MmsConfig.getDefaultMMSMessagesPerThread());
        }

        public void setMessageLimit(Context context, int limit) {
            SharedPreferences.Editor editPrefs = PreferenceManager.getDefaultSharedPreferences((Context)context).edit();
            editPrefs.putInt("MaxMmsMessagesPerThread", limit);
            editPrefs.apply();
        }

        protected long getThreadId(Cursor cursor) {
            return cursor.getLong(0);
        }

        protected Cursor getAllThreads(Context context) {
            ContentResolver resolver = context.getContentResolver();
            Cursor cursor = SqliteWrapper.query((Context)context, (ContentResolver)resolver, (Uri)Uri.withAppendedPath((Uri)Telephony.Mms.CONTENT_URI, (String)"threads"), (String[])ALL_MMS_THREADS_PROJECTION, null, null, (String)"date DESC");
            return cursor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteOldMessagesInSameThreadAsMessage(Context context, Uri uri) {
            if (!MmsRecycler.isAutoDeleteEnabled(context)) {
                return;
            }
            Cursor cursor = null;
            long latestDate = 0L;
            long threadId = 0L;
            try {
                int keep;
                String msgId = uri.getLastPathSegment();
                ContentResolver resolver = context.getContentResolver();
                cursor = SqliteWrapper.query((Context)context, (ContentResolver)resolver, (Uri)Telephony.Mms.CONTENT_URI, (String[])MMS_MESSAGE_PROJECTION, (String)("thread_id in (select thread_id from pdu where _id=" + msgId + ") AND locked=0"), null, (String)"date DESC");
                if (cursor == null) {
                    Log.e((String)Recycler.TAG, (String)"MMS: deleteOldMessagesInSameThreadAsMessage got back null cursor");
                    return;
                }
                int count = cursor.getCount();
                int numberToDelete = count - (keep = this.getMessageLimit(context));
                if (numberToDelete <= 0) {
                    return;
                }
                cursor.move(keep);
                latestDate = cursor.getLong(2);
                threadId = cursor.getLong(1);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            if (threadId != 0L) {
                this.deleteMessagesOlderThanDate(context, threadId, latestDate);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deleteMessagesForThread(Context context, long threadId, int keep) {
            if (threadId == 0L) {
                return;
            }
            Cursor cursor = null;
            long latestDate = 0L;
            try {
                ContentResolver resolver = context.getContentResolver();
                cursor = SqliteWrapper.query((Context)context, (ContentResolver)resolver, (Uri)Telephony.Mms.CONTENT_URI, (String[])MMS_MESSAGE_PROJECTION, (String)("thread_id=" + threadId + " AND locked=0"), null, (String)"date DESC");
                if (cursor == null) {
                    Log.e((String)Recycler.TAG, (String)"MMS: deleteMessagesForThread got back null cursor");
                    return;
                }
                int count = cursor.getCount();
                int numberToDelete = count - keep;
                if (numberToDelete <= 0) {
                    return;
                }
                cursor.move(keep);
                latestDate = cursor.getLong(2);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            this.deleteMessagesOlderThanDate(context, threadId, latestDate);
        }

        private void deleteMessagesOlderThanDate(Context context, long threadId, long latestDate) {
            long cntDeleted = SqliteWrapper.delete((Context)context, (ContentResolver)context.getContentResolver(), (Uri)Telephony.Mms.CONTENT_URI, (String)("thread_id=" + threadId + " AND locked=0 AND date<" + latestDate), null);
        }

        protected void dumpMessage(Cursor cursor, Context context) {
            long id2 = cursor.getLong(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean anyThreadOverLimit(Context context) {
            Cursor cursor = this.getAllThreads(context);
            if (cursor == null) {
                return false;
            }
            int limit = this.getMessageLimit(context);
            try {
                while (cursor.moveToNext()) {
                    long threadId = this.getThreadId(cursor);
                    ContentResolver resolver = context.getContentResolver();
                    Cursor msgs = SqliteWrapper.query((Context)context, (ContentResolver)resolver, (Uri)Telephony.Mms.CONTENT_URI, (String[])MMS_MESSAGE_PROJECTION, (String)("thread_id=" + threadId + " AND locked=0"), null, (String)"date DESC");
                    if (msgs == null) {
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        if (msgs.getCount() < limit) continue;
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        msgs.close();
                    }
                }
            }
            finally {
                cursor.close();
            }
            return false;
        }
    }

    public static class SmsRecycler
    extends Recycler {
        private static final String[] ALL_SMS_THREADS_PROJECTION = new String[]{"thread_id", "msg_count"};
        private static final int ID = 0;
        private static final int MESSAGE_COUNT = 1;
        private static final String[] SMS_MESSAGE_PROJECTION = new String[]{"_id", "thread_id", "address", "body", "date", "read", "type", "status"};
        private static final int COLUMN_ID = 0;
        private static final int COLUMN_THREAD_ID = 1;
        private static final int COLUMN_SMS_ADDRESS = 2;
        private static final int COLUMN_SMS_BODY = 3;
        private static final int COLUMN_SMS_DATE = 4;
        private static final int COLUMN_SMS_READ = 5;
        private static final int COLUMN_SMS_TYPE = 6;
        private static final int COLUMN_SMS_STATUS = 7;
        private final String MAX_SMS_MESSAGES_PER_THREAD = "MaxSmsMessagesPerThread";

        public int getMessageLimit(Context context) {
            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
            return prefs.getInt("MaxSmsMessagesPerThread", MmsConfig.getDefaultSMSMessagesPerThread());
        }

        public void setMessageLimit(Context context, int limit) {
            SharedPreferences.Editor editPrefs = PreferenceManager.getDefaultSharedPreferences((Context)context).edit();
            editPrefs.putInt("MaxSmsMessagesPerThread", limit);
            editPrefs.apply();
        }

        protected long getThreadId(Cursor cursor) {
            return cursor.getLong(0);
        }

        protected Cursor getAllThreads(Context context) {
            ContentResolver resolver = context.getContentResolver();
            Cursor cursor = SqliteWrapper.query((Context)context, (ContentResolver)resolver, (Uri)Telephony.Sms.Conversations.CONTENT_URI, (String[])ALL_SMS_THREADS_PROJECTION, null, null, (String)"date DESC");
            return cursor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deleteMessagesForThread(Context context, long threadId, int keep) {
            ContentResolver resolver = context.getContentResolver();
            Cursor cursor = null;
            try {
                cursor = SqliteWrapper.query((Context)context, (ContentResolver)resolver, (Uri)ContentUris.withAppendedId((Uri)Telephony.Sms.Conversations.CONTENT_URI, (long)threadId), (String[])SMS_MESSAGE_PROJECTION, (String)"locked=0", null, (String)"date DESC");
                if (cursor == null) {
                    Log.e((String)Recycler.TAG, (String)"SMS: deleteMessagesForThread got back null cursor");
                    return;
                }
                int count = cursor.getCount();
                int numberToDelete = count - keep;
                if (numberToDelete <= 0) {
                    return;
                }
                cursor.move(keep);
                long latestDate = cursor.getLong(4);
                long cntDeleted = SqliteWrapper.delete((Context)context, (ContentResolver)resolver, (Uri)ContentUris.withAppendedId((Uri)Telephony.Sms.Conversations.CONTENT_URI, (long)threadId), (String)("locked=0 AND date<" + latestDate), null);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        protected void dumpMessage(Cursor cursor, Context context) {
            long date = cursor.getLong(4);
            String dateStr = MessageUtils.formatTimeStampString(context, date, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean anyThreadOverLimit(Context context) {
            Cursor cursor = this.getAllThreads(context);
            if (cursor == null) {
                return false;
            }
            int limit = this.getMessageLimit(context);
            try {
                while (cursor.moveToNext()) {
                    long threadId = this.getThreadId(cursor);
                    ContentResolver resolver = context.getContentResolver();
                    Cursor msgs = SqliteWrapper.query((Context)context, (ContentResolver)resolver, (Uri)ContentUris.withAppendedId((Uri)Telephony.Sms.Conversations.CONTENT_URI, (long)threadId), (String[])SMS_MESSAGE_PROJECTION, (String)"locked=0", null, (String)"date DESC");
                    if (msgs == null) {
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        if (msgs.getCount() < limit) continue;
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        msgs.close();
                    }
                }
            }
            finally {
                cursor.close();
            }
            return false;
        }
    }
}

