/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.util;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.telephony.ServiceState;
import android.util.Log;
import android.widget.Toast;
import com.android.mms.data.Contact;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.NotificationInd;
import com.google.android.mms.pdu.PduPersister;

public class DownloadManager {
    private static final String TAG = "DownloadManager";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final int DEFERRED_MASK = 4;
    public static final int STATE_UNSTARTED = 128;
    public static final int STATE_DOWNLOADING = 129;
    public static final int STATE_TRANSIENT_FAILURE = 130;
    public static final int STATE_PERMANENT_FAILURE = 135;
    private final Context mContext;
    private final Handler mHandler;
    private final SharedPreferences mPreferences;
    private boolean mAutoDownload;
    private final SharedPreferences.OnSharedPreferenceChangeListener mPreferencesChangeListener = new SharedPreferences.OnSharedPreferenceChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSharedPreferenceChanged(SharedPreferences prefs, String key) {
            if ("pref_key_mms_auto_retrieval".equals(key) || "pref_key_mms_retrieval_during_roaming".equals(key)) {
                DownloadManager downloadManager = sInstance;
                synchronized (downloadManager) {
                    DownloadManager.this.mAutoDownload = DownloadManager.getAutoDownloadState(prefs);
                }
            }
        }
    };
    private final BroadcastReceiver mRoamingStateListener = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.SERVICE_STATE".equals(intent.getAction())) {
                ServiceState state = ServiceState.newFromBundle((Bundle)intent.getExtras());
                boolean isRoaming = state.getRoaming();
                DownloadManager downloadManager = sInstance;
                synchronized (downloadManager) {
                    DownloadManager.this.mAutoDownload = DownloadManager.getAutoDownloadState(DownloadManager.this.mPreferences, isRoaming);
                }
            }
        }
    };
    private static DownloadManager sInstance;

    private DownloadManager(Context context) {
        this.mContext = context;
        this.mHandler = new Handler();
        this.mPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.mPreferences.registerOnSharedPreferenceChangeListener(this.mPreferencesChangeListener);
        context.registerReceiver(this.mRoamingStateListener, new IntentFilter("android.intent.action.SERVICE_STATE"));
        this.mAutoDownload = DownloadManager.getAutoDownloadState(this.mPreferences);
    }

    public boolean isAuto() {
        return this.mAutoDownload;
    }

    public static void init(Context context) {
        if (sInstance != null) {
            Log.w((String)TAG, (String)"Already initialized.");
        }
        sInstance = new DownloadManager(context);
    }

    public static DownloadManager getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("Uninitialized.");
        }
        return sInstance;
    }

    static boolean getAutoDownloadState(SharedPreferences prefs) {
        return DownloadManager.getAutoDownloadState(prefs, DownloadManager.isRoaming());
    }

    static boolean getAutoDownloadState(SharedPreferences prefs, boolean roaming) {
        boolean autoDownload = prefs.getBoolean("pref_key_mms_auto_retrieval", true);
        if (autoDownload) {
            boolean alwaysAuto = prefs.getBoolean("pref_key_mms_retrieval_during_roaming", false);
            if (!roaming || alwaysAuto) {
                return true;
            }
        }
        return false;
    }

    static boolean isRoaming() {
        String roaming = SystemProperties.get((String)"gsm.operator.isroaming", null);
        return "true".equals(roaming);
    }

    public void markState(final Uri uri, int state) {
        try {
            NotificationInd nInd = (NotificationInd)PduPersister.getPduPersister((Context)this.mContext).load(uri);
            if (nInd.getExpiry() < System.currentTimeMillis() / 1000L && state == 129) {
                this.mHandler.post(new Runnable(){

                    public void run() {
                        Toast.makeText((Context)DownloadManager.this.mContext, (int)2131165425, (int)1).show();
                    }
                });
                SqliteWrapper.delete((Context)this.mContext, (ContentResolver)this.mContext.getContentResolver(), (Uri)uri, null, null);
                return;
            }
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            return;
        }
        if (state == 135) {
            this.mHandler.post(new Runnable(){

                public void run() {
                    try {
                        Toast.makeText((Context)DownloadManager.this.mContext, (CharSequence)DownloadManager.this.getMessage(uri), (int)1).show();
                    }
                    catch (MmsException e) {
                        Log.e((String)DownloadManager.TAG, (String)e.getMessage(), (Throwable)e);
                    }
                }
            });
        } else if (!this.mAutoDownload) {
            state |= 4;
        }
        ContentValues values = new ContentValues(1);
        values.put("st", Integer.valueOf(state));
        SqliteWrapper.update((Context)this.mContext, (ContentResolver)this.mContext.getContentResolver(), (Uri)uri, (ContentValues)values, null, null);
    }

    public void showErrorCodeToast(int errorStr) {
        final int errStr = errorStr;
        this.mHandler.post(new Runnable(){

            public void run() {
                try {
                    Toast.makeText((Context)DownloadManager.this.mContext, (int)errStr, (int)1).show();
                }
                catch (Exception e) {
                    Log.e((String)DownloadManager.TAG, (String)"Caught an exception in showErrorCodeToast");
                }
            }
        });
    }

    private String getMessage(Uri uri) throws MmsException {
        NotificationInd ind = (NotificationInd)PduPersister.getPduPersister((Context)this.mContext).load(uri);
        EncodedStringValue v = ind.getSubject();
        String subject = v != null ? v.getString() : this.mContext.getString(2131165422);
        v = ind.getFrom();
        String from = v != null ? Contact.get(v.getString(), false).getName() : this.mContext.getString(2131165423);
        return this.mContext.getString(0x7F0700F0, new Object[]{subject, from});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState(Uri uri) {
        Cursor cursor = SqliteWrapper.query((Context)this.mContext, (ContentResolver)this.mContext.getContentResolver(), (Uri)uri, (String[])new String[]{"st"}, null, null, null);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    int n = cursor.getInt(0) & 0xFFFFFFFB;
                    return n;
                }
            }
            finally {
                cursor.close();
            }
        }
        return 128;
    }
}

