/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.android.mms.model.IModelChangedObserver;
import com.android.mms.model.Model;
import com.android.mms.model.SlideModel;
import com.android.mms.model.SlideshowModel;
import com.android.mms.ui.Presenter;
import com.android.mms.ui.PresenterFactory;
import com.android.mms.ui.SlideEditorActivity;
import com.android.mms.ui.SlideListItemView;
import com.android.mms.ui.SlideshowEditor;
import com.android.mms.ui.SlideshowPresenter;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.PduBody;
import com.google.android.mms.pdu.PduPersister;
import java.util.List;

public class SlideshowEditActivity
extends ListActivity {
    private static final String TAG = "SlideshowEditActivity";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final int MENU_MOVE_UP = 0;
    private static final int MENU_MOVE_DOWN = 1;
    private static final int MENU_REMOVE_SLIDE = 2;
    private static final int MENU_ADD_SLIDE = 3;
    private static final int MENU_DISCARD_SLIDESHOW = 4;
    private static final int REQUEST_CODE_EDIT_SLIDE = 6;
    private static final String STATE = "state";
    private static final String SLIDE_INDEX = "slide_index";
    private static final String MESSAGE_URI = "message_uri";
    private ListView mList;
    private SlideListAdapter mSlideListAdapter;
    private SlideshowModel mSlideshowModel = null;
    private SlideshowEditor mSlideshowEditor = null;
    private Bundle mState;
    private Uri mUri;
    private Intent mResultIntent;
    private boolean mDirty;
    private View mAddSlideItem;
    private final IModelChangedObserver mModelChangedObserver = new IModelChangedObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onModelChanged(Model model, boolean dataChanged) {
            SlideshowEditActivity slideshowEditActivity = SlideshowEditActivity.this;
            synchronized (slideshowEditActivity) {
                SlideshowEditActivity.this.mDirty = true;
            }
            SlideshowEditActivity.this.setResult(-1, SlideshowEditActivity.this.mResultIntent);
            SlideshowEditActivity.this.adjustAddSlideVisibility();
        }
    };

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.mList = this.getListView();
        this.mAddSlideItem = this.createAddSlideItem();
        this.mList.addFooterView(this.mAddSlideItem);
        this.mAddSlideItem.setVisibility(8);
        if (icicle != null) {
            this.mState = icicle.getBundle(STATE);
        }
        this.mUri = this.mState != null ? Uri.parse((String)this.mState.getString(MESSAGE_URI)) : this.getIntent().getData();
        if (this.mUri == null) {
            Log.e((String)TAG, (String)"Cannot startup activity, null Uri.");
            this.finish();
            return;
        }
        this.mResultIntent = new Intent();
        this.mResultIntent.setData(this.mUri);
        try {
            this.initSlideList();
            this.adjustAddSlideVisibility();
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)"Failed to initialize the slide-list.", (Throwable)e);
            this.finish();
        }
    }

    private View createAddSlideItem() {
        View v = ((LayoutInflater)this.getSystemService("layout_inflater")).inflate(2130903070, null);
        TextView text = (TextView)v.findViewById(2131361892);
        text.setText(2131165228);
        text = (TextView)v.findViewById(2131361893);
        text.setText(2131165229);
        text.setVisibility(0);
        ImageView image = (ImageView)v.findViewById(2131361891);
        image.setImageResource(2130837543);
        return v;
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        if (position == l.getCount() - 1) {
            this.addNewSlide();
        } else {
            this.openSlide(position);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.mState != null) {
            this.mList.setSelection(this.mState.getInt(SLIDE_INDEX, 0));
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mState = new Bundle();
        if (this.mList.getSelectedItemPosition() >= 0) {
            this.mState.putInt(SLIDE_INDEX, this.mList.getSelectedItemPosition());
        }
        if (this.mUri != null) {
            this.mState.putString(MESSAGE_URI, this.mUri.toString());
        }
        outState.putBundle(STATE, this.mState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPause() {
        super.onPause();
        SlideshowEditActivity slideshowEditActivity = this;
        synchronized (slideshowEditActivity) {
            if (this.mDirty) {
                try {
                    PduBody pb = this.mSlideshowModel.toPduBody();
                    PduPersister.getPduPersister((Context)this).updateParts(this.mUri, pb);
                    this.mSlideshowModel.sync(pb);
                }
                catch (MmsException e) {
                    Log.e((String)TAG, (String)("Cannot update the message: " + this.mUri), (Throwable)e);
                }
            }
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.cleanupSlideshowModel();
    }

    private void cleanupSlideshowModel() {
        if (this.mSlideshowModel != null) {
            this.mSlideshowModel.unregisterModelChangedObserver(this.mModelChangedObserver);
            this.mSlideshowModel = null;
        }
    }

    private void initSlideList() throws MmsException {
        this.cleanupSlideshowModel();
        this.mSlideshowModel = SlideshowModel.createFromMessageUri((Context)this, this.mUri);
        this.mSlideshowModel.registerModelChangedObserver(this.mModelChangedObserver);
        this.mSlideshowEditor = new SlideshowEditor((Context)this, this.mSlideshowModel);
        this.mSlideListAdapter = new SlideListAdapter((Context)this, 2130903070, this.mSlideshowModel);
        this.mList.setAdapter((ListAdapter)this.mSlideListAdapter);
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        menu.clear();
        int position = this.mList.getSelectedItemPosition();
        if (position >= 0 && position != this.mList.getCount() - 1) {
            if (position > 0) {
                menu.add(0, 0, 0, 2131165225).setIcon(2130837562);
            }
            if (position < this.mSlideListAdapter.getCount() - 1) {
                menu.add(0, 1, 0, 2131165226).setIcon(2130837561);
            }
            menu.add(0, 3, 0, 2131165228).setIcon(2130837551);
            menu.add(0, 2, 0, 2131165227).setIcon(17301564);
        } else {
            menu.add(0, 3, 0, 2131165228).setIcon(2130837551);
        }
        menu.add(0, 4, 0, 2131165230).setIcon(2130837556);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int position = this.mList.getSelectedItemPosition();
        switch (item.getItemId()) {
            case 0: {
                if (position <= 0 || position >= this.mSlideshowModel.size()) break;
                this.mSlideshowEditor.moveSlideUp(position);
                this.mSlideListAdapter.notifyDataSetChanged();
                this.mList.setSelection(position - 1);
                break;
            }
            case 1: {
                if (position < 0 || position >= this.mSlideshowModel.size() - 1) break;
                this.mSlideshowEditor.moveSlideDown(position);
                this.mSlideListAdapter.notifyDataSetChanged();
                this.mList.setSelection(position + 1);
                break;
            }
            case 2: {
                if (position < 0 || position >= this.mSlideshowModel.size()) break;
                this.mSlideshowEditor.removeSlide(position);
                this.mSlideListAdapter.notifyDataSetChanged();
                break;
            }
            case 3: {
                this.addNewSlide();
                break;
            }
            case 4: {
                this.mSlideshowEditor.removeAllSlides();
                this.mSlideListAdapter.notifyDataSetChanged();
                this.finish();
            }
        }
        return true;
    }

    private void openSlide(int index) {
        Intent intent = new Intent((Context)this, SlideEditorActivity.class);
        intent.setData(this.mUri);
        intent.putExtra(SLIDE_INDEX, index);
        this.startActivityForResult(intent, 6);
    }

    private void adjustAddSlideVisibility() {
        if (this.mSlideshowModel.size() >= 10) {
            this.mAddSlideItem.setVisibility(8);
        } else {
            this.mAddSlideItem.setVisibility(0);
        }
    }

    private void addNewSlide() {
        if (this.mSlideshowEditor.addNewSlide()) {
            this.mSlideListAdapter.notifyDataSetChanged();
            this.mList.requestFocus();
            this.mList.setSelection(this.mSlideshowModel.size() - 1);
        } else {
            Toast.makeText((Context)this, (int)2131165274, (int)0).show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode != -1) {
            return;
        }
        switch (requestCode) {
            case 6: {
                SlideshowEditActivity slideshowEditActivity = this;
                synchronized (slideshowEditActivity) {
                    this.mDirty = true;
                }
                this.setResult(-1, this.mResultIntent);
                if (data != null && data.getBooleanExtra("done", false)) {
                    this.finish();
                    return;
                }
                try {
                    this.initSlideList();
                    break;
                }
                catch (MmsException e) {
                    Log.e((String)TAG, (String)"Failed to initialize the slide-list.", (Throwable)e);
                    this.finish();
                    return;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SlideListAdapter
    extends ArrayAdapter<SlideModel> {
        private final Context mContext;
        private final int mResource;
        private final LayoutInflater mInflater;
        private final SlideshowModel mSlideshow;

        public SlideListAdapter(Context context, int resource, SlideshowModel slideshow) {
            super(context, resource, (List)slideshow);
            this.mContext = context;
            this.mResource = resource;
            this.mInflater = LayoutInflater.from((Context)context);
            this.mSlideshow = slideshow;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            return this.createViewFromResource(position, convertView, this.mResource);
        }

        private View createViewFromResource(int position, View convertView, int resource) {
            SlideListItemView slideListItemView = (SlideListItemView)this.mInflater.inflate(resource, null);
            TextView text = (TextView)slideListItemView.findViewById(2131361892);
            text.setText((CharSequence)this.mContext.getString(2131165441, new Object[]{position + 1}));
            SlideModel slide = (SlideModel)this.getItem(position);
            int dur = slide.getDuration() / 1000;
            text = (TextView)slideListItemView.findViewById(2131361896);
            text.setText((CharSequence)this.mContext.getResources().getQuantityString(2131230720, dur, new Object[]{dur}));
            Presenter presenter = PresenterFactory.getPresenter("SlideshowPresenter", this.mContext, slideListItemView, this.mSlideshow);
            ((SlideshowPresenter)presenter).setLocation(position);
            presenter.present();
            return slideListItemView;
        }
    }
}

