/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.MediaController;
import com.android.mms.dom.AttrImpl;
import com.android.mms.dom.smil.SmilPlayer;
import com.android.mms.model.LayoutModel;
import com.android.mms.model.RegionModel;
import com.android.mms.model.SlideshowModel;
import com.android.mms.model.SmilHelper;
import com.android.mms.ui.PresenterFactory;
import com.android.mms.ui.SlideView;
import com.google.android.mms.MmsException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.smil.SMILDocument;
import org.w3c.dom.smil.SMILElement;

public class SlideshowActivity
extends Activity
implements EventListener {
    private static final String TAG = "SlideshowActivity";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private MediaController mMediaController;
    private SmilPlayer mSmilPlayer;
    private Handler mHandler;
    private SMILDocument mSmilDoc;
    private SlideView mSlideView;

    private static final boolean isMMSConformance(SMILDocument smilDoc) {
        SMILElement head = smilDoc.getHead();
        if (head == null) {
            return false;
        }
        NodeList children = head.getChildNodes();
        if (children == null || children.getLength() != 1) {
            return false;
        }
        Node layout2 = children.item(0);
        if (layout2 == null || !"layout".equals(layout2.getNodeName())) {
            return false;
        }
        NodeList layoutChildren = layout2.getChildNodes();
        if (layoutChildren == null) {
            return false;
        }
        int num = layoutChildren.getLength();
        if (num <= 0) {
            return false;
        }
        for (int i = 0; i < num; ++i) {
            Node layoutChild = layoutChildren.item(i);
            if (layoutChild == null) {
                return false;
            }
            String name = layoutChild.getNodeName();
            if ("root-layout".equals(name)) continue;
            if ("region".equals(name)) {
                NamedNodeMap map = layoutChild.getAttributes();
                for (int j = 0; j < map.getLength(); ++j) {
                    Node node = map.item(j);
                    if (node == null) {
                        return false;
                    }
                    String attrName = node.getNodeName();
                    if ("left".equals(attrName) || "top".equals(attrName) || "height".equals(attrName) || "width".equals(attrName) || "fit".equals(attrName)) continue;
                    if ("id".equals(attrName)) {
                        if (!(node instanceof AttrImpl)) {
                            return false;
                        }
                        String value = ((AttrImpl)node).getValue();
                        if ("Text".equals(value) || "Image".equals(value)) continue;
                        return false;
                    }
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    public void onCreate(Bundle icicle) {
        SlideshowModel model;
        super.onCreate(icicle);
        this.mHandler = new Handler();
        this.requestWindowFeature(1);
        this.getWindow().setFormat(-3);
        this.setContentView(2130903067);
        Intent intent = this.getIntent();
        Uri msg = intent.getData();
        try {
            model = SlideshowModel.createFromMessageUri((Context)this, msg);
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)"Cannot present the slide show.", (Throwable)e);
            this.finish();
            return;
        }
        this.mSlideView = (SlideView)this.findViewById(2131361884);
        PresenterFactory.getPresenter("SlideshowPresenter", (Context)this, this.mSlideView, model);
        this.mHandler.post(new Runnable(){

            private boolean isRotating() {
                return SlideshowActivity.this.mSmilPlayer.isPausedState() || SlideshowActivity.this.mSmilPlayer.isPlayingState() || SlideshowActivity.this.mSmilPlayer.isPlayedState();
            }

            public void run() {
                SlideshowActivity.this.mSmilPlayer = SmilPlayer.getPlayer();
                SlideshowActivity.this.initMediaController();
                SlideshowActivity.this.mSlideView.setMediaController(SlideshowActivity.this.mMediaController);
                SlideshowActivity.this.mSmilDoc = SmilHelper.getDocument(model);
                if (SlideshowActivity.isMMSConformance(SlideshowActivity.this.mSmilDoc)) {
                    int imageLeft = 0;
                    int imageTop = 0;
                    int textLeft = 0;
                    int textTop = 0;
                    LayoutModel layout2 = model.getLayout();
                    if (layout2 != null) {
                        RegionModel textRegion;
                        RegionModel imageRegion = layout2.getImageRegion();
                        if (imageRegion != null) {
                            imageLeft = imageRegion.getLeft();
                            imageTop = imageRegion.getTop();
                        }
                        if ((textRegion = layout2.getTextRegion()) != null) {
                            textLeft = textRegion.getLeft();
                            textTop = textRegion.getTop();
                        }
                    }
                    SlideshowActivity.this.mSlideView.enableMMSConformanceMode(textLeft, textTop, imageLeft, imageTop);
                }
                ((EventTarget)((Object)SlideshowActivity.this.mSmilDoc)).addEventListener("SimlDocumentEnd", SlideshowActivity.this, false);
                SlideshowActivity.this.mSmilPlayer.init(SlideshowActivity.this.mSmilDoc);
                if (this.isRotating()) {
                    SlideshowActivity.this.mSmilPlayer.reload();
                } else {
                    SlideshowActivity.this.mSmilPlayer.play();
                }
            }
        });
    }

    private void initMediaController() {
        this.mMediaController = new MediaController((Context)this, false);
        this.mMediaController.setMediaPlayer((MediaController.MediaPlayerControl)new SmilPlayerController(this.mSmilPlayer));
        this.mMediaController.setAnchorView(this.findViewById(2131361884));
        this.mMediaController.setPrevNextListeners(new View.OnClickListener(){

            public void onClick(View v) {
                SlideshowActivity.this.mSmilPlayer.next();
            }
        }, new View.OnClickListener(){

            public void onClick(View v) {
                SlideshowActivity.this.mSmilPlayer.prev();
            }
        });
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mSmilPlayer != null && this.mMediaController != null) {
            this.mMediaController.show();
        }
        return false;
    }

    protected void onPause() {
        super.onPause();
        if (this.mSmilDoc != null) {
            ((EventTarget)((Object)this.mSmilDoc)).removeEventListener("SimlDocumentEnd", this, false);
        }
    }

    protected void onStop() {
        super.onStop();
        if (null != this.mSmilPlayer) {
            if (this.isFinishing()) {
                this.mSmilPlayer.stop();
            } else {
                this.mSmilPlayer.stopWhenReload();
            }
            if (this.mMediaController != null) {
                this.mMediaController.hide();
            }
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                break;
            }
            case 4: 
            case 82: {
                if (this.mSmilPlayer == null || !this.mSmilPlayer.isPausedState() && !this.mSmilPlayer.isPlayingState() && !this.mSmilPlayer.isPlayedState()) break;
                this.mSmilPlayer.stop();
                break;
            }
            default: {
                if (this.mSmilPlayer == null || this.mMediaController == null) break;
                this.mMediaController.show();
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public void handleEvent(Event evt) {
        final Event event = evt;
        this.mHandler.post(new Runnable(){

            public void run() {
                String type = event.getType();
                if (type.equals("SimlDocumentEnd")) {
                    SlideshowActivity.this.finish();
                }
            }
        });
    }

    private class SmilPlayerController
    implements MediaController.MediaPlayerControl {
        private final SmilPlayer mPlayer;

        public SmilPlayerController(SmilPlayer player) {
            this.mPlayer = player;
        }

        public int getBufferPercentage() {
            return 100;
        }

        public int getCurrentPosition() {
            return this.mPlayer.getCurrentPosition();
        }

        public int getDuration() {
            return this.mPlayer.getDuration();
        }

        public boolean isPlaying() {
            return this.mPlayer != null ? this.mPlayer.isPlayingState() : false;
        }

        public void pause() {
            if (this.mPlayer != null) {
                this.mPlayer.pause();
            }
        }

        public void seekTo(int pos) {
        }

        public void start() {
            if (this.mPlayer != null) {
                this.mPlayer.start();
            }
        }

        public boolean canPause() {
            return true;
        }

        public boolean canSeekBackward() {
            return true;
        }

        public boolean canSeekForward() {
            return true;
        }
    }
}

