/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaPlayer;
import android.net.Uri;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsoluteLayout;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.MediaController;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.VideoView;
import com.android.mms.layout.LayoutManager;
import com.android.mms.ui.AdaptableSlideViewInterface;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlideView
extends AbsoluteLayout
implements AdaptableSlideViewInterface {
    private static final String TAG = "SlideView";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final int AUDIO_INFO_HEIGHT = 82;
    private View mAudioInfoView;
    private ImageView mImageView;
    private VideoView mVideoView;
    private ScrollView mScrollText;
    private TextView mTextView;
    private AdaptableSlideViewInterface.OnSizeChangedListener mSizeChangedListener;
    private MediaPlayer mAudioPlayer;
    private boolean mIsPrepared;
    private boolean mStartWhenPrepared;
    private int mSeekWhenPrepared;
    private boolean mStopWhenPrepared;
    private ScrollView mScrollViewPort;
    private LinearLayout mViewPort;
    private boolean mConformanceMode;
    private MediaController mMediaController;
    MediaPlayer.OnPreparedListener mPreparedListener = new MediaPlayer.OnPreparedListener(){

        public void onPrepared(MediaPlayer mp) {
            SlideView.this.mIsPrepared = true;
            if (SlideView.this.mSeekWhenPrepared > 0) {
                SlideView.this.mAudioPlayer.seekTo(SlideView.this.mSeekWhenPrepared);
                SlideView.this.mSeekWhenPrepared = 0;
            }
            if (SlideView.this.mStartWhenPrepared) {
                SlideView.this.mAudioPlayer.start();
                SlideView.this.mStartWhenPrepared = false;
                SlideView.this.displayAudioInfo();
            }
            if (SlideView.this.mStopWhenPrepared) {
                SlideView.this.mAudioPlayer.stop();
                SlideView.this.mAudioPlayer.release();
                SlideView.this.mAudioPlayer = null;
                SlideView.this.mStopWhenPrepared = false;
                SlideView.this.hideAudioInfo();
            }
        }
    };

    public SlideView(Context context) {
        super(context);
    }

    public SlideView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public void setImage(String name, Bitmap bitmap) {
        if (this.mImageView == null) {
            this.mImageView = new ImageView(this.mContext);
            this.mImageView.setPadding(0, 5, 0, 5);
            this.addView((View)this.mImageView, (ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(-2, -2, 0, 0));
        }
        try {
            if (null == bitmap) {
                bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837569);
            }
            this.mImageView.setVisibility(0);
            this.mImageView.setImageBitmap(bitmap);
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)"setImage: out of memory: ", (Throwable)e);
        }
    }

    @Override
    public void setImageRegion(int left, int top, int width, int height) {
        if (this.mImageView != null && !this.mConformanceMode) {
            this.mImageView.setLayoutParams((ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(width, height, left, top));
        }
    }

    @Override
    public void setImageRegionFit(String fit) {
    }

    @Override
    public void setVideo(String name, Uri video) {
        if (this.mVideoView == null) {
            this.mVideoView = new VideoView(this.mContext);
            this.addView((View)this.mVideoView, (ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(-2, -2, 0, 0));
        }
        this.mVideoView.setVisibility(0);
        this.mVideoView.setVideoURI(video);
    }

    public void setMediaController(MediaController mediaController) {
        this.mMediaController = mediaController;
    }

    private void initAudioInfoView(String name) {
        if (null == this.mAudioInfoView) {
            LayoutInflater factory = LayoutInflater.from((Context)this.getContext());
            this.mAudioInfoView = factory.inflate(2130903060, null);
            int height = this.mAudioInfoView.getHeight();
            TextView audioName = (TextView)this.mAudioInfoView.findViewById(2131361875);
            audioName.setText((CharSequence)name);
            if (this.mConformanceMode) {
                this.mViewPort.addView(this.mAudioInfoView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 82));
            } else {
                this.addView(this.mAudioInfoView, (ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(-1, 82, 0, this.getHeight() - 82));
            }
        }
        this.mAudioInfoView.setVisibility(8);
    }

    private void displayAudioInfo() {
        if (null != this.mAudioInfoView) {
            this.mAudioInfoView.setVisibility(0);
        }
    }

    private void hideAudioInfo() {
        if (null != this.mAudioInfoView) {
            this.mAudioInfoView.setVisibility(8);
        }
    }

    @Override
    public void setAudio(Uri audio, String name, Map<String, ?> extras) {
        if (audio == null) {
            throw new IllegalArgumentException("Audio URI may not be null.");
        }
        if (this.mAudioPlayer != null) {
            this.mAudioPlayer.reset();
            this.mAudioPlayer.release();
            this.mAudioPlayer = null;
        }
        this.mIsPrepared = false;
        try {
            this.mAudioPlayer = new MediaPlayer();
            this.mAudioPlayer.setOnPreparedListener(this.mPreparedListener);
            this.mAudioPlayer.setDataSource(this.mContext, audio);
            this.mAudioPlayer.prepareAsync();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Unexpected IOException.", (Throwable)e);
            this.mAudioPlayer.release();
            this.mAudioPlayer = null;
        }
        this.initAudioInfoView(name);
    }

    @Override
    public void setText(String name, String text) {
        if (!this.mConformanceMode) {
            if (null == this.mScrollText) {
                this.mScrollText = new ScrollView(this.mContext);
                this.mScrollText.setScrollBarStyle(0x3000000);
                this.addView((View)this.mScrollText, (ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(-2, -2, 0, 0));
            }
            if (null == this.mTextView) {
                this.mTextView = new TextView(this.mContext);
                this.mTextView.setTransformationMethod((TransformationMethod)HideReturnsTransformationMethod.getInstance());
                this.mScrollText.addView((View)this.mTextView);
            }
            this.mScrollText.requestFocus();
        }
        this.mTextView.setVisibility(0);
        this.mTextView.setText((CharSequence)text);
    }

    @Override
    public void setTextRegion(int left, int top, int width, int height) {
        if (this.mScrollText != null && !this.mConformanceMode) {
            this.mScrollText.setLayoutParams((ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(width, height, left, top));
        }
    }

    @Override
    public void setVideoRegion(int left, int top, int width, int height) {
        if (this.mVideoView != null && !this.mConformanceMode) {
            this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(width, height, left, top));
        }
    }

    @Override
    public void setImageVisibility(boolean visible) {
        if (this.mImageView != null) {
            if (this.mConformanceMode) {
                this.mImageView.setVisibility(visible ? 0 : 8);
            } else {
                this.mImageView.setVisibility(visible ? 0 : 4);
            }
        }
    }

    @Override
    public void setTextVisibility(boolean visible) {
        if (this.mScrollText != null) {
            if (this.mConformanceMode) {
                this.mTextView.setVisibility(visible ? 0 : 8);
            } else {
                this.mScrollText.setVisibility(visible ? 0 : 4);
            }
        }
    }

    @Override
    public void setVideoVisibility(boolean visible) {
        if (this.mVideoView != null) {
            if (this.mConformanceMode) {
                this.mVideoView.setVisibility(visible ? 0 : 8);
            } else {
                this.mVideoView.setVisibility(visible ? 0 : 4);
            }
        }
    }

    @Override
    public void startAudio() {
        if (this.mAudioPlayer != null && this.mIsPrepared) {
            this.mAudioPlayer.start();
            this.mStartWhenPrepared = false;
            this.displayAudioInfo();
        } else {
            this.mStartWhenPrepared = true;
        }
    }

    @Override
    public void stopAudio() {
        if (this.mAudioPlayer != null && this.mIsPrepared) {
            this.mAudioPlayer.stop();
            this.mAudioPlayer.release();
            this.mAudioPlayer = null;
            this.hideAudioInfo();
        } else {
            this.mStopWhenPrepared = true;
        }
    }

    @Override
    public void pauseAudio() {
        if (this.mAudioPlayer != null && this.mIsPrepared && this.mAudioPlayer.isPlaying()) {
            this.mAudioPlayer.pause();
        }
        this.mStartWhenPrepared = false;
    }

    @Override
    public void seekAudio(int seekTo) {
        if (this.mAudioPlayer != null && this.mIsPrepared) {
            this.mAudioPlayer.seekTo(seekTo);
        } else {
            this.mSeekWhenPrepared = seekTo;
        }
    }

    @Override
    public void startVideo() {
        if (this.mVideoView != null) {
            this.mVideoView.start();
        }
    }

    @Override
    public void stopVideo() {
        if (this.mVideoView != null) {
            this.mVideoView.stopPlayback();
        }
    }

    @Override
    public void pauseVideo() {
        if (this.mVideoView != null) {
            this.mVideoView.pause();
        }
    }

    @Override
    public void seekVideo(int seekTo) {
        if (this.mVideoView != null && seekTo > 0) {
            this.mVideoView.seekTo(seekTo);
        }
    }

    @Override
    public void reset() {
        if (null != this.mScrollText) {
            this.mScrollText.setVisibility(8);
        }
        if (null != this.mImageView) {
            this.mImageView.setVisibility(8);
        }
        if (null != this.mAudioPlayer) {
            this.stopAudio();
        }
        if (null != this.mVideoView) {
            this.stopVideo();
            this.mVideoView.setVisibility(8);
        }
        if (null != this.mTextView) {
            this.mTextView.setVisibility(8);
        }
        if (this.mScrollViewPort != null) {
            this.mScrollViewPort.scrollTo(0, 0);
            this.mScrollViewPort.setLayoutParams((ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(-1, -1, 0, 0));
        }
    }

    @Override
    public void setVisibility(boolean visible) {
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mSizeChangedListener != null) {
            this.mSizeChangedListener.onSizeChanged(w, h - 82);
        }
    }

    @Override
    public void setOnSizeChangedListener(AdaptableSlideViewInterface.OnSizeChangedListener l) {
        this.mSizeChangedListener = l;
    }

    public void enableMMSConformanceMode(int textLeft, int textTop, int imageLeft, int imageTop) {
        this.mConformanceMode = true;
        if (this.mScrollViewPort == null) {
            this.mScrollViewPort = new ScrollView(this.mContext){
                private int mBottomY;

                protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
                    super.onLayout(changed, left, top, right, bottom);
                    if (this.getChildCount() > 0) {
                        int childHeight = this.getChildAt(0).getHeight();
                        int height = this.getHeight();
                        this.mBottomY = height < childHeight ? childHeight - height : 0;
                    }
                }

                protected void onScrollChanged(int l, int t, int oldl, int oldt) {
                    if ((t == 0 || t >= this.mBottomY) && SlideView.this.mMediaController != null) {
                        SlideView.this.mMediaController.show();
                    }
                }
            };
            this.mScrollViewPort.setScrollBarStyle(0x3000000);
            this.mViewPort = new LinearLayout(this.mContext);
            this.mViewPort.setOrientation(1);
            this.mViewPort.setGravity(17);
            this.mViewPort.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (SlideView.this.mMediaController != null) {
                        SlideView.this.mMediaController.show();
                    }
                }
            });
            this.mScrollViewPort.addView((View)this.mViewPort, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
            this.addView((View)this.mScrollViewPort);
        }
        TreeMap<Position, Object> viewsByPosition = new TreeMap<Position, Object>(new Comparator<Position>(){

            @Override
            public int compare(Position p1, Position p2) {
                int l1 = p1.mLeft;
                int t1 = p1.mTop;
                int l2 = p2.mLeft;
                int t2 = p2.mTop;
                int res = t1 - t2;
                if (res == 0) {
                    res = l1 - l2;
                }
                if (res == 0) {
                    return -1;
                }
                return res;
            }
        });
        if (textLeft >= 0 && textTop >= 0) {
            this.mTextView = new TextView(this.mContext);
            this.mTextView.setTransformationMethod((TransformationMethod)HideReturnsTransformationMethod.getInstance());
            this.mTextView.setTextSize(18.0f);
            this.mTextView.setPadding(5, 5, 5, 5);
            viewsByPosition.put(new Position(textLeft, textTop), this.mTextView);
        }
        if (imageLeft >= 0 && imageTop >= 0) {
            this.mImageView = new ImageView(this.mContext);
            this.mImageView.setPadding(0, 5, 0, 5);
            viewsByPosition.put(new Position(imageLeft, imageTop), this.mImageView);
            this.mVideoView = new VideoView(this.mContext);
            viewsByPosition.put(new Position(imageLeft + 1, imageTop), this.mVideoView);
        }
        for (View view : viewsByPosition.values()) {
            if (view instanceof VideoView) {
                this.mViewPort.addView(view, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, LayoutManager.getInstance().getLayoutParameters().getHeight()));
            } else {
                this.mViewPort.addView(view, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            }
            view.setVisibility(8);
        }
    }

    private class Position {
        public int mTop;
        public int mLeft;

        public Position(int left, int top) {
            this.mTop = top;
            this.mLeft = left;
        }
    }
}

