/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaPlayer;
import android.net.Uri;
import android.text.TextUtils;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.mms.ui.SlideViewInterface;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlideListItemView
extends LinearLayout
implements SlideViewInterface {
    private static final String TAG = "SlideListItemView";
    private TextView mTextPreview;
    private ImageView mImagePreview;
    private TextView mAttachmentName;
    private ImageView mAttachmentIcon;

    public SlideListItemView(Context context) {
        super(context);
    }

    public SlideListItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        this.mTextPreview = (TextView)this.findViewById(2131361893);
        this.mTextPreview.setTransformationMethod((TransformationMethod)HideReturnsTransformationMethod.getInstance());
        this.mImagePreview = (ImageView)this.findViewById(2131361891);
        this.mAttachmentName = (TextView)this.findViewById(2131361894);
        this.mAttachmentIcon = (ImageView)this.findViewById(2131361895);
    }

    @Override
    public void startAudio() {
    }

    @Override
    public void startVideo() {
    }

    @Override
    public void setAudio(Uri audio, String name, Map<String, ?> extras) {
        if (name != null) {
            this.mAttachmentName.setText((CharSequence)name);
            this.mAttachmentIcon.setImageResource(2130837574);
        } else {
            this.mAttachmentName.setText((CharSequence)"");
            this.mAttachmentIcon.setImageDrawable(null);
        }
    }

    @Override
    public void setImage(String name, Bitmap bitmap) {
        try {
            if (null == bitmap) {
                bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837569);
            }
            this.mImagePreview.setImageBitmap(bitmap);
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)"setImage: out of memory: ", (Throwable)e);
        }
    }

    @Override
    public void setImageRegionFit(String fit) {
    }

    @Override
    public void setImageVisibility(boolean visible) {
    }

    @Override
    public void setText(String name, String text) {
        this.mTextPreview.setText((CharSequence)text);
        this.mTextPreview.setVisibility(TextUtils.isEmpty((CharSequence)text) ? 8 : 0);
    }

    @Override
    public void setTextVisibility(boolean visible) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVideo(String name, Uri video) {
        if (name != null) {
            this.mAttachmentName.setText((CharSequence)name);
            this.mAttachmentIcon.setImageResource(2130837585);
        } else {
            this.mAttachmentName.setText((CharSequence)"");
            this.mAttachmentIcon.setImageDrawable(null);
        }
        MediaPlayer mp = new MediaPlayer();
        try {
            mp.setDataSource(this.mContext, video);
            this.mImagePreview.setImageBitmap(mp.getFrameAt(1000));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Unexpected IOException.", (Throwable)e);
        }
        finally {
            mp.release();
        }
    }

    @Override
    public void setVideoVisibility(boolean visible) {
    }

    @Override
    public void stopAudio() {
    }

    @Override
    public void stopVideo() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void setVisibility(boolean visible) {
    }

    @Override
    public void pauseAudio() {
    }

    @Override
    public void pauseVideo() {
    }

    @Override
    public void seekAudio(int seekTo) {
    }

    @Override
    public void seekVideo(int seekTo) {
    }
}

