/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentUris;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.provider.Settings;
import android.text.InputFilter;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.android.mms.ExceedMessageSizeException;
import com.android.mms.MmsConfig;
import com.android.mms.ResolutionException;
import com.android.mms.UnsupportContentTypeException;
import com.android.mms.model.IModelChangedObserver;
import com.android.mms.model.Model;
import com.android.mms.model.SlideModel;
import com.android.mms.model.SlideshowModel;
import com.android.mms.ui.BasicSlideEditorView;
import com.android.mms.ui.EditSlideDurationActivity;
import com.android.mms.ui.LayoutSelectorAdapter;
import com.android.mms.ui.MessageUtils;
import com.android.mms.ui.PresenterFactory;
import com.android.mms.ui.SlideshowEditor;
import com.android.mms.ui.SlideshowPresenter;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.PduBody;
import com.google.android.mms.pdu.PduPart;
import com.google.android.mms.pdu.PduPersister;

public class SlideEditorActivity
extends Activity {
    private static final String TAG = "SlideEditorActivity";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    public static final String SLIDE_INDEX = "slide_index";
    private static final int MENU_REMOVE_TEXT = 0;
    private static final int MENU_ADD_PICTURE = 1;
    private static final int MENU_TAKE_PICTURE = 2;
    private static final int MENU_DEL_PICTURE = 3;
    private static final int MENU_ADD_AUDIO = 4;
    private static final int MENU_DEL_AUDIO = 5;
    private static final int MENU_ADD_VIDEO = 6;
    private static final int MENU_ADD_SLIDE = 7;
    private static final int MENU_DEL_VIDEO = 8;
    private static final int MENU_LAYOUT = 9;
    private static final int MENU_DURATION = 10;
    private static final int MENU_PREVIEW_SLIDESHOW = 11;
    private static final int MENU_RECORD_SOUND = 12;
    private static final int MENU_SUB_AUDIO = 13;
    private static final int REQUEST_CODE_EDIT_TEXT = 0;
    private static final int REQUEST_CODE_CHANGE_PICTURE = 1;
    private static final int REQUEST_CODE_TAKE_PICTURE = 2;
    private static final int REQUEST_CODE_CHANGE_MUSIC = 3;
    private static final int REQUEST_CODE_RECORD_SOUND = 4;
    private static final int REQUEST_CODE_CHANGE_VIDEO = 5;
    private static final int REQUEST_CODE_CHANGE_DURATION = 6;
    private static final int NUM_DIRECT_DURATIONS = 10;
    private ImageButton mNextSlide;
    private ImageButton mPreSlide;
    private Button mPreview;
    private Button mReplaceImage;
    private Button mRemoveSlide;
    private EditText mTextEditor;
    private Button mDone;
    private BasicSlideEditorView mSlideView;
    private SlideshowModel mSlideshowModel;
    private SlideshowEditor mSlideshowEditor;
    private SlideshowPresenter mPresenter;
    private boolean mDirty;
    private int mPosition;
    private Uri mUri;
    private static final String MESSAGE_URI = "message_uri";
    private final IModelChangedObserver mModelChangedObserver = new IModelChangedObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onModelChanged(Model model, boolean dataChanged) {
            SlideEditorActivity slideEditorActivity = SlideEditorActivity.this;
            synchronized (slideEditorActivity) {
                SlideEditorActivity.this.mDirty = true;
            }
            SlideEditorActivity.this.setResult(-1);
        }
    };
    private final View.OnClickListener mOnRemoveSlide = new View.OnClickListener(){

        public void onClick(View v) {
            if (SlideEditorActivity.this.mPosition >= 0 && SlideEditorActivity.this.mPosition < SlideEditorActivity.this.mSlideshowModel.size()) {
                SlideEditorActivity.this.mSlideshowEditor.removeSlide(SlideEditorActivity.this.mPosition);
                int size = SlideEditorActivity.this.mSlideshowModel.size();
                if (size > 0) {
                    if (SlideEditorActivity.this.mPosition >= size) {
                        SlideEditorActivity.this.mPosition--;
                    }
                    SlideEditorActivity.this.showCurrentSlide();
                } else {
                    SlideEditorActivity.this.finish();
                    return;
                }
            }
        }
    };
    private final BasicSlideEditorView.OnTextChangedListener mOnTextChangedListener = new BasicSlideEditorView.OnTextChangedListener(){

        public void onTextChanged(String s) {
            if (!SlideEditorActivity.this.isFinishing()) {
                SlideEditorActivity.this.mSlideshowEditor.changeText(SlideEditorActivity.this.mPosition, s);
            }
        }
    };
    private final View.OnClickListener mOnPreview = new View.OnClickListener(){

        public void onClick(View v) {
            SlideEditorActivity.this.previewSlideshow();
        }
    };
    private final View.OnClickListener mOnReplaceImage = new View.OnClickListener(){

        public void onClick(View v) {
            SlideModel slide = SlideEditorActivity.this.mSlideshowModel.get(SlideEditorActivity.this.mPosition);
            if (slide != null && slide.hasVideo()) {
                Toast.makeText((Context)SlideEditorActivity.this, (int)2131165275, (int)0).show();
                return;
            }
            Intent intent = new Intent("android.intent.action.GET_CONTENT", null);
            intent.setType("image/*");
            SlideEditorActivity.this.startActivityForResult(intent, 1);
        }
    };
    private final View.OnClickListener mOnNavigateBackward = new View.OnClickListener(){

        public void onClick(View v) {
            if (SlideEditorActivity.this.mPosition > 0) {
                SlideEditorActivity.this.mPosition--;
                SlideEditorActivity.this.showCurrentSlide();
            }
        }
    };
    private final View.OnClickListener mOnNavigateForward = new View.OnClickListener(){

        public void onClick(View v) {
            if (SlideEditorActivity.this.mPosition < SlideEditorActivity.this.mSlideshowModel.size() - 1) {
                SlideEditorActivity.this.mPosition++;
                SlideEditorActivity.this.showCurrentSlide();
            }
        }
    };
    private final View.OnClickListener mDoneClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            Intent data = new Intent();
            data.putExtra("done", true);
            SlideEditorActivity.this.setResult(-1, data);
            SlideEditorActivity.this.finish();
        }
    };
    private final MessageUtils.ResizeImageResultCallback mResizeImageCallback = new MessageUtils.ResizeImageResultCallback(){

        public void onResizeResult(PduPart part, boolean append) {
            SlideEditorActivity context = SlideEditorActivity.this;
            if (part == null) {
                Toast.makeText((Context)SlideEditorActivity.this, (CharSequence)SlideEditorActivity.this.getResourcesString(2131165260, SlideEditorActivity.this.getPictureString()), (int)0).show();
                return;
            }
            try {
                long messageId = ContentUris.parseId((Uri)SlideEditorActivity.this.mUri);
                PduPersister persister = PduPersister.getPduPersister((Context)context);
                Uri newUri = persister.persistPart(part, messageId);
                SlideEditorActivity.this.mSlideshowEditor.changeImage(SlideEditorActivity.this.mPosition, newUri);
                SlideEditorActivity.this.setReplaceButtonText(2131165288);
            }
            catch (MmsException e) {
                SlideEditorActivity.this.notifyUser("add picture failed");
                Toast.makeText((Context)SlideEditorActivity.this, (CharSequence)SlideEditorActivity.this.getResourcesString(2131165260, SlideEditorActivity.this.getPictureString()), (int)0).show();
            }
            catch (UnsupportContentTypeException e) {
                MessageUtils.showErrorDialog((Context)SlideEditorActivity.this, SlideEditorActivity.this.getResourcesString(2131165256, SlideEditorActivity.this.getPictureString()), SlideEditorActivity.this.getResourcesString(2131165257, SlideEditorActivity.this.getPictureString()));
            }
            catch (ResolutionException e) {
                MessageUtils.showErrorDialog((Context)SlideEditorActivity.this, SlideEditorActivity.this.getResourcesString(2131165261), SlideEditorActivity.this.getResourcesString(2131165262));
            }
            catch (ExceedMessageSizeException e) {
                MessageUtils.showErrorDialog((Context)SlideEditorActivity.this, SlideEditorActivity.this.getResourcesString(2131165258), SlideEditorActivity.this.getResourcesString(2131165260, SlideEditorActivity.this.getPictureString()));
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903050);
        this.mSlideView = (BasicSlideEditorView)this.findViewById(2131361834);
        this.mSlideView.setOnTextChangedListener(this.mOnTextChangedListener);
        this.mPreSlide = (ImageButton)this.findViewById(2131361838);
        this.mPreSlide.setOnClickListener(this.mOnNavigateBackward);
        this.mNextSlide = (ImageButton)this.findViewById(2131361839);
        this.mNextSlide.setOnClickListener(this.mOnNavigateForward);
        this.mPreview = (Button)this.findViewById(2131361840);
        this.mPreview.setOnClickListener(this.mOnPreview);
        this.mReplaceImage = (Button)this.findViewById(2131361841);
        this.mReplaceImage.setOnClickListener(this.mOnReplaceImage);
        this.mRemoveSlide = (Button)this.findViewById(2131361842);
        this.mRemoveSlide.setOnClickListener(this.mOnRemoveSlide);
        this.mTextEditor = (EditText)this.findViewById(2131361843);
        this.mTextEditor.setFilters(new InputFilter[]{new InputFilter.LengthFilter(MmsConfig.getMaxTextLimit())});
        this.mDone = (Button)this.findViewById(2131361844);
        this.mDone.setOnClickListener(this.mDoneClickListener);
        this.initActivityState(savedInstanceState, this.getIntent());
        try {
            this.mSlideshowModel = SlideshowModel.createFromMessageUri((Context)this, this.mUri);
            this.mSlideshowModel.registerModelChangedObserver(this.mModelChangedObserver);
            this.mSlideshowEditor = new SlideshowEditor((Context)this, this.mSlideshowModel);
            this.mPresenter = (SlideshowPresenter)PresenterFactory.getPresenter("SlideshowPresenter", (Context)this, this.mSlideView, this.mSlideshowModel);
            if (this.mPosition >= this.mSlideshowModel.size()) {
                this.mPosition = Math.max(0, this.mSlideshowModel.size() - 1);
            } else if (this.mPosition < 0) {
                this.mPosition = 0;
            }
            this.showCurrentSlide();
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)"Create SlideshowModel failed!", (Throwable)e);
            this.finish();
            return;
        }
    }

    private void initActivityState(Bundle savedInstanceState, Intent intent) {
        if (savedInstanceState != null) {
            this.mUri = (Uri)savedInstanceState.getParcelable(MESSAGE_URI);
            this.mPosition = savedInstanceState.getInt(SLIDE_INDEX, 0);
        } else {
            this.mUri = intent.getData();
            this.mPosition = intent.getIntExtra(SLIDE_INDEX, 0);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(SLIDE_INDEX, this.mPosition);
        outState.putParcelable(MESSAGE_URI, (Parcelable)this.mUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPause() {
        super.onPause();
        SlideEditorActivity slideEditorActivity = this;
        synchronized (slideEditorActivity) {
            if (this.mDirty) {
                try {
                    PduBody pb = this.mSlideshowModel.toPduBody();
                    PduPersister.getPduPersister((Context)this).updateParts(this.mUri, pb);
                    this.mSlideshowModel.sync(pb);
                }
                catch (MmsException e) {
                    Log.e((String)TAG, (String)("Cannot update the message: " + this.mUri), (Throwable)e);
                }
            }
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mSlideshowModel != null) {
            this.mSlideshowModel.unregisterModelChangedObserver(this.mModelChangedObserver);
        }
    }

    private void previewSlideshow() {
        MessageUtils.viewMmsMessageAttachment((Context)this, this.mUri, this.mSlideshowModel);
    }

    private void updateTitle() {
        this.setTitle(this.getString(2131165231, new Object[]{this.mPosition + 1, this.mSlideshowModel.size()}));
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        if (this.isFinishing()) {
            return false;
        }
        menu.clear();
        SlideModel slide = this.mSlideshowModel.get(this.mPosition);
        if (slide == null) {
            return false;
        }
        menu.add(0, 11, 0, 2131165287).setIcon(17301951);
        if (slide.hasText() && !TextUtils.isEmpty((CharSequence)slide.getText().getText())) {
            menu.add(0, 0, 0, 2131165232).setIcon(2130837567);
        }
        if (slide.hasImage()) {
            menu.add(0, 3, 0, 2131165234).setIcon(2130837565);
        } else if (!slide.hasVideo()) {
            menu.add(0, 1, 0, 2131165233).setIcon(2130837564);
            menu.add(0, 2, 0, 2131165396).setIcon(2130837564);
        }
        if (slide.hasAudio()) {
            menu.add(0, 5, 0, 2131165236).setIcon(2130837566);
        } else if (!slide.hasVideo()) {
            if (MmsConfig.getAllowAttachAudio()) {
                SubMenu subMenu = menu.addSubMenu(0, 13, 0, 2131165235).setIcon(2130837552);
                subMenu.add(0, 4, 0, 2131165399);
                subMenu.add(0, 12, 0, 2131165400);
            } else {
                menu.add(0, 12, 0, 2131165400).setIcon(2130837552);
            }
        }
        if (slide.hasVideo()) {
            menu.add(0, 8, 0, 2131165238).setIcon(2130837568);
        } else if (!slide.hasAudio() && !slide.hasImage()) {
            menu.add(0, 6, 0, 2131165237).setIcon(2130837563);
        }
        menu.add(0, 7, 0, 2131165228).setIcon(2130837551);
        String duration = this.getResources().getString(2131165289);
        menu.add(0, 10, 0, (CharSequence)duration.replace("%s", String.valueOf(slide.getDuration() / 1000))).setIcon(2130837557);
        int resId = this.mSlideshowModel.getLayout().getLayoutType() == 1 ? 2131165292 : 2131165293;
        menu.add(0, 9, 0, resId).setIcon(2130837564);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 11: {
                this.previewSlideshow();
                break;
            }
            case 0: {
                SlideModel slide = this.mSlideshowModel.get(this.mPosition);
                if (slide == null) break;
                slide.removeText();
                break;
            }
            case 1: {
                Intent intent = new Intent("android.intent.action.GET_CONTENT", null);
                intent.setType("image/*");
                this.startActivityForResult(intent, 1);
                break;
            }
            case 2: {
                Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
                this.startActivityForResult(intent, 2);
                break;
            }
            case 3: {
                this.mSlideshowEditor.removeImage(this.mPosition);
                this.setReplaceButtonText(2131165233);
                break;
            }
            case 4: {
                MessageUtils.selectAudio((Context)this, 3);
                break;
            }
            case 12: {
                MessageUtils.recordSound((Context)this, 4);
                break;
            }
            case 5: {
                this.mSlideshowEditor.removeAudio(this.mPosition);
                break;
            }
            case 6: {
                Intent intent = new Intent("android.intent.action.GET_CONTENT");
                intent.setType("video/*");
                this.startActivityForResult(intent, 5);
                break;
            }
            case 8: {
                this.mSlideshowEditor.removeVideo(this.mPosition);
                break;
            }
            case 7: {
                ++this.mPosition;
                if (this.mSlideshowEditor.addNewSlide(this.mPosition)) {
                    this.showCurrentSlide();
                    break;
                }
                --this.mPosition;
                Toast.makeText((Context)this, (int)2131165274, (int)0).show();
                break;
            }
            case 9: {
                this.showLayoutSelectorDialog();
                break;
            }
            case 10: {
                this.showDurationDialog();
            }
        }
        return true;
    }

    private void setReplaceButtonText(int text) {
        this.mReplaceImage.setText(text);
    }

    private void showDurationDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setIcon(2130837572);
        String title = this.getResources().getString(2131165290);
        builder.setTitle((CharSequence)(title + (this.mPosition + 1) + "/" + this.mSlideshowModel.size()));
        builder.setItems(2131034114, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (which >= 0 && which < 10) {
                    SlideEditorActivity.this.mSlideshowEditor.changeDuration(SlideEditorActivity.this.mPosition, (which + 1) * 1000);
                } else {
                    Intent intent = new Intent((Context)SlideEditorActivity.this, EditSlideDurationActivity.class);
                    intent.putExtra(SlideEditorActivity.SLIDE_INDEX, SlideEditorActivity.this.mPosition);
                    intent.putExtra("slide_total", SlideEditorActivity.this.mSlideshowModel.size());
                    intent.putExtra("dur", SlideEditorActivity.this.mSlideshowModel.get(SlideEditorActivity.this.mPosition).getDuration() / 1000);
                    SlideEditorActivity.this.startActivityForResult(intent, 6);
                }
                dialog.dismiss();
            }
        });
        builder.show();
    }

    private void showLayoutSelectorDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setIcon(2130837573);
        String title = this.getResources().getString(2131165291);
        builder.setTitle((CharSequence)(title + (this.mPosition + 1) + "/" + this.mSlideshowModel.size()));
        LayoutSelectorAdapter adapter = new LayoutSelectorAdapter((Context)this);
        builder.setAdapter((ListAdapter)adapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                switch (which) {
                    case 0: {
                        SlideEditorActivity.this.mSlideshowEditor.changeLayout(1);
                        break;
                    }
                    case 1: {
                        SlideEditorActivity.this.mSlideshowEditor.changeLayout(0);
                    }
                }
                dialog.dismiss();
            }
        });
        builder.show();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode != -1) {
            return;
        }
        switch (requestCode) {
            case 0: {
                this.mSlideshowEditor.changeText(this.mPosition, data.getAction());
                break;
            }
            case 2: {
                Bitmap bitmap = (Bitmap)data.getParcelableExtra("data");
                if (bitmap == null) {
                    Toast.makeText((Context)this, (CharSequence)this.getResourcesString(2131165260, this.getPictureString()), (int)0).show();
                    return;
                }
                try {
                    this.mSlideshowEditor.changeImage(this.mPosition, MessageUtils.saveBitmapAsPart((Context)this, this.mUri, bitmap));
                    this.setReplaceButtonText(2131165288);
                }
                catch (MmsException e) {
                    Log.e((String)TAG, (String)"add image failed", (Throwable)e);
                    this.notifyUser("add picture failed");
                    Toast.makeText((Context)this, (CharSequence)this.getResourcesString(2131165260, this.getPictureString()), (int)0).show();
                }
                catch (UnsupportContentTypeException e) {
                    MessageUtils.showErrorDialog((Context)this, this.getResourcesString(2131165256, this.getPictureString()), this.getResourcesString(2131165257, this.getPictureString()));
                }
                catch (ResolutionException e) {
                    MessageUtils.resizeImageAsync((Context)this, data.getData(), new Handler(), this.mResizeImageCallback, false);
                }
                catch (ExceedMessageSizeException e) {
                    MessageUtils.resizeImageAsync((Context)this, data.getData(), new Handler(), this.mResizeImageCallback, false);
                }
                break;
            }
            case 1: {
                try {
                    this.mSlideshowEditor.changeImage(this.mPosition, data.getData());
                    this.setReplaceButtonText(2131165288);
                }
                catch (MmsException e) {
                    Log.e((String)TAG, (String)"add image failed", (Throwable)e);
                    this.notifyUser("add picture failed");
                    Toast.makeText((Context)this, (CharSequence)this.getResourcesString(2131165260, this.getPictureString()), (int)0).show();
                }
                catch (UnsupportContentTypeException e) {
                    MessageUtils.showErrorDialog((Context)this, this.getResourcesString(2131165256, this.getPictureString()), this.getResourcesString(2131165257, this.getPictureString()));
                }
                catch (ResolutionException e) {
                    MessageUtils.resizeImageAsync((Context)this, data.getData(), new Handler(), this.mResizeImageCallback, false);
                }
                catch (ExceedMessageSizeException e) {
                    MessageUtils.resizeImageAsync((Context)this, data.getData(), new Handler(), this.mResizeImageCallback, false);
                }
                break;
            }
            case 3: 
            case 4: {
                Uri uri;
                if (requestCode == 3) {
                    uri = (Uri)data.getParcelableExtra("android.intent.extra.ringtone.PICKED_URI");
                    if (Settings.System.DEFAULT_RINGTONE_URI.equals((Object)uri)) {
                        return;
                    }
                } else {
                    uri = data.getData();
                }
                try {
                    this.mSlideshowEditor.changeAudio(this.mPosition, uri);
                }
                catch (MmsException e) {
                    Log.e((String)TAG, (String)"add audio failed", (Throwable)e);
                    this.notifyUser("add music failed");
                    Toast.makeText((Context)this, (CharSequence)this.getResourcesString(2131165260, this.getAudioString()), (int)0).show();
                }
                catch (UnsupportContentTypeException e) {
                    MessageUtils.showErrorDialog((Context)this, this.getResourcesString(2131165256, this.getAudioString()), this.getResourcesString(2131165257, this.getAudioString()));
                }
                catch (ExceedMessageSizeException e) {
                    MessageUtils.showErrorDialog((Context)this, this.getResourcesString(2131165258), this.getResourcesString(2131165260, this.getAudioString()));
                }
                break;
            }
            case 5: {
                try {
                    this.mSlideshowEditor.changeVideo(this.mPosition, data.getData());
                }
                catch (MmsException e) {
                    Log.e((String)TAG, (String)"add video failed", (Throwable)e);
                    this.notifyUser("add video failed");
                    Toast.makeText((Context)this, (CharSequence)this.getResourcesString(2131165260, this.getVideoString()), (int)0).show();
                }
                catch (UnsupportContentTypeException e) {
                    MessageUtils.showErrorDialog((Context)this, this.getResourcesString(2131165256, this.getVideoString()), this.getResourcesString(2131165257, this.getVideoString()));
                }
                catch (ExceedMessageSizeException e) {
                    MessageUtils.showErrorDialog((Context)this, this.getResourcesString(2131165258), this.getResourcesString(2131165260, this.getVideoString()));
                }
                break;
            }
            case 6: {
                this.mSlideshowEditor.changeDuration(this.mPosition, Integer.valueOf(data.getAction()) * 1000);
            }
        }
    }

    private String getResourcesString(int id2, String mediaName) {
        Resources r = this.getResources();
        return r.getString(id2, new Object[]{mediaName});
    }

    private String getResourcesString(int id2) {
        Resources r = this.getResources();
        return r.getString(id2);
    }

    private String getAudioString() {
        return this.getResourcesString(2131165415);
    }

    private String getPictureString() {
        return this.getResourcesString(2131165416);
    }

    private String getVideoString() {
        return this.getResourcesString(2131165417);
    }

    private void notifyUser(String message) {
    }

    private void showCurrentSlide() {
        this.mPresenter.setLocation(this.mPosition);
        this.mPresenter.present();
        this.updateTitle();
        if (this.mSlideshowModel.get(this.mPosition).hasImage()) {
            this.setReplaceButtonText(2131165288);
        } else {
            this.setReplaceButtonText(2131165233);
        }
    }
}

