/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.app.ListActivity;
import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.SearchRecentSuggestions;
import android.provider.Telephony;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.style.StyleSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CursorAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.android.mms.MmsApp;
import com.android.mms.data.Contact;
import com.android.mms.ui.ComposeMessageActivity;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SearchActivity
extends ListActivity {
    private AsyncQueryHandler mQueryHandler;
    private HashMap<Contact, TextView> mContactMap = new HashMap();
    Contact.UpdateListener mContactListener = new Contact.UpdateListener(){

        public void onUpdate(Contact updated) {
            TextView tv = (TextView)SearchActivity.this.mContactMap.get(updated);
            if (tv != null) {
                tv.setText((CharSequence)updated.getNameAndNumber());
            }
        }
    };

    public void onStop() {
        super.onStop();
        Contact.removeListener(this.mContactListener);
    }

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.setContentView(2130903064);
        String searchStringParameter = this.getIntent().getStringExtra("query");
        if (searchStringParameter == null) {
            searchStringParameter = this.getIntent().getStringExtra("intent_extra_data_key");
        }
        final String searchString = searchStringParameter != null ? searchStringParameter.trim() : searchStringParameter;
        ContentResolver cr = this.getContentResolver();
        searchStringParameter = searchStringParameter.trim();
        final ListView listView = this.getListView();
        listView.setItemsCanFocus(true);
        listView.setFocusable(true);
        listView.setClickable(true);
        this.setTitle("");
        Contact.addListener(this.mContactListener);
        this.mQueryHandler = new AsyncQueryHandler(cr){

            protected void onQueryComplete(int token, Object cookie, Cursor c) {
                SearchRecentSuggestions recent;
                if (c == null) {
                    return;
                }
                final int threadIdPos = c.getColumnIndex("thread_id");
                final int addressPos = c.getColumnIndex("address");
                final int bodyPos = c.getColumnIndex("body");
                final int rowidPos = c.getColumnIndex("_id");
                int cursorCount = c.getCount();
                SearchActivity.this.setTitle(SearchActivity.this.getResources().getQuantityString(2131230721, cursorCount, new Object[]{cursorCount, searchString}));
                SearchActivity.this.setListAdapter((ListAdapter)new CursorAdapter((Context)SearchActivity.this, c, false){

                    public void bindView(View view, Context context, Cursor cursor) {
                        TextView title = (TextView)view.findViewById(2131361831);
                        TextViewSnippet snippet = (TextViewSnippet)view.findViewById(2131361881);
                        String address = cursor.getString(addressPos);
                        Contact contact = address != null ? Contact.get(address, false) : null;
                        String titleString = contact != null ? contact.getNameAndNumber() : "";
                        title.setText((CharSequence)titleString);
                        snippet.setText(cursor.getString(bodyPos), searchString);
                        final long threadId = cursor.getLong(threadIdPos);
                        final long rowid = cursor.getLong(rowidPos);
                        view.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                Intent onClickIntent = new Intent((Context)SearchActivity.this, ComposeMessageActivity.class);
                                onClickIntent.putExtra("thread_id", threadId);
                                onClickIntent.putExtra("highlight", searchString);
                                onClickIntent.putExtra("select_id", rowid);
                                SearchActivity.this.startActivity(onClickIntent);
                            }
                        });
                    }

                    public View newView(Context context, Cursor cursor, ViewGroup parent) {
                        LayoutInflater inflater = LayoutInflater.from((Context)context);
                        View v = inflater.inflate(2130903065, parent, false);
                        return v;
                    }
                });
                listView.setFocusable(true);
                listView.setFocusableInTouchMode(true);
                listView.requestFocus();
                if (cursorCount > 0 && (recent = ((MmsApp)SearchActivity.this.getApplication()).getRecentSuggestions()) != null) {
                    recent.saveRecentQuery(searchString, SearchActivity.this.getString(2131165460, new Object[]{cursorCount, searchString}));
                }
            }
        };
        Uri uri = Telephony.MmsSms.SEARCH_URI.buildUpon().appendQueryParameter("pattern", searchString).build();
        this.mQueryHandler.startQuery(0, null, uri, null, null, null, null);
    }

    public static class TextViewSnippet
    extends TextView {
        private static String sEllipsis = "\u2026";
        private static int sTypefaceHighlight = 1;
        private String mFullText;
        private String mTargetString;
        private Pattern mPattern;

        public TextViewSnippet(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public TextViewSnippet(Context context) {
            super(context);
        }

        public TextViewSnippet(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            String fullTextLower = this.mFullText.toLowerCase();
            String targetStringLower = this.mTargetString.toLowerCase();
            int startPos = 0;
            int searchStringLength = targetStringLower.length();
            int bodyLength = fullTextLower.length();
            Matcher m = this.mPattern.matcher(this.mFullText);
            if (m.find(0)) {
                startPos = m.start();
            }
            TextPaint tp = this.getPaint();
            float searchStringWidth = tp.measureText(this.mTargetString);
            float textFieldWidth = this.getWidth();
            String snippetString = null;
            if (searchStringWidth > textFieldWidth) {
                snippetString = this.mFullText.substring(startPos, startPos + searchStringLength);
            } else {
                float ellipsisWidth = tp.measureText(sEllipsis);
                textFieldWidth -= 2.0f * ellipsisWidth;
                int offset = -1;
                int start = -1;
                int end = -1;
                while (true) {
                    String candidate;
                    int newstart = Math.max(0, startPos - ++offset);
                    int newend = Math.min(bodyLength, startPos + searchStringLength + offset);
                    if (newstart == start && newend == end || tp.measureText(candidate = this.mFullText.substring(start = newstart, end = newend)) > textFieldWidth) break;
                    snippetString = String.format("%s%s%s", start == 0 ? "" : sEllipsis, candidate, end == bodyLength ? "" : sEllipsis);
                }
            }
            SpannableString spannable = new SpannableString((CharSequence)snippetString);
            int start = 0;
            m = this.mPattern.matcher(snippetString);
            while (m.find(start)) {
                spannable.setSpan((Object)new StyleSpan(sTypefaceHighlight), m.start(), m.end(), 0);
                start = m.end();
            }
            this.setText((CharSequence)spannable);
            super.onLayout(changed, left, top, right, bottom);
        }

        public void setText(String fullText, String target) {
            String patternString = "\\b" + Pattern.quote(target);
            this.mPattern = Pattern.compile(patternString, 2);
            this.mFullText = fullText;
            this.mTargetString = target;
            this.requestLayout();
        }
    }
}

