/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.content.Context;
import android.os.Handler;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.method.NumberKeyListener;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.mms.ui.NumberPickerButton;

public class NumberPicker
extends LinearLayout {
    public static final Formatter TWO_DIGIT_FORMATTER = new Formatter(){
        final StringBuilder mBuilder = new StringBuilder();
        final java.util.Formatter mFmt = new java.util.Formatter(this.mBuilder);
        final Object[] mArgs = new Object[1];

        public String toString(int value) {
            this.mArgs[0] = value;
            this.mBuilder.delete(0, this.mBuilder.length());
            this.mFmt.format("%02d", this.mArgs);
            return this.mFmt.toString();
        }
    };
    private final Handler mHandler;
    private final Runnable mRunnable = new Runnable(){

        public void run() {
            if (NumberPicker.this.mIncrement) {
                NumberPicker.this.changeCurrent(NumberPicker.this.mCurrent + 1);
                NumberPicker.this.mHandler.postDelayed((Runnable)this, NumberPicker.this.mSpeed);
            } else if (NumberPicker.this.mDecrement) {
                NumberPicker.this.changeCurrent(NumberPicker.this.mCurrent - 1);
                NumberPicker.this.mHandler.postDelayed((Runnable)this, NumberPicker.this.mSpeed);
            }
        }
    };
    private final EditText mText;
    private final InputFilter mNumberInputFilter;
    private String[] mDisplayedValues;
    private int mStart;
    private int mEnd;
    private int mCurrent;
    private int mPrevious;
    private OnChangedListener mListener;
    private Formatter mFormatter;
    private long mSpeed = 300L;
    private boolean mIncrement;
    private boolean mDecrement;
    private static final char[] DIGIT_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private NumberPickerButton mIncrementButton;
    private NumberPickerButton mDecrementButton;

    public NumberPicker(Context context) {
        this(context, null);
    }

    public NumberPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(1);
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        inflater.inflate(2130903058, (ViewGroup)this, true);
        this.mHandler = new Handler();
        View.OnClickListener clickListener = new View.OnClickListener(){

            public void onClick(View v) {
                NumberPicker.this.validateInput((View)NumberPicker.this.mText);
                if (!NumberPicker.this.mText.hasFocus()) {
                    NumberPicker.this.mText.requestFocus();
                }
                if (2131361869 == v.getId()) {
                    NumberPicker.this.changeCurrent(NumberPicker.this.mCurrent + 1);
                } else if (2131361871 == v.getId()) {
                    NumberPicker.this.changeCurrent(NumberPicker.this.mCurrent - 1);
                }
            }
        };
        View.OnFocusChangeListener focusListener = new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    NumberPicker.this.validateInput(v);
                }
            }
        };
        View.OnLongClickListener longClickListener = new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                NumberPicker.this.mText.clearFocus();
                if (2131361869 == v.getId()) {
                    NumberPicker.this.mIncrement = true;
                    NumberPicker.this.mHandler.post(NumberPicker.this.mRunnable);
                } else if (2131361871 == v.getId()) {
                    NumberPicker.this.mDecrement = true;
                    NumberPicker.this.mHandler.post(NumberPicker.this.mRunnable);
                }
                return true;
            }
        };
        NumberPickerInputFilter inputFilter = new NumberPickerInputFilter();
        this.mNumberInputFilter = new NumberRangeKeyListener();
        this.mIncrementButton = (NumberPickerButton)this.findViewById(2131361869);
        this.mIncrementButton.setOnClickListener(clickListener);
        this.mIncrementButton.setOnLongClickListener(longClickListener);
        this.mIncrementButton.setNumberPicker(this);
        this.mDecrementButton = (NumberPickerButton)this.findViewById(2131361871);
        this.mDecrementButton.setOnClickListener(clickListener);
        this.mDecrementButton.setOnLongClickListener(longClickListener);
        this.mDecrementButton.setNumberPicker(this);
        this.mText = (EditText)this.findViewById(2131361870);
        this.mText.setOnFocusChangeListener(focusListener);
        this.mText.setFilters(new InputFilter[]{inputFilter});
        this.mText.setRawInputType(2);
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mIncrementButton.setEnabled(enabled);
        this.mDecrementButton.setEnabled(enabled);
        this.mText.setEnabled(enabled);
    }

    public void setOnChangeListener(OnChangedListener listener) {
        this.mListener = listener;
    }

    public void setFormatter(Formatter formatter) {
        this.mFormatter = formatter;
    }

    public void setRange(int start, int end) {
        this.setRange(start, end, null);
    }

    public void setRange(int start, int end, String[] displayedValues) {
        this.mDisplayedValues = displayedValues;
        this.mStart = start;
        this.mEnd = end;
        this.mCurrent = start;
        this.updateView();
    }

    public void setCurrent(int current) {
        if (current < this.mStart || current > this.mEnd) {
            throw new IllegalArgumentException("current should be >= start and <= end");
        }
        this.mCurrent = current;
        this.updateView();
    }

    public void setSpeed(long speed) {
        this.mSpeed = speed;
    }

    private String formatNumber(int value) {
        return this.mFormatter != null ? this.mFormatter.toString(value) : String.valueOf(value);
    }

    protected void changeCurrent(int current) {
        if (current > this.mEnd) {
            current = this.mStart;
        } else if (current < this.mStart) {
            current = this.mEnd;
        }
        this.mPrevious = this.mCurrent;
        this.mCurrent = current;
        this.notifyChange();
        this.updateView();
    }

    private void notifyChange() {
        if (this.mListener != null) {
            this.mListener.onChanged(this, this.mPrevious, this.mCurrent);
        }
    }

    private void updateView() {
        if (this.mDisplayedValues == null) {
            this.mText.setText((CharSequence)this.formatNumber(this.mCurrent));
        } else {
            this.mText.setText((CharSequence)this.mDisplayedValues[this.mCurrent - this.mStart]);
        }
        this.mText.setSelection(this.mText.getText().length());
    }

    private void validateCurrentView(CharSequence str) {
        int val = this.getSelectedPos(((Object)str).toString());
        if (val >= this.mStart && val <= this.mEnd && this.mCurrent != val) {
            this.mPrevious = this.mCurrent;
            this.mCurrent = val;
            this.notifyChange();
        }
        this.updateView();
    }

    private void validateInput(View v) {
        String str = String.valueOf(((TextView)v).getText());
        if ("".equals(str)) {
            this.updateView();
        } else {
            this.validateCurrentView(str);
        }
    }

    public void cancelIncrement() {
        this.mIncrement = false;
    }

    public void cancelDecrement() {
        this.mDecrement = false;
    }

    private int getSelectedPos(String str) {
        if (this.mDisplayedValues == null) {
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
            }
        } else {
            for (int i = 0; i < this.mDisplayedValues.length; ++i) {
                str = str.toLowerCase();
                if (!this.mDisplayedValues[i].toLowerCase().startsWith(str)) continue;
                return this.mStart + i;
            }
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.mStart;
    }

    public int getCurrent() {
        return this.mCurrent;
    }

    protected int getEndRange() {
        return this.mEnd;
    }

    protected int getBeginRange() {
        return this.mStart;
    }

    private class NumberRangeKeyListener
    extends NumberKeyListener {
        private NumberRangeKeyListener() {
        }

        public int getInputType() {
            return 2;
        }

        protected char[] getAcceptedChars() {
            return DIGIT_CHARACTERS;
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            String result;
            CharSequence filtered = super.filter(source, start, end, dest, dstart, dend);
            if (filtered == null) {
                filtered = source.subSequence(start, end);
            }
            if ("".equals(result = String.valueOf(dest.subSequence(0, dstart)) + filtered + dest.subSequence(dend, dest.length()))) {
                return result;
            }
            int val = NumberPicker.this.getSelectedPos(result);
            if (val > NumberPicker.this.mEnd) {
                return "";
            }
            return filtered;
        }
    }

    private class NumberPickerInputFilter
    implements InputFilter {
        private NumberPickerInputFilter() {
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (NumberPicker.this.mDisplayedValues == null) {
                return NumberPicker.this.mNumberInputFilter.filter(source, start, end, dest, dstart, dend);
            }
            String filtered = String.valueOf(source.subSequence(start, end));
            String result = String.valueOf(dest.subSequence(0, dstart)) + filtered + dest.subSequence(dend, dest.length());
            String str = String.valueOf(result).toLowerCase();
            for (String val : NumberPicker.this.mDisplayedValues) {
                if (!(val = val.toLowerCase()).startsWith(str)) continue;
                return filtered;
            }
            return "";
        }
    }

    public static interface Formatter {
        public String toString(int var1);
    }

    public static interface OnChangedListener {
        public void onChanged(NumberPicker var1, int var2, int var3);
    }
}

