/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import com.android.mms.model.AudioModel;
import com.android.mms.model.ImageModel;
import com.android.mms.model.Model;
import com.android.mms.model.SlideModel;
import com.android.mms.model.SlideshowModel;
import com.android.mms.model.VideoModel;
import com.android.mms.ui.Presenter;
import com.android.mms.ui.SlideViewInterface;
import com.android.mms.ui.ViewInterface;

public class MmsThumbnailPresenter
extends Presenter {
    private static final String TAG = "MmsThumbnailPresenter";

    public MmsThumbnailPresenter(Context context, ViewInterface view, Model model) {
        super(context, view, model);
    }

    public void present() {
        SlideModel slide = ((SlideshowModel)this.mModel).get(0);
        if (slide != null) {
            this.presentFirstSlide((SlideViewInterface)this.mView, slide);
        }
    }

    private void presentFirstSlide(SlideViewInterface view, SlideModel slide) {
        view.reset();
        if (slide.hasImage()) {
            this.presentImageThumbnail(view, slide.getImage());
        } else if (slide.hasVideo()) {
            this.presentVideoThumbnail(view, slide.getVideo());
        } else if (slide.hasAudio()) {
            this.presentAudioThumbnail(view, slide.getAudio());
        }
    }

    private void presentVideoThumbnail(SlideViewInterface view, VideoModel video) {
        if (video.isDrmProtected()) {
            this.showDrmIcon(view, video.getSrc());
        } else {
            view.setVideo(video.getSrc(), video.getUri());
        }
    }

    private void presentImageThumbnail(SlideViewInterface view, ImageModel image) {
        if (image.isDrmProtected()) {
            this.showDrmIcon(view, image.getSrc());
        } else {
            view.setImage(image.getSrc(), image.getBitmap());
        }
    }

    protected void presentAudioThumbnail(SlideViewInterface view, AudioModel audio) {
        if (audio.isDrmProtected()) {
            this.showDrmIcon(view, audio.getSrc());
        } else {
            view.setAudio(audio.getUri(), audio.getSrc(), audio.getExtras());
        }
    }

    private void showDrmIcon(SlideViewInterface view, String name) {
        try {
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)2130837571);
            view.setImage(name, bitmap);
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)"showDrmIcon: out of memory: ", (Throwable)e);
        }
    }

    public void onModelChanged(Model model, boolean dataChanged) {
    }
}

