/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.os.Bundle;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceCategory;
import android.preference.PreferenceManager;
import android.preference.PreferenceScreen;
import android.provider.SearchRecentSuggestions;
import android.view.Menu;
import android.view.MenuItem;
import com.android.mms.MmsApp;
import com.android.mms.MmsConfig;
import com.android.mms.ui.ManageSimMessages;
import com.android.mms.ui.NumberPickerDialog;
import com.android.mms.util.Recycler;

public class MessagingPreferenceActivity
extends PreferenceActivity {
    public static final String MMS_DELIVERY_REPORT_MODE = "pref_key_mms_delivery_reports";
    public static final String EXPIRY_TIME = "pref_key_mms_expiry";
    public static final String PRIORITY = "pref_key_mms_priority";
    public static final String READ_REPORT_MODE = "pref_key_mms_read_reports";
    public static final String SMS_DELIVERY_REPORT_MODE = "pref_key_sms_delivery_reports";
    public static final String NOTIFICATION_ENABLED = "pref_key_enable_notifications";
    public static final String NOTIFICATION_VIBRATE = "pref_key_vibrate";
    public static final String NOTIFICATION_VIBRATE_WHEN = "pref_key_vibrateWhen";
    public static final String NOTIFICATION_RINGTONE = "pref_key_ringtone";
    public static final String AUTO_RETRIEVAL = "pref_key_mms_auto_retrieval";
    public static final String RETRIEVAL_DURING_ROAMING = "pref_key_mms_retrieval_during_roaming";
    public static final String AUTO_DELETE = "pref_key_auto_delete";
    private static final int MENU_RESTORE_DEFAULTS = 1;
    private Preference mSmsLimitPref;
    private Preference mSmsDeliveryReportPref;
    private Preference mMmsLimitPref;
    private Preference mMmsDeliveryReportPref;
    private Preference mMmsReadReportPref;
    private Preference mManageSimPref;
    private Preference mClearHistoryPref;
    private ListPreference mVibrateWhenPref;
    private Recycler mSmsRecycler;
    private Recycler mMmsRecycler;
    private static final int CONFIRM_CLEAR_SEARCH_HISTORY_DIALOG = 3;
    NumberPickerDialog.OnNumberSetListener mSmsLimitListener = new NumberPickerDialog.OnNumberSetListener(){

        public void onNumberSet(int limit) {
            MessagingPreferenceActivity.this.mSmsRecycler.setMessageLimit((Context)MessagingPreferenceActivity.this, limit);
            MessagingPreferenceActivity.this.setSmsDisplayLimit();
        }
    };
    NumberPickerDialog.OnNumberSetListener mMmsLimitListener = new NumberPickerDialog.OnNumberSetListener(){

        public void onNumberSet(int limit) {
            MessagingPreferenceActivity.this.mMmsRecycler.setMessageLimit((Context)MessagingPreferenceActivity.this, limit);
            MessagingPreferenceActivity.this.setMmsDisplayLimit();
        }
    };

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.addPreferencesFromResource(2130968577);
        this.setMessagePreferences();
    }

    private void setMessagePreferences() {
        boolean SMSDeliveryReport;
        this.mManageSimPref = this.findPreference("pref_key_manage_sim_messages");
        this.mSmsLimitPref = this.findPreference("pref_key_sms_delete_limit");
        this.mSmsDeliveryReportPref = this.findPreference(SMS_DELIVERY_REPORT_MODE);
        this.mMmsDeliveryReportPref = this.findPreference(MMS_DELIVERY_REPORT_MODE);
        this.mMmsReadReportPref = this.findPreference(READ_REPORT_MODE);
        this.mMmsLimitPref = this.findPreference("pref_key_mms_delete_limit");
        this.mClearHistoryPref = this.findPreference("pref_key_mms_clear_history");
        this.mVibrateWhenPref = (ListPreference)this.findPreference(NOTIFICATION_VIBRATE_WHEN);
        if (!MmsApp.getApplication().getTelephonyManager().hasIccCard()) {
            PreferenceCategory smsCategory = (PreferenceCategory)this.findPreference("pref_key_sms_settings");
            smsCategory.removePreference(this.mManageSimPref);
        }
        if (!(SMSDeliveryReport = Resources.getSystem().getBoolean(17629207))) {
            PreferenceCategory smsCategory = (PreferenceCategory)this.findPreference("pref_key_sms_settings");
            smsCategory.removePreference(this.mSmsDeliveryReportPref);
            if (!MmsApp.getApplication().getTelephonyManager().hasIccCard()) {
                this.getPreferenceScreen().removePreference((Preference)smsCategory);
            }
        }
        if (!MmsConfig.getMmsEnabled()) {
            PreferenceCategory mmsOptions = (PreferenceCategory)this.findPreference("pref_key_mms_settings");
            this.getPreferenceScreen().removePreference((Preference)mmsOptions);
            PreferenceCategory storageOptions = (PreferenceCategory)this.findPreference("pref_key_storage_settings");
            storageOptions.removePreference(this.findPreference("pref_key_mms_delete_limit"));
        } else {
            PreferenceCategory mmsOptions;
            boolean MMSDeliveryReport = Resources.getSystem().getBoolean(17629208);
            boolean MMSReadReport = Resources.getSystem().getBoolean(17629209);
            if (!MMSDeliveryReport) {
                mmsOptions = (PreferenceCategory)this.findPreference("pref_key_mms_settings");
                mmsOptions.removePreference(this.mMmsDeliveryReportPref);
            }
            if (!MMSReadReport) {
                mmsOptions = (PreferenceCategory)this.findPreference("pref_key_mms_settings");
                mmsOptions.removePreference(this.mMmsReadReportPref);
            }
        }
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this);
        if (!sharedPreferences.contains(NOTIFICATION_VIBRATE_WHEN) && sharedPreferences.contains(NOTIFICATION_VIBRATE)) {
            int stringId = sharedPreferences.getBoolean(NOTIFICATION_VIBRATE, false) ? 2131165334 : 2131165335;
            this.mVibrateWhenPref.setValue(this.getString(stringId));
        }
        this.mSmsRecycler = Recycler.getSmsRecycler();
        this.mMmsRecycler = Recycler.getMmsRecycler();
        this.setSmsDisplayLimit();
        this.setMmsDisplayLimit();
    }

    private void setSmsDisplayLimit() {
        this.mSmsLimitPref.setSummary((CharSequence)this.getString(2131165319, new Object[]{this.mSmsRecycler.getMessageLimit((Context)this)}));
    }

    private void setMmsDisplayLimit() {
        this.mMmsLimitPref.setSummary((CharSequence)this.getString(2131165319, new Object[]{this.mMmsRecycler.getMessageLimit((Context)this)}));
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        menu.clear();
        menu.add(0, 1, 0, 2131165309);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 1: {
                this.restoreDefaultPreferences();
                return true;
            }
        }
        return false;
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if (preference == this.mSmsLimitPref) {
            new NumberPickerDialog((Context)this, this.mSmsLimitListener, this.mSmsRecycler.getMessageLimit((Context)this), this.mSmsRecycler.getMessageMinLimit(), this.mSmsRecycler.getMessageMaxLimit(), 2131165325).show();
        } else if (preference == this.mMmsLimitPref) {
            new NumberPickerDialog((Context)this, this.mMmsLimitListener, this.mMmsRecycler.getMessageLimit((Context)this), this.mMmsRecycler.getMessageMinLimit(), this.mMmsRecycler.getMessageMaxLimit(), 2131165326).show();
        } else if (preference == this.mManageSimPref) {
            this.startActivity(new Intent((Context)this, ManageSimMessages.class));
        } else if (preference == this.mClearHistoryPref) {
            this.showDialog(3);
            return true;
        }
        return super.onPreferenceTreeClick(preferenceScreen, preference);
    }

    private void restoreDefaultPreferences() {
        PreferenceManager.getDefaultSharedPreferences((Context)this).edit().clear().apply();
        this.setPreferenceScreen(null);
        this.addPreferencesFromResource(2130968577);
        this.setMessagePreferences();
    }

    protected Dialog onCreateDialog(int id2) {
        switch (id2) {
            case 3: {
                return new AlertDialog.Builder((Context)this).setTitle(2131165461).setMessage(2131165462).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        SearchRecentSuggestions recent = ((MmsApp)MessagingPreferenceActivity.this.getApplication()).getRecentSuggestions();
                        if (recent != null) {
                            recent.clearHistory();
                        }
                        dialog.dismiss();
                    }
                }).setNegativeButton(0x1040000, null).setIcon(17301543).create();
            }
        }
        return super.onCreateDialog(id2);
    }
}

