/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.provider.Telephony;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.android.mms.transaction.MessagingNotification;
import com.android.mms.ui.MessageListAdapter;

public class ManageSimMessages
extends Activity
implements View.OnCreateContextMenuListener {
    private static final Uri ICC_URI = Uri.parse((String)"content://sms/icc");
    private static final String TAG = "ManageSimMessages";
    private static final int MENU_COPY_TO_PHONE_MEMORY = 0;
    private static final int MENU_DELETE_FROM_SIM = 1;
    private static final int MENU_VIEW = 2;
    private static final int OPTION_MENU_DELETE_ALL = 0;
    private static final int SHOW_LIST = 0;
    private static final int SHOW_EMPTY = 1;
    private static final int SHOW_BUSY = 2;
    private int mState;
    private ContentResolver mContentResolver;
    private Cursor mCursor = null;
    private ListView mSimList;
    private TextView mMessage;
    private MessageListAdapter mListAdapter = null;
    private AsyncQueryHandler mQueryHandler = null;
    public static final int SIM_FULL_NOTIFICATION_ID = 234;
    private final ContentObserver simChangeObserver = new ContentObserver(new Handler()){

        public void onChange(boolean selfUpdate) {
            ManageSimMessages.this.refreshMessageList();
        }
    };

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.requestWindowFeature(5);
        this.mContentResolver = this.getContentResolver();
        this.mQueryHandler = new QueryHandler(this.mContentResolver, this);
        this.setContentView(2130903066);
        this.mSimList = (ListView)this.findViewById(2131361882);
        this.mMessage = (TextView)this.findViewById(2131361883);
        this.init();
    }

    protected void onNewIntent(Intent intent) {
        this.setIntent(intent);
        this.init();
    }

    private void init() {
        MessagingNotification.cancelNotification(this.getApplicationContext(), 234);
        this.updateState(2);
        this.startQuery();
    }

    private void startQuery() {
        try {
            this.mQueryHandler.startQuery(0, null, ICC_URI, null, null, null, null);
        }
        catch (SQLiteException e) {
            SqliteWrapper.checkSQLiteException((Context)this, (SQLiteException)e);
        }
    }

    private void refreshMessageList() {
        this.updateState(2);
        if (this.mCursor != null) {
            this.stopManagingCursor(this.mCursor);
            this.mCursor.close();
        }
        this.startQuery();
    }

    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        menu.add(0, 0, 0, 2131165380);
        menu.add(0, 1, 0, 2131165381);
    }

    public boolean onContextItemSelected(MenuItem item) {
        AdapterView.AdapterContextMenuInfo info;
        try {
            info = (AdapterView.AdapterContextMenuInfo)item.getMenuInfo();
        }
        catch (ClassCastException exception) {
            Log.e((String)TAG, (String)"Bad menuInfo.", (Throwable)exception);
            return false;
        }
        final Cursor cursor = (Cursor)this.mListAdapter.getItem(info.position);
        switch (item.getItemId()) {
            case 0: {
                this.copyToPhoneMemory(cursor);
                return true;
            }
            case 1: {
                this.confirmDeleteDialog(new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        ManageSimMessages.this.updateState(2);
                        ManageSimMessages.this.deleteFromSim(cursor);
                        dialog.dismiss();
                    }
                }, 2131165350);
                return true;
            }
            case 2: {
                this.viewMessage(cursor);
                return true;
            }
        }
        return super.onContextItemSelected(item);
    }

    public void onResume() {
        super.onResume();
        this.registerSimChangeObserver();
    }

    public void onPause() {
        super.onPause();
        this.mContentResolver.unregisterContentObserver(this.simChangeObserver);
    }

    private void registerSimChangeObserver() {
        this.mContentResolver.registerContentObserver(ICC_URI, true, this.simChangeObserver);
    }

    private void copyToPhoneMemory(Cursor cursor) {
        String address = cursor.getString(cursor.getColumnIndexOrThrow("address"));
        String body = cursor.getString(cursor.getColumnIndexOrThrow("body"));
        Long date = cursor.getLong(cursor.getColumnIndexOrThrow("date"));
        try {
            if (this.isIncomingMessage(cursor)) {
                Telephony.Sms.Inbox.addMessage((ContentResolver)this.mContentResolver, (String)address, (String)body, null, (Long)date, (boolean)true);
            } else {
                Telephony.Sms.Sent.addMessage((ContentResolver)this.mContentResolver, (String)address, (String)body, null, (Long)date);
            }
        }
        catch (SQLiteException e) {
            SqliteWrapper.checkSQLiteException((Context)this, (SQLiteException)e);
        }
    }

    private boolean isIncomingMessage(Cursor cursor) {
        int messageStatus = cursor.getInt(cursor.getColumnIndexOrThrow("status"));
        return messageStatus == 1 || messageStatus == 3;
    }

    private void deleteFromSim(Cursor cursor) {
        String messageIndexString = cursor.getString(cursor.getColumnIndexOrThrow("index_on_icc"));
        Uri simUri = ICC_URI.buildUpon().appendPath(messageIndexString).build();
        SqliteWrapper.delete((Context)this, (ContentResolver)this.mContentResolver, (Uri)simUri, null, null);
    }

    private void deleteAllFromSim() {
        Cursor cursor = this.mListAdapter.getCursor();
        if (cursor != null && cursor.moveToFirst()) {
            int count = cursor.getCount();
            for (int i = 0; i < count; ++i) {
                this.deleteFromSim(cursor);
                cursor.moveToNext();
            }
        }
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        menu.clear();
        if (null != this.mCursor && this.mCursor.getCount() > 0 && this.mState == 0) {
            menu.add(0, 0, 0, 2131165376).setIcon(17301564);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 0: {
                this.confirmDeleteDialog(new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        ManageSimMessages.this.updateState(2);
                        ManageSimMessages.this.deleteAllFromSim();
                        dialog.dismiss();
                    }
                }, 2131165349);
            }
        }
        return true;
    }

    private void confirmDeleteDialog(DialogInterface.OnClickListener listener, int messageId) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle(2131165342);
        builder.setIcon(17301543);
        builder.setCancelable(true);
        builder.setPositiveButton(2131165301, listener);
        builder.setNegativeButton(2131165302, null);
        builder.setMessage(messageId);
        builder.show();
    }

    private void updateState(int state) {
        if (this.mState == state) {
            return;
        }
        this.mState = state;
        switch (state) {
            case 0: {
                this.mSimList.setVisibility(0);
                this.mMessage.setVisibility(8);
                this.setTitle(this.getString(2131165382));
                this.setProgressBarIndeterminateVisibility(false);
                break;
            }
            case 1: {
                this.mSimList.setVisibility(8);
                this.mMessage.setVisibility(0);
                this.setTitle(this.getString(2131165382));
                this.setProgressBarIndeterminateVisibility(false);
                break;
            }
            case 2: {
                this.mSimList.setVisibility(8);
                this.mMessage.setVisibility(8);
                this.setTitle(this.getString(2131165197));
                this.setProgressBarIndeterminateVisibility(true);
                break;
            }
            default: {
                Log.e((String)TAG, (String)"Invalid State");
            }
        }
    }

    private void viewMessage(Cursor cursor) {
    }

    private class QueryHandler
    extends AsyncQueryHandler {
        private final ManageSimMessages mParent;

        public QueryHandler(ContentResolver contentResolver, ManageSimMessages parent) {
            super(contentResolver);
            this.mParent = parent;
        }

        protected void onQueryComplete(int token, Object cookie, Cursor cursor) {
            ManageSimMessages.this.mCursor = cursor;
            if (ManageSimMessages.this.mCursor != null) {
                if (!ManageSimMessages.this.mCursor.moveToFirst()) {
                    ManageSimMessages.this.updateState(1);
                } else if (ManageSimMessages.this.mListAdapter == null) {
                    ManageSimMessages.this.mListAdapter = new MessageListAdapter((Context)this.mParent, ManageSimMessages.this.mCursor, ManageSimMessages.this.mSimList, false, null);
                    ManageSimMessages.this.mSimList.setAdapter((ListAdapter)ManageSimMessages.this.mListAdapter);
                    ManageSimMessages.this.mSimList.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this.mParent);
                    ManageSimMessages.this.updateState(0);
                } else {
                    ManageSimMessages.this.mListAdapter.changeCursor(ManageSimMessages.this.mCursor);
                    ManageSimMessages.this.updateState(0);
                }
                ManageSimMessages.this.startManagingCursor(ManageSimMessages.this.mCursor);
            } else {
                ManageSimMessages.this.updateState(1);
            }
        }
    }
}

