/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

public class EditSlideDurationActivity
extends Activity {
    public static final String SLIDE_INDEX = "slide_index";
    public static final String SLIDE_TOTAL = "slide_total";
    public static final String SLIDE_DUR = "dur";
    private TextView mLabel;
    private Button mDone;
    private EditText mDur;
    private int mCurSlide;
    private int mTotal;
    private Bundle mState;
    private static final String STATE = "state";
    private static final String TAG = "EditSlideDurationActivity";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private final View.OnKeyListener mOnKeyListener = new View.OnKeyListener(){

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (event.getAction() != 0) {
                return false;
            }
            switch (keyCode) {
                case 23: {
                    EditSlideDurationActivity.this.editDone();
                }
            }
            return false;
        }
    };
    private final View.OnClickListener mOnDoneClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            EditSlideDurationActivity.this.editDone();
        }
    };

    protected void onCreate(Bundle icicle) {
        int dur;
        super.onCreate(icicle);
        this.requestWindowFeature(1);
        this.setContentView(2130903051);
        if (icicle == null) {
            Intent intent = this.getIntent();
            this.mCurSlide = intent.getIntExtra(SLIDE_INDEX, 1);
            this.mTotal = intent.getIntExtra(SLIDE_TOTAL, 1);
            dur = intent.getIntExtra(SLIDE_DUR, 8);
        } else {
            this.mState = icicle.getBundle(STATE);
            this.mCurSlide = this.mState.getInt(SLIDE_INDEX, 1);
            this.mTotal = this.mState.getInt(SLIDE_TOTAL, 1);
            dur = this.mState.getInt(SLIDE_DUR, 8);
        }
        this.mLabel = (TextView)this.findViewById(2131361845);
        this.mLabel.setText((CharSequence)(this.getString(2131165290) + " " + (this.mCurSlide + 1) + "/" + this.mTotal));
        this.mDur = (EditText)this.findViewById(2131361846);
        this.mDur.setText((CharSequence)String.valueOf(dur));
        this.mDur.setOnKeyListener(this.mOnKeyListener);
        this.mDone = (Button)this.findViewById(2131361847);
        this.mDone.setOnClickListener(this.mOnDoneClickListener);
    }

    protected void onSaveInstanceState(Bundle outState) {
        int durValue;
        super.onSaveInstanceState(outState);
        this.mState = new Bundle();
        this.mState.putInt(SLIDE_INDEX, this.mCurSlide);
        this.mState.putInt(SLIDE_TOTAL, this.mTotal);
        try {
            durValue = Integer.parseInt(this.mDur.getText().toString());
        }
        catch (NumberFormatException e) {
            durValue = 5;
        }
        this.mState.putInt(SLIDE_DUR, durValue);
        outState.putBundle(STATE, this.mState);
    }

    protected void editDone() {
        String dur = this.mDur.getText().toString();
        int durValue = 0;
        try {
            durValue = Integer.valueOf(dur);
        }
        catch (NumberFormatException e) {
            this.notifyUser(2131165295);
            return;
        }
        if (durValue <= 0) {
            this.notifyUser(0x7F070070);
            return;
        }
        this.setResult(-1, new Intent(this.mDur.getText().toString()));
        this.finish();
    }

    private void notifyUser(int msgId) {
        this.mDur.requestFocus();
        this.mDur.selectAll();
        Toast.makeText((Context)this, (int)msgId, (int)0).show();
    }
}

