/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.app.ListActivity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.Bundle;
import android.provider.Telephony;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.android.mms.ui.DeliveryReportAdapter;
import com.android.mms.ui.DeliveryReportItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliveryReportActivity
extends ListActivity {
    private static final String LOG_TAG = "DeliveryReportActivity";
    static final String[] MMS_REPORT_REQUEST_PROJECTION = new String[]{"address", "d_rpt", "rr"};
    static final String[] MMS_REPORT_STATUS_PROJECTION = new String[]{"address", "delivery_status", "read_status"};
    static final String[] SMS_REPORT_STATUS_PROJECTION = new String[]{"address", "status"};
    static final int COLUMN_RECIPIENT = 0;
    static final int COLUMN_DELIVERY_REPORT = 1;
    static final int COLUMN_READ_REPORT = 2;
    static final int COLUMN_DELIVERY_STATUS = 1;
    static final int COLUMN_READ_STATUS = 2;
    private long mMessageId;
    private String mMessageType;

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.requestWindowFeature(1);
        this.setContentView(2130903047);
        Intent intent = this.getIntent();
        this.mMessageId = this.getMessageId(icicle, intent);
        this.mMessageType = this.getMessageType(icicle, intent);
        this.initListView();
        this.initListAdapter();
    }

    private void initListView() {
        LayoutInflater inflater = this.getLayoutInflater();
        View header = inflater.inflate(2130903048, null);
        this.getListView().addHeaderView(header, null, true);
    }

    private void initListAdapter() {
        List<DeliveryReportItem> items = this.getReportItems();
        if (items == null) {
            items = new ArrayList<DeliveryReportItem>(1);
            items.add(new DeliveryReportItem("", this.getString(2131165386)));
            Log.w((String)LOG_TAG, (String)"cursor == null");
        }
        this.setListAdapter((ListAdapter)new DeliveryReportAdapter((Context)this, items));
    }

    public void onResume() {
        super.onResume();
        this.refreshDeliveryReport();
    }

    private void refreshDeliveryReport() {
        ListView list = this.getListView();
        list.invalidateViews();
        list.requestFocus();
    }

    private long getMessageId(Bundle icicle, Intent intent) {
        long msgId = 0L;
        if (icicle != null) {
            msgId = icicle.getLong("message_id");
        }
        if (msgId == 0L) {
            msgId = intent.getLongExtra("message_id", 0L);
        }
        return msgId;
    }

    private String getMessageType(Bundle icicle, Intent intent) {
        String msgType = null;
        if (icicle != null) {
            msgType = icicle.getString("message_type");
        }
        if (msgType == null) {
            msgType = intent.getStringExtra("message_type");
        }
        return msgType;
    }

    private List<DeliveryReportItem> getReportItems() {
        if (this.mMessageType.equals("sms")) {
            return this.getSmsReportItems();
        }
        return this.getMmsReportItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DeliveryReportItem> getSmsReportItems() {
        String selection = "_id = " + this.mMessageId;
        Cursor c = SqliteWrapper.query((Context)this, (ContentResolver)this.getContentResolver(), (Uri)Telephony.Sms.CONTENT_URI, (String[])SMS_REPORT_STATUS_PROJECTION, (String)selection, null, null);
        if (c == null) {
            return null;
        }
        try {
            if (c.getCount() <= 0) {
                List<DeliveryReportItem> list = null;
                return list;
            }
            ArrayList<DeliveryReportItem> items = new ArrayList<DeliveryReportItem>();
            while (c.moveToNext()) {
                items.add(new DeliveryReportItem(this.getString(2131165393) + c.getString(0), this.getString(2131165394) + this.getSmsStatusText(c.getInt(1))));
            }
            ArrayList<DeliveryReportItem> arrayList = items;
            return arrayList;
        }
        finally {
            c.close();
        }
    }

    private String getMmsReportStatusText(MmsReportRequest request, Map<String, MmsReportStatus> reportStatus) {
        if (reportStatus == null) {
            return this.getString(2131165387);
        }
        String recipient = request.getRecipient();
        recipient = Telephony.Mms.isEmailAddress((String)recipient) ? Telephony.Mms.extractAddrSpec((String)recipient) : PhoneNumberUtils.stripSeparators((String)recipient);
        MmsReportStatus status = DeliveryReportActivity.queryStatusByRecipient(reportStatus, recipient);
        if (status == null) {
            return this.getString(2131165387);
        }
        if (request.isReadReportRequested() && status.readStatus != 0) {
            switch (status.readStatus) {
                case 128: {
                    return this.getString(2131165388);
                }
                case 129: {
                    return this.getString(2131165391);
                }
            }
        }
        switch (status.deliveryStatus) {
            case 0: {
                return this.getString(2131165387);
            }
            case 129: 
            case 134: {
                return this.getString(2131165389);
            }
            case 130: {
                return this.getString(2131165392);
            }
        }
        return this.getString(2131165390);
    }

    private static MmsReportStatus queryStatusByRecipient(Map<String, MmsReportStatus> status, String recipient) {
        Set<String> recipientSet = status.keySet();
        for (String r : recipientSet) {
            if (!(Telephony.Mms.isEmailAddress((String)recipient) ? TextUtils.equals((CharSequence)r, (CharSequence)recipient) : PhoneNumberUtils.compare((String)r, (String)recipient))) continue;
            return status.get(r);
        }
        return null;
    }

    private List<DeliveryReportItem> getMmsReportItems() {
        List<MmsReportRequest> reportReqs = this.getMmsReportRequests();
        if (null == reportReqs) {
            return null;
        }
        if (reportReqs.size() == 0) {
            return null;
        }
        Map<String, MmsReportStatus> reportStatus = this.getMmsReportStatus();
        ArrayList<DeliveryReportItem> items = new ArrayList<DeliveryReportItem>();
        for (MmsReportRequest reportReq : reportReqs) {
            String statusText = this.getString(2131165394) + this.getMmsReportStatusText(reportReq, reportStatus);
            items.add(new DeliveryReportItem(this.getString(2131165393) + reportReq.getRecipient(), statusText));
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, MmsReportStatus> getMmsReportStatus() {
        Uri uri = Uri.withAppendedPath((Uri)Telephony.Mms.REPORT_STATUS_URI, (String)String.valueOf(this.mMessageId));
        Cursor c = SqliteWrapper.query((Context)this, (ContentResolver)this.getContentResolver(), (Uri)uri, (String[])MMS_REPORT_STATUS_PROJECTION, null, null, null);
        if (c == null) {
            return null;
        }
        try {
            HashMap<String, MmsReportStatus> statusMap = new HashMap<String, MmsReportStatus>();
            while (c.moveToNext()) {
                String recipient = c.getString(0);
                recipient = Telephony.Mms.isEmailAddress((String)recipient) ? Telephony.Mms.extractAddrSpec((String)recipient) : PhoneNumberUtils.stripSeparators((String)recipient);
                MmsReportStatus status = new MmsReportStatus(c.getInt(1), c.getInt(2));
                statusMap.put(recipient, status);
            }
            HashMap<String, MmsReportStatus> hashMap = statusMap;
            return hashMap;
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MmsReportRequest> getMmsReportRequests() {
        Uri uri = Uri.withAppendedPath((Uri)Telephony.Mms.REPORT_REQUEST_URI, (String)String.valueOf(this.mMessageId));
        Cursor c = SqliteWrapper.query((Context)this, (ContentResolver)this.getContentResolver(), (Uri)uri, (String[])MMS_REPORT_REQUEST_PROJECTION, null, null, null);
        if (c == null) {
            return null;
        }
        try {
            if (c.getCount() <= 0) {
                List<MmsReportRequest> list = null;
                return list;
            }
            ArrayList<MmsReportRequest> reqList = new ArrayList<MmsReportRequest>();
            while (c.moveToNext()) {
                reqList.add(new MmsReportRequest(c.getString(0), c.getInt(1), c.getInt(2)));
            }
            ArrayList<MmsReportRequest> arrayList = reqList;
            return arrayList;
        }
        finally {
            c.close();
        }
    }

    private String getSmsStatusText(int status) {
        if (status == -1) {
            return this.getString(2131165386);
        }
        if (status >= 64) {
            return this.getString(2131165390);
        }
        if (status >= 32) {
            return this.getString(2131165387);
        }
        return this.getString(2131165389);
    }

    private static final class MmsReportRequest {
        private final String mRecipient;
        private final boolean mIsDeliveryReportRequsted;
        private final boolean mIsReadReportRequested;

        public MmsReportRequest(String recipient, int drValue, int rrValue) {
            this.mRecipient = recipient;
            this.mIsDeliveryReportRequsted = drValue == 128;
            this.mIsReadReportRequested = rrValue == 128;
        }

        public String getRecipient() {
            return this.mRecipient;
        }

        public boolean isDeliveryReportRequested() {
            return this.mIsDeliveryReportRequsted;
        }

        public boolean isReadReportRequested() {
            return this.mIsReadReportRequested;
        }
    }

    private static final class MmsReportStatus {
        final int deliveryStatus;
        final int readStatus;

        public MmsReportStatus(int drStatus, int rrStatus) {
            this.deliveryStatus = drStatus;
            this.readStatus = rrStatus;
        }
    }
}

