/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.content.Context;
import com.android.mms.data.ContactList;
import com.android.mms.data.Conversation;
import com.android.mms.ui.MessageUtils;

public class ConversationListItemData {
    private Conversation mConversation;
    private long mThreadId;
    private String mSubject;
    private String mDate;
    private boolean mHasAttachment;
    private boolean mIsRead;
    private boolean mHasError;
    private boolean mHasDraft;
    private int mMessageCount;
    private ContactList mRecipients;
    private String mRecipientString;
    private int mPresenceResId;

    public ConversationListItemData(Context context, Conversation conv) {
        this.mConversation = conv;
        this.mThreadId = conv.getThreadId();
        this.mPresenceResId = 0;
        this.mSubject = conv.getSnippet();
        this.mDate = MessageUtils.formatTimeStampString(context, conv.getDate());
        this.mIsRead = !conv.hasUnreadMessages();
        this.mHasError = conv.hasError();
        this.mHasDraft = conv.hasDraft();
        this.mMessageCount = conv.getMessageCount();
        this.mHasAttachment = conv.hasAttachment();
        this.updateRecipients();
    }

    public void updateRecipients() {
        this.mRecipients = this.mConversation.getRecipients();
        this.mRecipientString = this.mRecipients.formatNames(", ");
    }

    public long getThreadId() {
        return this.mThreadId;
    }

    public String getDate() {
        return this.mDate;
    }

    public String getFrom() {
        return this.mRecipientString;
    }

    public ContactList getContacts() {
        return this.mRecipients;
    }

    public int getPresenceResourceId() {
        return this.mPresenceResId;
    }

    public String getSubject() {
        return this.mSubject;
    }

    public boolean hasAttachment() {
        return this.mHasAttachment;
    }

    public boolean isRead() {
        return this.mIsRead;
    }

    public boolean hasError() {
        return this.mHasError;
    }

    public boolean hasDraft() {
        return this.mHasDraft;
    }

    public int getMessageCount() {
        return this.mMessageCount;
    }

    public String toString() {
        return "[ConversationHeader from:" + this.getFrom() + " subject:" + this.getSubject() + "]";
    }
}

