/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.text.style.TextAppearanceSpan;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.QuickContactBadge;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.android.mms.data.Contact;
import com.android.mms.data.ContactList;
import com.android.mms.ui.ConversationListItemData;

public class ConversationListItem
extends RelativeLayout
implements Contact.UpdateListener {
    private static final String TAG = "ConversationListItem";
    private static final boolean DEBUG = false;
    private TextView mSubjectView;
    private TextView mFromView;
    private TextView mDateView;
    private View mAttachmentView;
    private View mErrorIndicator;
    private ImageView mPresenceView;
    private QuickContactBadge mAvatarView;
    private static Drawable sDefaultContactImage;
    private Handler mHandler = new Handler();
    private ConversationListItemData mConversationHeader;
    private static final StyleSpan STYLE_BOLD;

    public ConversationListItem(Context context) {
        super(context);
    }

    public ConversationListItem(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (sDefaultContactImage == null) {
            sDefaultContactImage = context.getResources().getDrawable(2130837532);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mFromView = (TextView)this.findViewById(2131361824);
        this.mSubjectView = (TextView)this.findViewById(2131361803);
        this.mDateView = (TextView)this.findViewById(2131361825);
        this.mAttachmentView = this.findViewById(2131361827);
        this.mErrorIndicator = this.findViewById(2131361826);
        this.mPresenceView = (ImageView)this.findViewById(2131361823);
        this.mAvatarView = (QuickContactBadge)this.findViewById(2131361822);
    }

    public void setPresenceIcon(int iconId) {
        if (iconId == 0) {
            this.mPresenceView.setVisibility(8);
        } else {
            this.mPresenceView.setImageResource(iconId);
            this.mPresenceView.setVisibility(0);
        }
    }

    public ConversationListItemData getConversationHeader() {
        return this.mConversationHeader;
    }

    private void setConversationHeader(ConversationListItemData header) {
        this.mConversationHeader = header;
    }

    public void bind(String title, String explain) {
        this.mFromView.setText((CharSequence)title);
        this.mSubjectView.setText((CharSequence)explain);
    }

    private CharSequence formatMessage(ConversationListItemData ch) {
        int size = 16973894;
        int color2 = 8;
        String from = ch.getFrom();
        SpannableStringBuilder buf = new SpannableStringBuilder((CharSequence)from);
        if (ch.getMessageCount() > 1) {
            buf.append((CharSequence)(" (" + ch.getMessageCount() + ") "));
        }
        int before = buf.length();
        if (ch.hasDraft()) {
            buf.append((CharSequence)" ");
            buf.append((CharSequence)this.mContext.getResources().getString(2131165198));
            buf.setSpan((Object)new TextAppearanceSpan(this.mContext, 16973894, 8), before, buf.length(), 17);
            buf.setSpan((Object)new ForegroundColorSpan(this.mContext.getResources().getColor(2130837613)), before, buf.length(), 17);
        }
        if (!ch.isRead()) {
            buf.setSpan((Object)STYLE_BOLD, 0, buf.length(), 17);
        }
        return buf;
    }

    private void updateAvatarView() {
        Drawable avatarDrawable;
        ConversationListItemData ch = this.mConversationHeader;
        if (ch.getContacts().size() == 1) {
            Contact contact = (Contact)ch.getContacts().get(0);
            avatarDrawable = contact.getAvatar(this.mContext, sDefaultContactImage);
            if (contact.existsInDatabase()) {
                this.mAvatarView.assignContactUri(contact.getUri());
            } else {
                this.mAvatarView.assignContactFromPhone(contact.getNumber(), true);
            }
        } else {
            avatarDrawable = sDefaultContactImage;
            this.mAvatarView.assignContactUri(null);
        }
        this.mAvatarView.setImageDrawable(avatarDrawable);
        this.mAvatarView.setVisibility(0);
    }

    private void updateFromView() {
        ConversationListItemData ch = this.mConversationHeader;
        ch.updateRecipients();
        this.mFromView.setText(this.formatMessage(ch));
        this.setPresenceIcon(ch.getContacts().getPresenceResId());
        this.updateAvatarView();
    }

    public void onUpdate(Contact updated) {
        this.mHandler.post(new Runnable(){

            public void run() {
                ConversationListItem.this.updateFromView();
            }
        });
    }

    public final void bind(Context context, ConversationListItemData ch) {
        this.setConversationHeader(ch);
        Drawable background = ch.isRead() ? this.mContext.getResources().getDrawable(2130837508) : this.mContext.getResources().getDrawable(2130837509);
        this.setBackgroundDrawable(background);
        RelativeLayout.LayoutParams attachmentLayout = (RelativeLayout.LayoutParams)this.mAttachmentView.getLayoutParams();
        boolean hasError = ch.hasError();
        if (hasError) {
            attachmentLayout.addRule(0, 2131361826);
        } else {
            attachmentLayout.addRule(0, 2131361825);
        }
        boolean hasAttachment = ch.hasAttachment();
        this.mAttachmentView.setVisibility(hasAttachment ? 0 : 8);
        this.mDateView.setText((CharSequence)ch.getDate());
        this.mFromView.setText(this.formatMessage(ch));
        ContactList contacts = ch.getContacts();
        Contact.addListener(this);
        this.setPresenceIcon(contacts.getPresenceResId());
        this.mSubjectView.setText((CharSequence)ch.getSubject());
        RelativeLayout.LayoutParams subjectLayout = (RelativeLayout.LayoutParams)this.mSubjectView.getLayoutParams();
        subjectLayout.addRule(0, hasAttachment ? 2131361827 : (hasError ? 2131361826 : 2131361825));
        this.mErrorIndicator.setVisibility(hasError ? 0 : 8);
        this.updateAvatarView();
    }

    public final void unbind() {
        Contact.removeListener(this);
    }

    static {
        STYLE_BOLD = new StyleSpan(1);
    }
}

