/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.app.AlertDialog;
import android.app.ListActivity;
import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SqliteWrapper;
import android.os.Bundle;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import android.util.Log;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.CheckBox;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.android.mms.data.Contact;
import com.android.mms.data.ContactList;
import com.android.mms.data.Conversation;
import com.android.mms.transaction.MessagingNotification;
import com.android.mms.ui.ComposeMessageActivity;
import com.android.mms.ui.ConversationListAdapter;
import com.android.mms.ui.ConversationListItem;
import com.android.mms.ui.MessageUtils;
import com.android.mms.ui.MessagingPreferenceActivity;
import com.android.mms.ui.WarnOfStorageLimitsActivity;
import com.android.mms.util.DraftCache;
import com.android.mms.util.Recycler;

public class ConversationList
extends ListActivity
implements DraftCache.OnDraftChangedListener {
    private static final String TAG = "ConversationList";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final int THREAD_LIST_QUERY_TOKEN = 1701;
    public static final int DELETE_CONVERSATION_TOKEN = 1801;
    public static final int HAVE_LOCKED_MESSAGES_TOKEN = 1802;
    private static final int DELETE_OBSOLETE_THREADS_TOKEN = 1803;
    public static final int MENU_COMPOSE_NEW = 0;
    public static final int MENU_SEARCH = 1;
    public static final int MENU_DELETE_ALL = 3;
    public static final int MENU_PREFERENCES = 4;
    public static final int MENU_DELETE = 0;
    public static final int MENU_VIEW = 1;
    public static final int MENU_VIEW_CONTACT = 2;
    public static final int MENU_ADD_TO_CONTACTS = 3;
    private ThreadListQueryHandler mQueryHandler;
    private ConversationListAdapter mListAdapter;
    private CharSequence mTitle;
    private SharedPreferences mPrefs;
    private Handler mHandler;
    private boolean mNeedToMarkAsSeen;
    private static final String CHECKED_MESSAGE_LIMITS = "checked_message_limits";
    private final ConversationListAdapter.OnContentChangedListener mContentChangedListener = new ConversationListAdapter.OnContentChangedListener(){

        public void onContentChanged(ConversationListAdapter adapter) {
            ConversationList.this.startAsyncQuery();
        }
    };
    private final View.OnCreateContextMenuListener mConvListOnCreateContextMenuListener = new View.OnCreateContextMenuListener(){

        public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
            Cursor cursor = ConversationList.this.mListAdapter.getCursor();
            if (cursor == null || cursor.getPosition() < 0) {
                return;
            }
            Conversation conv = Conversation.from((Context)ConversationList.this, cursor);
            ContactList recipients = conv.getRecipients();
            menu.setHeaderTitle((CharSequence)recipients.formatNames(","));
            AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)menuInfo;
            if (info.position > 0) {
                menu.add(0, 1, 0, 2131165196);
                if (recipients.size() == 1) {
                    if (((Contact)recipients.get(0)).existsInDatabase()) {
                        menu.add(0, 2, 0, 2131165298);
                    } else {
                        menu.add(0, 3, 0, 2131165299);
                    }
                }
                menu.add(0, 0, 0, 2131165194);
            }
        }
    };
    private final View.OnKeyListener mThreadListKeyListener = new View.OnKeyListener(){

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (event.getAction() == 0) {
                switch (keyCode) {
                    case 67: {
                        long id2 = ConversationList.this.getListView().getSelectedItemId();
                        if (id2 > 0L) {
                            ConversationList.confirmDeleteThread(id2, ConversationList.this.mQueryHandler);
                        }
                        return true;
                    }
                }
            }
            return false;
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(5);
        this.setContentView(2130903045);
        this.mQueryHandler = new ThreadListQueryHandler(this.getContentResolver());
        ListView listView = this.getListView();
        LayoutInflater inflater = LayoutInflater.from((Context)this);
        ConversationListItem headerView = (ConversationListItem)inflater.inflate(2130903044, (ViewGroup)listView, false);
        headerView.bind(this.getString(2131165185), this.getString(2131165186));
        listView.addHeaderView((View)headerView, null, true);
        listView.setOnCreateContextMenuListener(this.mConvListOnCreateContextMenuListener);
        listView.setOnKeyListener(this.mThreadListKeyListener);
        this.initListAdapter();
        this.mTitle = this.getString(0x7F070000);
        this.mHandler = new Handler();
        this.mPrefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        boolean checkedMessageLimits = this.mPrefs.getBoolean(CHECKED_MESSAGE_LIMITS, false);
        if (!checkedMessageLimits) {
            this.runOneTimeStorageLimitCheckForLegacyMessages();
        }
    }

    private void initListAdapter() {
        this.mListAdapter = new ConversationListAdapter((Context)this, null);
        this.mListAdapter.setOnContentChangedListener(this.mContentChangedListener);
        this.setListAdapter((ListAdapter)this.mListAdapter);
        this.getListView().setRecyclerListener((AbsListView.RecyclerListener)this.mListAdapter);
    }

    public synchronized void runOneTimeStorageLimitCheckForLegacyMessages() {
        if (Recycler.isAutoDeleteEnabled((Context)this)) {
            this.markCheckedMessageLimit();
            return;
        }
        new Thread(new Runnable(){

            public void run() {
                if (Recycler.checkForThreadsOverLimit((Context)ConversationList.this)) {
                    ConversationList.this.mHandler.postDelayed(new Runnable(){

                        public void run() {
                            Intent intent = new Intent((Context)ConversationList.this, WarnOfStorageLimitsActivity.class);
                            ConversationList.this.startActivity(intent);
                        }
                    }, 2000L);
                } else {
                    ConversationList.this.runOnUiThread(new Runnable(){

                        public void run() {
                            SharedPreferences.Editor editor = ConversationList.this.mPrefs.edit();
                            editor.putBoolean("pref_key_auto_delete", true);
                            editor.apply();
                        }
                    });
                }
                ConversationList.this.runOnUiThread(new Runnable(){

                    public void run() {
                        ConversationList.this.markCheckedMessageLimit();
                    }
                });
            }
        }).start();
    }

    private void markCheckedMessageLimit() {
        SharedPreferences.Editor editor = this.mPrefs.edit();
        editor.putBoolean(CHECKED_MESSAGE_LIMITS, true);
        editor.apply();
    }

    protected void onNewIntent(Intent intent) {
        this.startAsyncQuery();
    }

    protected void onStart() {
        super.onStart();
        MessagingNotification.cancelNotification(this.getApplicationContext(), 239);
        DraftCache.getInstance().addOnDraftChangedListener(this);
        this.mNeedToMarkAsSeen = true;
        this.startAsyncQuery();
        if (!Conversation.loadingThreads()) {
            Contact.invalidateCache();
        }
    }

    protected void onStop() {
        super.onStop();
        DraftCache.getInstance().removeOnDraftChangedListener(this);
        this.mListAdapter.changeCursor(null);
    }

    public void onDraftChanged(final long threadId, final boolean hasDraft) {
        this.mQueryHandler.post(new Runnable(){

            public void run() {
                if (Log.isLoggable((String)"Mms:app", (int)2)) {
                    ConversationList.this.log("onDraftChanged: threadId=" + threadId + ", hasDraft=" + hasDraft, new Object[0]);
                }
                ConversationList.this.mListAdapter.notifyDataSetChanged();
            }
        });
    }

    private void startAsyncQuery() {
        try {
            this.setTitle(this.getString(2131165197));
            this.setProgressBarIndeterminateVisibility(true);
            Conversation.startQueryForAll(this.mQueryHandler, 1701);
        }
        catch (SQLiteException e) {
            SqliteWrapper.checkSQLiteException((Context)this, (SQLiteException)e);
        }
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        menu.clear();
        menu.add(0, 0, 0, 2131165189).setIcon(17301940);
        if (this.mListAdapter.getCount() > 0) {
            menu.add(0, 3, 0, 2131165193).setIcon(17301564);
        }
        menu.add(0, 1, 0, 17039372).setIcon(17301583).setAlphabeticShortcut('s');
        menu.add(0, 4, 0, 2131165190).setIcon(17301577);
        return true;
    }

    public boolean onSearchRequested() {
        this.startSearch(null, false, null, false);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 0: {
                this.createNewMessage();
                break;
            }
            case 1: {
                this.onSearchRequested();
                break;
            }
            case 3: {
                ConversationList.confirmDeleteThread(-1L, this.mQueryHandler);
                break;
            }
            case 4: {
                Intent intent = new Intent((Context)this, MessagingPreferenceActivity.class);
                this.startActivityIfNeeded(intent, -1);
                break;
            }
            default: {
                return true;
            }
        }
        return false;
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        if (position == 0) {
            this.createNewMessage();
        } else {
            Cursor cursor = (Cursor)this.getListView().getItemAtPosition(position);
            Conversation conv = Conversation.from((Context)this, cursor);
            long tid = conv.getThreadId();
            this.openThread(tid);
        }
    }

    private void createNewMessage() {
        this.startActivity(ComposeMessageActivity.createIntent((Context)this, 0L));
    }

    private void openThread(long threadId) {
        this.startActivity(ComposeMessageActivity.createIntent((Context)this, threadId));
    }

    public static Intent createAddContactIntent(String address) {
        Intent intent = new Intent("android.intent.action.INSERT_OR_EDIT");
        intent.setType("vnd.android.cursor.item/contact");
        if (Telephony.Mms.isEmailAddress((String)address)) {
            intent.putExtra("email", address);
        } else {
            intent.putExtra("phone", address);
            intent.putExtra("phone_type", 2);
        }
        intent.setFlags(524288);
        return intent;
    }

    public boolean onContextItemSelected(MenuItem item) {
        Cursor cursor = this.mListAdapter.getCursor();
        if (cursor != null && cursor.getPosition() >= 0) {
            Conversation conv = Conversation.from((Context)this, cursor);
            long threadId = conv.getThreadId();
            switch (item.getItemId()) {
                case 0: {
                    ConversationList.confirmDeleteThread(threadId, this.mQueryHandler);
                    break;
                }
                case 1: {
                    this.openThread(threadId);
                    break;
                }
                case 2: {
                    Contact contact = (Contact)conv.getRecipients().get(0);
                    Intent intent = new Intent("android.intent.action.VIEW", contact.getUri());
                    intent.setFlags(524288);
                    this.startActivity(intent);
                    break;
                }
                case 3: {
                    String address = ((Contact)conv.getRecipients().get(0)).getNumber();
                    this.startActivity(ConversationList.createAddContactIntent(address));
                    break;
                }
            }
        }
        return super.onContextItemSelected(item);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    public static void confirmDeleteThread(long threadId, AsyncQueryHandler handler) {
        Conversation.startQueryHaveLockedMessages(handler, threadId, 1802);
    }

    public static void confirmDeleteThreadDialog(final DeleteThreadListener listener, boolean deleteAll, boolean hasLockedMessages, Context context) {
        View contents = View.inflate((Context)context, (int)2130903046, null);
        TextView msg = (TextView)contents.findViewById(2131361828);
        msg.setText(deleteAll ? 2131165345 : 2131165344);
        final CheckBox checkbox = (CheckBox)contents.findViewById(2131361829);
        if (!hasLockedMessages) {
            checkbox.setVisibility(8);
        } else {
            listener.setDeleteLockedMessage(checkbox.isChecked());
            checkbox.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    listener.setDeleteLockedMessage(checkbox.isChecked());
                }
            });
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle(2131165342).setIcon(17301543).setCancelable(true).setPositiveButton(2131165352, (DialogInterface.OnClickListener)listener).setNegativeButton(2131165302, null).setView(contents).show();
    }

    private void log(String format, Object ... args) {
        String s = String.format(format, args);
        Log.d((String)TAG, (String)("[" + Thread.currentThread().getId() + "] " + s));
    }

    private final class ThreadListQueryHandler
    extends AsyncQueryHandler {
        public ThreadListQueryHandler(ContentResolver contentResolver) {
            super(contentResolver);
        }

        protected void onQueryComplete(int token, Object cookie, Cursor cursor) {
            switch (token) {
                case 1701: {
                    ConversationList.this.mListAdapter.changeCursor(cursor);
                    ConversationList.this.setTitle(ConversationList.this.mTitle);
                    ConversationList.this.setProgressBarIndeterminateVisibility(false);
                    if (!ConversationList.this.mNeedToMarkAsSeen) break;
                    ConversationList.this.mNeedToMarkAsSeen = false;
                    Conversation.markAllConversationsAsSeen(ConversationList.this.getApplicationContext());
                    Conversation.asyncDeleteObsoleteThreads(ConversationList.this.mQueryHandler, 1803);
                    break;
                }
                case 1802: {
                    long threadId = (Long)cookie;
                    ConversationList.confirmDeleteThreadDialog(new DeleteThreadListener(threadId, ConversationList.this.mQueryHandler, (Context)ConversationList.this), threadId == -1L, cursor != null && cursor.getCount() > 0, (Context)ConversationList.this);
                    break;
                }
                default: {
                    Log.e((String)ConversationList.TAG, (String)("onQueryComplete called with unknown token " + token));
                }
            }
        }

        protected void onDeleteComplete(int token, Object cookie, int result) {
            switch (token) {
                case 1801: {
                    Conversation.init((Context)ConversationList.this);
                    MessagingNotification.nonBlockingUpdateNewMessageIndicator((Context)ConversationList.this, false, false);
                    MessagingNotification.updateSendFailedNotification((Context)ConversationList.this);
                    ConversationList.this.startAsyncQuery();
                    break;
                }
            }
        }
    }

    public static class DeleteThreadListener
    implements DialogInterface.OnClickListener {
        private final long mThreadId;
        private final AsyncQueryHandler mHandler;
        private final Context mContext;
        private boolean mDeleteLockedMessages;

        public DeleteThreadListener(long threadId, AsyncQueryHandler handler, Context context) {
            this.mThreadId = threadId;
            this.mHandler = handler;
            this.mContext = context;
        }

        public void setDeleteLockedMessage(boolean deleteLockedMessages) {
            this.mDeleteLockedMessages = deleteLockedMessages;
        }

        public void onClick(DialogInterface dialog, int whichButton) {
            MessageUtils.handleReadReport(this.mContext, this.mThreadId, 129, new Runnable(){

                public void run() {
                    int token = 1801;
                    if (DeleteThreadListener.this.mThreadId == -1L) {
                        Conversation.startDeleteAll(DeleteThreadListener.this.mHandler, token, DeleteThreadListener.this.mDeleteLockedMessages);
                        DraftCache.getInstance().refresh();
                    } else {
                        Conversation.startDelete(DeleteThreadListener.this.mHandler, token, DeleteThreadListener.this.mDeleteLockedMessages, DeleteThreadListener.this.mThreadId);
                        DraftCache.getInstance().setDraftState(DeleteThreadListener.this.mThreadId, false);
                    }
                }
            });
            dialog.dismiss();
        }
    }
}

