/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.AsyncQueryHandler;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SqliteWrapper;
import android.drm.mobile1.DrmException;
import android.drm.mobile1.DrmRawContent;
import android.graphics.drawable.Drawable;
import android.media.CamcorderProfile;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.os.SystemProperties;
import android.provider.ContactsContract;
import android.provider.DrmStore;
import android.provider.MediaStore;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.SmsMessage;
import android.text.ClipboardManager;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.TextKeyListener;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import android.util.Log;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewStub;
import android.view.inputmethod.InputMethodManager;
import android.webkit.MimeTypeMap;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.android.mms.LogTag;
import com.android.mms.MmsConfig;
import com.android.mms.data.Contact;
import com.android.mms.data.ContactList;
import com.android.mms.data.Conversation;
import com.android.mms.data.WorkingMessage;
import com.android.mms.model.SlideModel;
import com.android.mms.model.SlideshowModel;
import com.android.mms.transaction.MessagingNotification;
import com.android.mms.ui.AttachmentEditor;
import com.android.mms.ui.AttachmentTypeSelectorAdapter;
import com.android.mms.ui.ConversationList;
import com.android.mms.ui.DeliveryReportActivity;
import com.android.mms.ui.MessageItem;
import com.android.mms.ui.MessageListAdapter;
import com.android.mms.ui.MessageListItem;
import com.android.mms.ui.MessageListView;
import com.android.mms.ui.MessageUtils;
import com.android.mms.ui.RecipientsAdapter;
import com.android.mms.ui.RecipientsEditor;
import com.android.mms.ui.SlideshowEditActivity;
import com.android.mms.util.SmileyParser;
import com.google.android.mms.ContentType;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.PduBody;
import com.google.android.mms.pdu.PduPart;
import com.google.android.mms.pdu.PduPersister;
import com.google.android.mms.pdu.SendReq;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;

public class ComposeMessageActivity
extends Activity
implements View.OnClickListener,
TextView.OnEditorActionListener,
WorkingMessage.MessageStatusListener,
Contact.UpdateListener {
    public static final int REQUEST_CODE_ATTACH_IMAGE = 10;
    public static final int REQUEST_CODE_TAKE_PICTURE = 11;
    public static final int REQUEST_CODE_ATTACH_VIDEO = 12;
    public static final int REQUEST_CODE_TAKE_VIDEO = 13;
    public static final int REQUEST_CODE_ATTACH_SOUND = 14;
    public static final int REQUEST_CODE_RECORD_SOUND = 15;
    public static final int REQUEST_CODE_CREATE_SLIDESHOW = 16;
    public static final int REQUEST_CODE_ECM_EXIT_DIALOG = 17;
    public static final int REQUEST_CODE_ADD_CONTACT = 18;
    private static final String TAG = "Mms/compose";
    private static final boolean DEBUG = false;
    private static final boolean TRACE = false;
    private static final boolean LOCAL_LOGV = false;
    private static final int MENU_ADD_SUBJECT = 0;
    private static final int MENU_DELETE_THREAD = 1;
    private static final int MENU_ADD_ATTACHMENT = 2;
    private static final int MENU_DISCARD = 3;
    private static final int MENU_SEND = 4;
    private static final int MENU_CALL_RECIPIENT = 5;
    private static final int MENU_CONVERSATION_LIST = 6;
    private static final int MENU_VIEW_CONTACT = 12;
    private static final int MENU_ADD_TO_CONTACTS = 13;
    private static final int MENU_EDIT_MESSAGE = 14;
    private static final int MENU_VIEW_SLIDESHOW = 16;
    private static final int MENU_VIEW_MESSAGE_DETAILS = 17;
    private static final int MENU_DELETE_MESSAGE = 18;
    private static final int MENU_SEARCH = 19;
    private static final int MENU_DELIVERY_REPORT = 20;
    private static final int MENU_FORWARD_MESSAGE = 21;
    private static final int MENU_CALL_BACK = 22;
    private static final int MENU_SEND_EMAIL = 23;
    private static final int MENU_COPY_MESSAGE_TEXT = 24;
    private static final int MENU_COPY_TO_SDCARD = 25;
    private static final int MENU_INSERT_SMILEY = 26;
    private static final int MENU_ADD_ADDRESS_TO_CONTACTS = 27;
    private static final int MENU_LOCK_MESSAGE = 28;
    private static final int MENU_UNLOCK_MESSAGE = 29;
    private static final int MENU_COPY_TO_DRM_PROVIDER = 30;
    private static final int RECIPIENTS_MAX_LENGTH = 312;
    private static final int MESSAGE_LIST_QUERY_TOKEN = 9527;
    private static final int DELETE_MESSAGE_TOKEN = 9700;
    private static final int CHARS_REMAINING_BEFORE_COUNTER_SHOWN = 10;
    private static final long NO_DATE_FOR_DIALOG = -1L;
    private static final String EXIT_ECM_RESULT = "exit_ecm_result";
    private ContentResolver mContentResolver;
    private BackgroundQueryHandler mBackgroundQueryHandler;
    private Conversation mConversation;
    private boolean mExitOnSent;
    private View mTopPanel;
    private View mBottomPanel;
    private EditText mTextEditor;
    private TextView mTextCounter;
    private Button mSendButton;
    private EditText mSubjectTextEditor;
    private AttachmentEditor mAttachmentEditor;
    private MessageListView mMsgListView;
    public MessageListAdapter mMsgListAdapter;
    private RecipientsEditor mRecipientsEditor;
    private boolean mIsKeyboardOpen;
    private boolean mIsLandscape;
    private boolean mPossiblePendingNotification;
    private boolean mToastForDraftSave;
    private boolean mSentMessage;
    private WorkingMessage mWorkingMessage;
    private AlertDialog mSmileyDialog;
    private boolean mWaitingForSubActivity;
    private int mLastRecipientCount;
    private AttachmentTypeSelectorAdapter mAttachmentTypeSelectorAdapter;
    private boolean mSendingMessage;
    private Intent mAddContactIntent;
    private String mDebugRecipients;
    private final Handler mAttachmentEditorHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ComposeMessageActivity.this.editSlideshow();
                    break;
                }
                case 2: {
                    if (!ComposeMessageActivity.this.isPreparedForSending()) break;
                    ComposeMessageActivity.this.confirmSendMessageIfNeeded();
                    break;
                }
                case 3: 
                case 7: 
                case 8: 
                case 9: {
                    MessageUtils.viewMmsMessageAttachment((Context)ComposeMessageActivity.this, ComposeMessageActivity.this.mWorkingMessage);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    ComposeMessageActivity.this.showAddAttachmentDialog(true);
                    break;
                }
                case 10: {
                    ComposeMessageActivity.this.mWorkingMessage.setAttachment(0, null, false);
                    break;
                }
            }
        }
    };
    private final Handler mMessageListItemHandler = new Handler(){

        public void handleMessage(Message msg) {
            String type;
            switch (msg.what) {
                case 1: {
                    type = "mms";
                    break;
                }
                case 2: {
                    type = "sms";
                    break;
                }
                default: {
                    Log.w((String)ComposeMessageActivity.TAG, (String)("Unknown message: " + msg.what));
                    return;
                }
            }
            MessageItem msgItem = ComposeMessageActivity.this.getMessageItem(type, (Long)msg.obj, false);
            if (msgItem != null) {
                ComposeMessageActivity.this.editMessageItem(msgItem);
                ComposeMessageActivity.this.drawBottomPanel();
            }
        }
    };
    private final View.OnKeyListener mSubjectKeyListener = new View.OnKeyListener(){

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (event.getAction() != 0) {
                return false;
            }
            if (keyCode == 67 && ComposeMessageActivity.this.mSubjectTextEditor.length() == 0) {
                ComposeMessageActivity.this.showSubjectEditor(false);
                ComposeMessageActivity.this.mWorkingMessage.setSubject(null, true);
                return true;
            }
            return false;
        }
    };
    private final TextWatcher mRecipientsWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            ComposeMessageActivity.this.onUserInteraction();
        }

        public void afterTextChanged(Editable s) {
            if (!ComposeMessageActivity.this.isRecipientsEditorVisible()) {
                IllegalStateException e = new IllegalStateException("afterTextChanged called with invisible mRecipientsEditor");
                Log.w((String)ComposeMessageActivity.TAG, (String)"RecipientsWatcher: afterTextChanged called with invisible mRecipientsEditor");
                return;
            }
            ComposeMessageActivity.this.mWorkingMessage.setWorkingRecipients(ComposeMessageActivity.this.mRecipientsEditor.getNumbers());
            ComposeMessageActivity.this.mWorkingMessage.setHasEmail(ComposeMessageActivity.this.mRecipientsEditor.containsEmail(), true);
            ComposeMessageActivity.this.checkForTooManyRecipients();
            for (int pos = s.length() - 1; pos >= 0; --pos) {
                char c = s.charAt(pos);
                if (c == ' ') continue;
                if (c != ',') break;
                ComposeMessageActivity.this.updateTitle(ComposeMessageActivity.this.mConversation.getRecipients());
                break;
            }
            ComposeMessageActivity.this.updateSendButtonState();
        }
    };
    private final View.OnCreateContextMenuListener mRecipientsMenuCreateListener = new View.OnCreateContextMenuListener(){

        public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
            if (menuInfo != null) {
                Contact c = ((RecipientsEditor.RecipientContextMenuInfo)menuInfo).recipient;
                RecipientsMenuClickListener l = new RecipientsMenuClickListener(c);
                menu.setHeaderTitle((CharSequence)c.getName());
                if (c.existsInDatabase()) {
                    menu.add(0, 12, 0, 2131165298).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)l);
                } else if (ComposeMessageActivity.this.canAddToContacts(c)) {
                    menu.add(0, 13, 0, 2131165299).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)l);
                }
            }
        }
    };
    private final View.OnCreateContextMenuListener mMsgListMenuCreateListener = new View.OnCreateContextMenuListener(){

        public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
            MsgListMenuClickListener l;
            MessageItem msgItem;
            block19: {
                block18: {
                    Cursor cursor = ComposeMessageActivity.this.mMsgListAdapter.getCursor();
                    String type = cursor.getString(0);
                    long msgId = cursor.getLong(1);
                    ComposeMessageActivity.this.addPositionBasedMenuItems(menu, v, menuInfo);
                    msgItem = ComposeMessageActivity.this.mMsgListAdapter.getCachedMessageItem(type, msgId, cursor);
                    if (msgItem == null) {
                        Log.e((String)ComposeMessageActivity.TAG, (String)("Cannot load message item for type = " + type + ", msgId = " + msgId));
                        return;
                    }
                    menu.setHeaderTitle(2131165223);
                    l = new MsgListMenuClickListener();
                    if (msgItem.mLocked) {
                        menu.add(0, 29, 0, 2131165379).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)l);
                    } else {
                        menu.add(0, 28, 0, 2131165378).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)l);
                    }
                    if (!msgItem.isMms()) break block18;
                    switch (msgItem.mBoxId) {
                        case 1: {
                            break;
                        }
                        case 4: {
                            if (ComposeMessageActivity.this.getRecipients().size() != 1) break;
                            menu.add(0, 14, 0, 2131165373).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)l);
                        }
                    }
                    switch (msgItem.mAttachmentType) {
                        case 0: {
                            break;
                        }
                        case 1: 
                        case 2: {
                            if (ComposeMessageActivity.this.haveSomethingToCopyToSDCard(msgItem.mMsgId)) {
                                menu.add(0, 25, 0, 2131165433).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)l);
                                break;
                            }
                            break block19;
                        }
                        default: {
                            menu.add(0, 16, 0, 2131165204).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)l);
                            if (ComposeMessageActivity.this.haveSomethingToCopyToSDCard(msgItem.mMsgId)) {
                                menu.add(0, 25, 0, 2131165433).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)l);
                            }
                            if (ComposeMessageActivity.this.haveSomethingToCopyToDrmProvider(msgItem.mMsgId)) {
                                menu.add(0, 30, 0, ComposeMessageActivity.this.getDrmMimeMenuStringRsrc(msgItem.mMsgId)).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)l);
                                break;
                            }
                            break block19;
                        }
                    }
                    break block19;
                }
                if (ComposeMessageActivity.this.getRecipients().size() == 1 && (msgItem.mBoxId == 4 || msgItem.mBoxId == 5)) {
                    menu.add(0, 14, 0, 2131165373).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)l);
                }
            }
            ComposeMessageActivity.this.addCallAndContactMenuItems(menu, l, msgItem);
            if (msgItem.isDownloaded()) {
                menu.add(0, 21, 0, 2131165215).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)l);
            }
            if (msgItem.isSms()) {
                menu.add(0, 24, 0, 2131165222).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)l);
            }
            menu.add(0, 17, 0, 2131165205).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)l);
            menu.add(0, 18, 0, 2131165207).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)l);
            if (msgItem.mDeliveryStatus != MessageItem.DeliveryStatus.NONE || msgItem.mReadReport) {
                menu.add(0, 20, 0, 2131165206).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)l);
            }
        }
    };
    private final IntentFilter mHttpProgressFilter = new IntentFilter("com.android.mms.PROGRESS_STATUS");
    private final BroadcastReceiver mHttpProgressReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if ("com.android.mms.PROGRESS_STATUS".equals(intent.getAction())) {
                long token = intent.getLongExtra("token", -1L);
                if (token != ComposeMessageActivity.this.mConversation.getThreadId()) {
                    return;
                }
                int progress = intent.getIntExtra("progress", 0);
                switch (progress) {
                    case -1: {
                        ComposeMessageActivity.this.setProgressBarVisibility(true);
                        break;
                    }
                    case -2: 
                    case 100: {
                        ComposeMessageActivity.this.setProgressBarVisibility(false);
                        break;
                    }
                    default: {
                        ComposeMessageActivity.this.setProgress(100 * progress);
                    }
                }
            }
        }
    };
    private static ContactList sEmptyContactList;
    Runnable mResetMessageRunnable = new Runnable(){

        public void run() {
            ComposeMessageActivity.this.resetMessage();
        }
    };
    private final MessageUtils.ResizeImageResultCallback mResizeImageCallback = new MessageUtils.ResizeImageResultCallback(){

        public void onResizeResult(PduPart part, boolean append) {
            int result;
            if (part == null) {
                ComposeMessageActivity.this.handleAddAttachmentError(-1, 2131165416);
                return;
            }
            ComposeMessageActivity context = ComposeMessageActivity.this;
            PduPersister persister = PduPersister.getPduPersister((Context)context);
            Uri messageUri = ComposeMessageActivity.this.mWorkingMessage.saveAsMms(true);
            try {
                Uri dataUri = persister.persistPart(part, ContentUris.parseId((Uri)messageUri));
                result = ComposeMessageActivity.this.mWorkingMessage.setAttachment(1, dataUri, append);
                if (Log.isLoggable((String)"Mms:app", (int)2)) {
                    ComposeMessageActivity.log("ResizeImageResultCallback: dataUri=" + dataUri);
                }
            }
            catch (MmsException e) {
                result = -1;
            }
            ComposeMessageActivity.this.handleAddAttachmentError(result, 2131165416);
        }
    };
    private static final String mVideoUri;
    private static final String mImageUri;
    private final TextWatcher mTextEditorWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            ComposeMessageActivity.this.onUserInteraction();
            ComposeMessageActivity.this.mWorkingMessage.setText(s);
            ComposeMessageActivity.this.updateSendButtonState();
            ComposeMessageActivity.this.updateCounter(s, start, before, count);
            ComposeMessageActivity.this.ensureCorrectButtonHeight();
        }

        public void afterTextChanged(Editable s) {
        }
    };
    private final TextWatcher mSubjectEditorWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            ComposeMessageActivity.this.mWorkingMessage.setSubject(s, true);
        }

        public void afterTextChanged(Editable s) {
        }
    };
    private final MessageListAdapter.OnDataSetChangedListener mDataSetChangedListener = new MessageListAdapter.OnDataSetChangedListener(){

        public void onDataSetChanged(MessageListAdapter adapter) {
            ComposeMessageActivity.this.mPossiblePendingNotification = true;
        }

        public void onContentChanged(MessageListAdapter adapter) {
            ComposeMessageActivity.this.startMsgListQuery();
        }
    };

    private static void log(String logMsg) {
        Thread current = Thread.currentThread();
        long tid = current.getId();
        StackTraceElement[] stack = current.getStackTrace();
        String methodName = stack[3].getMethodName();
        logMsg = "[" + tid + "] [" + methodName + "] " + logMsg;
        Log.d((String)TAG, (String)logMsg);
    }

    private void editSlideshow() {
        Uri dataUri = this.mWorkingMessage.saveAsMms(false);
        Intent intent = new Intent((Context)this, SlideshowEditActivity.class);
        intent.setData(dataUri);
        this.startActivityForResult(intent, 16);
    }

    private MessageItem getMessageItem(String type, long msgId, boolean createFromCursorIfNotInCache) {
        return this.mMsgListAdapter.getCachedMessageItem(type, msgId, createFromCursorIfNotInCache ? this.mMsgListAdapter.getCursor() : null);
    }

    private boolean isCursorValid() {
        Cursor cursor = this.mMsgListAdapter.getCursor();
        if (cursor.isClosed() || cursor.isBeforeFirst() || cursor.isAfterLast()) {
            Log.e((String)TAG, (String)"Bad cursor.", (Throwable)new RuntimeException());
            return false;
        }
        return true;
    }

    private void resetCounter() {
        this.mTextCounter.setText((CharSequence)"");
        this.mTextCounter.setVisibility(8);
    }

    private void updateCounter(CharSequence text, int start, int before, int count) {
        WorkingMessage workingMessage = this.mWorkingMessage;
        if (workingMessage.requiresMms()) {
            boolean textRemoved;
            boolean bl = textRemoved = before > count;
            if (!textRemoved) {
                this.setSendButtonText(workingMessage.requiresMms());
                return;
            }
        }
        int[] params = SmsMessage.calculateLength((CharSequence)text, (boolean)false);
        int msgCount = params[0];
        int remainingInCurrentMessage = params[2];
        if (!MmsConfig.getMultipartSmsEnabled()) {
            this.mWorkingMessage.setLengthRequiresMms(msgCount >= MmsConfig.getSmsToMmsTextThreshold(), true);
        }
        boolean showCounter = false;
        if (!(workingMessage.requiresMms() || msgCount <= 1 && remainingInCurrentMessage > 10)) {
            showCounter = true;
        }
        this.setSendButtonText(workingMessage.requiresMms());
        if (showCounter) {
            String counterText = msgCount > 1 ? remainingInCurrentMessage + " / " + msgCount : String.valueOf(remainingInCurrentMessage);
            this.mTextCounter.setText((CharSequence)counterText);
            this.mTextCounter.setVisibility(0);
        } else {
            this.mTextCounter.setVisibility(8);
        }
    }

    public void startActivityForResult(Intent intent, int requestCode) {
        if (requestCode >= 0) {
            this.mWaitingForSubActivity = true;
        }
        super.startActivityForResult(intent, requestCode);
    }

    private void toastConvertInfo(boolean toMms) {
        int resId = toMms ? 2131165272 : 2131165273;
        Toast.makeText((Context)this, (int)resId, (int)0).show();
    }

    private void confirmSendMessageIfNeeded() {
        if (!this.isRecipientsEditorVisible()) {
            this.sendMessage(true);
            return;
        }
        boolean isMms = this.mWorkingMessage.requiresMms();
        if (this.mRecipientsEditor.hasInvalidRecipient(isMms)) {
            if (this.mRecipientsEditor.hasValidRecipient(isMms)) {
                String title = this.getResourcesString(2131165266, this.mRecipientsEditor.formatInvalidNumbers(isMms));
                new AlertDialog.Builder((Context)this).setIcon(17301543).setTitle((CharSequence)title).setMessage(2131165268).setPositiveButton(2131165307, (DialogInterface.OnClickListener)new SendIgnoreInvalidRecipientListener()).setNegativeButton(2131165302, (DialogInterface.OnClickListener)new CancelSendingListener()).show();
            } else {
                new AlertDialog.Builder((Context)this).setIcon(17301543).setTitle(2131165269).setMessage(2131165270).setPositiveButton(2131165301, (DialogInterface.OnClickListener)new CancelSendingListener()).show();
            }
        } else {
            this.sendMessage(true);
        }
    }

    private void checkForTooManyRecipients() {
        int recipientLimit = MmsConfig.getRecipientLimit();
        if (recipientLimit != Integer.MAX_VALUE) {
            boolean tooMany;
            int recipientCount = this.recipientCount();
            boolean bl = tooMany = recipientCount > recipientLimit;
            if (recipientCount != this.mLastRecipientCount) {
                this.mLastRecipientCount = recipientCount;
                if (tooMany) {
                    String tooManyMsg = this.getString(2131165280, new Object[]{recipientCount, recipientLimit});
                    Toast.makeText((Context)this, (CharSequence)tooManyMsg, (int)1).show();
                }
            }
        }
    }

    private boolean canAddToContacts(Contact contact) {
        char c;
        String name = contact.getName();
        if (!TextUtils.isEmpty((CharSequence)contact.getNumber()) && this.isSpecialChar(c = contact.getNumber().charAt(0))) {
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)name) && this.isSpecialChar(c = name.charAt(0))) {
            return false;
        }
        return Telephony.Mms.isEmailAddress((String)name) || Telephony.Mms.isPhoneNumber((String)name) || MessageUtils.isLocalNumber(contact.getNumber());
    }

    private boolean isSpecialChar(char c) {
        return c == '*' || c == '%' || c == '$';
    }

    private void addPositionBasedMenuItems(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        AdapterView.AdapterContextMenuInfo info;
        try {
            info = (AdapterView.AdapterContextMenuInfo)menuInfo;
        }
        catch (ClassCastException e) {
            Log.e((String)TAG, (String)"bad menuInfo");
            return;
        }
        int position = info.position;
        this.addUriSpecificMenuItems(menu, v, position);
    }

    private Uri getSelectedUriFromMessageList(ListView listView, int position) {
        int max;
        int min;
        URLSpan[] urls;
        MessageListItem msglistItem = (MessageListItem)listView.getChildAt(position);
        if (msglistItem == null) {
            return null;
        }
        CharSequence text = null;
        int selStart = -1;
        int selEnd = -1;
        TextView textView = (TextView)msglistItem.findViewById(2131361857);
        if (textView != null) {
            text = textView.getText();
            selStart = textView.getSelectionStart();
            selEnd = textView.getSelectionEnd();
        }
        if (selStart == -1 && (textView = (TextView)msglistItem.findViewById(2131361880)) != null) {
            text = textView.getText();
            selStart = textView.getSelectionStart();
            selEnd = textView.getSelectionEnd();
        }
        if (selStart != selEnd && (urls = (URLSpan[])((Spanned)text).getSpans(min = Math.min(selStart, selEnd), max = Math.max(selStart, selEnd), URLSpan.class)).length == 1) {
            return Uri.parse((String)urls[0].getURL());
        }
        return null;
    }

    private void addUriSpecificMenuItems(ContextMenu menu, View v, int position) {
        Uri uri = this.getSelectedUriFromMessageList((ListView)v, position);
        if (uri != null) {
            Intent intent = new Intent(null, uri);
            intent.addCategory("android.intent.category.SELECTED_ALTERNATIVE");
            menu.addIntentOptions(0, 0, 0, new ComponentName((Context)this, ComposeMessageActivity.class), null, intent, 0, null);
        }
    }

    private final void addCallAndContactMenuItems(ContextMenu menu, MsgListMenuClickListener l, MessageItem msgItem) {
        StringBuilder textToSpannify = new StringBuilder();
        if (msgItem.mBoxId == 1) {
            textToSpannify.append(msgItem.mAddress + ": ");
        }
        textToSpannify.append(msgItem.mBody);
        SpannableString msg = new SpannableString((CharSequence)textToSpannify.toString());
        Linkify.addLinks((Spannable)msg, (int)15);
        ArrayList<String> uris = MessageUtils.extractUris((URLSpan[])msg.getSpans(0, msg.length(), URLSpan.class));
        while (uris.size() > 0) {
            Intent intent;
            String uriString = uris.remove(0);
            while (uris.contains(uriString)) {
                uris.remove(uriString);
            }
            int sep = uriString.indexOf(":");
            String prefix = null;
            if (sep >= 0) {
                prefix = uriString.substring(0, sep);
                uriString = uriString.substring(sep + 1);
            }
            boolean addToContacts = false;
            if ("mailto".equalsIgnoreCase(prefix)) {
                String sendEmailString = this.getString(2131165188).replace("%s", uriString);
                intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("mailto:" + uriString)));
                intent.setFlags(524288);
                menu.add(0, 23, 0, (CharSequence)sendEmailString).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)l).setIntent(intent);
                addToContacts = !this.haveEmailContact(uriString);
            } else if ("tel".equalsIgnoreCase(prefix)) {
                String callBackString = this.getString(2131165187).replace("%s", uriString);
                intent = new Intent("android.intent.action.CALL", Uri.parse((String)("tel:" + uriString)));
                intent.setFlags(524288);
                menu.add(0, 22, 0, (CharSequence)callBackString).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)l).setIntent(intent);
                boolean bl = addToContacts = !this.isNumberInContacts(uriString);
            }
            if (!addToContacts) continue;
            Intent intent2 = ConversationList.createAddContactIntent(uriString);
            String addContactString = this.getString(0x7F070007).replace("%s", uriString);
            menu.add(0, 27, 0, (CharSequence)addContactString).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)l).setIntent(intent2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean haveEmailContact(String emailAddress) {
        Cursor cursor = SqliteWrapper.query((Context)this, (ContentResolver)this.getContentResolver(), (Uri)Uri.withAppendedPath((Uri)ContactsContract.CommonDataKinds.Email.CONTENT_LOOKUP_URI, (String)Uri.encode((String)emailAddress)), (String[])new String[]{"display_name"}, null, null, null);
        if (cursor != null) {
            try {
                while (cursor.moveToNext()) {
                    String name = cursor.getString(0);
                    if (TextUtils.isEmpty((CharSequence)name)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                cursor.close();
            }
        }
        return false;
    }

    private boolean isNumberInContacts(String phoneNumber) {
        return Contact.get(phoneNumber, false).existsInDatabase();
    }

    private void editMessageItem(MessageItem msgItem) {
        if ("sms".equals(msgItem.mType)) {
            this.editSmsMessageItem(msgItem);
        } else {
            this.editMmsMessageItem(msgItem);
        }
        if (msgItem.isFailedMessage() && this.mMsgListAdapter.getCount() <= 1) {
            this.initRecipientsEditor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editSmsMessageItem(MessageItem msgItem) {
        Conversation conversation = this.mConversation;
        synchronized (conversation) {
            if (this.mConversation.getMessageCount() <= 1) {
                this.mConversation.clearThreadId();
            }
        }
        Uri uri = ContentUris.withAppendedId((Uri)Telephony.Sms.CONTENT_URI, (long)msgItem.mMsgId);
        SqliteWrapper.delete((Context)this, (ContentResolver)this.mContentResolver, (Uri)uri, null, null);
        this.mWorkingMessage.setText(msgItem.mBody);
    }

    private void editMmsMessageItem(MessageItem msgItem) {
        this.mWorkingMessage.discard();
        this.mWorkingMessage = WorkingMessage.load(this, msgItem.mMessageUri);
        this.mWorkingMessage.setConversation(this.mConversation);
        this.mAttachmentEditor.update(this.mWorkingMessage);
        this.drawTopPanel();
        this.mWorkingMessage.setSubject(msgItem.mSubject, false);
        if (this.mWorkingMessage.hasSubject()) {
            this.showSubjectEditor(true);
        }
    }

    private void copyToClipboard(String str) {
        ClipboardManager clip = (ClipboardManager)this.getSystemService("clipboard");
        clip.setText((CharSequence)str);
    }

    private void forwardMessage(MessageItem msgItem) {
        Intent intent = ComposeMessageActivity.createIntent((Context)this, 0L);
        intent.putExtra("exit_on_sent", true);
        intent.putExtra("forwarded_message", true);
        if (msgItem.mType.equals("sms")) {
            intent.putExtra("sms_body", msgItem.mBody);
        } else {
            SendReq sendReq = new SendReq();
            String subject = this.getString(2131165263);
            if (msgItem.mSubject != null) {
                subject = subject + msgItem.mSubject;
            }
            sendReq.setSubject(new EncodedStringValue(subject));
            sendReq.setBody(msgItem.mSlideshow.makeCopy((Context)this));
            Uri uri = null;
            try {
                PduPersister persister = PduPersister.getPduPersister((Context)this);
                uri = persister.persist((GenericPdu)sendReq, Telephony.Mms.Draft.CONTENT_URI);
            }
            catch (MmsException e) {
                Log.e((String)TAG, (String)("Failed to copy message: " + msgItem.mMessageUri), (Throwable)e);
                Toast.makeText((Context)this, (int)2131165276, (int)0).show();
                return;
            }
            intent.putExtra("msg_uri", (Parcelable)uri);
            intent.putExtra("subject", subject);
        }
        intent.setClassName((Context)this, "com.android.mms.ui.ForwardMessageActivity");
        this.startActivity(intent);
    }

    private void lockMessage(MessageItem msgItem, boolean locked) {
        Uri uri = "sms".equals(msgItem.mType) ? Telephony.Sms.CONTENT_URI : Telephony.Mms.CONTENT_URI;
        final Uri lockUri = ContentUris.withAppendedId((Uri)uri, (long)msgItem.mMsgId);
        final ContentValues values = new ContentValues(1);
        values.put("locked", Integer.valueOf(locked ? 1 : 0));
        new Thread(new Runnable(){

            public void run() {
                ComposeMessageActivity.this.getContentResolver().update(lockUri, values, null, null);
            }
        }, "lockMessage").start();
    }

    private boolean haveSomethingToCopyToSDCard(long msgId) {
        PduBody body = PduBodyCache.getPduBody((Context)this, ContentUris.withAppendedId((Uri)Telephony.Mms.CONTENT_URI, (long)msgId));
        if (body == null) {
            return false;
        }
        boolean result = false;
        int partNum = body.getPartsNum();
        for (int i = 0; i < partNum; ++i) {
            PduPart part = body.getPart(i);
            String type = new String(part.getContentType());
            if (Log.isLoggable((String)"Mms:app", (int)2)) {
                ComposeMessageActivity.log("[CMA] haveSomethingToCopyToSDCard: part[" + i + "] contentType=" + type);
            }
            if (!ContentType.isImageType((String)type) && !ContentType.isVideoType((String)type) && !ContentType.isAudioType((String)type)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean haveSomethingToCopyToDrmProvider(long msgId) {
        String mimeType = this.getDrmMimeType(msgId);
        return this.isAudioMimeType(mimeType);
    }

    private boolean copyToDrmProvider(long msgId) {
        boolean result = true;
        PduBody body = PduBodyCache.getPduBody((Context)this, ContentUris.withAppendedId((Uri)Telephony.Mms.CONTENT_URI, (long)msgId));
        if (body == null) {
            return false;
        }
        int partNum = body.getPartsNum();
        for (int i = 0; i < partNum; ++i) {
            PduPart part = body.getPart(i);
            String type = new String(part.getContentType());
            if (!ContentType.isDrmType((String)type)) continue;
            result &= this.copyPartToDrmProvider(part);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String mimeTypeOfDrmPart(PduPart part) {
        Uri uri = part.getDataUri();
        InputStream input = null;
        try {
            input = this.mContentResolver.openInputStream(uri);
            if (input instanceof FileInputStream) {
                String mimeType;
                FileInputStream fin = (FileInputStream)input;
                DrmRawContent content = new DrmRawContent((InputStream)fin, fin.available(), "application/vnd.oma.drm.message");
                String string2 = mimeType = content.getContentType();
                return string2;
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"IOException caught while opening or reading stream", (Throwable)e);
        }
        catch (DrmException e) {
            Log.e((String)TAG, (String)"DrmException caught ", (Throwable)e);
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"IOException caught while closing stream", (Throwable)e);
                }
            }
        }
        return null;
    }

    private String getDrmMimeType(long msgId) {
        PduBody body = PduBodyCache.getPduBody((Context)this, ContentUris.withAppendedId((Uri)Telephony.Mms.CONTENT_URI, (long)msgId));
        if (body == null) {
            return null;
        }
        int partNum = body.getPartsNum();
        for (int i = 0; i < partNum; ++i) {
            PduPart part = body.getPart(i);
            String type = new String(part.getContentType());
            if (!ContentType.isDrmType((String)type)) continue;
            return this.mimeTypeOfDrmPart(part);
        }
        return null;
    }

    private int getDrmMimeMenuStringRsrc(long msgId) {
        String mimeType = this.getDrmMimeType(msgId);
        if (this.isAudioMimeType(mimeType)) {
            return 2131165436;
        }
        return 0;
    }

    private int getDrmMimeSavedStringRsrc(long msgId, boolean success) {
        String mimeType = this.getDrmMimeType(msgId);
        if (this.isAudioMimeType(mimeType)) {
            return success ? 2131165437 : 2131165438;
        }
        return 0;
    }

    private boolean isAudioMimeType(String mimeType) {
        return mimeType != null && mimeType.startsWith("audio/");
    }

    private boolean isImageMimeType(String mimeType) {
        return mimeType != null && mimeType.startsWith("image/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyPartToDrmProvider(PduPart part) {
        Uri uri = part.getDataUri();
        InputStream input = null;
        try {
            input = this.mContentResolver.openInputStream(uri);
            if (input instanceof FileInputStream) {
                String title;
                int index;
                FileInputStream fin = (FileInputStream)input;
                byte[] location = part.getName();
                if (location == null) {
                    location = part.getFilename();
                }
                if (location == null) {
                    location = part.getContentLocation();
                }
                if ((index = (title = new String(location)).indexOf(".")) == -1) {
                    String type = new String(part.getContentType());
                } else {
                    title = title.substring(0, index);
                }
                Intent item = DrmStore.addDrmFile((ContentResolver)this.mContentResolver, (FileInputStream)fin, (String)title);
                if (item == null) {
                    Log.w((String)TAG, (String)("unable to add file " + uri + " to DrmProvider"));
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"IOException caught while opening or reading stream", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"IOException caught while closing stream", (Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean copyMedia(long msgId) {
        boolean result = true;
        PduBody body = PduBodyCache.getPduBody((Context)this, ContentUris.withAppendedId((Uri)Telephony.Mms.CONTENT_URI, (long)msgId));
        if (body == null) {
            return false;
        }
        int partNum = body.getPartsNum();
        for (int i = 0; i < partNum; ++i) {
            PduPart part = body.getPart(i);
            String type = new String(part.getContentType());
            if (!ContentType.isImageType((String)type) && !ContentType.isVideoType((String)type) && !ContentType.isAudioType((String)type)) continue;
            result &= this.copyPart(part, Long.toHexString(msgId));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyPart(PduPart part, String fallback) {
        Uri uri = part.getDataUri();
        InputStream input = null;
        FileOutputStream fout = null;
        try {
            input = this.mContentResolver.openInputStream(uri);
            if (input instanceof FileInputStream) {
                String extension;
                FileInputStream fin = (FileInputStream)input;
                byte[] location = part.getName();
                if (location == null) {
                    location = part.getFilename();
                }
                if (location == null) {
                    location = part.getContentLocation();
                }
                String fileName = location == null ? fallback : new String(location);
                String dir = Environment.getExternalStorageDirectory() + "/" + Environment.DIRECTORY_DOWNLOADS + "/";
                int index = fileName.indexOf(".");
                if (index == -1) {
                    String type = new String(part.getContentType());
                    extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(type);
                } else {
                    extension = fileName.substring(index + 1, fileName.length());
                    fileName = fileName.substring(0, index);
                }
                File file = this.getUniqueDestination(dir + fileName, extension);
                File parentFile = file.getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    Log.e((String)TAG, (String)("[MMS] copyPart: mkdirs for " + parentFile.getPath() + " failed!"));
                    boolean bl = false;
                    return bl;
                }
                fout = new FileOutputStream(file);
                byte[] buffer = new byte[8000];
                int size = 0;
                while ((size = fin.read(buffer)) != -1) {
                    fout.write(buffer, 0, size);
                }
                this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)file)));
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"IOException caught while opening or reading stream", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"IOException caught while closing stream", (Throwable)e);
                    return false;
                }
            }
            if (null != fout) {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"IOException caught while closing stream", (Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    private File getUniqueDestination(String base, String extension) {
        File file = new File(base + "." + extension);
        int i = 2;
        while (file.exists()) {
            file = new File(base + "_" + i + "." + extension);
            ++i;
        }
        return file;
    }

    private void showDeliveryReport(long messageId, String type) {
        Intent intent = new Intent((Context)this, DeliveryReportActivity.class);
        intent.putExtra("message_id", messageId);
        intent.putExtra("message_type", type);
        this.startActivity(intent);
    }

    private ContactList getRecipients() {
        if (this.isRecipientsEditorVisible()) {
            if (sEmptyContactList == null) {
                sEmptyContactList = new ContactList();
            }
            return sEmptyContactList;
        }
        return this.mConversation.getRecipients();
    }

    private void updateTitle(ContactList list) {
        String s;
        switch (list.size()) {
            case 0: {
                String recipient = "";
                if (this.mRecipientsEditor != null) {
                    recipient = this.mRecipientsEditor.getText().toString();
                }
                s = recipient;
                break;
            }
            case 1: {
                s = ((Contact)list.get(0)).getNameAndNumber();
                break;
            }
            default: {
                s = list.formatNames(", ");
            }
        }
        this.mDebugRecipients = list.serialize();
        this.getWindow().setTitle((CharSequence)s);
    }

    private void initRecipientsEditor() {
        if (this.isRecipientsEditorVisible()) {
            return;
        }
        ContactList recipients = this.getRecipients();
        ViewStub stub = (ViewStub)this.findViewById(2131361802);
        if (stub != null) {
            this.mRecipientsEditor = (RecipientsEditor)stub.inflate();
        } else {
            this.mRecipientsEditor = (RecipientsEditor)this.findViewById(2131361878);
            this.mRecipientsEditor.setVisibility(0);
        }
        this.mRecipientsEditor.setAdapter((ListAdapter)new RecipientsAdapter((Context)this));
        this.mRecipientsEditor.populate(recipients);
        this.mRecipientsEditor.setOnCreateContextMenuListener(this.mRecipientsMenuCreateListener);
        this.mRecipientsEditor.addTextChangedListener(this.mRecipientsWatcher);
        this.mRecipientsEditor.setFilters(new InputFilter[]{new InputFilter.LengthFilter(312)});
        this.mRecipientsEditor.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                InputMethodManager inputManager;
                if (!(ComposeMessageActivity.this.mRecipientsEditor.getRecipientCount() != 1 || (inputManager = (InputMethodManager)ComposeMessageActivity.this.getSystemService("input_method")) != null && inputManager.isFullscreenMode())) {
                    ComposeMessageActivity.this.mTextEditor.requestFocus();
                }
            }
        });
        this.mRecipientsEditor.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    RecipientsEditor editor = (RecipientsEditor)v;
                    ContactList contacts = editor.constructContactsFromInput();
                    ComposeMessageActivity.this.updateTitle(contacts);
                }
            }
        });
        this.mTopPanel.setVisibility(0);
    }

    public static boolean cancelFailedToDeliverNotification(Intent intent, Context context) {
        if (MessagingNotification.isFailedToDeliver(intent)) {
            MessagingNotification.cancelNotification(context, 789);
            return true;
        }
        return false;
    }

    public static boolean cancelFailedDownloadNotification(Intent intent, Context context) {
        if (MessagingNotification.isFailedToDownload(intent)) {
            MessagingNotification.cancelNotification(context, 531);
            return true;
        }
        return false;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903042);
        this.setProgressBarVisibility(false);
        this.getWindow().setSoftInputMode(18);
        this.initResourceRefs();
        this.mContentResolver = this.getContentResolver();
        this.mBackgroundQueryHandler = new BackgroundQueryHandler(this.mContentResolver);
        this.initialize(savedInstanceState, 0L);
    }

    private void showSubjectEditor(boolean show) {
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            ComposeMessageActivity.log("" + show);
        }
        if (this.mSubjectTextEditor == null) {
            if (!show) {
                return;
            }
            this.mSubjectTextEditor = (EditText)this.findViewById(2131361803);
        }
        this.mSubjectTextEditor.setOnKeyListener(show ? this.mSubjectKeyListener : null);
        if (show) {
            this.mSubjectTextEditor.addTextChangedListener(this.mSubjectEditorWatcher);
        } else {
            this.mSubjectTextEditor.removeTextChangedListener(this.mSubjectEditorWatcher);
        }
        this.mSubjectTextEditor.setText(this.mWorkingMessage.getSubject());
        this.mSubjectTextEditor.setVisibility(show ? 0 : 8);
        this.hideOrShowTopPanel();
    }

    private void hideOrShowTopPanel() {
        boolean anySubViewsVisible = this.isSubjectEditorVisible() || this.isRecipientsEditorVisible();
        this.mTopPanel.setVisibility(anySubViewsVisible ? 0 : 8);
    }

    public void initialize(Bundle savedInstanceState, long originalThreadId) {
        Intent intent = this.getIntent();
        this.mWorkingMessage = WorkingMessage.createEmpty(this);
        this.initActivityState(savedInstanceState, intent);
        if (originalThreadId != 0L && originalThreadId == this.mConversation.getThreadId()) {
            LogTag.warnPossibleRecipientMismatch("ComposeMessageActivity.initialize:  threadId didn't change from: " + originalThreadId, this);
        }
        ComposeMessageActivity.log("savedInstanceState = " + savedInstanceState + " intent = " + intent + " mConversation = " + this.mConversation);
        if (ComposeMessageActivity.cancelFailedToDeliverNotification(this.getIntent(), (Context)this)) {
            this.undeliveredMessageDialog(this.getMessageDate(null));
        }
        ComposeMessageActivity.cancelFailedDownloadNotification(this.getIntent(), (Context)this);
        this.initMessageList();
        boolean isForwardedMessage = false;
        if (!this.handleSendIntent(intent) && !(isForwardedMessage = this.handleForwardedMessage())) {
            this.loadDraft();
        }
        this.mWorkingMessage.setConversation(this.mConversation);
        if (this.mConversation.getThreadId() <= 0L) {
            this.hideRecipientEditor();
            this.initRecipientsEditor();
            this.getWindow().setSoftInputMode(20);
        } else {
            this.hideRecipientEditor();
        }
        this.updateSendButtonState();
        this.drawTopPanel();
        this.drawBottomPanel();
        this.mAttachmentEditor.update(this.mWorkingMessage);
        Configuration config = this.getResources().getConfiguration();
        this.mIsKeyboardOpen = config.keyboardHidden == 1;
        this.mIsLandscape = config.orientation == 2;
        this.onKeyboardStateChanged(this.mIsKeyboardOpen);
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            ComposeMessageActivity.log("update title, mConversation=" + this.mConversation.toString());
        }
        this.updateTitle(this.mConversation.getRecipients());
        if (isForwardedMessage && this.isRecipientsEditorVisible()) {
            this.mRecipientsEditor.requestFocus();
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
        Conversation conversation = null;
        this.mSentMessage = false;
        long originalThreadId = this.mConversation.getThreadId();
        long threadId = intent.getLongExtra("thread_id", 0L);
        Uri intentUri = intent.getData();
        boolean sameThread = false;
        if (threadId > 0L) {
            conversation = Conversation.get((Context)this, threadId, false);
        } else {
            if (this.mConversation.getThreadId() == 0L) {
                this.mWorkingMessage.syncWorkingRecipients();
                sameThread = this.mConversation.sameRecipient(intentUri);
            }
            if (!sameThread) {
                conversation = Conversation.get((Context)this, intentUri, false);
            }
        }
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            ComposeMessageActivity.log("data=" + intentUri + ", thread_id extra is " + threadId + ", new conversation=" + conversation + ", mConversation=" + this.mConversation);
        }
        if (conversation != null) {
            conversation.blockMarkAsRead(true);
            boolean bl = sameThread = conversation.getThreadId() == this.mConversation.getThreadId() && conversation.equals(this.mConversation);
        }
        if (sameThread) {
            ComposeMessageActivity.log("same conversation");
        } else {
            if (Log.isLoggable((String)"Mms:app", (int)2)) {
                ComposeMessageActivity.log("different conversation");
            }
            this.saveDraft();
            this.initialize(null, originalThreadId);
            this.loadMessageContent();
        }
    }

    protected void onRestart() {
        super.onRestart();
        if (this.mWorkingMessage.isDiscarded()) {
            if (this.mWorkingMessage.isWorthSaving()) {
                this.mWorkingMessage.unDiscard();
            } else if (this.isRecipientsEditorVisible()) {
                this.goToConversationList();
            } else {
                this.loadDraft();
                this.mWorkingMessage.setConversation(this.mConversation);
                this.mAttachmentEditor.update(this.mWorkingMessage);
            }
        }
    }

    protected void onStart() {
        super.onStart();
        this.mConversation.blockMarkAsRead(true);
        this.initFocus();
        this.registerReceiver(this.mHttpProgressReceiver, this.mHttpProgressFilter);
        this.loadMessageContent();
        this.mWorkingMessage.syncWorkingRecipients();
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            ComposeMessageActivity.log("update title, mConversation=" + this.mConversation.toString());
        }
        this.updateTitle(this.mConversation.getRecipients());
    }

    public void loadMessageContent() {
        this.startMsgListQuery();
        this.updateSendFailedNotification();
        this.drawBottomPanel();
    }

    private void updateSendFailedNotification() {
        final long threadId = this.mConversation.getThreadId();
        if (threadId <= 0L) {
            return;
        }
        new Thread(new Runnable(){

            public void run() {
                MessagingNotification.updateSendFailedNotificationForThread((Context)ComposeMessageActivity.this, threadId);
            }
        }, "updateSendFailedNotification").start();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("recipients", this.getRecipients().serialize());
        this.mWorkingMessage.writeStateToBundle(outState);
        if (this.mExitOnSent) {
            outState.putBoolean("exit_on_sent", this.mExitOnSent);
        }
    }

    protected void onResume() {
        super.onResume();
        this.addRecipientsListeners();
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            ComposeMessageActivity.log("update title, mConversation=" + this.mConversation.toString());
        }
        this.mMessageListItemHandler.postDelayed(new Runnable(){

            public void run() {
                ContactList recipients = ComposeMessageActivity.this.isRecipientsEditorVisible() ? ComposeMessageActivity.this.mRecipientsEditor.constructContactsFromInput() : ComposeMessageActivity.this.getRecipients();
                ComposeMessageActivity.this.updateTitle(recipients);
            }
        }, 100L);
    }

    protected void onPause() {
        super.onPause();
        this.removeRecipientsListeners();
    }

    protected void onStop() {
        super.onStop();
        this.mConversation.blockMarkAsRead(false);
        if (this.mMsgListAdapter != null) {
            this.mMsgListAdapter.changeCursor(null);
        }
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            ComposeMessageActivity.log("save draft");
        }
        this.saveDraft();
        this.unregisterReceiver(this.mHttpProgressReceiver);
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        boolean isLandscape;
        super.onConfigurationChanged(newConfig);
        this.mIsKeyboardOpen = newConfig.keyboardHidden == 1;
        boolean bl = isLandscape = newConfig.orientation == 2;
        if (this.mIsLandscape != isLandscape) {
            this.mIsLandscape = isLandscape;
            this.mAttachmentEditor.update(this.mWorkingMessage);
        }
        this.onKeyboardStateChanged(this.mIsKeyboardOpen);
    }

    private void onKeyboardStateChanged(boolean isKeyboardOpen) {
        if (isKeyboardOpen) {
            if (this.mRecipientsEditor != null) {
                this.mRecipientsEditor.setFocusableInTouchMode(true);
            }
            if (this.mSubjectTextEditor != null) {
                this.mSubjectTextEditor.setFocusableInTouchMode(true);
            }
            this.mTextEditor.setFocusableInTouchMode(true);
            this.mTextEditor.setHint(2131165251);
        } else {
            if (this.mRecipientsEditor != null) {
                this.mRecipientsEditor.setFocusable(false);
            }
            if (this.mSubjectTextEditor != null) {
                this.mSubjectTextEditor.setFocusable(false);
            }
            this.mTextEditor.setFocusable(false);
            this.mTextEditor.setHint(2131165252);
        }
    }

    public void onUserInteraction() {
        this.checkPendingNotification();
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        if (hasFocus) {
            this.checkPendingNotification();
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 67: {
                Cursor cursor;
                if (this.mMsgListAdapter == null || !this.mMsgListView.isFocused()) break;
                try {
                    cursor = (Cursor)this.mMsgListView.getSelectedItem();
                }
                catch (ClassCastException e) {
                    Log.e((String)TAG, (String)"Unexpected ClassCastException.", (Throwable)e);
                    return super.onKeyDown(keyCode, event);
                }
                if (cursor == null) break;
                boolean locked = cursor.getInt(20) != 0;
                DeleteMessageListener l = new DeleteMessageListener(cursor.getLong(1), cursor.getString(0), locked);
                this.confirmDeleteDialog(l, locked);
                return true;
            }
            case 23: 
            case 66: {
                if (!this.isPreparedForSending()) break;
                this.confirmSendMessageIfNeeded();
                return true;
            }
            case 4: {
                this.exitComposeMessageActivity(new Runnable(){

                    public void run() {
                        ComposeMessageActivity.this.finish();
                    }
                });
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    private void exitComposeMessageActivity(Runnable exit) {
        if (!this.mWorkingMessage.isWorthSaving()) {
            exit.run();
            return;
        }
        if (this.isRecipientsEditorVisible() && !this.mRecipientsEditor.hasValidRecipient(this.mWorkingMessage.requiresMms())) {
            MessageUtils.showDiscardDraftConfirmDialog((Context)this, new DiscardDraftListener());
            return;
        }
        this.mToastForDraftSave = true;
        exit.run();
    }

    private void goToConversationList() {
        this.finish();
        this.startActivity(new Intent((Context)this, ConversationList.class));
    }

    private void hideRecipientEditor() {
        if (this.mRecipientsEditor != null) {
            this.mRecipientsEditor.removeTextChangedListener(this.mRecipientsWatcher);
            this.mRecipientsEditor.setVisibility(8);
            this.hideOrShowTopPanel();
        }
    }

    private boolean isRecipientsEditorVisible() {
        return null != this.mRecipientsEditor && 0 == this.mRecipientsEditor.getVisibility();
    }

    private boolean isSubjectEditorVisible() {
        return null != this.mSubjectTextEditor && 0 == this.mSubjectTextEditor.getVisibility();
    }

    public void onAttachmentChanged() {
        this.runOnUiThread(new Runnable(){

            public void run() {
                ComposeMessageActivity.this.drawBottomPanel();
                ComposeMessageActivity.this.updateSendButtonState();
                ComposeMessageActivity.this.mAttachmentEditor.update(ComposeMessageActivity.this.mWorkingMessage);
            }
        });
    }

    public void onProtocolChanged(final boolean mms) {
        this.runOnUiThread(new Runnable(){

            public void run() {
                ComposeMessageActivity.this.toastConvertInfo(mms);
                ComposeMessageActivity.this.setSendButtonText(mms);
            }
        });
    }

    private void setSendButtonText(boolean isMms) {
        Button sendButton = this.mSendButton;
        sendButton.setText(2131165248);
        if (isMms) {
            sendButton.append((CharSequence)"\n");
            SpannableString spannable = new SpannableString((CharSequence)this.getString(2131165249));
            int mmsTextSize = (int)(sendButton.getTextSize() * 0.75f);
            spannable.setSpan((Object)new AbsoluteSizeSpan(mmsTextSize), 0, spannable.length(), 0);
            sendButton.append((CharSequence)spannable);
            this.mTextCounter.setText((CharSequence)"");
        }
    }

    public void onPreMessageSent() {
        this.runOnUiThread(this.mResetMessageRunnable);
    }

    public void onMessageSent() {
        if (this.mMsgListAdapter.getCount() == 0) {
            this.startMsgListQuery();
        }
    }

    public void onMaxPendingMessagesReached() {
        this.saveDraft();
        this.runOnUiThread(new Runnable(){

            public void run() {
                Toast.makeText((Context)ComposeMessageActivity.this, (int)2131165470, (int)1).show();
            }
        });
    }

    public void onAttachmentError(final int error) {
        this.runOnUiThread(new Runnable(){

            public void run() {
                ComposeMessageActivity.this.handleAddAttachmentError(error, 2131165416);
                ComposeMessageActivity.this.onMessageSent();
            }
        });
    }

    private boolean isRecipientCallable() {
        ContactList recipients = this.getRecipients();
        return recipients.size() == 1 && !recipients.containsEmail();
    }

    private void dialRecipient() {
        String number = ((Contact)this.getRecipients().get(0)).getNumber();
        Intent dialIntent = new Intent("android.intent.action.CALL", Uri.parse((String)("tel:" + number)));
        this.startActivity(dialIntent);
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        ContactList recipients;
        menu.clear();
        if (this.isRecipientCallable()) {
            menu.add(0, 5, 0, 2131165192).setIcon(2130837554);
        }
        if ((recipients = this.getRecipients()).size() == 1 && ((Contact)recipients.get(0)).existsInDatabase()) {
            menu.add(0, 12, 0, 2131165298).setIcon(2130837555);
        }
        if (MmsConfig.getMmsEnabled()) {
            if (!this.isSubjectEditorVisible()) {
                menu.add(0, 0, 0, 2131165243).setIcon(2130837558);
            }
            if (!this.mWorkingMessage.hasAttachment()) {
                menu.add(0, 2, 0, 2131165242).setIcon(2130837553);
            }
        }
        if (this.isPreparedForSending()) {
            menu.add(0, 4, 0, 2131165248).setIcon(17301584);
        }
        menu.add(0, 26, 0, 0x7F0700FF).setIcon(2130837559);
        if (this.mMsgListAdapter.getCount() > 0) {
            Cursor cursor = this.mMsgListAdapter.getCursor();
            if (null != cursor && cursor.getCount() > 0) {
                menu.add(0, 1, 0, 2131165214).setIcon(17301564);
            }
        } else {
            menu.add(0, 3, 0, 2131165244).setIcon(17301564);
        }
        menu.add(0, 6, 0, 2131165250).setIcon(2130837560);
        this.buildAddAddressToContactMenuItem(menu);
        return true;
    }

    private void buildAddAddressToContactMenuItem(Menu menu) {
        for (Contact c : this.getRecipients()) {
            if (c.existsInDatabase() || !this.canAddToContacts(c)) continue;
            Intent intent = ConversationList.createAddContactIntent(c.getNumber());
            menu.add(0, 27, 0, 2131165299).setIcon(17301555).setIntent(intent);
            break;
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 0: {
                this.showSubjectEditor(true);
                this.mWorkingMessage.setSubject("", true);
                this.mSubjectTextEditor.requestFocus();
                break;
            }
            case 2: {
                this.showAddAttachmentDialog(false);
                break;
            }
            case 3: {
                this.mWorkingMessage.discard();
                this.finish();
                break;
            }
            case 4: {
                if (!this.isPreparedForSending()) break;
                this.confirmSendMessageIfNeeded();
                break;
            }
            case 19: {
                this.onSearchRequested();
                break;
            }
            case 1: {
                this.confirmDeleteThread(this.mConversation.getThreadId());
                break;
            }
            case 6: {
                this.exitComposeMessageActivity(new Runnable(){

                    public void run() {
                        ComposeMessageActivity.this.goToConversationList();
                    }
                });
                break;
            }
            case 5: {
                this.dialRecipient();
                break;
            }
            case 26: {
                this.showSmileyDialog();
                break;
            }
            case 12: {
                ContactList list = this.getRecipients();
                if (list.size() != 1 || !((Contact)list.get(0)).existsInDatabase()) break;
                Uri contactUri = ((Contact)list.get(0)).getUri();
                Intent intent = new Intent("android.intent.action.VIEW", contactUri);
                intent.setFlags(524288);
                this.startActivity(intent);
                break;
            }
            case 27: {
                this.mAddContactIntent = item.getIntent();
                this.startActivityForResult(this.mAddContactIntent, 18);
            }
        }
        return true;
    }

    private void confirmDeleteThread(long threadId) {
        Conversation.startQueryHaveLockedMessages(this.mBackgroundQueryHandler, threadId, 1802);
    }

    private int getVideoCaptureDurationLimit() {
        return CamcorderProfile.get((int)0).duration;
    }

    private void addAttachment(int type, boolean replace) {
        int currentSlideSize = 0;
        SlideshowModel slideShow = this.mWorkingMessage.getSlideshow();
        if (replace && slideShow != null) {
            SlideModel slide = slideShow.get(0);
            currentSlideSize = slide.getSlideSize();
        }
        switch (type) {
            case 0: {
                MessageUtils.selectImage((Context)this, 10);
                break;
            }
            case 1: {
                Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
                intent.putExtra("output", (Parcelable)Telephony.Mms.ScrapSpace.CONTENT_URI);
                this.startActivityForResult(intent, 11);
                break;
            }
            case 2: {
                MessageUtils.selectVideo((Context)this, 12);
                break;
            }
            case 3: {
                long sizeLimit = MmsConfig.getMaxMessageSize() - 1024;
                if (slideShow != null) {
                    sizeLimit -= (long)slideShow.getCurrentMessageSize();
                    sizeLimit += (long)currentSlideSize;
                }
                if (sizeLimit > 0L) {
                    int durationLimit = this.getVideoCaptureDurationLimit();
                    Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
                    intent.putExtra("android.intent.extra.videoQuality", 0);
                    intent.putExtra("android.intent.extra.sizeLimit", sizeLimit);
                    intent.putExtra("android.intent.extra.durationLimit", durationLimit);
                    this.startActivityForResult(intent, 13);
                    break;
                }
                Toast.makeText((Context)this, (CharSequence)this.getString(2131165259), (int)0).show();
                break;
            }
            case 4: {
                MessageUtils.selectAudio((Context)this, 14);
                break;
            }
            case 5: {
                MessageUtils.recordSound((Context)this, 15);
                break;
            }
            case 6: {
                this.editSlideshow();
                break;
            }
        }
    }

    private void showAddAttachmentDialog(final boolean replace) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setIcon(2130837533);
        builder.setTitle(2131165242);
        if (this.mAttachmentTypeSelectorAdapter == null) {
            this.mAttachmentTypeSelectorAdapter = new AttachmentTypeSelectorAdapter((Context)this, 0);
        }
        builder.setAdapter((ListAdapter)this.mAttachmentTypeSelectorAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ComposeMessageActivity.this.addAttachment(ComposeMessageActivity.this.mAttachmentTypeSelectorAdapter.buttonToCommand(which), replace);
                dialog.dismiss();
            }
        });
        builder.show();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mWaitingForSubActivity = false;
        if (this.mWorkingMessage.isFakeMmsForDraft()) {
            this.mWorkingMessage.removeFakeMmsForDraft();
        }
        if (requestCode != 11 ? data == null : resultCode != -1) {
            return;
        }
        switch (requestCode) {
            case 16: {
                WorkingMessage newMessage;
                if (data == null || (newMessage = WorkingMessage.load(this, data.getData())) == null) break;
                this.mWorkingMessage = newMessage;
                this.mWorkingMessage.setConversation(this.mConversation);
                this.mAttachmentEditor.update(this.mWorkingMessage);
                this.drawTopPanel();
                this.updateSendButtonState();
                break;
            }
            case 11: {
                File file = new File("/sdcard/mms/scrapSpace/.temp.jpg");
                Uri uri = Uri.fromFile((File)file);
                this.addImage(uri, false);
                break;
            }
            case 10: {
                this.addImage(data.getData(), false);
                break;
            }
            case 12: 
            case 13: {
                this.addVideo(data.getData(), false);
                break;
            }
            case 14: {
                Uri uri = (Uri)data.getParcelableExtra("android.intent.extra.ringtone.PICKED_URI");
                if (Settings.System.DEFAULT_RINGTONE_URI.equals((Object)uri)) break;
                this.addAudio(uri);
                break;
            }
            case 15: {
                this.addAudio(data.getData());
                break;
            }
            case 17: {
                boolean outOfEmergencyMode = data.getBooleanExtra(EXIT_ECM_RESULT, false);
                if (!outOfEmergencyMode) break;
                this.sendMessage(false);
                break;
            }
            case 18: {
                Contact contact;
                if (this.mAddContactIntent == null) break;
                String address = this.mAddContactIntent.getStringExtra("email");
                if (address == null) {
                    address = this.mAddContactIntent.getStringExtra("phone");
                }
                if (address == null || (contact = Contact.get(address, false)) == null) break;
                contact.reload();
                break;
            }
        }
    }

    private void handleAddAttachmentError(final int error, final int mediaTypeStringId) {
        if (error == 0) {
            return;
        }
        this.runOnUiThread(new Runnable(){

            public void run() {
                String message2;
                String title;
                Resources res = ComposeMessageActivity.this.getResources();
                String mediaType = res.getString(mediaTypeStringId);
                switch (error) {
                    case -1: {
                        String message2 = res.getString(2131165260, new Object[]{mediaType});
                        Toast.makeText((Context)ComposeMessageActivity.this, (CharSequence)message2, (int)0).show();
                        return;
                    }
                    case -3: {
                        title = res.getString(2131165256, new Object[]{mediaType});
                        message2 = res.getString(2131165257, new Object[]{mediaType});
                        break;
                    }
                    case -2: {
                        title = res.getString(2131165258, new Object[]{mediaType});
                        message2 = res.getString(2131165260, new Object[]{mediaType});
                        break;
                    }
                    case -4: {
                        title = res.getString(2131165261);
                        message2 = res.getString(2131165262);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown error " + error);
                    }
                }
                MessageUtils.showErrorDialog((Context)ComposeMessageActivity.this, title, message2);
            }
        });
    }

    private void addImage(Uri uri, boolean append) {
        int result;
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            ComposeMessageActivity.log("append=" + append + ", uri=" + uri);
        }
        if ((result = this.mWorkingMessage.setAttachment(1, uri, append)) == -4 || result == -2) {
            if (Log.isLoggable((String)"Mms:app", (int)2)) {
                ComposeMessageActivity.log("resize image " + uri);
            }
            MessageUtils.resizeImageAsync((Context)this, uri, this.mAttachmentEditorHandler, this.mResizeImageCallback, append);
            return;
        }
        this.handleAddAttachmentError(result, 2131165416);
    }

    private void addVideo(Uri uri, boolean append) {
        if (uri != null) {
            int result = this.mWorkingMessage.setAttachment(2, uri, append);
            this.handleAddAttachmentError(result, 2131165417);
        }
    }

    private void addAudio(Uri uri) {
        int result = this.mWorkingMessage.setAttachment(3, uri, false);
        this.handleAddAttachmentError(result, 2131165415);
    }

    private boolean handleForwardedMessage() {
        Intent intent = this.getIntent();
        if (!intent.getBooleanExtra("forwarded_message", false)) {
            return false;
        }
        Uri uri = (Uri)intent.getParcelableExtra("msg_uri");
        if (Log.isLoggable((String)"Mms:app", (int)3)) {
            ComposeMessageActivity.log("" + uri);
        }
        if (uri != null) {
            this.mWorkingMessage = WorkingMessage.load(this, uri);
            this.mWorkingMessage.setSubject(intent.getStringExtra("subject"), false);
        } else {
            this.mWorkingMessage.setText(intent.getStringExtra("sms_body"));
        }
        this.mMsgListAdapter.changeCursor(null);
        return true;
    }

    private boolean handleSendIntent(Intent intent) {
        Bundle extras = intent.getExtras();
        if (extras == null) {
            return false;
        }
        final String mimeType = intent.getType();
        String action = intent.getAction();
        if ("android.intent.action.SEND".equals(action)) {
            if (extras.containsKey("android.intent.extra.STREAM")) {
                Uri uri = (Uri)extras.getParcelable("android.intent.extra.STREAM");
                this.addAttachment(mimeType, uri, false);
                return true;
            }
            if (extras.containsKey("android.intent.extra.TEXT")) {
                this.mWorkingMessage.setText(extras.getString("android.intent.extra.TEXT"));
                return true;
            }
        } else if ("android.intent.action.SEND_MULTIPLE".equals(action) && extras.containsKey("android.intent.extra.STREAM")) {
            SlideshowModel slideShow = this.mWorkingMessage.getSlideshow();
            final ArrayList uris = extras.getParcelableArrayList("android.intent.extra.STREAM");
            int currentSlideCount = slideShow != null ? slideShow.size() : 0;
            int importCount = uris.size();
            if (importCount + currentSlideCount > 10) {
                importCount = Math.min(10 - currentSlideCount, importCount);
                Toast.makeText((Context)this, (CharSequence)this.getString(2131165281, new Object[]{10, importCount}), (int)1).show();
            }
            final AlertDialog dialog = new AlertDialog.Builder((Context)this).setIcon(17301543).setTitle(2131165282).setMessage(2131165283).create();
            final Runnable showProgress = new Runnable(){

                public void run() {
                    dialog.show();
                }
            };
            this.mAttachmentEditorHandler.postDelayed(showProgress, 1000L);
            final int numberToImport = importCount;
            new Thread(new Runnable(){

                public void run() {
                    for (int i = 0; i < numberToImport; ++i) {
                        Parcelable uri = (Parcelable)uris.get(i);
                        ComposeMessageActivity.this.addAttachment(mimeType, (Uri)uri, true);
                    }
                    ComposeMessageActivity.this.mAttachmentEditorHandler.removeCallbacks(showProgress);
                    dialog.dismiss();
                }
            }, "addAttachment").start();
            return true;
        }
        return false;
    }

    private void addAttachment(String type, Uri uri, boolean append) {
        if (uri != null) {
            boolean wildcard = "*/*".equals(type);
            if (type.startsWith("image/") || wildcard && uri.toString().startsWith(mImageUri)) {
                this.addImage(uri, append);
            } else if (type.startsWith("video/") || wildcard && uri.toString().startsWith(mVideoUri)) {
                this.addVideo(uri, append);
            }
        }
    }

    private String getResourcesString(int id2, String mediaName) {
        Resources r = this.getResources();
        return r.getString(id2, new Object[]{mediaName});
    }

    private void drawBottomPanel() {
        this.resetCounter();
        if (this.mWorkingMessage.hasSlideshow()) {
            this.mBottomPanel.setVisibility(8);
            this.mAttachmentEditor.requestFocus();
            return;
        }
        this.mBottomPanel.setVisibility(0);
        CharSequence text = this.mWorkingMessage.getText();
        if (text != null) {
            this.mTextEditor.setTextKeepState(text);
        } else {
            this.mTextEditor.setText((CharSequence)"");
        }
    }

    private void drawTopPanel() {
        this.showSubjectEditor(this.mWorkingMessage.hasSubject());
    }

    public void onClick(View v) {
        if (v == this.mSendButton && this.isPreparedForSending()) {
            this.confirmSendMessageIfNeeded();
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (event != null) {
            if (!event.isShiftPressed()) {
                if (this.isPreparedForSending()) {
                    this.confirmSendMessageIfNeeded();
                }
                return true;
            }
            return false;
        }
        if (this.isPreparedForSending()) {
            this.confirmSendMessageIfNeeded();
        }
        return true;
    }

    private void ensureCorrectButtonHeight() {
        int currentTextLines = this.mTextEditor.getLineCount();
        if (currentTextLines <= 2) {
            this.mTextCounter.setVisibility(8);
        } else if (currentTextLines > 2 && this.mTextCounter.getVisibility() == 8) {
            this.mTextCounter.setVisibility(4);
        }
    }

    private void initResourceRefs() {
        this.mMsgListView = (MessageListView)this.findViewById(2131361804);
        this.mMsgListView.setDivider(null);
        this.mBottomPanel = this.findViewById(2131361814);
        this.mTextEditor = (EditText)this.findViewById(2131361815);
        this.mTextEditor.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mTextEditor.addTextChangedListener(this.mTextEditorWatcher);
        this.mTextEditor.setFilters(new InputFilter[]{new InputFilter.LengthFilter(MmsConfig.getMaxTextLimit())});
        this.mTextCounter = (TextView)this.findViewById(2131361818);
        this.mSendButton = (Button)this.findViewById(2131361816);
        this.mSendButton.setOnClickListener((View.OnClickListener)this);
        this.mTopPanel = this.findViewById(2131361801);
        this.mTopPanel.setFocusable(false);
        this.mAttachmentEditor = (AttachmentEditor)this.findViewById(2131361805);
        this.mAttachmentEditor.setHandler(this.mAttachmentEditorHandler);
    }

    private void confirmDeleteDialog(DialogInterface.OnClickListener listener, boolean locked) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle(locked ? 2131165343 : 2131165342);
        builder.setIcon(17301543);
        builder.setCancelable(true);
        builder.setMessage(locked ? 2131165347 : 2131165346);
        builder.setPositiveButton(2131165352, listener);
        builder.setNegativeButton(2131165302, null);
        builder.show();
    }

    void undeliveredMessageDialog(long date) {
        LinearLayout dialog = (LinearLayout)LayoutInflater.from((Context)this).inflate(2130903063, null);
        String body = date >= 0L ? this.getString(2131165212, new Object[]{MessageUtils.formatTimeStampString((Context)this, date)}) : this.getString(2131165213);
        ((TextView)dialog.findViewById(2131361880)).setText((CharSequence)body);
        Toast undeliveredDialog = new Toast((Context)this);
        undeliveredDialog.setView((View)dialog);
        undeliveredDialog.setDuration(1);
        undeliveredDialog.show();
    }

    private void startMsgListQuery() {
        Uri conversationUri = this.mConversation.getUri();
        if (conversationUri == null) {
            return;
        }
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            ComposeMessageActivity.log("for " + conversationUri);
        }
        this.mBackgroundQueryHandler.cancelOperation(9527);
        try {
            this.mBackgroundQueryHandler.startQuery(9527, null, conversationUri, MessageListAdapter.PROJECTION, null, null, null);
        }
        catch (SQLiteException e) {
            SqliteWrapper.checkSQLiteException((Context)this, (SQLiteException)e);
        }
    }

    private void initMessageList() {
        if (this.mMsgListAdapter != null) {
            return;
        }
        String highlightString = this.getIntent().getStringExtra("highlight");
        Pattern highlight = highlightString == null ? null : Pattern.compile("\\b" + Pattern.quote(highlightString), 2);
        this.mMsgListAdapter = new MessageListAdapter((Context)this, null, this.mMsgListView, true, highlight);
        this.mMsgListAdapter.setOnDataSetChangedListener(this.mDataSetChangedListener);
        this.mMsgListAdapter.setMsgListItemHandler(this.mMessageListItemHandler);
        this.mMsgListView.setAdapter((ListAdapter)this.mMsgListAdapter);
        this.mMsgListView.setItemsCanFocus(false);
        this.mMsgListView.setVisibility(0);
        this.mMsgListView.setOnCreateContextMenuListener(this.mMsgListMenuCreateListener);
        this.mMsgListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (view != null) {
                    ((MessageListItem)view).onMessageListItemClick();
                }
            }
        });
    }

    private void loadDraft() {
        if (this.mWorkingMessage.isWorthSaving()) {
            Log.w((String)TAG, (String)"called with non-empty working message");
            return;
        }
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            ComposeMessageActivity.log("call WorkingMessage.loadDraft");
        }
        this.mWorkingMessage = WorkingMessage.loadDraft(this, this.mConversation);
    }

    private void saveDraft() {
        if (this.mWorkingMessage.isDiscarded()) {
            return;
        }
        if (!this.mWaitingForSubActivity && !this.mWorkingMessage.isWorthSaving()) {
            if (Log.isLoggable((String)"Mms:app", (int)2)) {
                ComposeMessageActivity.log("not worth saving, discard WorkingMessage and bail");
            }
            this.mWorkingMessage.discard();
            return;
        }
        this.mWorkingMessage.saveDraft();
        if (this.mToastForDraftSave) {
            Toast.makeText((Context)this, (int)2131165278, (int)0).show();
        }
    }

    private boolean isPreparedForSending() {
        int recipientCount = this.recipientCount();
        return recipientCount > 0 && recipientCount <= MmsConfig.getRecipientLimit() && (this.mWorkingMessage.hasAttachment() || this.mWorkingMessage.hasText());
    }

    private int recipientCount() {
        int recipientCount = this.isRecipientsEditorVisible() ? this.mRecipientsEditor.getRecipientCount() : this.getRecipients().size();
        return recipientCount;
    }

    private void sendMessage(boolean bCheckEcmMode) {
        String inEcm;
        if (bCheckEcmMode && Boolean.parseBoolean(inEcm = SystemProperties.get((String)"ril.cdma.inecmmode"))) {
            try {
                this.startActivityForResult(new Intent("android.intent.action.ACTION_SHOW_NOTICE_ECM_BLOCK_OTHERS", null), 17);
                return;
            }
            catch (ActivityNotFoundException e) {
                Log.e((String)TAG, (String)"Cannot find EmergencyCallbackModeExitDialog", (Throwable)e);
            }
        }
        if (!this.mSendingMessage) {
            String workingRecipients;
            String sendingRecipients = this.mConversation.getRecipients().serialize();
            if (!sendingRecipients.equals(this.mDebugRecipients) && !this.mDebugRecipients.equals(workingRecipients = this.mWorkingMessage.getWorkingRecipients())) {
                LogTag.warnPossibleRecipientMismatch("ComposeMessageActivity.sendMessage recipients in window: \"" + this.mDebugRecipients + "\" differ from recipients from conv: \"" + sendingRecipients + "\" and working recipients: " + workingRecipients, this);
            }
            this.removeRecipientsListeners();
            this.mWorkingMessage.send(this.mDebugRecipients);
            this.mSentMessage = true;
            this.mSendingMessage = true;
            this.addRecipientsListeners();
        }
        if (this.mExitOnSent) {
            this.finish();
        }
    }

    private void resetMessage() {
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            ComposeMessageActivity.log("");
        }
        this.mAttachmentEditor.hideView();
        this.showSubjectEditor(false);
        this.mTextEditor.requestFocus();
        this.mTextEditor.removeTextChangedListener(this.mTextEditorWatcher);
        TextKeyListener.clear((Editable)this.mTextEditor.getText());
        this.mWorkingMessage = WorkingMessage.createEmpty(this);
        this.mWorkingMessage.setConversation(this.mConversation);
        this.hideRecipientEditor();
        this.drawBottomPanel();
        this.updateSendButtonState();
        this.mTextEditor.addTextChangedListener(this.mTextEditorWatcher);
        if (this.mIsLandscape) {
            InputMethodManager inputMethodManager = (InputMethodManager)this.getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(this.mTextEditor.getWindowToken(), 0);
        }
        this.mLastRecipientCount = 0;
        this.mSendingMessage = false;
    }

    private void updateSendButtonState() {
        boolean enable = false;
        if (this.isPreparedForSending()) {
            if (!this.mWorkingMessage.hasSlideshow()) {
                enable = true;
            } else {
                this.mAttachmentEditor.setCanSend(true);
            }
        } else if (null != this.mAttachmentEditor) {
            this.mAttachmentEditor.setCanSend(false);
        }
        this.setSendButtonText(this.mWorkingMessage.requiresMms());
        this.mSendButton.setEnabled(enable);
        this.mSendButton.setFocusable(enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMessageDate(Uri uri) {
        Cursor cursor;
        if (uri != null && (cursor = SqliteWrapper.query((Context)this, (ContentResolver)this.mContentResolver, (Uri)uri, (String[])new String[]{"date"}, null, null, null)) != null) {
            try {
                if (cursor.getCount() == 1 && cursor.moveToFirst()) {
                    long l = cursor.getLong(0) * 1000L;
                    return l;
                }
            }
            finally {
                cursor.close();
            }
        }
        return -1L;
    }

    private void initActivityState(Bundle bundle, Intent intent) {
        if (bundle != null) {
            String recipients = bundle.getString("recipients");
            this.mConversation = Conversation.get((Context)this, ContactList.getByNumbers(recipients, false, true), false);
            this.addRecipientsListeners();
            this.mExitOnSent = bundle.getBoolean("exit_on_sent", false);
            this.mWorkingMessage.readStateFromBundle(bundle);
            return;
        }
        long threadId = intent.getLongExtra("thread_id", 0L);
        if (threadId > 0L) {
            this.mConversation = Conversation.get((Context)this, threadId, false);
        } else {
            Uri intentData = intent.getData();
            if (intentData != null) {
                this.mConversation = Conversation.get((Context)this, intentData, false);
                this.mWorkingMessage.setText(this.getBody(intentData));
            } else {
                String address = intent.getStringExtra("address");
                this.mConversation = !TextUtils.isEmpty((CharSequence)address) ? Conversation.get((Context)this, ContactList.getByNumbers(address, false, true), false) : Conversation.createNew((Context)this);
            }
        }
        this.addRecipientsListeners();
        this.mExitOnSent = intent.getBooleanExtra("exit_on_sent", false);
        if (intent.hasExtra("sms_body")) {
            this.mWorkingMessage.setText(intent.getStringExtra("sms_body"));
        }
        this.mWorkingMessage.setSubject(intent.getStringExtra("subject"), false);
    }

    private void initFocus() {
        if (!this.mIsKeyboardOpen) {
            return;
        }
        if (this.isRecipientsEditorVisible() && TextUtils.isEmpty((CharSequence)this.mRecipientsEditor.getText()) && !this.mTextEditor.isFocused()) {
            this.mRecipientsEditor.requestFocus();
            return;
        }
        this.mTextEditor.requestFocus();
    }

    private void checkPendingNotification() {
        if (this.mPossiblePendingNotification && this.hasWindowFocus()) {
            this.mConversation.markAsRead();
            this.mPossiblePendingNotification = false;
        }
    }

    private void showSmileyDialog() {
        if (this.mSmileyDialog == null) {
            int[] icons = SmileyParser.DEFAULT_SMILEY_RES_IDS;
            String[] names = this.getResources().getStringArray(2131034113);
            String[] texts = this.getResources().getStringArray(2131034112);
            int N = names.length;
            ArrayList entries = new ArrayList();
            for (int i = 0; i < N; ++i) {
                boolean added = false;
                for (int j = 0; j < i; ++j) {
                    if (icons[i] != icons[j]) continue;
                    added = true;
                    break;
                }
                if (added) continue;
                HashMap<String, Object> entry = new HashMap<String, Object>();
                entry.put("icon", icons[i]);
                entry.put("name", names[i]);
                entry.put("text", texts[i]);
                entries.add(entry);
            }
            final SimpleAdapter a = new SimpleAdapter((Context)this, entries, 2130903071, new String[]{"icon", "name", "text"}, new int[]{2131361897, 2131361898, 2131361899});
            SimpleAdapter.ViewBinder viewBinder = new SimpleAdapter.ViewBinder(){

                public boolean setViewValue(View view, Object data, String textRepresentation) {
                    if (view instanceof ImageView) {
                        Drawable img = ComposeMessageActivity.this.getResources().getDrawable(((Integer)data).intValue());
                        ((ImageView)view).setImageDrawable(img);
                        return true;
                    }
                    return false;
                }
            };
            a.setViewBinder(viewBinder);
            AlertDialog.Builder b = new AlertDialog.Builder((Context)this);
            b.setTitle((CharSequence)this.getString(0x7F0700FF));
            b.setCancelable(true);
            b.setAdapter((ListAdapter)a, new DialogInterface.OnClickListener(){

                public final void onClick(DialogInterface dialog, int which) {
                    HashMap item = (HashMap)a.getItem(which);
                    ComposeMessageActivity.this.mTextEditor.append((CharSequence)((String)item.get("text")));
                    dialog.dismiss();
                }
            });
            this.mSmileyDialog = b.create();
        }
        this.mSmileyDialog.show();
    }

    public void onUpdate(final Contact updated) {
        this.mMessageListItemHandler.post(new Runnable(){

            public void run() {
                ContactList recipients;
                ContactList contactList = recipients = ComposeMessageActivity.this.isRecipientsEditorVisible() ? ComposeMessageActivity.this.mRecipientsEditor.constructContactsFromInput() : ComposeMessageActivity.this.getRecipients();
                if (Log.isLoggable((String)"Mms:app", (int)2)) {
                    ComposeMessageActivity.log("[CMA] onUpdate contact updated: " + updated);
                    ComposeMessageActivity.log("[CMA] onUpdate recipients: " + recipients);
                }
                ComposeMessageActivity.this.updateTitle(recipients);
                ComposeMessageActivity.this.mMsgListAdapter.notifyDataSetChanged();
                if (ComposeMessageActivity.this.mRecipientsEditor != null) {
                    ComposeMessageActivity.this.mRecipientsEditor.populate(recipients);
                }
            }
        });
    }

    private void addRecipientsListeners() {
        Contact.addListener(this);
    }

    private void removeRecipientsListeners() {
        Contact.removeListener(this);
    }

    public static Intent createIntent(Context context, long threadId) {
        Intent intent = new Intent(context, ComposeMessageActivity.class);
        if (threadId > 0L) {
            intent.setData(Conversation.getUri(threadId));
        }
        return intent;
    }

    private String getBody(Uri uri) {
        String[] params;
        if (uri == null) {
            return null;
        }
        String urlStr = uri.getSchemeSpecificPart();
        if (!urlStr.contains("?")) {
            return null;
        }
        urlStr = urlStr.substring(urlStr.indexOf(63) + 1);
        for (String p : params = urlStr.split("&")) {
            if (!p.startsWith("body=")) continue;
            try {
                return URLDecoder.decode(p.substring(5), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        mVideoUri = MediaStore.Video.Media.getContentUri((String)"external").toString();
        mImageUri = MediaStore.Images.Media.getContentUri((String)"external").toString();
    }

    private final class BackgroundQueryHandler
    extends AsyncQueryHandler {
        public BackgroundQueryHandler(ContentResolver contentResolver) {
            super(contentResolver);
        }

        protected void onQueryComplete(int token, Object cookie, Cursor cursor) {
            switch (token) {
                case 9527: {
                    int newSelectionPos = -1;
                    long targetMsgId = ComposeMessageActivity.this.getIntent().getLongExtra("select_id", -1L);
                    if (targetMsgId != -1L) {
                        cursor.moveToPosition(-1);
                        while (cursor.moveToNext()) {
                            long msgId = cursor.getLong(1);
                            if (msgId != targetMsgId) continue;
                            newSelectionPos = cursor.getPosition();
                            break;
                        }
                    }
                    ComposeMessageActivity.this.mMsgListAdapter.changeCursor(cursor);
                    if (newSelectionPos != -1) {
                        ComposeMessageActivity.this.mMsgListView.setSelection(newSelectionPos);
                    }
                    if (cursor.getCount() == 0 && !ComposeMessageActivity.this.isRecipientsEditorVisible() && !ComposeMessageActivity.this.mSentMessage) {
                        ComposeMessageActivity.this.initRecipientsEditor();
                    }
                    ComposeMessageActivity.this.mTextEditor.requestFocus();
                    ComposeMessageActivity.this.mConversation.blockMarkAsRead(false);
                    return;
                }
                case 1802: {
                    long threadId = (Long)cookie;
                    ConversationList.confirmDeleteThreadDialog(new ConversationList.DeleteThreadListener(threadId, ComposeMessageActivity.this.mBackgroundQueryHandler, (Context)ComposeMessageActivity.this), threadId == -1L, cursor != null && cursor.getCount() > 0, (Context)ComposeMessageActivity.this);
                }
            }
        }

        protected void onDeleteComplete(int token, Object cookie, int result) {
            switch (token) {
                case 1801: 
                case 9700: {
                    MessagingNotification.nonBlockingUpdateNewMessageIndicator((Context)ComposeMessageActivity.this, false, false);
                    ComposeMessageActivity.this.updateSendFailedNotification();
                }
            }
            if (token == 1801) {
                ComposeMessageActivity.this.mWorkingMessage.discard();
                Conversation.init((Context)ComposeMessageActivity.this);
                ComposeMessageActivity.this.finish();
            }
        }
    }

    private static class PduBodyCache {
        private static PduBody mLastPduBody;
        private static Uri mLastUri;

        private PduBodyCache() {
        }

        public static PduBody getPduBody(Context context, Uri contentUri) {
            if (contentUri.equals((Object)mLastUri)) {
                return mLastPduBody;
            }
            try {
                mLastPduBody = SlideshowModel.getPduBody(context, contentUri);
                mLastUri = contentUri;
            }
            catch (MmsException e) {
                Log.e((String)ComposeMessageActivity.TAG, (String)e.getMessage(), (Throwable)e);
                return null;
            }
            return mLastPduBody;
        }
    }

    private final class MsgListMenuClickListener
    implements MenuItem.OnMenuItemClickListener {
        private MsgListMenuClickListener() {
        }

        public boolean onMenuItemClick(MenuItem item) {
            long msgId;
            if (!ComposeMessageActivity.this.isCursorValid()) {
                return false;
            }
            Cursor cursor = ComposeMessageActivity.this.mMsgListAdapter.getCursor();
            String type = cursor.getString(0);
            MessageItem msgItem = ComposeMessageActivity.this.getMessageItem(type, msgId = cursor.getLong(1), true);
            if (msgItem == null) {
                return false;
            }
            switch (item.getItemId()) {
                case 14: {
                    ComposeMessageActivity.this.editMessageItem(msgItem);
                    ComposeMessageActivity.this.drawBottomPanel();
                    return true;
                }
                case 24: {
                    ComposeMessageActivity.this.copyToClipboard(msgItem.mBody);
                    return true;
                }
                case 21: {
                    ComposeMessageActivity.this.forwardMessage(msgItem);
                    return true;
                }
                case 16: {
                    MessageUtils.viewMmsMessageAttachment((Context)ComposeMessageActivity.this, ContentUris.withAppendedId((Uri)Telephony.Mms.CONTENT_URI, (long)msgId), null);
                    return true;
                }
                case 17: {
                    String messageDetails = MessageUtils.getMessageDetails((Context)ComposeMessageActivity.this, cursor, msgItem.mMessageSize);
                    new AlertDialog.Builder((Context)ComposeMessageActivity.this).setTitle(2131165354).setMessage((CharSequence)messageDetails).setPositiveButton(17039370, null).setCancelable(true).show();
                    return true;
                }
                case 18: {
                    DeleteMessageListener l = new DeleteMessageListener(msgItem.mMessageUri, msgItem.mLocked);
                    ComposeMessageActivity.this.confirmDeleteDialog(l, msgItem.mLocked);
                    return true;
                }
                case 20: {
                    ComposeMessageActivity.this.showDeliveryReport(msgId, type);
                    return true;
                }
                case 25: {
                    int resId = ComposeMessageActivity.this.copyMedia(msgId) ? 2131165434 : 2131165435;
                    Toast.makeText((Context)ComposeMessageActivity.this, (int)resId, (int)0).show();
                    return true;
                }
                case 30: {
                    int resId = ComposeMessageActivity.this.getDrmMimeSavedStringRsrc(msgId, ComposeMessageActivity.this.copyToDrmProvider(msgId));
                    Toast.makeText((Context)ComposeMessageActivity.this, (int)resId, (int)0).show();
                    return true;
                }
                case 28: {
                    ComposeMessageActivity.this.lockMessage(msgItem, true);
                    return true;
                }
                case 29: {
                    ComposeMessageActivity.this.lockMessage(msgItem, false);
                    return true;
                }
            }
            return false;
        }
    }

    private final class RecipientsMenuClickListener
    implements MenuItem.OnMenuItemClickListener {
        private final Contact mRecipient;

        RecipientsMenuClickListener(Contact recipient) {
            this.mRecipient = recipient;
        }

        public boolean onMenuItemClick(MenuItem item) {
            switch (item.getItemId()) {
                case 12: {
                    Uri contactUri = this.mRecipient.getUri();
                    Intent intent = new Intent("android.intent.action.VIEW", contactUri);
                    intent.setFlags(524288);
                    ComposeMessageActivity.this.startActivity(intent);
                    return true;
                }
                case 13: {
                    ComposeMessageActivity.this.mAddContactIntent = ConversationList.createAddContactIntent(this.mRecipient.getNumber());
                    ComposeMessageActivity.this.startActivityForResult(ComposeMessageActivity.this.mAddContactIntent, 18);
                    return true;
                }
            }
            return false;
        }
    }

    private class CancelSendingListener
    implements DialogInterface.OnClickListener {
        private CancelSendingListener() {
        }

        public void onClick(DialogInterface dialog, int whichButton) {
            if (ComposeMessageActivity.this.isRecipientsEditorVisible()) {
                ComposeMessageActivity.this.mRecipientsEditor.requestFocus();
            }
            dialog.dismiss();
        }
    }

    private class SendIgnoreInvalidRecipientListener
    implements DialogInterface.OnClickListener {
        private SendIgnoreInvalidRecipientListener() {
        }

        public void onClick(DialogInterface dialog, int whichButton) {
            ComposeMessageActivity.this.sendMessage(true);
            dialog.dismiss();
        }
    }

    private class DiscardDraftListener
    implements DialogInterface.OnClickListener {
        private DiscardDraftListener() {
        }

        public void onClick(DialogInterface dialog, int whichButton) {
            ComposeMessageActivity.this.mWorkingMessage.discard();
            dialog.dismiss();
            ComposeMessageActivity.this.finish();
        }
    }

    private class DeleteMessageListener
    implements DialogInterface.OnClickListener {
        private final Uri mDeleteUri;
        private final boolean mDeleteLocked;

        public DeleteMessageListener(Uri uri, boolean deleteLocked) {
            this.mDeleteUri = uri;
            this.mDeleteLocked = deleteLocked;
        }

        public DeleteMessageListener(long msgId, String type, boolean deleteLocked) {
            this.mDeleteUri = "mms".equals(type) ? ContentUris.withAppendedId((Uri)Telephony.Mms.CONTENT_URI, (long)msgId) : ContentUris.withAppendedId((Uri)Telephony.Sms.CONTENT_URI, (long)msgId);
            this.mDeleteLocked = deleteLocked;
        }

        public void onClick(DialogInterface dialog, int whichButton) {
            ComposeMessageActivity.this.mBackgroundQueryHandler.startDelete(9700, null, this.mDeleteUri, this.mDeleteLocked ? null : "locked=0", null);
            dialog.dismiss();
        }
    }
}

