/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.provider.Telephony;
import android.telephony.SmsMessage;
import android.text.TextUtils;
import com.android.mms.transaction.MessagingNotification;

public class ClassZeroActivity
extends Activity {
    private static final String BUFFER = "         ";
    private static final int BUFFER_OFFSET = "         ".length() * 2;
    private static final String TAG = "display_00";
    private static final int ON_AUTO_SAVE = 1;
    private static final String[] REPLACE_PROJECTION = new String[]{"_id", "address", "protocol"};
    private static final int REPLACE_COLUMN_ID = 0;
    private static final long DEFAULT_TIMER = 300000L;
    private static final String TIMER_FIRE = "timer_fire";
    private SmsMessage mMessage = null;
    private boolean mRead = false;
    private long mTimerSet = 0L;
    private AlertDialog mDialog = null;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                ClassZeroActivity.this.mRead = false;
                ClassZeroActivity.this.mDialog.dismiss();
                ClassZeroActivity.this.saveMessage();
                ClassZeroActivity.this.finish();
            }
        }
    };
    private final DialogInterface.OnClickListener mCancelListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int whichButton) {
            dialog.dismiss();
            ClassZeroActivity.this.finish();
        }
    };
    private final DialogInterface.OnClickListener mSaveListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int whichButton) {
            ClassZeroActivity.this.mRead = true;
            ClassZeroActivity.this.saveMessage();
            dialog.dismiss();
            ClassZeroActivity.this.finish();
        }
    };

    private void saveMessage() {
        Uri messageUri = null;
        messageUri = this.mMessage.isReplace() ? this.replaceMessage(this.mMessage) : this.storeMessage(this.mMessage);
        if (!this.mRead && messageUri != null) {
            MessagingNotification.nonBlockingUpdateNewMessageIndicator((Context)this, true, false);
        }
    }

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.requestWindowFeature(1);
        this.getWindow().setBackgroundDrawableResource(2130837609);
        byte[] pdu = this.getIntent().getByteArrayExtra("pdu");
        this.mMessage = SmsMessage.createFromPdu((byte[])pdu);
        String messageChars = this.mMessage.getMessageBody();
        String message = messageChars.toString();
        if (TextUtils.isEmpty((CharSequence)message)) {
            this.finish();
            return;
        }
        if (message.length() < BUFFER_OFFSET) {
            messageChars = BUFFER + message + BUFFER;
        }
        long now = SystemClock.uptimeMillis();
        this.mDialog = new AlertDialog.Builder((Context)this).setMessage((CharSequence)messageChars).setPositiveButton(2131165465, this.mSaveListener).setNegativeButton(0x1040000, this.mCancelListener).setCancelable(false).show();
        this.mTimerSet = now + 300000L;
        if (icicle != null) {
            this.mTimerSet = icicle.getLong(TIMER_FIRE, this.mTimerSet);
        }
    }

    protected void onStart() {
        super.onStart();
        long now = SystemClock.uptimeMillis();
        if (this.mTimerSet <= now) {
            this.mHandler.sendEmptyMessage(1);
        } else {
            this.mHandler.sendEmptyMessageAtTime(1, this.mTimerSet);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putLong(TIMER_FIRE, this.mTimerSet);
    }

    protected void onStop() {
        super.onStop();
        this.mHandler.removeMessages(1);
    }

    private ContentValues extractContentValues(SmsMessage sms) {
        ContentValues values = new ContentValues();
        values.put("address", sms.getDisplayOriginatingAddress());
        values.put("date", new Long(System.currentTimeMillis()));
        values.put("protocol", Integer.valueOf(sms.getProtocolIdentifier()));
        values.put("read", Integer.valueOf(this.mRead ? 1 : 0));
        values.put("seen", Integer.valueOf(this.mRead ? 1 : 0));
        if (sms.getPseudoSubject().length() > 0) {
            values.put("subject", sms.getPseudoSubject());
        }
        values.put("reply_path_present", Integer.valueOf(sms.isReplyPathPresent() ? 1 : 0));
        values.put("service_center", sms.getServiceCenterAddress());
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Uri replaceMessage(SmsMessage sms) {
        ContentValues values = this.extractContentValues(sms);
        values.put("body", sms.getMessageBody());
        ContentResolver resolver = this.getContentResolver();
        String originatingAddress = sms.getOriginatingAddress();
        int protocolIdentifier = sms.getProtocolIdentifier();
        String selection = "address = ? AND protocol = ?";
        String[] selectionArgs = new String[]{originatingAddress, Integer.toString(protocolIdentifier)};
        Cursor cursor = SqliteWrapper.query((Context)this, (ContentResolver)resolver, (Uri)Telephony.Sms.Inbox.CONTENT_URI, (String[])REPLACE_PROJECTION, (String)selection, (String[])selectionArgs, null);
        try {
            if (cursor.moveToFirst()) {
                long messageId = cursor.getLong(0);
                Uri messageUri = ContentUris.withAppendedId((Uri)Telephony.Sms.CONTENT_URI, (long)messageId);
                SqliteWrapper.update((Context)this, (ContentResolver)resolver, (Uri)messageUri, (ContentValues)values, null, null);
                Uri uri = messageUri;
                return uri;
            }
        }
        finally {
            cursor.close();
        }
        return this.storeMessage(sms);
    }

    private Uri storeMessage(SmsMessage sms) {
        ContentValues values = this.extractContentValues(sms);
        values.put("body", sms.getDisplayMessageBody());
        ContentResolver resolver = this.getContentResolver();
        return SqliteWrapper.insert((Context)this, (ContentResolver)resolver, (Uri)Telephony.Sms.Inbox.CONTENT_URI, (ContentValues)values);
    }
}

