/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.mms.ui.SlideViewInterface;
import com.android.mms.ui.VideoAttachmentView;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSlideEditorView
extends LinearLayout
implements SlideViewInterface {
    private static final String TAG = "BasicSlideEditorView";
    private ImageView mImageView;
    private View mAudioView;
    private TextView mAudioNameView;
    private EditText mEditText;
    private boolean mOnTextChangedListenerEnabled = true;
    private OnTextChangedListener mOnTextChangedListener;

    public BasicSlideEditorView(Context context) {
        super(context);
    }

    public BasicSlideEditorView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void onFinishInflate() {
        this.mImageView = (ImageView)this.findViewById(2131361835);
        this.mAudioView = this.findViewById(2131361836);
        this.mAudioNameView = (TextView)this.findViewById(2131361793);
        this.mEditText = (EditText)this.findViewById(2131361843);
        this.mEditText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (BasicSlideEditorView.this.mOnTextChangedListenerEnabled && BasicSlideEditorView.this.mOnTextChangedListener != null) {
                    BasicSlideEditorView.this.mOnTextChangedListener.onTextChanged(((Object)s).toString());
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }

    @Override
    public void startAudio() {
    }

    @Override
    public void startVideo() {
    }

    @Override
    public void setAudio(Uri audio, String name, Map<String, ?> extras) {
        this.mAudioView.setVisibility(0);
        this.mAudioNameView.setText((CharSequence)name);
    }

    @Override
    public void setImage(String name, Bitmap bitmap) {
        try {
            if (null == bitmap) {
                bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837569);
            }
            this.mImageView.setImageBitmap(bitmap);
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)"setImage: out of memory: ", (Throwable)e);
        }
    }

    @Override
    public void setImageRegionFit(String fit) {
    }

    @Override
    public void setImageVisibility(boolean visible) {
    }

    @Override
    public void setText(String name, String text) {
        this.mOnTextChangedListenerEnabled = false;
        if (text != null && !text.equals(this.mEditText.getText().toString())) {
            this.mEditText.setText((CharSequence)text);
            this.mEditText.setSelection(text.length());
        }
        this.mOnTextChangedListenerEnabled = true;
    }

    @Override
    public void setTextVisibility(boolean visible) {
    }

    @Override
    public void setVideo(String name, Uri video) {
        try {
            Bitmap bitmap = VideoAttachmentView.createVideoThumbnail(this.mContext, video);
            if (null == bitmap) {
                bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837570);
            }
            this.mImageView.setImageBitmap(bitmap);
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)"setVideo: out of memory: ", (Throwable)e);
        }
    }

    @Override
    public void setVideoVisibility(boolean visible) {
    }

    @Override
    public void stopAudio() {
    }

    @Override
    public void stopVideo() {
    }

    @Override
    public void reset() {
        this.mImageView.setImageDrawable(null);
        this.mAudioView.setVisibility(8);
        this.mOnTextChangedListenerEnabled = false;
        this.mEditText.setText((CharSequence)"");
        this.mOnTextChangedListenerEnabled = true;
    }

    @Override
    public void setVisibility(boolean visible) {
    }

    public void setOnTextChangedListener(OnTextChangedListener l) {
        this.mOnTextChangedListener = l;
    }

    @Override
    public void pauseAudio() {
    }

    @Override
    public void pauseVideo() {
    }

    @Override
    public void seekAudio(int seekTo) {
    }

    @Override
    public void seekVideo(int seekTo) {
    }

    public static interface OnTextChangedListener {
        public void onTextChanged(String var1);
    }
}

