/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.provider.Telephony;
import android.text.TextUtils;
import android.util.Log;

public class TransactionSettings {
    private static final String TAG = "TransactionSettings";
    private static final boolean DEBUG = true;
    private static final boolean LOCAL_LOGV = true;
    private String mServiceCenter;
    private String mProxyAddress;
    private int mProxyPort;
    private static final String[] APN_PROJECTION = new String[]{"type", "mmsc", "mmsproxy", "mmsport"};
    private static final int COLUMN_TYPE = 0;
    private static final int COLUMN_MMSC = 1;
    private static final int COLUMN_MMSPROXY = 2;
    private static final int COLUMN_MMSPORT = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionSettings(Context context, String apnName) {
        boolean sawValidApn;
        block10: {
            this.mProxyPort = -1;
            String selection = apnName != null ? "apn='" + apnName.trim() + "'" : null;
            Cursor cursor = SqliteWrapper.query((Context)context, (ContentResolver)context.getContentResolver(), (Uri)Uri.withAppendedPath((Uri)Telephony.Carriers.CONTENT_URI, (String)"current"), (String[])APN_PROJECTION, (String)selection, null, null);
            if (cursor == null) {
                Log.e((String)TAG, (String)"Apn is not found in Database!");
                return;
            }
            sawValidApn = false;
            block5: while (true) {
                while (cursor.moveToNext() && TextUtils.isEmpty((CharSequence)this.mServiceCenter)) {
                    if (!TransactionSettings.isValidApnType(cursor.getString(0), "mms")) continue;
                    sawValidApn = true;
                    this.mServiceCenter = cursor.getString(1).trim();
                    this.mProxyAddress = cursor.getString(2);
                    if (!this.isProxySet()) continue;
                    String portString = cursor.getString(3);
                    try {
                        this.mProxyPort = Integer.parseInt(portString);
                        continue block5;
                    }
                    catch (NumberFormatException e) {
                        if (TextUtils.isEmpty((CharSequence)portString)) {
                            Log.w((String)TAG, (String)"mms port not set!");
                            continue;
                        }
                        Log.e((String)TAG, (String)("Bad port number format: " + portString), (Throwable)e);
                    }
                }
                break block10;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                cursor.close();
            }
        }
        if (sawValidApn && TextUtils.isEmpty((CharSequence)this.mServiceCenter)) {
            Log.e((String)TAG, (String)"Invalid APN setting: MMSC is empty");
        }
    }

    public TransactionSettings(String mmscUrl, String proxyAddr, int proxyPort) {
        this.mProxyPort = -1;
        this.mServiceCenter = mmscUrl != null ? mmscUrl.trim() : null;
        this.mProxyAddress = proxyAddr;
        this.mProxyPort = proxyPort;
    }

    public String getMmscUrl() {
        return this.mServiceCenter;
    }

    public String getProxyAddress() {
        return this.mProxyAddress;
    }

    public int getProxyPort() {
        return this.mProxyPort;
    }

    public boolean isProxySet() {
        return this.mProxyAddress != null && this.mProxyAddress.trim().length() != 0;
    }

    private static boolean isValidApnType(String types, String requestType) {
        if (TextUtils.isEmpty((CharSequence)types)) {
            return true;
        }
        for (String t : types.split(",")) {
            if (!t.equals(requestType) && !t.equals("*")) continue;
            return true;
        }
        return false;
    }
}

