/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.app.Service;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.PowerManager;
import android.provider.Telephony;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.android.common.NetworkConnectivityListener;
import com.android.mms.transaction.MessagingNotification;
import com.android.mms.transaction.MmsSystemEventReceiver;
import com.android.mms.transaction.NotificationTransaction;
import com.android.mms.transaction.Observable;
import com.android.mms.transaction.Observer;
import com.android.mms.transaction.ReadRecTransaction;
import com.android.mms.transaction.RetrieveTransaction;
import com.android.mms.transaction.RetryScheduler;
import com.android.mms.transaction.SendTransaction;
import com.android.mms.transaction.Transaction;
import com.android.mms.transaction.TransactionBundle;
import com.android.mms.transaction.TransactionSettings;
import com.android.mms.transaction.TransactionState;
import com.android.mms.util.RateController;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.NotificationInd;
import com.google.android.mms.pdu.PduParser;
import com.google.android.mms.pdu.PduPersister;
import java.io.IOException;
import java.util.ArrayList;

public class TransactionService
extends Service
implements Observer {
    private static final String TAG = "TransactionService";
    public static final String TRANSACTION_COMPLETED_ACTION = "android.intent.action.TRANSACTION_COMPLETED_ACTION";
    public static final String ACTION_ONALARM = "android.intent.action.ACTION_ONALARM";
    public static final String STATE = "state";
    public static final String STATE_URI = "uri";
    private static final int EVENT_TRANSACTION_REQUEST = 1;
    private static final int EVENT_DATA_STATE_CHANGED = 2;
    private static final int EVENT_CONTINUE_MMS_CONNECTIVITY = 3;
    private static final int EVENT_HANDLE_NEXT_PENDING_TRANSACTION = 4;
    private static final int EVENT_QUIT = 100;
    private static final int TOAST_MSG_QUEUED = 1;
    private static final int TOAST_DOWNLOAD_LATER = 2;
    private static final int TOAST_NONE = -1;
    private static final int APN_EXTENSION_WAIT = 30000;
    private ServiceHandler mServiceHandler;
    private Looper mServiceLooper;
    private final ArrayList<Transaction> mProcessing = new ArrayList();
    private final ArrayList<Transaction> mPending = new ArrayList();
    private ConnectivityManager mConnMgr;
    private NetworkConnectivityListener mConnectivityListener;
    private PowerManager.WakeLock mWakeLock;
    public Handler mToastHandler = new Handler(){

        public void handleMessage(Message msg) {
            String str = null;
            if (msg.what == 1) {
                str = TransactionService.this.getString(2131165420);
            } else if (msg.what == 2) {
                str = TransactionService.this.getString(0x7F0700F7);
            }
            if (str != null) {
                Toast.makeText((Context)TransactionService.this, (CharSequence)str, (int)1).show();
            }
        }
    };

    public void onCreate() {
        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
            Log.v((String)TAG, (String)"Creating TransactionService");
        }
        HandlerThread thread = new HandlerThread(TAG);
        thread.start();
        this.mServiceLooper = thread.getLooper();
        this.mServiceHandler = new ServiceHandler(this.mServiceLooper);
        this.mConnectivityListener = new NetworkConnectivityListener();
        this.mConnectivityListener.registerHandler(this.mServiceHandler, 2);
        this.mConnectivityListener.startListening((Context)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onStartCommand(Intent intent, int flags, int startId) {
        boolean noNetwork;
        if (intent == null) {
            return 2;
        }
        this.mConnMgr = (ConnectivityManager)this.getSystemService("connectivity");
        boolean bl = noNetwork = !this.isNetworkAvailable();
        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
            Log.v((String)TAG, (String)("onStart: #" + startId + ": " + intent.getExtras() + " intent=" + intent));
            Log.v((String)TAG, (String)("    networkAvailable=" + !noNetwork));
        }
        if (ACTION_ONALARM.equals(intent.getAction()) || intent.getExtras() == null) {
            Cursor cursor = PduPersister.getPduPersister((Context)this).getPendingMessages(System.currentTimeMillis());
            if (cursor != null) {
                try {
                    int count = cursor.getCount();
                    if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                        Log.v((String)TAG, (String)("onStart: cursor.count=" + count));
                    }
                    if (count == 0) {
                        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                            Log.v((String)TAG, (String)"onStart: no pending messages. Stopping service.");
                        }
                        RetryScheduler.setRetryAlarm((Context)this);
                        this.stopSelfIfIdle(startId);
                        int n = 2;
                        return n;
                    }
                    int columnIndexOfMsgId = cursor.getColumnIndexOrThrow("msg_id");
                    int columnIndexOfMsgType = cursor.getColumnIndexOrThrow("msg_type");
                    if (noNetwork) {
                        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                            Log.v((String)TAG, (String)"onStart: registerForConnectionStateChanges");
                        }
                        MmsSystemEventReceiver.registerForConnectionStateChanges(this.getApplicationContext());
                    }
                    while (cursor.moveToNext()) {
                        int msgType = cursor.getInt(columnIndexOfMsgType);
                        int transactionType = this.getTransactionType(msgType);
                        if (noNetwork) {
                            this.onNetworkUnavailable(startId, transactionType);
                            int n = 2;
                            return n;
                        }
                        switch (transactionType) {
                            case -1: {
                                break;
                            }
                            case 1: {
                                int failureType = cursor.getInt(cursor.getColumnIndexOrThrow("err_type"));
                                if (!TransactionService.isTransientFailure(failureType)) break;
                            }
                            default: {
                                Uri uri = ContentUris.withAppendedId((Uri)Telephony.Mms.CONTENT_URI, (long)cursor.getLong(columnIndexOfMsgId));
                                TransactionBundle args = new TransactionBundle(transactionType, uri.toString());
                                this.launchTransaction(startId, args, false);
                            }
                        }
                    }
                }
                finally {
                    cursor.close();
                }
            } else {
                if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                    Log.v((String)TAG, (String)"onStart: no pending messages. Stopping service.");
                }
                RetryScheduler.setRetryAlarm((Context)this);
                this.stopSelfIfIdle(startId);
            }
        } else {
            if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                Log.v((String)TAG, (String)"onStart: launch transaction...");
            }
            TransactionBundle args = new TransactionBundle(intent.getExtras());
            this.launchTransaction(startId, args, noNetwork);
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSelfIfIdle(int startId) {
        ArrayList<Transaction> arrayList = this.mProcessing;
        synchronized (arrayList) {
            if (this.mProcessing.isEmpty() && this.mPending.isEmpty()) {
                if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                    Log.v((String)TAG, (String)"stopSelfIfIdle: STOP!");
                }
                if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                    Log.v((String)TAG, (String)"stopSelfIfIdle: unRegisterForConnectionStateChanges");
                }
                MmsSystemEventReceiver.unRegisterForConnectionStateChanges(this.getApplicationContext());
                this.stopSelf(startId);
            }
        }
    }

    private static boolean isTransientFailure(int type) {
        return type < 10 && type > 0;
    }

    private boolean isNetworkAvailable() {
        return this.mConnMgr.getNetworkInfo(2).isAvailable();
    }

    private int getTransactionType(int msgType) {
        switch (msgType) {
            case 130: {
                return 1;
            }
            case 135: {
                return 3;
            }
            case 128: {
                return 2;
            }
        }
        Log.w((String)TAG, (String)("Unrecognized MESSAGE_TYPE: " + msgType));
        return -1;
    }

    private void launchTransaction(int serviceId, TransactionBundle txnBundle, boolean noNetwork) {
        if (noNetwork) {
            Log.w((String)TAG, (String)"launchTransaction: no network error!");
            this.onNetworkUnavailable(serviceId, txnBundle.getTransactionType());
            return;
        }
        Message msg = this.mServiceHandler.obtainMessage(1);
        msg.arg1 = serviceId;
        msg.obj = txnBundle;
        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
            Log.v((String)TAG, (String)("launchTransaction: sending message " + msg));
        }
        this.mServiceHandler.sendMessage(msg);
    }

    private void onNetworkUnavailable(int serviceId, int transactionType) {
        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
            Log.v((String)TAG, (String)("onNetworkUnavailable: sid=" + serviceId + ", type=" + transactionType));
        }
        int toastType = -1;
        if (transactionType == 1) {
            toastType = 2;
        } else if (transactionType == 2) {
            toastType = 1;
        }
        if (toastType != -1) {
            this.mToastHandler.sendEmptyMessage(toastType);
        }
        this.stopSelf(serviceId);
    }

    public void onDestroy() {
        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
            Log.v((String)TAG, (String)"Destroying TransactionService");
        }
        if (!this.mPending.isEmpty()) {
            Log.w((String)TAG, (String)"TransactionService exiting with transaction still pending");
        }
        this.releaseWakeLock();
        this.mConnectivityListener.unregisterHandler(this.mServiceHandler);
        this.mConnectivityListener.stopListening();
        this.mConnectivityListener = null;
        this.mServiceHandler.sendEmptyMessage(100);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable observable) {
        Transaction transaction = (Transaction)observable;
        int serviceId = transaction.getServiceId();
        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
            Log.v((String)TAG, (String)("update transaction " + serviceId));
        }
        try {
            ArrayList<Transaction> arrayList = this.mProcessing;
            synchronized (arrayList) {
                this.mProcessing.remove(transaction);
                if (this.mPending.size() > 0) {
                    if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                        Log.v((String)TAG, (String)"update: handle next pending transaction...");
                    }
                    Message msg = this.mServiceHandler.obtainMessage(4, transaction.getConnectionSettings());
                    this.mServiceHandler.sendMessage(msg);
                } else {
                    if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                        Log.v((String)TAG, (String)"update: endMmsConnectivity");
                    }
                    this.endMmsConnectivity();
                }
            }
            Intent intent = new Intent(TRANSACTION_COMPLETED_ACTION);
            TransactionState state = transaction.getState();
            int result = state.getState();
            intent.putExtra(STATE, result);
            switch (result) {
                case 1: {
                    if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                        Log.v((String)TAG, (String)("Transaction complete: " + serviceId));
                    }
                    intent.putExtra(STATE_URI, (Parcelable)state.getContentUri());
                    switch (transaction.getType()) {
                        case 0: 
                        case 1: {
                            MessagingNotification.blockingUpdateNewMessageIndicator((Context)this, true, false);
                            MessagingNotification.updateDownloadFailedNotification((Context)this);
                            break;
                        }
                        case 2: {
                            RateController.getInstance().update();
                        }
                    }
                    break;
                }
                case 2: {
                    if (!Log.isLoggable((String)"Mms:transaction", (int)2)) break;
                    Log.v((String)TAG, (String)("Transaction failed: " + serviceId));
                    break;
                }
                default: {
                    if (!Log.isLoggable((String)"Mms:transaction", (int)2)) break;
                    Log.v((String)TAG, (String)("Transaction state unknown: " + serviceId + " " + result));
                }
            }
            if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                Log.v((String)TAG, (String)("update: broadcast transaction result " + result));
            }
            this.sendBroadcast(intent);
        }
        finally {
            transaction.detach(this);
            MmsSystemEventReceiver.unRegisterForConnectionStateChanges(this.getApplicationContext());
            this.stopSelf(serviceId);
        }
    }

    private synchronized void createWakeLock() {
        if (this.mWakeLock == null) {
            PowerManager pm = (PowerManager)this.getSystemService("power");
            this.mWakeLock = pm.newWakeLock(1, "MMS Connectivity");
            this.mWakeLock.setReferenceCounted(false);
        }
    }

    private void acquireWakeLock() {
        this.mWakeLock.acquire();
    }

    private void releaseWakeLock() {
        if (this.mWakeLock != null && this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
    }

    protected int beginMmsConnectivity() throws IOException {
        this.createWakeLock();
        int result = this.mConnMgr.startUsingNetworkFeature(0, "enableMMS");
        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
            Log.v((String)TAG, (String)("beginMmsConnectivity: result=" + result));
        }
        switch (result) {
            case 0: 
            case 1: {
                this.acquireWakeLock();
                return result;
            }
        }
        throw new IOException("Cannot establish MMS connectivity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endMmsConnectivity() {
        try {
            if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                Log.v((String)TAG, (String)"endMmsConnectivity");
            }
            this.mServiceHandler.removeMessages(3);
            if (this.mConnMgr != null) {
                this.mConnMgr.stopUsingNetworkFeature(0, "enableMMS");
            }
        }
        finally {
            this.releaseWakeLock();
        }
    }

    private final class ServiceHandler
    extends Handler {
        public ServiceHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handleMessage(Message msg) {
            if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                Log.v((String)TransactionService.TAG, (String)("Handling incoming message: " + msg));
            }
            Observable transaction = null;
            switch (msg.what) {
                case 100: {
                    this.getLooper().quit();
                    return;
                }
                case 3: {
                    ArrayList arrayList = TransactionService.this.mProcessing;
                    synchronized (arrayList) {
                        if (TransactionService.this.mProcessing.isEmpty()) {
                            return;
                        }
                    }
                    if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                        Log.v((String)TransactionService.TAG, (String)"handle EVENT_CONTINUE_MMS_CONNECTIVITY event...");
                    }
                    try {
                        int result = TransactionService.this.beginMmsConnectivity();
                        if (result != 0) {
                            Log.v((String)TransactionService.TAG, (String)("Extending MMS connectivity returned " + result + " instead of APN_ALREADY_ACTIVE"));
                            return;
                        }
                    }
                    catch (IOException e) {
                        Log.w((String)TransactionService.TAG, (String)"Attempt to extend use of MMS connectivity failed");
                        return;
                    }
                    this.sendMessageDelayed(this.obtainMessage(3), 30000L);
                    return;
                }
                case 2: {
                    if (TransactionService.this.mConnectivityListener == null) {
                        return;
                    }
                    NetworkInfo info = TransactionService.this.mConnectivityListener.getNetworkInfo();
                    if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                        Log.v((String)TransactionService.TAG, (String)("Handle DATA_STATE_CHANGED event: " + info));
                    }
                    if (info == null || info.getType() != 2) {
                        if (!Log.isLoggable((String)"Mms:transaction", (int)2)) return;
                        Log.v((String)TransactionService.TAG, (String)"   type is not TYPE_MOBILE_MMS, bail");
                        return;
                    }
                    if (!info.isConnected()) {
                        if (!Log.isLoggable((String)"Mms:transaction", (int)2)) return;
                        Log.v((String)TransactionService.TAG, (String)"   TYPE_MOBILE_MMS not connected, bail");
                        return;
                    }
                    TransactionSettings settings = new TransactionSettings((Context)TransactionService.this, info.getExtraInfo());
                    if (TextUtils.isEmpty((CharSequence)settings.getMmscUrl())) {
                        if (!Log.isLoggable((String)"Mms:transaction", (int)2)) return;
                        Log.v((String)TransactionService.TAG, (String)"   empty MMSC url, bail");
                        return;
                    }
                    this.sendMessageDelayed(this.obtainMessage(3), 30000L);
                    this.processPendingTransaction((Transaction)transaction, settings);
                    return;
                }
                case 1: {
                    Object transactionSettings;
                    int serviceId = msg.arg1;
                    try {
                        TransactionBundle args = (TransactionBundle)msg.obj;
                        String mmsc = args.getMmscUrl();
                        transactionSettings = mmsc != null ? new TransactionSettings(mmsc, args.getProxyAddress(), args.getProxyPort()) : new TransactionSettings((Context)TransactionService.this, null);
                        int transactionType = args.getTransactionType();
                        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                            Log.v((String)TransactionService.TAG, (String)("handle EVENT_TRANSACTION_REQUEST: transactionType=" + transactionType));
                        }
                        switch (transactionType) {
                            case 0: {
                                String uri = args.getUri();
                                if (uri != null) {
                                    transaction = new NotificationTransaction((Context)TransactionService.this, serviceId, (TransactionSettings)transactionSettings, uri);
                                    break;
                                }
                                byte[] pushData = args.getPushData();
                                PduParser parser = new PduParser(pushData);
                                GenericPdu ind = parser.parse();
                                int type = 130;
                                if (ind == null || ind.getMessageType() != type) {
                                    Log.e((String)TransactionService.TAG, (String)"Invalid PUSH data.");
                                    transaction = null;
                                    return;
                                }
                                transaction = new NotificationTransaction((Context)TransactionService.this, serviceId, (TransactionSettings)transactionSettings, (NotificationInd)ind);
                                break;
                            }
                            case 1: {
                                transaction = new RetrieveTransaction((Context)TransactionService.this, serviceId, (TransactionSettings)transactionSettings, args.getUri());
                                break;
                            }
                            case 2: {
                                transaction = new SendTransaction((Context)TransactionService.this, serviceId, (TransactionSettings)transactionSettings, args.getUri());
                                break;
                            }
                            case 3: {
                                transaction = new ReadRecTransaction((Context)TransactionService.this, serviceId, (TransactionSettings)transactionSettings, args.getUri());
                                break;
                            }
                            default: {
                                Log.w((String)TransactionService.TAG, (String)("Invalid transaction type: " + serviceId));
                                transaction = null;
                                return;
                            }
                        }
                        if (!this.processTransaction((Transaction)transaction)) {
                            transaction = null;
                            return;
                        }
                        if (!Log.isLoggable((String)"Mms:transaction", (int)2)) return;
                        Log.v((String)TransactionService.TAG, (String)("Started processing of incoming message: " + msg));
                        return;
                    }
                    catch (Exception ex) {
                        Log.w((String)TransactionService.TAG, (String)("Exception occurred while handling message: " + msg), (Throwable)ex);
                        if (transaction == null) return;
                        try {
                            transaction.detach(TransactionService.this);
                            if (TransactionService.this.mProcessing.contains(transaction)) {
                                transactionSettings = TransactionService.this.mProcessing;
                                synchronized (transactionSettings) {
                                    TransactionService.this.mProcessing.remove(transaction);
                                }
                            }
                            transaction = null;
                            return;
                        }
                        catch (Throwable t) {
                            try {
                                Log.e((String)TransactionService.TAG, (String)"Unexpected Throwable.", (Throwable)t);
                                return;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                transaction = null;
                            }
                        }
                    }
                    finally {
                        if (transaction == null) {
                            if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                                Log.v((String)TransactionService.TAG, (String)("Transaction was null. Stopping self: " + serviceId));
                            }
                            TransactionService.this.endMmsConnectivity();
                            TransactionService.this.stopSelf(serviceId);
                        }
                    }
                }
                case 4: {
                    this.processPendingTransaction((Transaction)transaction, (TransactionSettings)msg.obj);
                    return;
                }
            }
            Log.w((String)TransactionService.TAG, (String)("what=" + msg.what));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processPendingTransaction(Transaction transaction, TransactionSettings settings) {
            block15: {
                if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                    Log.v((String)TransactionService.TAG, (String)("processPendingTxn: transaction=" + transaction));
                }
                int numProcessTransaction = 0;
                ArrayList arrayList = TransactionService.this.mProcessing;
                synchronized (arrayList) {
                    if (TransactionService.this.mPending.size() != 0) {
                        transaction = (Transaction)TransactionService.this.mPending.remove(0);
                    }
                    numProcessTransaction = TransactionService.this.mProcessing.size();
                }
                if (transaction != null) {
                    if (settings != null) {
                        transaction.setConnectionSettings(settings);
                    }
                    try {
                        int serviceId = transaction.getServiceId();
                        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                            Log.v((String)TransactionService.TAG, (String)("processPendingTxn: process " + serviceId));
                        }
                        if (this.processTransaction(transaction)) {
                            if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                                Log.v((String)TransactionService.TAG, (String)("Started deferred processing of transaction  " + transaction));
                            }
                            break block15;
                        }
                        transaction = null;
                        TransactionService.this.stopSelf(serviceId);
                    }
                    catch (IOException e) {
                        Log.w((String)TransactionService.TAG, (String)e.getMessage(), (Throwable)e);
                    }
                } else if (numProcessTransaction == 0) {
                    if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                        Log.v((String)TransactionService.TAG, (String)"processPendingTxn: no more transaction, endMmsConnectivity");
                    }
                    TransactionService.this.endMmsConnectivity();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processTransaction(Transaction transaction) throws IOException {
            ArrayList arrayList = TransactionService.this.mProcessing;
            synchronized (arrayList) {
                int connectivityResult;
                for (Transaction t : TransactionService.this.mPending) {
                    if (!t.isEquivalent(transaction)) continue;
                    if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                        Log.v((String)TransactionService.TAG, (String)("Transaction already pending: " + transaction.getServiceId()));
                    }
                    return true;
                }
                for (Transaction t : TransactionService.this.mProcessing) {
                    if (!t.isEquivalent(transaction)) continue;
                    if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                        Log.v((String)TransactionService.TAG, (String)("Duplicated transaction: " + transaction.getServiceId()));
                    }
                    return true;
                }
                if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                    Log.v((String)TransactionService.TAG, (String)"processTransaction: call beginMmsConnectivity...");
                }
                if ((connectivityResult = TransactionService.this.beginMmsConnectivity()) == 1) {
                    TransactionService.this.mPending.add(transaction);
                    if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                        Log.v((String)TransactionService.TAG, (String)"processTransaction: connResult=APN_REQUEST_STARTED, defer transaction pending MMS connectivity");
                    }
                    return true;
                }
                if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                    Log.v((String)TransactionService.TAG, (String)("Adding transaction to 'mProcessing' list: " + transaction));
                }
                TransactionService.this.mProcessing.add(transaction);
            }
            this.sendMessageDelayed(this.obtainMessage(3), 30000L);
            if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                Log.v((String)TransactionService.TAG, (String)("processTransaction: starting transaction " + transaction));
            }
            transaction.attach(TransactionService.this);
            transaction.process();
            return true;
        }
    }
}

