/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import com.android.mms.transaction.SmsReceiverService;

public class SmsReceiver
extends BroadcastReceiver {
    static final Object mStartingServiceSync = new Object();
    static PowerManager.WakeLock mStartingService;
    private static SmsReceiver sInstance;

    public static SmsReceiver getInstance() {
        if (sInstance == null) {
            sInstance = new SmsReceiver();
        }
        return sInstance;
    }

    public void onReceive(Context context, Intent intent) {
        this.onReceiveWithPrivilege(context, intent, false);
    }

    protected void onReceiveWithPrivilege(Context context, Intent intent, boolean privileged) {
        if (!privileged && intent.getAction().equals("android.provider.Telephony.SMS_RECEIVED")) {
            return;
        }
        intent.setClass(context, SmsReceiverService.class);
        intent.putExtra("result", this.getResultCode());
        SmsReceiver.beginStartingService(context, intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beginStartingService(Context context, Intent intent) {
        Object object = mStartingServiceSync;
        synchronized (object) {
            if (mStartingService == null) {
                PowerManager pm = (PowerManager)context.getSystemService("power");
                mStartingService = pm.newWakeLock(1, "StartingAlertService");
                mStartingService.setReferenceCounted(false);
            }
            mStartingService.acquire();
            context.startService(intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishStartingService(Service service, int startId) {
        Object object = mStartingServiceSync;
        synchronized (object) {
            if (mStartingService != null && service.stopSelfResult(startId)) {
                mStartingService.release();
            }
        }
    }
}

