/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.provider.Telephony;
import android.text.TextUtils;
import android.util.Log;
import com.android.mms.transaction.RetryScheduler;
import com.android.mms.transaction.Transaction;
import com.android.mms.transaction.TransactionSettings;
import com.android.mms.ui.MessageUtils;
import com.android.mms.util.RateController;
import com.android.mms.util.SendingProgressTokenManager;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.PduComposer;
import com.google.android.mms.pdu.PduParser;
import com.google.android.mms.pdu.PduPersister;
import com.google.android.mms.pdu.SendConf;
import com.google.android.mms.pdu.SendReq;
import java.util.Arrays;

public class SendTransaction
extends Transaction
implements Runnable {
    private static final String TAG = "SendTransaction";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private Thread mThread;
    private final Uri mSendReqURI;

    public SendTransaction(Context context, int transId, TransactionSettings connectionSettings, String uri) {
        super(context, transId, connectionSettings);
        this.mSendReqURI = Uri.parse((String)uri);
        this.mId = uri;
        this.attach(RetryScheduler.getInstance(context));
    }

    public void process() {
        this.mThread = new Thread(this);
        this.mThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            byte[] confId;
            byte[] reqId;
            SendConf conf;
            RateController rateCtlr = RateController.getInstance();
            if (rateCtlr.isLimitSurpassed() && !rateCtlr.isAllowedByUser()) {
                Log.e((String)TAG, (String)"Sending rate limit surpassed.");
                return;
            }
            PduPersister persister = PduPersister.getPduPersister((Context)this.mContext);
            SendReq sendReq = (SendReq)persister.load(this.mSendReqURI);
            long date = System.currentTimeMillis() / 1000L;
            sendReq.setDate(date);
            ContentValues values = new ContentValues(1);
            values.put("date", Long.valueOf(date));
            SqliteWrapper.update((Context)this.mContext, (ContentResolver)this.mContext.getContentResolver(), (Uri)this.mSendReqURI, (ContentValues)values, null, null);
            String lineNumber = MessageUtils.getLocalNumber();
            if (!TextUtils.isEmpty((CharSequence)lineNumber)) {
                sendReq.setFrom(new EncodedStringValue(lineNumber));
            }
            long tokenKey = ContentUris.parseId((Uri)this.mSendReqURI);
            byte[] response = this.sendPdu(SendingProgressTokenManager.get(tokenKey), new PduComposer(this.mContext, (GenericPdu)sendReq).make());
            SendingProgressTokenManager.remove(tokenKey);
            if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                String respStr = new String(response);
                Log.d((String)TAG, (String)("[SendTransaction] run: send mms msg (" + this.mId + "), resp=" + respStr));
            }
            if ((conf = (SendConf)new PduParser(response).parse()) == null) {
                Log.e((String)TAG, (String)"No M-Send.conf received.");
            }
            if (!Arrays.equals(reqId = sendReq.getTransactionId(), confId = conf.getTransactionId())) {
                Log.e((String)TAG, (String)("Inconsistent Transaction-ID: req=" + new String(reqId) + ", conf=" + new String(confId)));
                return;
            }
            values = new ContentValues(2);
            int respStatus = conf.getResponseStatus();
            values.put("resp_st", Integer.valueOf(respStatus));
            if (respStatus != 128) {
                SqliteWrapper.update((Context)this.mContext, (ContentResolver)this.mContext.getContentResolver(), (Uri)this.mSendReqURI, (ContentValues)values, null, null);
                Log.e((String)TAG, (String)("Server returned an error code: " + respStatus));
                return;
            }
            String messageId = PduPersister.toIsoString((byte[])conf.getMessageId());
            values.put("m_id", messageId);
            SqliteWrapper.update((Context)this.mContext, (ContentResolver)this.mContext.getContentResolver(), (Uri)this.mSendReqURI, (ContentValues)values, null, null);
            Uri uri = persister.move(this.mSendReqURI, Telephony.Mms.Sent.CONTENT_URI);
            this.mTransactionState.setState(1);
            this.mTransactionState.setContentUri(uri);
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)t));
        }
        finally {
            if (this.mTransactionState.getState() != 1) {
                this.mTransactionState.setState(2);
                this.mTransactionState.setContentUri(this.mSendReqURI);
                Log.e((String)TAG, (String)"Delivery failed.");
            }
            this.notifyObservers();
        }
    }

    public int getType() {
        return 2;
    }
}

