/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.provider.Telephony;
import android.util.Log;
import com.android.mms.MmsConfig;
import com.android.mms.transaction.RetryScheduler;
import com.android.mms.transaction.Transaction;
import com.android.mms.transaction.TransactionSettings;
import com.android.mms.ui.MessageUtils;
import com.android.mms.util.DownloadManager;
import com.android.mms.util.Recycler;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.AcknowledgeInd;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.PduComposer;
import com.google.android.mms.pdu.PduParser;
import com.google.android.mms.pdu.PduPersister;
import com.google.android.mms.pdu.RetrieveConf;
import java.io.IOException;

public class RetrieveTransaction
extends Transaction
implements Runnable {
    private static final String TAG = "RetrieveTransaction";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private final Uri mUri;
    private final String mContentLocation;
    private boolean mLocked;
    static final String[] PROJECTION = new String[]{"ct_l", "locked"};
    static final int COLUMN_CONTENT_LOCATION = 0;
    static final int COLUMN_LOCKED = 1;

    public RetrieveTransaction(Context context, int serviceId, TransactionSettings connectionSettings, String uri) throws MmsException {
        super(context, serviceId, connectionSettings);
        if (!uri.startsWith("content://")) {
            throw new IllegalArgumentException("Initializing from X-Mms-Content-Location is abandoned!");
        }
        this.mUri = Uri.parse((String)uri);
        this.mId = this.mContentLocation = this.getContentLocation(context, this.mUri);
        this.attach(RetryScheduler.getInstance(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContentLocation(Context context, Uri uri) throws MmsException {
        Cursor cursor = SqliteWrapper.query((Context)context, (ContentResolver)context.getContentResolver(), (Uri)uri, (String[])PROJECTION, null, null, null);
        this.mLocked = false;
        if (cursor != null) {
            try {
                if (cursor.getCount() == 1 && cursor.moveToFirst()) {
                    this.mLocked = cursor.getInt(1) == 1;
                    String string2 = cursor.getString(0);
                    return string2;
                }
            }
            finally {
                cursor.close();
            }
        }
        throw new MmsException("Cannot get X-Mms-Content-Location from: " + uri);
    }

    public void process() {
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            DownloadManager.getInstance().markState(this.mUri, 129);
            byte[] resp = this.getPdu(this.mContentLocation);
            RetrieveConf retrieveConf = (RetrieveConf)new PduParser(resp).parse();
            if (null == retrieveConf) {
                throw new MmsException("Invalid M-Retrieve.conf PDU.");
            }
            Uri msgUri = null;
            if (RetrieveTransaction.isDuplicateMessage(this.mContext, retrieveConf)) {
                this.mTransactionState.setState(2);
                this.mTransactionState.setContentUri(this.mUri);
            } else {
                PduPersister persister = PduPersister.getPduPersister((Context)this.mContext);
                msgUri = persister.persist((GenericPdu)retrieveConf, Telephony.Mms.Inbox.CONTENT_URI);
                this.mTransactionState.setState(1);
                this.mTransactionState.setContentUri(msgUri);
                RetrieveTransaction.updateContentLocation(this.mContext, msgUri, this.mContentLocation, this.mLocked);
            }
            SqliteWrapper.delete((Context)this.mContext, (ContentResolver)this.mContext.getContentResolver(), (Uri)this.mUri, null, null);
            if (msgUri != null) {
                Recycler.getMmsRecycler().deleteOldMessagesInSameThreadAsMessage(this.mContext, msgUri);
            }
            this.sendAcknowledgeInd(retrieveConf);
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)t));
        }
        finally {
            if (this.mTransactionState.getState() != 1) {
                this.mTransactionState.setState(2);
                this.mTransactionState.setContentUri(this.mUri);
                Log.e((String)TAG, (String)"Retrieval failed.");
            }
            this.notifyObservers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isDuplicateMessage(Context context, RetrieveConf rc) {
        byte[] rawMessageId = rc.getMessageId();
        if (rawMessageId != null) {
            String messageId = new String(rawMessageId);
            String selection = "(m_id = ? AND m_type = ?)";
            String[] selectionArgs = new String[]{messageId, String.valueOf(132)};
            Cursor cursor = SqliteWrapper.query((Context)context, (ContentResolver)context.getContentResolver(), (Uri)Telephony.Mms.CONTENT_URI, (String[])new String[]{"_id"}, (String)selection, (String[])selectionArgs, null);
            if (cursor != null) {
                try {
                    if (cursor.getCount() > 0) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    cursor.close();
                }
            }
        }
        return false;
    }

    private void sendAcknowledgeInd(RetrieveConf rc) throws MmsException, IOException {
        byte[] tranId = rc.getTransactionId();
        if (tranId != null) {
            AcknowledgeInd acknowledgeInd = new AcknowledgeInd(18, tranId);
            String lineNumber = MessageUtils.getLocalNumber();
            acknowledgeInd.setFrom(new EncodedStringValue(lineNumber));
            if (MmsConfig.getNotifyWapMMSC()) {
                this.sendPdu(new PduComposer(this.mContext, (GenericPdu)acknowledgeInd).make(), this.mContentLocation);
            } else {
                this.sendPdu(new PduComposer(this.mContext, (GenericPdu)acknowledgeInd).make());
            }
        }
    }

    private static void updateContentLocation(Context context, Uri uri, String contentLocation, boolean locked) {
        ContentValues values = new ContentValues(2);
        values.put("ct_l", contentLocation);
        values.put("locked", Boolean.valueOf(locked));
        SqliteWrapper.update((Context)context, (ContentResolver)context.getContentResolver(), (Uri)uri, (ContentValues)values, null, null);
    }

    public int getType() {
        return 1;
    }
}

