/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.ContentResolver;
import android.content.Context;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.provider.Telephony;
import android.util.Log;
import com.android.mms.MmsApp;
import com.android.mms.MmsConfig;
import com.android.mms.transaction.RetryScheduler;
import com.android.mms.transaction.Transaction;
import com.android.mms.transaction.TransactionSettings;
import com.android.mms.util.DownloadManager;
import com.android.mms.util.Recycler;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.NotificationInd;
import com.google.android.mms.pdu.NotifyRespInd;
import com.google.android.mms.pdu.PduComposer;
import com.google.android.mms.pdu.PduParser;
import com.google.android.mms.pdu.PduPersister;
import java.io.IOException;

public class NotificationTransaction
extends Transaction
implements Runnable {
    private static final String TAG = "NotificationTransaction";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private Uri mUri;
    private NotificationInd mNotificationInd;
    private String mContentLocation;

    public NotificationTransaction(Context context, int serviceId, TransactionSettings connectionSettings, String uriString) {
        super(context, serviceId, connectionSettings);
        this.mUri = Uri.parse((String)uriString);
        try {
            this.mNotificationInd = (NotificationInd)PduPersister.getPduPersister((Context)context).load(this.mUri);
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)("Failed to load NotificationInd from: " + uriString), (Throwable)e);
            throw new IllegalArgumentException();
        }
        this.mId = new String(this.mNotificationInd.getTransactionId());
        this.mContentLocation = new String(this.mNotificationInd.getContentLocation());
        this.attach(RetryScheduler.getInstance(context));
    }

    public NotificationTransaction(Context context, int serviceId, TransactionSettings connectionSettings, NotificationInd ind) {
        super(context, serviceId, connectionSettings);
        try {
            this.mUri = PduPersister.getPduPersister((Context)context).persist((GenericPdu)ind, Telephony.Mms.Inbox.CONTENT_URI);
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)"Failed to save NotificationInd in constructor.", (Throwable)e);
            throw new IllegalArgumentException();
        }
        this.mNotificationInd = ind;
        this.mId = new String(ind.getTransactionId());
    }

    public void process() {
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DownloadManager downloadManager = DownloadManager.getInstance();
        boolean autoDownload = downloadManager.isAuto();
        boolean dataSuspended = MmsApp.getApplication().getTelephonyManager().getDataState() == 3;
        try {
            int status = 131;
            if (!autoDownload || dataSuspended) {
                downloadManager.markState(this.mUri, 128);
                this.sendNotifyRespInd(status);
                return;
            }
            downloadManager.markState(this.mUri, 129);
            byte[] retrieveConfData = null;
            try {
                retrieveConfData = this.getPdu(this.mContentLocation);
            }
            catch (IOException e) {
                this.mTransactionState.setState(2);
            }
            if (retrieveConfData != null) {
                GenericPdu pdu = new PduParser(retrieveConfData).parse();
                if (pdu == null || pdu.getMessageType() != 132) {
                    Log.e((String)TAG, (String)"Invalid M-RETRIEVE.CONF PDU.");
                    this.mTransactionState.setState(2);
                    status = 132;
                } else {
                    PduPersister p = PduPersister.getPduPersister((Context)this.mContext);
                    Uri uri = p.persist(pdu, Telephony.Mms.Inbox.CONTENT_URI);
                    SqliteWrapper.delete((Context)this.mContext, (ContentResolver)this.mContext.getContentResolver(), (Uri)this.mUri, null, null);
                    this.mUri = uri;
                    status = 129;
                }
            }
            switch (status) {
                case 129: {
                    this.mTransactionState.setState(1);
                    break;
                }
                case 131: {
                    if (this.mTransactionState.getState() != 0) break;
                    this.mTransactionState.setState(1);
                }
            }
            this.sendNotifyRespInd(status);
            Recycler.getMmsRecycler().deleteOldMessagesInSameThreadAsMessage(this.mContext, this.mUri);
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)t));
        }
        finally {
            this.mTransactionState.setContentUri(this.mUri);
            if (!autoDownload || dataSuspended) {
                this.mTransactionState.setState(1);
            }
            if (this.mTransactionState.getState() != 1) {
                this.mTransactionState.setState(2);
                Log.e((String)TAG, (String)"NotificationTransaction failed.");
            }
            this.notifyObservers();
        }
    }

    private void sendNotifyRespInd(int status) throws MmsException, IOException {
        NotifyRespInd notifyRespInd = new NotifyRespInd(18, this.mNotificationInd.getTransactionId(), status);
        if (MmsConfig.getNotifyWapMMSC()) {
            this.sendPdu(new PduComposer(this.mContext, (GenericPdu)notifyRespInd).make(), this.mContentLocation);
        } else {
            this.sendPdu(new PduComposer(this.mContext, (GenericPdu)notifyRespInd).make());
        }
    }

    public int getType() {
        return 0;
    }
}

