/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.util.Log;
import com.android.mms.transaction.MessagingNotification;
import com.android.mms.transaction.TransactionService;
import com.google.android.mms.util.PduCache;

public class MmsSystemEventReceiver
extends BroadcastReceiver {
    private static final String TAG = "MmsSystemEventReceiver";
    private static MmsSystemEventReceiver sMmsSystemEventReceiver;

    private static void wakeUpService(Context context) {
        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
            Log.v((String)TAG, (String)"wakeUpService: start transaction service ...");
        }
        context.startService(new Intent(context, TransactionService.class));
    }

    public void onReceive(Context context, Intent intent) {
        String action;
        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
            Log.v((String)TAG, (String)("Intent received: " + intent));
        }
        if ((action = intent.getAction()).equals("android.intent.action.CONTENT_CHANGED")) {
            Uri changed = (Uri)intent.getParcelableExtra("deleted_contents");
            PduCache.getInstance().purge(changed);
        } else if (action.equals("android.intent.action.ANY_DATA_STATE")) {
            String state = intent.getStringExtra("state");
            if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
                Log.v((String)TAG, (String)("ANY_DATA_STATE event received: " + state));
            }
            if (state.equals("CONNECTED")) {
                MmsSystemEventReceiver.wakeUpService(context);
            }
        } else if (action.equals("android.intent.action.BOOT_COMPLETED")) {
            MessagingNotification.nonBlockingUpdateNewMessageIndicator(context, false, false);
        }
    }

    public static void registerForConnectionStateChanges(Context context) {
        MmsSystemEventReceiver.unRegisterForConnectionStateChanges(context);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.ANY_DATA_STATE");
        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
            Log.v((String)TAG, (String)"registerForConnectionStateChanges");
        }
        if (sMmsSystemEventReceiver == null) {
            sMmsSystemEventReceiver = new MmsSystemEventReceiver();
        }
        context.registerReceiver((BroadcastReceiver)sMmsSystemEventReceiver, intentFilter);
    }

    public static void unRegisterForConnectionStateChanges(Context context) {
        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
            Log.v((String)TAG, (String)"unRegisterForConnectionStateChanges");
        }
        if (sMmsSystemEventReceiver != null) {
            try {
                context.unregisterReceiver((BroadcastReceiver)sMmsSystemEventReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

