/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import android.util.Log;
import com.android.mms.transaction.MessageSender;
import com.android.mms.transaction.TransactionService;
import com.android.mms.util.SendingProgressTokenManager;
import com.google.android.mms.InvalidHeaderValueException;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.PduPersister;
import com.google.android.mms.pdu.ReadRecInd;
import com.google.android.mms.pdu.SendReq;

public class MmsMessageSender
implements MessageSender {
    private static final String TAG = "MmsMessageSender";
    private final Context mContext;
    private final Uri mMessageUri;
    private final long mMessageSize;
    private static final boolean DEFAULT_DELIVERY_REPORT_MODE = false;
    private static final boolean DEFAULT_READ_REPORT_MODE = false;
    private static final long DEFAULT_EXPIRY_TIME = 604800L;
    private static final int DEFAULT_PRIORITY = 129;
    private static final String DEFAULT_MESSAGE_CLASS = "personal";

    public MmsMessageSender(Context context, Uri location, long messageSize) {
        this.mContext = context;
        this.mMessageUri = location;
        this.mMessageSize = messageSize;
        if (this.mMessageUri == null) {
            throw new IllegalArgumentException("Null message URI.");
        }
    }

    public boolean sendMessage(long token) throws MmsException {
        PduPersister p = PduPersister.getPduPersister((Context)this.mContext);
        GenericPdu pdu = p.load(this.mMessageUri);
        if (pdu.getMessageType() != 128) {
            throw new MmsException("Invalid message: " + pdu.getMessageType());
        }
        SendReq sendReq = (SendReq)pdu;
        this.updatePreferencesHeaders(sendReq);
        sendReq.setMessageClass(DEFAULT_MESSAGE_CLASS.getBytes());
        sendReq.setDate(System.currentTimeMillis() / 1000L);
        sendReq.setMessageSize(this.mMessageSize);
        p.updateHeaders(this.mMessageUri, sendReq);
        p.move(this.mMessageUri, Telephony.Mms.Outbox.CONTENT_URI);
        SendingProgressTokenManager.put(ContentUris.parseId((Uri)this.mMessageUri), token);
        this.mContext.startService(new Intent(this.mContext, TransactionService.class));
        return true;
    }

    private void updatePreferencesHeaders(SendReq sendReq) throws MmsException {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.mContext);
        sendReq.setExpiry(prefs.getLong("pref_key_mms_expiry", 604800L));
        sendReq.setPriority(prefs.getInt("pref_key_mms_priority", 129));
        boolean dr = prefs.getBoolean("pref_key_mms_delivery_reports", false);
        sendReq.setDeliveryReport(dr ? 128 : 129);
        boolean rr = prefs.getBoolean("pref_key_mms_read_reports", false);
        sendReq.setReadReport(rr ? 128 : 129);
    }

    public static void sendReadRec(Context context, String to, String messageId, int status) {
        EncodedStringValue[] sender = new EncodedStringValue[]{new EncodedStringValue(to)};
        try {
            ReadRecInd readRec = new ReadRecInd(new EncodedStringValue("insert-address-token".getBytes()), messageId.getBytes(), 18, status, sender);
            readRec.setDate(System.currentTimeMillis() / 1000L);
            PduPersister.getPduPersister((Context)context).persist((GenericPdu)readRec, Telephony.Mms.Outbox.CONTENT_URI);
            context.startService(new Intent(context, TransactionService.class));
        }
        catch (InvalidHeaderValueException e) {
            Log.e((String)TAG, (String)"Invalide header value", (Throwable)e);
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)"Persist message failed", (Throwable)e);
        }
    }
}

